/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.mixins.lotr.common.entity.npc;

import com.github.maximuslotro.lotrrextended.common.advancements.ExtendedCriteriaTriggers;
import com.github.maximuslotro.lotrrextended.common.entity.ai.goal.ExtendedPlayerTypedRunArroundLikeCrazyGoal;
import com.github.maximuslotro.lotrrextended.common.entity.ai.goal.ExtendedPlayerTypedWaterAvoidingRandomWalkingGoal;
import com.github.maximuslotro.lotrrextended.common.init.ExtendedAttributes;
import com.github.maximuslotro.lotrrextended.common.inventory.ExtendedWargInventoryContainer;
import com.github.maximuslotro.lotrrextended.common.network.ExtendedPacketHandler;
import com.github.maximuslotro.lotrrextended.common.network.ExtendedSOpenWargWindowPacket;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import lotr.common.entity.ai.goal.PanicIfBurningGoal;
import lotr.common.entity.npc.ExtendedRidableWargEntity;
import lotr.common.entity.npc.NPCEntity;
import lotr.common.entity.npc.WargEntity;
import lotr.common.entity.npc.ai.goal.WargLeapAndDisableShieldGoal;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IEquipable;
import net.minecraft.entity.IJumpingMount;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effects;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.TransportationHelper;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.ICollisionReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WargEntity.class})
public abstract class MixinWargEntity
extends NPCEntity
implements IInventoryChangedListener,
IJumpingMount,
IEquipable,
ExtendedRidableWargEntity {
    private static final Ingredient FOOD_ITEMS = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151015_O, Items.field_151102_aT, Blocks.field_150407_cf.func_199767_j(), Items.field_151034_e, Items.field_151150_bK, Items.field_151153_ao, Items.field_196100_at});
    private static final DataParameter<Byte> DATA_ID_FLAGS = EntityDataManager.func_187226_a(WargEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Optional<UUID>> DATA_ID_OWNER_UUID = EntityDataManager.func_187226_a(WargEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    private boolean isJumping;
    private Inventory inventory;
    private int temper;
    private float playerJumpPendingScale;
    private LazyOptional<?> itemHandler = null;

    protected MixinWargEntity(EntityType<? extends WargEntity> type, World w) {
        super(type, w);
    }

    @Shadow(remap=false)
    public boolean getIsLeaping() {
        return false;
    }

    @Shadow(remap=false)
    public void startLeaping() {
    }

    @Inject(method={"<init>(Lnet/minecraft/entity/EntityType;Lnet/minecraft/world/World;)V"}, at={@At(value="TAIL")}, remap=false)
    public void constructor(EntityType<? extends WargEntity> type, World w, CallbackInfo ci) {
        this.createInventory();
    }

    @Inject(method={"addAdditionalSaveData(Lnet/minecraft/nbt/CompoundNBT;)V"}, at={@At(value="TAIL")})
    public void addAdditionalSaveDataExtended(CompoundNBT pCompound, CallbackInfo ci) {
        super.func_213281_b(pCompound);
        pCompound.func_74768_a("Temper", this.getTemper());
        pCompound.func_74757_a("Tame", this.isTamed());
        if (this.getOwnerUUID() != null) {
            pCompound.func_186854_a("Owner", this.getOwnerUUID());
        }
        if (!this.inventory.func_70301_a(0).func_190926_b()) {
            pCompound.func_218657_a("SaddleItem", (INBT)this.inventory.func_70301_a(0).func_77955_b(new CompoundNBT()));
        }
    }

    @Inject(method={"readAdditionalSaveData(Lnet/minecraft/nbt/CompoundNBT;)V"}, at={@At(value="TAIL")})
    public void readAdditionalSaveDataExtended(CompoundNBT pCompound, CallbackInfo ci) {
        ItemStack itemstack;
        UUID uuid;
        super.func_70037_a(pCompound);
        this.setTemper(pCompound.func_74762_e("Temper"));
        this.setTamed(pCompound.func_74767_n("Tame"));
        if (pCompound.func_186855_b("Owner")) {
            uuid = pCompound.func_186857_a("Owner");
        } else {
            String s = pCompound.func_74779_i("Owner");
            uuid = PreYggdrasilConverter.func_187473_a((MinecraftServer)this.func_184102_h(), (String)s);
        }
        if (uuid != null) {
            this.setOwnerUUID(uuid);
        }
        if (pCompound.func_150297_b("SaddleItem", 10) && (itemstack = ItemStack.func_199557_a((CompoundNBT)pCompound.func_74775_l("SaddleItem"))).func_77973_b() == Items.field_151141_av) {
            this.inventory.func_70299_a(0, itemstack);
        }
        this.updateContainerEquipment();
    }

    @Inject(method={"defineSynchedData()V"}, at={@At(value="TAIL")})
    protected void defineSynchedData(CallbackInfo ci) {
        this.field_70180_af.func_187214_a(DATA_ID_FLAGS, (Object)0);
        this.field_70180_af.func_187214_a(DATA_ID_OWNER_UUID, Optional.empty());
    }

    protected void addNPCAI() {
        super.addNPCAI();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicIfBurningGoal((CreatureEntity)this, 1.6));
        this.field_70714_bg.func_75776_a(2, (Goal)new ExtendedPlayerTypedRunArroundLikeCrazyGoal((WargEntity)this, 1.2));
        this.field_70714_bg.func_75776_a(3, (Goal)new WargLeapAndDisableShieldGoal((WargEntity)this, 0.45f));
        this.addAttackGoal(4);
        this.field_70714_bg.func_75776_a(7, (Goal)new ExtendedPlayerTypedWaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 12.0f, 0.02f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, NPCEntity.class, 8.0f, 0.02f));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtGoal((MobEntity)this, LivingEntity.class, 12.0f, 0.02f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    @Overwrite(remap=false)
    public static AttributeModifierMap.MutableAttribute regAttrs() {
        return NPCEntity.registerBaseNPCAttributes().func_233815_a_(Attributes.field_233819_b_, 32.0).func_233815_a_(Attributes.field_233821_d_, 0.22).func_233815_a_(Attributes.field_233820_c_, 0.5).func_233814_a_((Attribute)ExtendedAttributes.WARG_JUMP_STRENGTH.get());
    }

    private boolean getFlag(int pFlagId) {
        return ((Byte)this.field_70180_af.func_187225_a(DATA_ID_FLAGS) & pFlagId) != 0;
    }

    private void setFlag(int pFlagId, boolean pValue) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(DATA_ID_FLAGS);
        if (pValue) {
            this.field_70180_af.func_187227_b(DATA_ID_FLAGS, (Object)((byte)(b0 | pFlagId)));
        } else {
            this.field_70180_af.func_187227_b(DATA_ID_FLAGS, (Object)((byte)(b0 & ~pFlagId)));
        }
    }

    @Override
    public boolean isTamed() {
        return this.getFlag(2);
    }

    @Nullable
    public UUID getOwnerUUID() {
        return ((Optional)this.field_70180_af.func_187225_a(DATA_ID_OWNER_UUID)).orElse(null);
    }

    public void setOwnerUUID(@Nullable UUID pUuid) {
        this.field_70180_af.func_187227_b(DATA_ID_OWNER_UUID, Optional.ofNullable(pUuid));
    }

    public boolean isJumping() {
        return this.isJumping;
    }

    private void setTamed(boolean pTamed) {
        this.setFlag(2, pTamed);
    }

    public void setIsJumping(boolean pJumping) {
        this.isJumping = pJumping;
    }

    public boolean func_230264_L__() {
        return this.func_70089_S() && !this.func_70631_g_() && this.isTamed();
    }

    public void func_230266_a_(@Nullable SoundCategory pSource) {
        this.inventory.func_70299_a(0, new ItemStack((IItemProvider)Items.field_151141_av));
        if (pSource != null) {
            this.field_70170_p.func_217384_a((PlayerEntity)null, (Entity)this, SoundEvents.field_187726_cu, pSource, 0.5f, 1.0f);
        }
    }

    public boolean func_110257_ck() {
        return this.getFlag(4);
    }

    @Override
    public int getTemper() {
        return this.temper;
    }

    private void setTemper(int pTemper) {
        this.temper = pTemper;
    }

    @Override
    public int modifyTemper(int pAddedTemper) {
        int i = MathHelper.func_76125_a((int)(this.getTemper() + pAddedTemper), (int)0, (int)this.getMaxTemper());
        this.setTemper(i);
        return i;
    }

    public ActionResultType func_230254_b_(PlayerEntity pPlayer, Hand pHand) {
        ItemStack itemstack = pPlayer.func_184586_b(pHand);
        if (!pPlayer.field_70170_p.field_72995_K) {
            pPlayer.func_145747_a((ITextComponent)new StringTextComponent("Is Tamed:" + this.isTamed() + ", isSecondaryUseActive" + pPlayer.func_226563_dT_() + ", isFood:" + this.isFood(itemstack)), Util.field_240973_b_);
        }
        if (!this.func_70631_g_()) {
            if (this.isTamed() && pPlayer.func_226563_dT_()) {
                this.openInventory(pPlayer);
                return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
            }
            if (this.func_184207_aI()) {
                return super.func_230254_b_(pPlayer, pHand);
            }
        }
        if (!itemstack.func_190926_b()) {
            if (this.isFood(itemstack)) {
                return this.fedFood(pPlayer, itemstack);
            }
            ActionResultType actionresulttype = itemstack.func_111282_a_(pPlayer, (LivingEntity)this, pHand);
            if (actionresulttype.func_226246_a_()) {
                return actionresulttype;
            }
            if (!this.isTamed()) {
                this.func_184185_a(this.func_184639_G(), this.func_70599_aP(), this.func_70647_i());
                this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
            }
            boolean flag = !this.func_70631_g_() && !this.func_110257_ck() && itemstack.func_77973_b() == Items.field_151141_av;
            pPlayer.func_145747_a((ITextComponent)new StringTextComponent(!this.func_70631_g_() + ":" + !this.func_110257_ck() + ":" + (itemstack.func_77973_b() == Items.field_151141_av)), Util.field_240973_b_);
            if (this.isArmor(itemstack) || flag) {
                this.openInventory(pPlayer);
                return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
            }
        }
        this.doPlayerRide(pPlayer);
        return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
    }

    public boolean func_70104_M() {
        return !this.func_184207_aI();
    }

    public boolean func_225503_b_(float pFallDistance, float pDamageMultiplier) {
        int i;
        if (pFallDistance > 1.0f) {
            this.func_184185_a(SoundEvents.field_187723_ct, 0.4f, 1.0f);
        }
        if ((i = this.func_225508_e_(pFallDistance, pDamageMultiplier)) <= 0) {
            return false;
        }
        this.func_70097_a(DamageSource.field_76379_h, i);
        if (this.func_184207_aI()) {
            for (Entity entity : this.func_184182_bu()) {
                entity.func_70097_a(DamageSource.field_76379_h, (float)i);
            }
        }
        this.func_226295_cZ_();
        return true;
    }

    protected int func_225508_e_(float pDistance, float pDamageMultiplier) {
        return MathHelper.func_76123_f((float)((pDistance * 0.5f - 3.0f) * pDamageMultiplier));
    }

    @Override
    public void makeMad() {
        this.func_184185_a(this.func_184639_G(), this.func_70599_aP(), this.func_70647_i());
    }

    @Override
    public int getInventorySize() {
        return 2;
    }

    private void createInventory() {
        Inventory inventory = this.inventory;
        this.inventory = new Inventory(this.getInventorySize());
        if (inventory != null) {
            inventory.func_110132_b((IInventoryChangedListener)this);
            int i = Math.min(inventory.func_70302_i_(), this.inventory.func_70302_i_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = inventory.func_70301_a(j);
                if (itemstack.func_190926_b()) continue;
                this.inventory.func_70299_a(j, itemstack.func_77946_l());
            }
        }
        this.inventory.func_110134_a((IInventoryChangedListener)this);
        this.updateContainerEquipment();
        this.itemHandler = LazyOptional.of(() -> new InvWrapper((IInventory)this.inventory));
    }

    private void updateContainerEquipment() {
        if (!this.field_70170_p.field_72995_K) {
            this.setFlag(4, !this.inventory.func_70301_a(0).func_190926_b());
        }
    }

    public void func_76316_a(IInventory pInvBasic) {
        boolean flag = this.func_110257_ck();
        this.updateContainerEquipment();
        if (this.field_70173_aa > 20 && !flag && this.func_110257_ck()) {
            this.func_184185_a(SoundEvents.field_187726_cu, 0.5f, 1.0f);
        }
    }

    @Override
    public int getMaxTemper() {
        return 100;
    }

    private void openInventory(PlayerEntity pPlayer) {
        if (!this.field_70170_p.field_72995_K && (!this.func_184207_aI() || this.func_184196_w((Entity)pPlayer)) && this.isTamed() && pPlayer instanceof ServerPlayerEntity) {
            this.openWargInventory((ServerPlayerEntity)pPlayer, (WargEntity)this, (IInventory)this.inventory);
        }
    }

    private void openWargInventory(ServerPlayerEntity pPlayer, WargEntity pHorse, IInventory pInventory) {
        if (pPlayer.field_71070_bA != pPlayer.field_71069_bz) {
            pPlayer.func_71053_j();
        }
        pPlayer.func_71117_bO();
        ExtendedPacketHandler.sendToClient(new ExtendedSOpenWargWindowPacket(pPlayer.field_71139_cq, pInventory.func_70302_i_(), pHorse.func_145782_y()), pPlayer);
        pPlayer.field_71070_bA = new ExtendedWargInventoryContainer(pPlayer.field_71139_cq, pPlayer.field_71071_by, pInventory, pHorse);
        pPlayer.field_71070_bA.func_75132_a((IContainerListener)pPlayer);
        MinecraftForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open((PlayerEntity)pPlayer, pPlayer.field_71070_bA));
    }

    private ActionResultType fedFood(PlayerEntity pPlayer, ItemStack pStack) {
        boolean flag = this.handleEating(pPlayer, pStack);
        if (!pPlayer.field_71075_bZ.field_75098_d) {
            pStack.func_190918_g(1);
        }
        if (this.field_70170_p.field_72995_K) {
            return ActionResultType.CONSUME;
        }
        return flag ? ActionResultType.SUCCESS : ActionResultType.PASS;
    }

    private boolean handleEating(PlayerEntity pPlayer, ItemStack pStack) {
        boolean flag = false;
        float f = 0.0f;
        int i = 0;
        int j = 0;
        Item item = pStack.func_77973_b();
        if (item == Items.field_151015_O) {
            f = 2.0f;
            i = 20;
            j = 3;
        }
        if (this.func_110143_aJ() < this.func_110138_aP() && f > 0.0f) {
            this.func_70691_i(f);
            flag = true;
        }
        if (j > 0 && (flag || !this.isTamed()) && this.getTemper() < this.getMaxTemper()) {
            flag = true;
            if (!this.field_70170_p.field_72995_K) {
                this.modifyTemper(j);
            }
        }
        return flag;
    }

    private void doPlayerRide(PlayerEntity pPlayer) {
        if (!this.field_70170_p.field_72995_K) {
            pPlayer.field_70177_z = this.field_70177_z;
            pPlayer.field_70125_A = this.field_70125_A;
            pPlayer.func_184220_m((Entity)this);
        }
    }

    protected boolean func_70610_aX() {
        return super.func_70610_aX() && this.func_184207_aI() && this.func_110257_ck();
    }

    private boolean isFood(ItemStack pStack) {
        return FOOD_ITEMS.test(pStack);
    }

    protected void func_213337_cE() {
        super.func_213337_cE();
        if (this.inventory != null) {
            for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
                ItemStack itemstack = this.inventory.func_70301_a(i);
                if (itemstack.func_190926_b() || EnchantmentHelper.func_190939_c((ItemStack)itemstack)) continue;
                this.func_199701_a_(itemstack);
            }
        }
    }

    @Override
    public boolean tameWithName(PlayerEntity pPlayer) {
        this.setOwnerUUID(pPlayer.func_110124_au());
        this.setTamed(true);
        if (pPlayer instanceof ServerPlayerEntity) {
            ExtendedCriteriaTriggers.TAME_LIVING_TRIGGER.trigger((ServerPlayerEntity)pPlayer, (LivingEntity)this);
        }
        this.field_70170_p.func_72960_a((Entity)this, (byte)7);
        return true;
    }

    public void func_213352_e(Vector3d pTravelVector) {
        if (this.func_70089_S()) {
            if (this.func_184207_aI() && this.func_82171_bF() && this.func_110257_ck()) {
                LivingEntity livingentity = (LivingEntity)this.func_184179_bs();
                this.field_70126_B = this.field_70177_z = livingentity.field_70177_z;
                this.field_70125_A = livingentity.field_70125_A * 0.5f;
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
                this.field_70759_as = this.field_70761_aq = this.field_70177_z;
                float f = livingentity.field_70702_br * 0.5f;
                float f1 = livingentity.field_191988_bg;
                if (f1 <= 0.0f) {
                    f1 *= 0.25f;
                }
                if (this.field_70122_E && this.playerJumpPendingScale == 0.0f) {
                    f = 0.0f;
                    f1 = 0.0f;
                }
                if (this.playerJumpPendingScale > 0.0f && !this.isJumping() && this.field_70122_E) {
                    double d0 = this.func_233637_b_((Attribute)ExtendedAttributes.WARG_JUMP_STRENGTH.get()) * (double)this.playerJumpPendingScale * (double)this.func_226269_ah_();
                    double d1 = this.func_70644_a(Effects.field_76430_j) ? d0 + (double)((float)(this.func_70660_b(Effects.field_76430_j).func_76458_c() + 1) * 0.1f) : d0;
                    Vector3d vector3d = this.func_213322_ci();
                    this.func_213293_j(vector3d.field_72450_a, d1, vector3d.field_72449_c);
                    this.setIsJumping(true);
                    this.field_70160_al = true;
                    ForgeHooks.onLivingJump((LivingEntity)this);
                    if (f1 > 0.0f) {
                        float f2 = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180)));
                        float f3 = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)));
                        this.func_213317_d(this.func_213322_ci().func_72441_c((double)(-0.4f * f2 * this.playerJumpPendingScale), 0.0, (double)(0.4f * f3 * this.playerJumpPendingScale)));
                    }
                    this.playerJumpPendingScale = 0.0f;
                }
                this.field_70747_aH = this.func_70689_ay() * 0.1f;
                if (this.func_184186_bw()) {
                    this.func_70659_e((float)this.func_233637_b_(Attributes.field_233821_d_));
                    super.func_213352_e(new Vector3d((double)f, pTravelVector.field_72448_b, (double)f1));
                } else if (livingentity instanceof PlayerEntity) {
                    this.func_213317_d(Vector3d.field_186680_a);
                }
                if (this.field_70122_E) {
                    this.playerJumpPendingScale = 0.0f;
                    this.setIsJumping(false);
                }
                this.func_233629_a_((LivingEntity)this, false);
            } else {
                this.field_70747_aH = 0.02f;
                super.func_213352_e(pTravelVector);
            }
        }
    }

    private void playJumpSound() {
        this.func_184185_a(SoundEvents.field_187720_cs, 0.4f, 1.0f);
    }

    public boolean func_82171_bF() {
        System.out.println("canBeControlledByRider" + (this.func_184179_bs() instanceof PlayerEntity));
        return this.func_184179_bs() instanceof PlayerEntity;
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (this.func_184188_bt().get(0) instanceof PlayerEntity ? (Entity)this.func_184188_bt().get(0) : null);
    }

    public boolean func_184186_bw() {
        System.out.println("isControlledByLocalInstance:" + super.func_184186_bw());
        return super.func_184186_bw();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_110206_u(int pJumpPower) {
        if (this.func_110257_ck()) {
            if (pJumpPower < 0) {
                pJumpPower = 0;
            } else {
                this.startLeaping();
            }
            this.playerJumpPendingScale = pJumpPower >= 90 ? 1.0f : 0.4f + 0.4f * (float)pJumpPower / 90.0f;
        }
    }

    public boolean func_184776_b() {
        return this.func_110257_ck();
    }

    public void func_184775_b(int pJumpPower) {
        this.playJumpSound();
    }

    public void func_184777_r_() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte pId) {
        if (pId == 7) {
            this.spawnTamingParticles(true);
        } else if (pId == 6) {
            this.spawnTamingParticles(false);
        } else {
            super.func_70103_a(pId);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void spawnTamingParticles(boolean pTamed) {
        BasicParticleType iparticledata = pTamed ? ParticleTypes.field_197633_z : ParticleTypes.field_197601_L;
        for (int i = 0; i < 10; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_195594_a((IParticleData)iparticledata, this.func_226282_d_(1.0), this.func_226279_cv_() + 0.5, this.func_226287_g_(1.0), d0, d1, d2);
        }
    }

    public void func_184232_k(Entity pPassenger) {
        super.func_184232_k(pPassenger);
        if (pPassenger instanceof PlayerEntity) {
            PlayerEntity playerEntity = (PlayerEntity)pPassenger;
            this.field_70761_aq = playerEntity.field_70761_aq;
        }
    }

    public boolean func_70617_f_() {
        return false;
    }

    @Override
    public boolean canWearArmor() {
        return false;
    }

    @Override
    public boolean isWearingArmor() {
        return !this.func_184582_a(EquipmentSlotType.CHEST).func_190926_b();
    }

    @Override
    public boolean isArmor(ItemStack pStack) {
        return false;
    }

    public boolean func_174820_d(int pSlotIndex, ItemStack pStack) {
        int i = pSlotIndex - 400;
        if (i >= 0 && i < 2 && i < this.inventory.func_70302_i_()) {
            if (i == 0 && pStack.func_77973_b() != Items.field_151141_av) {
                return false;
            }
            if (i != 1 || this.canWearArmor() && this.isArmor(pStack)) {
                this.inventory.func_70299_a(i, pStack);
                this.updateContainerEquipment();
                return true;
            }
            return false;
        }
        int j = pSlotIndex - 500 + 2;
        if (j >= 2 && j < this.inventory.func_70302_i_()) {
            this.inventory.func_70299_a(j, pStack);
            return true;
        }
        return false;
    }

    @Nullable
    private Vector3d getDismountLocationInDirection(Vector3d pDirection, LivingEntity pPassenger) {
        double d0 = this.func_226277_ct_() + pDirection.field_72450_a;
        double d1 = this.func_174813_aQ().field_72338_b;
        double d2 = this.func_226281_cx_() + pDirection.field_72449_c;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        block0: for (Pose pose : pPassenger.func_230297_ef_()) {
            blockpos$mutable.func_189532_c(d0, d1, d2);
            double d3 = this.func_174813_aQ().field_72337_e + 0.75;
            do {
                Vector3d vector3d;
                AxisAlignedBB axisalignedbb;
                double d4 = this.field_70170_p.func_242403_h((BlockPos)blockpos$mutable);
                if ((double)blockpos$mutable.func_177956_o() + d4 > d3) continue block0;
                if (TransportationHelper.func_234630_a_((double)d4) && TransportationHelper.func_234631_a_((ICollisionReader)this.field_70170_p, (LivingEntity)pPassenger, (AxisAlignedBB)(axisalignedbb = pPassenger.func_233648_f_(pose)).func_191194_a(vector3d = new Vector3d(d0, (double)blockpos$mutable.func_177956_o() + d4, d2)))) {
                    pPassenger.func_213301_b(pose);
                    return vector3d;
                }
                blockpos$mutable.func_189536_c(Direction.UP);
            } while ((double)blockpos$mutable.func_177956_o() < d3);
        }
        return null;
    }

    public Vector3d func_230268_c_(LivingEntity pLivingEntity) {
        Vector3d vector3d = MixinWargEntity.func_233559_a_((double)this.func_213311_cf(), (double)pLivingEntity.func_213311_cf(), (float)(this.field_70177_z + (pLivingEntity.func_184591_cq() == HandSide.RIGHT ? 90.0f : -90.0f)));
        Vector3d vector3d1 = this.getDismountLocationInDirection(vector3d, pLivingEntity);
        if (vector3d1 != null) {
            return vector3d1;
        }
        Vector3d vector3d2 = MixinWargEntity.func_233559_a_((double)this.func_213311_cf(), (double)pLivingEntity.func_213311_cf(), (float)(this.field_70177_z + (pLivingEntity.func_184591_cq() == HandSide.LEFT ? 90.0f : -90.0f)));
        Vector3d vector3d3 = this.getDismountLocationInDirection(vector3d2, pLivingEntity);
        return vector3d3 != null ? vector3d3 : this.func_213303_ch();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (this.func_70089_S() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.itemHandler != null) {
            return this.itemHandler.cast();
        }
        return super.getCapability(capability, facing);
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        if (this.itemHandler != null) {
            LazyOptional<?> oldHandler = this.itemHandler;
            this.itemHandler = null;
            oldHandler.invalidate();
        }
    }
}

