/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.mixins.lotr.common.init;

import com.github.maximuslotro.lotrrextended.common.datagen.DataGenValueHolder;
import com.github.maximuslotro.lotrrextended.common.inventory.ExtendedBookshelfContainer;
import com.github.maximuslotro.lotrrextended.common.inventory.ExtendedHiredUnitContainer;
import com.github.maximuslotro.lotrrextended.common.inventory.ExtendedHiredUnitEquipmentContainer;
import com.github.maximuslotro.lotrrextended.common.inventory.container.ExtendedGrinderContainer;
import java.util.function.Supplier;
import lotr.common.init.ExtendedContainers;
import lotr.common.init.LOTRContainers;
import lotr.common.inventory.ExtendedCoinExchangeContainer;
import lotr.common.inventory.ExtendedTradeContainer;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.fml.DatagenModLoader;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LOTRContainers.class})
public class MixinLOTRContainers {
    @Shadow(remap=false)
    @Final
    public static DeferredRegister<ContainerType<?>> CONTAINERS;

    @Inject(method={"register()V"}, at={@At(value="HEAD")}, remap=false)
    private static void bootstrapExtendedContainers(CallbackInfo ci) {
        ExtendedContainers.COIN_TRADING = MixinLOTRContainers.register("coin_exchange", "Coin Exchange", () -> IForgeContainerType.create(ExtendedCoinExchangeContainer::new));
        ExtendedContainers.TRADING = MixinLOTRContainers.register("trading", "Trading", () -> IForgeContainerType.create(ExtendedTradeContainer::new));
        ExtendedContainers.BOOKSHELF = MixinLOTRContainers.registerExtended("bookshelf", "Bookshelf", () -> IForgeContainerType.create(ExtendedBookshelfContainer::threeRows));
        ExtendedContainers.MILLSTONE = MixinLOTRContainers.registerExtended("stone_grinder", "Stone Grinder", () -> IForgeContainerType.create(ExtendedGrinderContainer::new));
        ExtendedContainers.HIRED_UNIT_CONTAINER = MixinLOTRContainers.register("hired_unit_menu", "Hired Unit Inventory", () -> IForgeContainerType.create(ExtendedHiredUnitContainer::new));
        ExtendedContainers.HIRED_UNIT_EQUIPMENT = MixinLOTRContainers.register("hired_unit_equipment", "Update Equipment", () -> IForgeContainerType.create(ExtendedHiredUnitEquipmentContainer::new));
    }

    private static <T extends Container> RegistryObject<ContainerType<T>> register(String name, String defaultName, Supplier<ContainerType<T>> sup) {
        if (DatagenModLoader.isRunningDataGen()) {
            DataGenValueHolder.containerTitlesHolders.put("container.lotr." + name, defaultName);
        }
        return CONTAINERS.register(name, sup);
    }

    private static <T extends Container> RegistryObject<ContainerType<T>> registerExtended(String name, String defaultName, Supplier<ContainerType<T>> sup) {
        if (DatagenModLoader.isRunningDataGen()) {
            DataGenValueHolder.containerTitlesHolders.put("container.lotrextended." + name, defaultName);
        }
        return CONTAINERS.register(name, sup);
    }
}

