/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.mixins.lotr.common.item;

import com.github.maximuslotro.lotrrextended.common.config.ExtendedServerConfig;
import lotr.common.data.FastTravelDataModule;
import lotr.common.data.LOTRLevelData;
import lotr.common.item.RedBookItem;
import lotr.common.network.LOTRPacketHandler;
import lotr.common.network.SPacketOpenScreen;
import lotr.common.util.LOTRUtil;
import lotr.common.world.map.CustomWaypointStructureHandler;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={RedBookItem.class})
public class MixinRedBookItem {
    @Shadow(remap=false)
    private void playFailedSound(World world, BlockPos pos) {
    }

    @Shadow(remap=false)
    private void playOpenScreenSound(World world, BlockPos pos) {
    }

    @Overwrite(remap=false)
    public boolean createCustomWaypointStructure(World world, BlockPos pos, PlayerEntity player) {
        if (!world.field_72995_K) {
            ServerWorld sWorld = (ServerWorld)world;
            boolean canBeCWPStructure = CustomWaypointStructureHandler.INSTANCE.isFocalPoint(world, pos);
            if (canBeCWPStructure) {
                if (!((Boolean)ExtendedServerConfig.enableRenewedWaypointCreation.get()).booleanValue()) {
                    LOTRUtil.sendMessage((PlayerEntity)player, (ITextComponent)new TranslationTextComponent("chat.lotr.cwp.create.disabled"));
                    return false;
                }
                if (CustomWaypointStructureHandler.INSTANCE.hasAdjacentWaypointMarker(world, pos)) {
                    LOTRUtil.sendMessage((PlayerEntity)player, (ITextComponent)new TranslationTextComponent("chat.lotr.cwp.alreadyExists"));
                    this.playFailedSound(world, pos);
                    return true;
                }
                FastTravelDataModule ftData = LOTRLevelData.sidedInstance((IWorldReader)world).getData(player).getFastTravelData();
                if (!ftData.canCreateOrAdoptMoreCustomWaypoints()) {
                    LOTRUtil.sendMessage((PlayerEntity)player, (ITextComponent)new TranslationTextComponent("chat.lotr.cwp.limit"));
                    this.playFailedSound(world, pos);
                    return true;
                }
                boolean isCompleteStructure = CustomWaypointStructureHandler.INSTANCE.isFocalPointOfCompletableStructure(sWorld, pos, msg -> LOTRUtil.sendMessage((PlayerEntity)player, (ITextComponent)msg));
                if (isCompleteStructure) {
                    CustomWaypointStructureHandler.INSTANCE.setPlayerClickedOnBlockToCreate(player, pos);
                    LOTRPacketHandler.sendTo((Object)new SPacketOpenScreen(SPacketOpenScreen.Type.CREATE_CUSTOM_WAYPOINT), (ServerPlayerEntity)((ServerPlayerEntity)player));
                    this.playOpenScreenSound(world, pos);
                } else {
                    this.playFailedSound(world, pos);
                }
                return true;
            }
        }
        return false;
    }
}

