/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.mixins.lotr.common.network;

import com.github.maximuslotro.lotrrextended.ExtendedLog;
import com.github.maximuslotro.lotrrextended.common.config.ExtendedServerConfig;
import com.github.maximuslotro.lotrrextended.common.utils.ExtendedReflectionHelper;
import lotr.common.LOTRLog;
import lotr.common.data.FastTravelDataModule;
import lotr.common.init.LOTRWorldTypes;
import lotr.common.item.RedBookItem;
import lotr.common.network.CPacketCreateCustomWaypoint;
import lotr.common.stat.LOTRStats;
import lotr.common.util.LOTRUtil;
import lotr.common.util.UsernameHelper;
import lotr.common.world.map.CustomWaypoint;
import lotr.common.world.map.CustomWaypointStructureHandler;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Mixin(value={CPacketCreateCustomWaypoint.class})
public class MixinCPacketCreateCustomWaypoint {
    @Overwrite(remap=false)
    private static void doCreateCustomWaypoint(CPacketCreateCustomWaypoint packet, ServerPlayerEntity player, FastTravelDataModule ftData) {
        ServerWorld world = player.func_71121_q();
        if (!((Boolean)ExtendedServerConfig.enableRenewedWaypointCreation.get()).booleanValue()) {
            LOTRUtil.sendMessage((PlayerEntity)player, (ITextComponent)new TranslationTextComponent("chat.lotr.cwp.create.disabled.gamerule"));
        } else if (!LOTRWorldTypes.hasMapFeatures((ServerWorld)world)) {
            LOTRUtil.sendMessage((PlayerEntity)player, (ITextComponent)new TranslationTextComponent("chat.lotr.cwp.create.disabled.worldtype"));
        } else if (!ftData.canCreateOrAdoptMoreCustomWaypoints()) {
            LOTRLog.warn((String)"Player %s tried to create a custom waypoint but has reached their limit", (Object[])new Object[]{UsernameHelper.getRawUsername((PlayerEntity)player)});
        } else {
            String waypointName = ExtendedReflectionHelper.getStringFieldFromClass(CPacketCreateCustomWaypoint.class, packet, "name");
            String waypointLore = ExtendedReflectionHelper.getStringFieldFromClass(CPacketCreateCustomWaypoint.class, packet, "lore");
            if (waypointName == null || waypointName.isEmpty()) {
                LOTRLog.warn((String)"Player %s tried to create a custom waypoint with a blank name", (Object[])new Object[]{UsernameHelper.getRawUsername((PlayerEntity)player)});
            } else if (waypointName.length() > 40) {
                LOTRLog.warn((String)"Player %s tried to create a custom waypoint with a name too long (%s)", (Object[])new Object[]{UsernameHelper.getRawUsername((PlayerEntity)player), waypointName});
            } else if (waypointLore.length() > 160) {
                LOTRLog.warn((String)"Player %s tried to create a custom waypoint with lore too long (%s)", (Object[])new Object[]{UsernameHelper.getRawUsername((PlayerEntity)player), waypointLore});
            } else {
                boolean isPublic = false;
                Boolean retrievedValue = ExtendedReflectionHelper.getBooleanFieldFromClass(CPacketCreateCustomWaypoint.class, packet, "isPublic");
                if (retrievedValue == null) {
                    ExtendedLog.error("Failed to parse CreateCustomWaypointPacket public modifier! Setting waypoint to private by default!");
                } else {
                    isPublic = retrievedValue;
                }
                BlockPos waypointPos = CustomWaypointStructureHandler.INSTANCE.getPlayerClickedOnBlockToCreate((PlayerEntity)player);
                if (waypointPos == null) {
                    LOTRLog.warn((String)"Player %s tried to create a custom waypoint without having clicked on a block", (Object[])new Object[]{UsernameHelper.getRawUsername((PlayerEntity)player)});
                } else {
                    Vector3d playerPos = player.func_213303_ch();
                    if (waypointPos.func_218138_a((IPosition)playerPos, false) >= 64.0) {
                        LOTRLog.warn((String)"Player %s tried to create a custom waypoint on a block too far away (player pos = %s, clicked pos = %s)", (Object[])new Object[]{UsernameHelper.getRawUsername((PlayerEntity)player), playerPos.toString(), waypointPos.toString()});
                    } else if (!CustomWaypointStructureHandler.INSTANCE.isFocalPointOfCompletableStructure(world, waypointPos)) {
                        LOTRLog.warn((String)"Player %s tried to create a custom waypoint without a completed structure (player pos = %s, clicked pos = %s)", (Object[])new Object[]{UsernameHelper.getRawUsername((PlayerEntity)player), playerPos.toString(), waypointPos.toString()});
                    } else if (CustomWaypointStructureHandler.INSTANCE.hasAdjacentWaypointMarker((World)world, waypointPos)) {
                        LOTRLog.warn((String)"Player %s tried to create a custom waypoint at an already completed structure (player pos = %s, clicked pos = %s)", (Object[])new Object[]{UsernameHelper.getRawUsername((PlayerEntity)player), playerPos.toString(), waypointPos.toString()});
                    } else {
                        CustomWaypointStructureHandler.INSTANCE.clearPlayerClickedOnBlockToCreate((PlayerEntity)player);
                        CustomWaypoint createdWaypoint = ftData.createNewCustomWaypoint(waypointName, waypointLore, isPublic, waypointPos);
                        CustomWaypointStructureHandler.INSTANCE.completeStructureWithCreatedWaypoint((PlayerEntity)player, createdWaypoint);
                        LOTRUtil.sendMessage((PlayerEntity)player, (ITextComponent)new TranslationTextComponent("chat.lotr.cwp.create", new Object[]{waypointName, ftData.getNumCustomWaypoints(), ftData.getMaxCustomWaypoints()}));
                        RedBookItem.playCompleteWaypointActionSound((World)world, (BlockPos)waypointPos);
                        player.func_195066_a(LOTRStats.CREATE_CUSTOM_WAYPOINT);
                    }
                }
            }
        }
    }
}

