/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.mixins.lotr.common.tileentity;

import com.github.maximuslotro.lotrrextended.ExtendedLog;
import com.github.maximuslotro.lotrrextended.common.config.ExtendedServerConfig;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import lotr.common.inv.KegContainer;
import lotr.common.inventory.ExtendedSingleItemDataHolderIInventory;
import lotr.common.item.VesselDrinkItem;
import lotr.common.recipe.DrinkBrewingRecipe;
import lotr.common.recipe.LOTRRecipes;
import lotr.common.tileentity.KegTileEntity;
import lotr.common.util.DrinkUtils;
import lotr.common.util.tileentity.ExtendedLootTableAccessor;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IIntArray;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={KegTileEntity.class})
public class MixinKegTileEntity
implements ExtendedLootTableAccessor {
    @Nullable
    public ResourceLocation lootTable;
    protected long lootTableSeed;
    @Shadow(remap=false)
    @Final
    private static final int[] SLOTS_INGREDIENT = new int[]{0, 1, 2, 3, 4, 5};
    @Shadow(remap=false)
    @Final
    private static final int[] SLOTS_WATER = new int[]{6, 7, 8};
    @Shadow(remap=false)
    private KegTileEntity.KegMode kegMode;
    @Shadow(remap=false)
    private ResourceLocation currentBrewingRecipe;
    @Shadow(remap=false)
    private int brewTimeTotal;
    @Shadow(remap=false)
    private NonNullList<ItemStack> inventory;
    @Final
    @Shadow(remap=false)
    private IIntArray kegData;

    @Shadow(remap=false)
    private void resendKegInventoryToPlayers() {
    }

    @Shadow(remap=false)
    private boolean isIngredientOrWaterSlot(int index) {
        return false;
    }

    @Overwrite(remap=false)
    private void updateBrewingRecipe() {
        if (this.kegMode == KegTileEntity.KegMode.EMPTY) {
            Inventory proxyInv = new Inventory(9);
            for (int i : SLOTS_INGREDIENT) {
                proxyInv.func_70299_a(i, this.func_70301_a(i));
            }
            for (int i : SLOTS_WATER) {
                proxyInv.func_70299_a(i, this.func_70301_a(i));
            }
            KegTileEntity entity = (KegTileEntity)this;
            if (!entity.func_145830_o()) {
                this.currentBrewingRecipe = null;
                this.func_70299_a(9, ItemStack.field_190927_a);
                this.brewTimeTotal = 0;
                entity.func_70296_d();
                return;
            }
            World level = entity.func_145831_w();
            Optional opt = level.func_199532_z().func_215371_a(LOTRRecipes.DRINK_BREWING, (IInventory)proxyInv, level);
            if (opt.isPresent()) {
                DrinkBrewingRecipe recipe = (DrinkBrewingRecipe)opt.get();
                this.currentBrewingRecipe = recipe.func_199560_c();
                ItemStack result = recipe.func_77572_b((IInventory)proxyInv);
                result.func_190920_e(16);
                VesselDrinkItem.setPotency((ItemStack)result, (VesselDrinkItem.Potency)VesselDrinkItem.Potency.WEAK);
                this.func_70299_a(9, result);
                this.brewTimeTotal = recipe.getBrewTime();
            } else {
                this.currentBrewingRecipe = null;
                this.func_70299_a(9, ItemStack.field_190927_a);
                this.brewTimeTotal = 0;
            }
            entity.func_70296_d();
            if (!level.field_72995_K) {
                this.resendKegInventoryToPlayers();
            }
        }
    }

    @Inject(method={"save(Lnet/minecraft/nbt/CompoundNBT;)Lnet/minecraft/nbt/CompoundNBT;"}, at={@At(value="TAIL")})
    public void injectedSave(CompoundNBT nbt, CallbackInfoReturnable<CompoundNBT> info) {
        if (this.lootTable != null) {
            nbt.func_74778_a("LootTable", this.lootTable.toString());
            if (this.lootTableSeed != 0L) {
                nbt.func_74772_a("LootTableSeed", this.lootTableSeed);
            }
        }
    }

    @Inject(method={"load(Lnet/minecraft/block/BlockState;Lnet/minecraft/nbt/CompoundNBT;)V"}, at={@At(value="TAIL")})
    public void load(BlockState state, CompoundNBT nbt, CallbackInfo info) {
        if (nbt.func_150297_b("LootTable", 8)) {
            this.lootTable = new ResourceLocation(nbt.func_74779_i("LootTable"));
            this.lootTableSeed = nbt.func_74763_f("LootTableSeed");
        }
    }

    @Overwrite
    protected Container func_213906_a(int id, PlayerInventory playerInventory) {
        this.unpackLootTableKeg(playerInventory.field_70458_d);
        return new KegContainer(id, playerInventory, (IInventory)((KegTileEntity)this), this.kegData);
    }

    @Overwrite
    public ItemStack func_70301_a(int index) {
        this.unpackLootTableKeg(null);
        return (ItemStack)this.inventory.get(index);
    }

    @Overwrite
    public ItemStack func_70298_a(int index, int count) {
        this.unpackLootTableKeg(null);
        ItemStack ret = ItemStackHelper.func_188382_a(this.inventory, (int)index, (int)count);
        if (this.isIngredientOrWaterSlot(index)) {
            this.updateBrewingRecipe();
        }
        return ret;
    }

    @Overwrite
    public ItemStack func_70304_b(int index) {
        this.unpackLootTableKeg(null);
        ItemStack ret = ItemStackHelper.func_188383_a(this.inventory, (int)index);
        if (this.isIngredientOrWaterSlot(index)) {
            this.updateBrewingRecipe();
        }
        return ret;
    }

    @Overwrite
    public boolean func_191420_l() {
        this.unpackLootTableKeg(null);
        for (ItemStack itemstack : this.inventory) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    @Overwrite
    public void func_70299_a(int index, ItemStack stack) {
        this.unpackLootTableKeg(null);
        this.inventory.get(index);
        this.inventory.set(index, (Object)stack);
        KegTileEntity entity = (KegTileEntity)this;
        if (stack.func_190916_E() > entity.func_70297_j_()) {
            stack.func_190920_e(entity.func_70297_j_());
        }
        if (this.isIngredientOrWaterSlot(index)) {
            this.updateBrewingRecipe();
        }
    }

    private void unpackLootTableKeg(@Nullable PlayerEntity player) {
        KegTileEntity entity = (KegTileEntity)this;
        try {
            if (!((Boolean)ExtendedServerConfig.enableDevMode.get()).booleanValue() && this.lootTable != null && entity.func_145831_w() != null && entity.func_145831_w().func_73046_m() != null) {
                LootTable loottable = entity.func_145831_w().func_73046_m().func_200249_aQ().func_186521_a(this.lootTable);
                if (player instanceof ServerPlayerEntity) {
                    CriteriaTriggers.field_232608_N_.func_235478_a_((ServerPlayerEntity)player, this.lootTable);
                }
                this.lootTable = null;
                LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerWorld)entity.func_145831_w()).func_216015_a(LootParameters.field_237457_g_, (Object)Vector3d.func_237489_a_((Vector3i)entity.func_174877_v())).func_216016_a(this.lootTableSeed);
                if (player != null) {
                    lootcontext$builder.func_186469_a(player.func_184817_da()).func_216015_a(LootParameters.field_216281_a, (Object)player);
                }
                ExtendedSingleItemDataHolderIInventory placeHolder = new ExtendedSingleItemDataHolderIInventory();
                loottable.func_216118_a((IInventory)placeHolder, lootcontext$builder.func_216022_a(LootParameterSets.field_216261_b));
                entity.fillBrewedWith(DrinkUtils.createDrink(new Random(), placeHolder.func_70301_a(0)));
            }
        }
        catch (NullPointerException e) {
            ExtendedLog.error("Caught a null-pointer exception while unpacking keg loot-table");
            ExtendedLog.error("Location: " + this.lootTable.toString() + ", Pos: " + entity.func_174877_v().toString());
            e.printStackTrace();
            ExtendedLog.error("Please report this if it happens!");
        }
    }

    @Override
    public void setLootTable(ResourceLocation table, long seed) {
        this.lootTable = table;
        this.lootTableSeed = seed;
    }

    @Override
    public ResourceLocation getLootTable() {
        return this.lootTable;
    }
}

