/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.mixins.lotr.common.tileentity;

import com.github.maximuslotro.lotrrextended.ExtendedLog;
import com.github.maximuslotro.lotrrextended.common.config.ExtendedServerConfig;
import java.util.Random;
import javax.annotation.Nullable;
import lotr.common.inventory.ExtendedSingleItemDataHolderIInventory;
import lotr.common.item.VesselDrinkItem;
import lotr.common.item.VesselType;
import lotr.common.tileentity.VesselDrinkTileEntity;
import lotr.common.util.tileentity.ExtendedLootTableAccessor;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={VesselDrinkTileEntity.class})
public class MixinVesselDrinkTileEntity
implements ExtendedLootTableAccessor,
ITickableTileEntity {
    @Nullable
    public ResourceLocation lootTable;
    protected long lootTableSeed;
    private boolean ticked = false;
    @Shadow(remap=false)
    private ItemStack drinkItem;
    @Shadow(remap=false)
    private VesselType vesselType;

    public void func_73660_a() {
        if (!((Boolean)ExtendedServerConfig.enableDevMode.get()).booleanValue()) {
            VesselDrinkTileEntity entity = (VesselDrinkTileEntity)this;
            if (this.lootTable != null && entity.func_145831_w() != null && !entity.func_145831_w().func_201670_d() && !this.ticked) {
                this.ticked = true;
                this.unpackLootTableVessel(null);
            }
        }
    }

    @Inject(method={"save(Lnet/minecraft/nbt/CompoundNBT;)Lnet/minecraft/nbt/CompoundNBT;"}, at={@At(value="TAIL")})
    public void injectedSave(CompoundNBT nbt, CallbackInfoReturnable<CompoundNBT> info) {
        if (this.lootTable != null) {
            nbt.func_74778_a("LootTable", this.lootTable.toString());
            if (this.lootTableSeed != 0L) {
                nbt.func_74772_a("LootTableSeed", this.lootTableSeed);
            }
        }
    }

    @Inject(method={"load(Lnet/minecraft/block/BlockState;Lnet/minecraft/nbt/CompoundNBT;)V"}, at={@At(value="TAIL")})
    public void load(BlockState state, CompoundNBT nbt, CallbackInfo info) {
        if (nbt.func_150297_b("LootTable", 8)) {
            this.lootTable = new ResourceLocation(nbt.func_74779_i("LootTable"));
            this.lootTableSeed = nbt.func_74763_f("LootTableSeed");
        }
    }

    @Overwrite(remap=false)
    public ItemStack getVesselItem() {
        VesselDrinkTileEntity entity = (VesselDrinkTileEntity)this;
        if (entity.func_145830_o() && !entity.func_145831_w().func_201670_d()) {
            this.unpackLootTableVessel(null);
        }
        if (this.drinkItem.func_190926_b()) {
            return this.vesselType.createEmpty();
        }
        ItemStack copy = this.drinkItem.func_77946_l();
        if (copy.func_77973_b() instanceof VesselDrinkItem) {
            VesselDrinkItem.setVessel((ItemStack)copy, (VesselType)this.vesselType);
        }
        copy.func_190920_e(1);
        return copy;
    }

    @Overwrite(remap=false)
    private void writeVessel(CompoundNBT nbt) {
        this.unpackLootTableVessel(null);
        nbt.func_218657_a("DrinkItem", (INBT)this.drinkItem.func_77955_b(new CompoundNBT()));
        nbt.func_74778_a("Vessel", this.vesselType.getCodeName());
    }

    private void unpackLootTableVessel(@Nullable PlayerEntity player) {
        VesselDrinkTileEntity entity = (VesselDrinkTileEntity)this;
        try {
            if (!((Boolean)ExtendedServerConfig.enableDevMode.get()).booleanValue() && this.lootTable != null && entity.func_145831_w() != null && !entity.func_145831_w().func_201670_d() && entity.func_145831_w().func_73046_m() != null) {
                LootTable loottable = entity.func_145831_w().func_73046_m().func_200249_aQ().func_186521_a(this.lootTable);
                if (player instanceof ServerPlayerEntity) {
                    CriteriaTriggers.field_232608_N_.func_235478_a_((ServerPlayerEntity)player, this.lootTable);
                }
                this.lootTable = null;
                LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerWorld)entity.func_145831_w()).func_216015_a(LootParameters.field_237457_g_, (Object)Vector3d.func_237489_a_((Vector3i)entity.func_174877_v())).func_216016_a(this.lootTableSeed);
                if (player != null) {
                    lootcontext$builder.func_186469_a(player.func_184817_da()).func_216015_a(LootParameters.field_216281_a, (Object)player);
                }
                ExtendedSingleItemDataHolderIInventory placeHolder = new ExtendedSingleItemDataHolderIInventory();
                loottable.func_216118_a((IInventory)placeHolder, lootcontext$builder.func_216022_a(LootParameterSets.field_216261_b));
                ItemStack drink = placeHolder.func_70301_a(0);
                VesselDrinkItem.setVessel((ItemStack)drink, (VesselType)this.vesselType);
                VesselDrinkItem.setPotency((ItemStack)drink, (VesselDrinkItem.Potency)VesselDrinkItem.Potency.randomForNPC((Random)new Random()));
                drink.func_190920_e(1);
                entity.setVesselItem(drink);
            }
        }
        catch (NullPointerException e) {
            ExtendedLog.error("Caught a null-pointer exception while unpacking vessel loot-table");
            ExtendedLog.error("Location: " + this.lootTable.toString() + ", Pos: " + entity.func_174877_v().toString());
            e.printStackTrace();
            ExtendedLog.error("Please report this if it happens!");
        }
    }

    @Override
    public void setLootTable(ResourceLocation table, long seed) {
        this.lootTable = table;
        this.lootTableSeed = seed;
        this.ticked = false;
    }

    @Override
    public ResourceLocation getLootTable() {
        return this.lootTable;
    }
}

