/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.mixins.lotr.common.world.spawning;

import com.github.maximuslotro.lotrrextended.common.config.ExtendedServerConfig;
import com.google.common.collect.Streams;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import lotr.common.entity.npc.NPCEntity;
import lotr.common.world.spawning.RenewedNPCSpawner;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={RenewedNPCSpawner.class})
public class MixinRenewedNPCSpawner {
    @Shadow(remap=false)
    private boolean includeInNPCCount(Entity e) {
        return false;
    }

    @Shadow(remap=false)
    private double performSpawningInChunk(ServerWorld world, ChunkPos chunkPos, Random rand) {
        return 0.0;
    }

    @Shadow(remap=false)
    private List<ChunkPos> gatherSpawnableChunks(ServerWorld world) {
        return null;
    }

    @Shadow(remap=false)
    private double getNPCDensityCapForChunk(ServerWorld world, ChunkPos chunkPos) {
        return 0.0;
    }

    @Overwrite(remap=false)
    private void runSpawnCycle(ServerWorld world) {
        block1: {
            List<ChunkPos> chunks = this.gatherSpawnableChunks(world);
            double sumDensity = chunks.stream().collect(Collectors.summingDouble(chunk -> this.getNPCDensityCapForChunk(world, (ChunkPos)chunk)));
            int cap = (int)(sumDensity * 0.51 * (Double)ExtendedServerConfig.npcGlobalSpawnDampingCoefficient.get());
            double count = Streams.stream((Iterable)world.func_241136_z_()).filter(this::includeInNPCCount).map(e -> (NPCEntity)e).collect(Collectors.summingDouble(NPCEntity::getSpawnCountWeight));
            if (!(count < (double)cap)) break block1;
            Collections.shuffle(chunks);
            Random rand = world.field_73012_v;
            for (ChunkPos chunkPos : chunks) {
                if ((count += this.performSpawningInChunk(world, chunkPos, rand)) >= (double)cap) break;
            }
        }
    }
}

