/*
 * Decompiled with CFR 0.152.
 */
package com.github.maximuslotro.lotrrextended.zzzDepricated;

import com.github.maximuslotro.lotrrextended.ExtendedLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.resources.IResource;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.FolderName;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;

public class StructureFileIO {
    private static final FolderName STRUCTURE_GEN_FOLDER = new FolderName("structure_gen");
    private static File MOD_FILE;

    public static void init() {
        List mods = ModList.get().getMods();
        for (ModInfo mod : mods) {
            if (!mod.getModId().equals("lotrextended")) continue;
            MOD_FILE = mod.getOwningFile().getFile().getFilePath().toFile();
            break;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CompoundNBT load(String fileName, MinecraftServer server) {
        try {
            System.out.println("Loading structure file " + fileName);
            if (StructureFileIO.getStructureScanDataFile(fileName, server).exists()) {
                FileInputStream fileStream = new FileInputStream(StructureFileIO.getStructureScanDataFile(fileName, server));
                CompoundNBT compound = CompressedStreamTools.func_74796_a((InputStream)fileStream);
                fileStream.close();
                return compound;
            }
            ResourceLocation location = new ResourceLocation("lotrextended", "structures/" + fileName + ".dat");
            try (IResource iresource = server.getDataPackRegistries().func_240970_h_().func_199002_a(location);){
                CompoundNBT compoundNBT = CompressedStreamTools.func_74796_a((InputStream)iresource.func_199027_b());
                return compoundNBT;
            }
            catch (FileNotFoundException filenotfoundexception) {
                ExtendedLog.error("Failed to find structure file: " + fileName);
                filenotfoundexception.printStackTrace();
                return null;
            }
            catch (Throwable throwable6) {
                ExtendedLog.error("Failed to load structure file: " + fileName, throwable6.toString());
                return null;
            }
        }
        catch (Exception var2) {
            ExtendedLog.error("Error loading structure file: " + fileName);
            var2.printStackTrace();
            return null;
        }
    }

    public static void save(String fileName, MinecraftServer server, CompoundNBT compound) {
        try {
            File structureGen = StructureFileIO.getStructureScanDataFile(fileName, server);
            if (!structureGen.exists()) {
                CompressedStreamTools.func_74799_a((CompoundNBT)new CompoundNBT(), (OutputStream)new FileOutputStream(structureGen));
            }
            CompressedStreamTools.func_74799_a((CompoundNBT)compound, (OutputStream)new FileOutputStream(structureGen));
        }
        catch (Exception var3) {
            ExtendedLog.error("Error saving structure: " + fileName);
            var3.printStackTrace();
        }
    }

    private static File getStructureScanDataFile(String fileName, MinecraftServer server) {
        File dir = server.func_240776_a_(STRUCTURE_GEN_FOLDER).toFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return new File(dir, fileName + ".dat");
    }
}

