/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.gui.inventory;

import com.github.maximuslotro.lotrrextended.common.network.ExtendedCPacketStopInteractingWithInteractable;
import com.github.maximuslotro.lotrrextended.common.network.ExtendedCPacketTradeSellItems;
import com.github.maximuslotro.lotrrextended.common.network.ExtendedPacketHandler;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import lotr.client.gui.widget.button.TradeSellButton;
import lotr.common.inventory.ExtendedTradeContainer;
import lotr.common.util.CoinUtils;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class ExtendedTradeScreen
extends ContainerScreen<ExtendedTradeContainer> {
    private int guiLeft;
    private int guiTop;
    private ExtendedTradeContainer container;
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("lotr:gui/trade.png");
    private PlayerEntity player;

    public ExtendedTradeScreen(ExtendedTradeContainer container, PlayerInventory playerInventory, ITextComponent title) {
        super((Container)container, playerInventory, title);
        this.field_147000_g = 270;
        this.field_146999_f = 176;
        this.guiLeft = (this.field_230708_k_ - this.field_146999_f) / 2;
        this.guiTop = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.container = container;
        this.player = playerInventory.field_70458_d;
    }

    public void func_230430_a_(MatrixStack matrix, int p_98419_, int p_98420_, float p_98421_) {
        this.func_230446_a_(matrix);
        super.func_230430_a_(matrix, p_98419_, p_98420_, p_98421_);
        this.func_230459_a_(matrix, p_98419_, p_98420_);
    }

    protected void func_230450_a_(MatrixStack matrix, float p_230450_2_, int p_230450_3_, int p_230450_4_) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(GUI_TEXTURE);
        int i = (this.field_230708_k_ - this.field_146999_f) / 2;
        int j = (this.field_230709_l_ - this.field_147000_g) / 2;
        ExtendedTradeScreen.func_238463_a_((MatrixStack)matrix, (int)i, (int)j, (float)0.0f, (float)0.0f, (int)this.field_146999_f, (int)this.field_147000_g, (int)280, (int)280);
    }

    protected void func_230459_a_(MatrixStack matrix, int p_230459_2_, int p_230459_3_) {
        int tradesUsed;
        ArrayList<Object> tooltip;
        int i;
        super.func_230459_a_(matrix, p_230459_2_, p_230459_3_);
        for (i = 0; i < this.container.getSoldPrices().length; ++i) {
            if (!this.isMouseOverElement(p_230459_2_, p_230459_3_, 8 + 18 * i, 61, 18, 18)) continue;
            tooltip = new ArrayList<Object>();
            if (this.container.getSoldQuantities()[i] == 0) {
                tooltip.add(new TranslationTextComponent("gui.lotrextended.trading.tooltip.cooldown").func_240699_a_(TextFormatting.ITALIC));
            } else {
                tradesUsed = this.container.getSoldOriginalQuantities()[i] - this.container.getSoldQuantities()[i];
                tooltip.add(new TranslationTextComponent("gui.lotrextended.trading.tooltip.trades_used", new Object[]{new StringTextComponent(String.valueOf(tradesUsed)), new StringTextComponent(String.valueOf(this.container.getSoldOriginalQuantities()[i]))}));
            }
            tooltip.add(new TranslationTextComponent("gui.lotrextended.trading.tooltip.new_trade_freq"));
            this.func_243308_b(matrix, tooltip, p_230459_2_, p_230459_3_);
        }
        for (i = 0; i < this.container.getBoughtPrices().length; ++i) {
            if (!this.isMouseOverElement(p_230459_2_, p_230459_3_, 8 + 18 * i, 112, 18, 18)) continue;
            tooltip = new ArrayList();
            if (this.container.getBoughtQuantities()[i] == 0) {
                tooltip.add(new TranslationTextComponent("gui.lotrextended.trading.tooltip.cooldown").func_240699_a_(TextFormatting.ITALIC));
            } else {
                tradesUsed = this.container.getBoughtOriginalQuantities()[i] - this.container.getBoughtQuantities()[i];
                tooltip.add(new TranslationTextComponent("gui.lotrextended.trading.tooltip.trades_used", new Object[]{new StringTextComponent(String.valueOf(tradesUsed)), new StringTextComponent(String.valueOf(this.container.getBoughtOriginalQuantities()[i]))}));
            }
            tooltip.add(new TranslationTextComponent("gui.lotrextended.trading.tooltip.new_trade_freq"));
            this.func_243308_b(matrix, tooltip, p_230459_2_, p_230459_3_);
        }
    }

    private boolean isMouseOverElement(int mouseX, int mouseY, int x, int y, int width, int height) {
        return mouseX >= x + this.guiLeft && mouseX <= x + width + this.guiLeft && mouseY >= y + this.guiTop && mouseY <= y + height + this.guiTop;
    }

    protected void func_230451_b_(MatrixStack matrix, int p_230451_2_, int p_230451_3_) {
        int i;
        ExtendedTradeScreen.func_238467_a_((MatrixStack)matrix, (int)180, (int)188, (int)(199 + this.field_230712_o_.func_78256_a(String.valueOf(CoinUtils.totalValueInPlayerInventory(this.player.field_71071_by)))), (int)203, (int)-1728053248);
        this.field_230706_i_.func_110434_K().func_110577_a(GUI_TEXTURE);
        ExtendedTradeScreen.func_238463_a_((MatrixStack)matrix, (int)179, (int)187, (float)176.0f, (float)54.0f, (int)18, (int)18, (int)280, (int)280);
        this.field_230712_o_.func_238421_b_(matrix, String.valueOf(CoinUtils.totalValueInPlayerInventory(this.player.field_71071_by)), 196.0f, 192.0f, -1);
        this.field_230712_o_.func_238421_b_(matrix, this.container.trader.getTraderName(), (float)((this.field_146999_f - 32 - this.field_230712_o_.func_78256_a(this.container.trader.getTraderName())) / 2 + 16), 11.0f, 0x404040);
        this.field_230712_o_.func_243248_b(matrix, this.field_213127_e.func_145748_c_(), 8.0f, (float)this.field_238745_s_, 0x404040);
        this.field_230712_o_.func_243248_b(matrix, (ITextComponent)new TranslationTextComponent("gui.lotrextended.trading.buy"), 8.0f, 30.0f, 0x404040);
        this.field_230712_o_.func_243248_b(matrix, (ITextComponent)new TranslationTextComponent("gui.lotrextended.trading.sell"), 8.0f, 82.0f, 0x404040);
        this.field_230712_o_.func_243248_b(matrix, (ITextComponent)new TranslationTextComponent("gui.lotrextended.trading.sell_offers"), 8.0f, 131.0f, 0x404040);
        if (this.container.getSellValue() > 0) {
            this.field_230712_o_.func_238421_b_(matrix, "x " + this.container.getSellValue(), 99.0f, 168.0f, 0x404040);
        }
        for (i = 0; i < this.container.getSoldPrices().length; ++i) {
            int amount = this.container.getSoldPrices()[i];
            String priceStr = String.valueOf(this.container.getSoldPrices()[i]);
            if (this.container.getSoldQuantities()[i] == 0) {
                priceStr = "...";
            }
            this.field_230712_o_.func_238421_b_(matrix, priceStr, (float)(8 + 18 * i + (18 - this.field_230712_o_.func_78256_a(priceStr)) / 2), 62.0f, 0x404040);
        }
        for (i = 0; i < this.container.getBoughtPrices().length; ++i) {
            String priceStr = String.valueOf(this.container.getBoughtPrices()[i]);
            if (this.container.getBoughtQuantities()[i] == 0) {
                priceStr = "...";
            }
            this.field_230712_o_.func_238421_b_(matrix, priceStr, (float)(8 + 18 * i + (18 - this.field_230712_o_.func_78256_a(priceStr)) / 2), 114.0f, 0x404040);
        }
        for (i = 0; i < this.container.getSoldQuantities().length; ++i) {
            float amountUsed = (float)(this.container.getSoldOriginalQuantities()[i] - this.container.getSoldQuantities()[i]) / (float)this.container.getSoldOriginalQuantities()[i];
            int pixels = (int)(amountUsed * 18.0f);
            if (pixels > 18) {
                pixels = 18;
            }
            if (pixels <= 0) continue;
            ExtendedTradeScreen.func_238467_a_((MatrixStack)matrix, (int)(7 + i * 18), (int)39, (int)(7 + i * 18 + pixels), (int)57, (int)-432589001);
        }
        this.field_230706_i_.func_110434_K().func_110577_a(GUI_TEXTURE);
        for (i = 0; i < this.container.getBoughtQuantities().length; ++i) {
            float amountUsed = (float)(this.container.getBoughtOriginalQuantities()[i] - this.container.getBoughtQuantities()[i]) / (float)this.container.getBoughtOriginalQuantities()[i];
            int pixels = (int)(amountUsed * 18.0f);
            if (pixels > 18) {
                pixels = 18;
            }
            if (pixels <= 0) continue;
            ExtendedTradeScreen.func_238467_a_((MatrixStack)matrix, (int)(7 + i * 18), (int)91, (int)(7 + i * 18 + pixels), (int)109, (int)-432589001);
        }
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.field_147000_g = 270;
        this.field_146999_f = 176;
        this.field_238745_s_ = 178;
        this.guiLeft = (this.field_230708_k_ - this.field_146999_f) / 2;
        this.guiTop = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.func_230480_a_((Widget)new TradeSellButton(this.guiLeft + 79, this.guiTop + 164, this.container, btn -> this.sellItems()));
    }

    private void sellItems() {
        if (this.container.getSellValue() > 0) {
            this.container.trader.playTradeSound();
            ExtendedPacketHandler.sendToServer(new ExtendedCPacketTradeSellItems());
        }
    }

    public void func_231175_as__() {
        super.func_231175_as__();
        ExtendedPacketHandler.sendToServer(new ExtendedCPacketStopInteractingWithInteractable(this.container.traderNPC.func_145782_y()));
        this.container.trader.removePlayerFromInteracting(this.player);
    }
}

