/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.data;

import com.github.maximuslotro.lotrrextended.common.config.ExtendedServerConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import lotr.common.LOTRMod;
import lotr.common.data.LOTRPlayerData;
import lotr.common.data.PlayerDataModule;
import lotr.common.fellowship.ExtendedFellowship;
import lotr.common.fellowship.ExtendedFellowshipHolderServer;
import lotr.common.fellowship.ExtendedFellowshipInvite;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class ExtendedFellowshipDataModule
extends PlayerDataModule {
    private List<UUID> fellowshipIDs = new ArrayList<UUID>();
    private List<ExtendedFellowshipInvite> invites = new ArrayList<ExtendedFellowshipInvite>();

    public ExtendedFellowshipDataModule(LOTRPlayerData pd) {
        super(pd);
    }

    public void save(CompoundNBT playerNBT) {
        ListNBT fellowships = new ListNBT();
        for (UUID fsID : this.fellowshipIDs) {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74778_a("ID", fsID.toString());
            fellowships.add((Object)nbt);
        }
        playerNBT.func_218657_a("Fellowships", (INBT)fellowships);
        ListNBT fellowshipInvites = new ListNBT();
        for (ExtendedFellowshipInvite invite : this.invites) {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74778_a("ID", invite.fellowshipID.toString());
            if (invite.Invitor != null) {
                nbt.func_74778_a("InviterID", invite.Invitor.toString());
            }
            fellowshipInvites.add((Object)nbt);
        }
        playerNBT.func_218657_a("FellowshipInvites", (INBT)fellowshipInvites);
    }

    public void load(CompoundNBT playerNBT) {
        this.fellowshipIDs.clear();
        ListNBT fellowships = playerNBT.func_150295_c("Fellowships", 10);
        for (int i = 0; i < fellowships.size(); ++i) {
            CompoundNBT nbt = fellowships.func_150305_b(i);
            UUID fsID = UUID.fromString(nbt.func_74779_i("ID"));
            if (fsID == null) continue;
            this.fellowshipIDs.add(fsID);
        }
        this.invites.clear();
        ListNBT fellowshipInvite = playerNBT.func_150295_c("FellowshipInvites", 10);
        for (int i = 0; i < fellowshipInvite.size(); ++i) {
            CompoundNBT nbt = fellowshipInvite.func_150305_b(i);
            UUID fsID = UUID.fromString(nbt.func_74779_i("ID"));
            if (fsID == null) continue;
            UUID inviterID = null;
            if (nbt.func_74764_b("InviterID")) {
                inviterID = UUID.fromString(nbt.func_74779_i("InviterID"));
            }
            this.invites.add(new ExtendedFellowshipInvite(fsID, inviterID));
        }
    }

    public List<UUID> getFellowshipIDs() {
        return this.fellowshipIDs;
    }

    public List<ExtendedFellowship> getFellowships() {
        ArrayList<ExtendedFellowship> ships = new ArrayList<ExtendedFellowship>();
        for (UUID ids : this.fellowshipIDs) {
            ExtendedFellowship fellowship = ExtendedFellowshipHolderServer.getFellowship(ServerLifecycleHooks.getCurrentServer().func_241755_D_(), ids);
            if (fellowship == null) continue;
            ships.add(fellowship);
        }
        return ships;
    }

    public void addFellowship(ExtendedFellowship fellowship) {
        UUID fsID;
        if (fellowship.isInFellowship(this.getPlayerUUID()) && !this.fellowshipIDs.contains(fsID = fellowship.getFellowshipId())) {
            this.fellowshipIDs.add(fsID);
            this.markDirty();
        }
    }

    public void removeFellowship(ExtendedFellowship fellowship) {
        UUID fsID;
        if ((!fellowship.isFellowshipOwner(this.getPlayerUUID()) || fellowship.isDisbanded()) && this.fellowshipIDs.contains(fsID = fellowship.getFellowshipId())) {
            this.fellowshipIDs.remove(fsID);
            this.markDirty();
        }
    }

    public void renameFellowship(ExtendedFellowship fs, String name) {
        if (fs.hasEditPowers(this.getPlayerUUID())) {
            fs.setFellowshipName(name);
        }
    }

    public void setFellowshipIcon(ExtendedFellowship fs, ItemStack itemstack) {
        if (fs.hasEditPowers(this.getPlayerUUID()) || fs.isFellowshipAdmin(this.getPlayerUUID())) {
            fs.setIcon(itemstack);
        }
    }

    public void setFellowshipPreventPVP(ExtendedFellowship fs, boolean prevent) {
        if (fs.hasEditPowers(this.getPlayerUUID()) || fs.isFellowshipAdmin(this.getPlayerUUID())) {
            fs.setPreventPVP(prevent);
        }
    }

    public void setFellowshipPreventHiredFF(ExtendedFellowship fs, boolean prevent) {
        if (fs.hasEditPowers(this.getPlayerUUID()) || fs.isFellowshipAdmin(this.getPlayerUUID())) {
            fs.setPreventHiredFF(prevent);
        }
    }

    public void setFellowshipShowMapLocations(ExtendedFellowship fs, boolean show) {
        if (fs.hasEditPowers(this.getPlayerUUID())) {
            fs.setHideMapLocation(show);
        }
    }

    public void removeFellowshipAdmin(ExtendedFellowship fs, UUID player) {
        if (fs.isFellowshipOwner(this.getPlayerUUID())) {
            fs.removeFellowshipAdmin(player);
            PlayerEntity owner = this.getPlayerFromUUID(player);
            fs.createNotification("command.lotrextended.fellowship.client.admin.removed", owner, fs.getFellowshipName());
        }
    }

    public void addFellowshipAdmin(ExtendedFellowship fs, UUID player) {
        if (fs.isFellowshipOwner(this.getPlayerUUID())) {
            fs.addFellowshipAdmin(player);
            PlayerEntity owner = this.getPlayerFromUUID(player);
            fs.createNotification("command.lotrextended.fellowship.client.admin.added", owner, fs.getFellowshipName());
        }
    }

    public void addPlayer(ExtendedFellowship fs, UUID player) {
        if (fs.hasEditPowers(this.getPlayerUUID())) {
            fs.addFellowshipMember(player);
        }
    }

    public void addInvitePlayer(ExtendedFellowship fs, UUID playerSendingInvite) {
        for (ExtendedFellowshipInvite extendedFellowshipInvite : this.invites) {
            if (!extendedFellowshipInvite.fellowshipID.equals(fs.getFellowshipId())) continue;
            return;
        }
        for (UUID uUID : this.fellowshipIDs) {
            if (!uUID.equals(fs.getFellowshipId())) continue;
            return;
        }
        this.invites.add(new ExtendedFellowshipInvite(fs.getFellowshipId(), playerSendingInvite));
        this.markDirty();
        PlayerEntity owner = this.getPlayerFromUUID(this.getPlayerUUID());
        fs.createNotification("command.lotrextended.fellowship.client.invite.recieved", owner);
    }

    public void removeInvitePlayer(ExtendedFellowship fs, boolean reject) {
        ExtendedFellowshipInvite foundInvite = null;
        for (ExtendedFellowshipInvite invite : this.invites) {
            if (!invite.fellowshipID.equals(fs.getFellowshipId())) continue;
            foundInvite = invite;
            break;
        }
        if (foundInvite != null) {
            this.invites.remove(foundInvite);
            this.markDirty();
            if (reject) {
                PlayerEntity player = this.getPlayerFromUUID(this.getPlayerUUID());
                fs.createNotification("command.lotrextended.fellowship.client.invite.rejected", player);
            }
        }
    }

    public void acceptInvitePlayer(ExtendedFellowship fs) {
        ExtendedFellowshipInvite existingInvite = null;
        for (ExtendedFellowshipInvite invite : this.invites) {
            if (!invite.fellowshipID.equals(fs.getFellowshipId())) continue;
            existingInvite = invite;
            break;
        }
        if (existingInvite != null) {
            if (fs.isDisbanded()) {
                this.removeInvitePlayer(fs, false);
                return;
            }
            fs.addFellowshipMember(this.getPlayerUUID());
            if (!this.fellowshipIDs.contains(fs.getFellowshipId())) {
                this.fellowshipIDs.add(fs.getFellowshipId());
            }
            this.invites.remove(existingInvite);
            this.markDirty();
            PlayerEntity owner = this.getPlayerFromUUID(this.getPlayerUUID());
            fs.createNotification("command.lotrextended.fellowship.client.invite.accepted", owner);
        }
    }

    public void setIcon(ExtendedFellowship fs, UUID player, ItemStack stack) {
        if (fs.hasEditPowers(this.getPlayerUUID())) {
            fs.setIcon(stack);
        }
    }

    public void removePlayer(ExtendedFellowship fs, UUID player) {
        if (fs.hasEditPowers(this.getPlayerUUID())) {
            fs.removeFellowshipMember(player);
            PlayerEntity owner = this.getPlayerFromUUID(player);
            fs.createNotification("command.lotrextended.fellowship.client.removed", owner, fs.getFellowshipName());
        }
    }

    public void setOwner(ExtendedFellowship fs, UUID player) {
        if (fs.isFellowshipOwner(this.getPlayerUUID())) {
            fs.setOwnerUUID(player);
            PlayerEntity owner = this.getPlayerFromUUID(player);
            fs.createNotification("command.lotrextended.fellowship.client.transfered", owner, fs.getFellowshipName());
        }
    }

    public boolean createFellowship(String name, boolean adminOverride) {
        if (!((Boolean)ExtendedServerConfig.enableFellowshipCreation.get()).booleanValue() && !adminOverride) {
            TranslationTextComponent comp = new TranslationTextComponent("gui.lotrextended.fellowships.creation.disabled");
            comp.func_240699_a_(TextFormatting.YELLOW);
            PlayerEntity owner = this.getPlayerFromUUID(this.getPlayerUUID());
            owner.func_145747_a((ITextComponent)comp, Util.field_240973_b_);
            return false;
        }
        if (!this.anyMatchingFellowshipNames(name)) {
            ExtendedFellowship fellowship = new ExtendedFellowship(name, this.getPlayerUUID());
            fellowship.createAndRegister();
            PlayerEntity owner = this.getPlayerFromUUID(this.getPlayerUUID());
            fellowship.createNotification("command.lotrextended.fellowship.client.created", owner);
            return true;
        }
        return false;
    }

    public void leaveFellowship(ExtendedFellowship fs) {
        if (!fs.isFellowshipOwner(this.getPlayerUUID())) {
            fs.removeFellowshipMember(this.getPlayerUUID());
            if (this.fellowshipIDs.contains(fs.getFellowshipId())) {
                this.removeFellowship(fs);
            }
            PlayerEntity owner = this.getPlayerFromUUID(this.getPlayerUUID());
            fs.createNotification("command.lotrextended.fellowship.client.leave", owner);
        }
    }

    public boolean disbandFellowship(ExtendedFellowship fs) {
        if (fs.isFellowshipOwner(this.getPlayerUUID())) {
            for (UUID user : fs.getFellowshipMembers()) {
                PlayerEntity player = this.getPlayerFromUUID(user);
                if (player == null) continue;
                fs.createNotification("command.lotrextended.fellowship.client.disbanded", player, fs.getFellowshipName());
            }
            fs.disband();
            this.removeFellowship(fs);
            return true;
        }
        return false;
    }

    public boolean anyMatchingFellowshipNames(String name) {
        return this.getFellowshipByName(name) != null;
    }

    public ExtendedFellowship getFellowshipByName(String fsName) {
        for (UUID fsID : this.fellowshipIDs) {
            ExtendedFellowship fs = ExtendedFellowshipHolderServer.getFellowship(ServerLifecycleHooks.getCurrentServer().func_241755_D_(), fsID);
            if (fs == null || !fs.getFellowshipName().equalsIgnoreCase(fsName)) continue;
            return fs;
        }
        return null;
    }

    public ExtendedFellowship getFellowshipByID(UUID id) {
        if (this.fellowshipIDs.contains(id)) {
            return ExtendedFellowshipHolderServer.getFellowship(ServerLifecycleHooks.getCurrentServer().func_241755_D_(), id);
        }
        return null;
    }

    public ExtendedFellowship getFellowshipByInviteName(String fsName) {
        for (ExtendedFellowshipInvite fsID : this.invites) {
            ExtendedFellowship fs = ExtendedFellowshipHolderServer.getFellowship(ServerLifecycleHooks.getCurrentServer().func_241755_D_(), fsID.fellowshipID);
            if (fs == null || !fs.getFellowshipName().equalsIgnoreCase(fsName)) continue;
            return fs;
        }
        return null;
    }

    public List<String> listAllFellowshipNames() {
        ArrayList<String> list = new ArrayList<String>();
        for (UUID fsID : this.fellowshipIDs) {
            ExtendedFellowship fs = ExtendedFellowshipHolderServer.getFellowship(ServerLifecycleHooks.getCurrentServer().func_241755_D_(), fsID);
            if (fs == null || !fs.isInFellowship(this.getPlayerUUID())) continue;
            list.add(fs.getFellowshipName());
        }
        return list;
    }

    public List<String> listAllInviteNames() {
        ArrayList<String> list = new ArrayList<String>();
        for (ExtendedFellowshipInvite fsID : this.invites) {
            ExtendedFellowship fs = ExtendedFellowshipHolderServer.getFellowship(ServerLifecycleHooks.getCurrentServer().func_241755_D_(), fsID.fellowshipID);
            if (fs == null) continue;
            list.add(fs.getFellowshipName());
        }
        return list;
    }

    public PlayerEntity getPlayerFromUUID(UUID id) {
        if (LOTRMod.PROXY.isClient()) {
            return null;
        }
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        return server.func_184103_al().func_177451_a(id);
    }
}

