/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.data;

import com.github.maximuslotro.lotrrextended.common.init.ExtendedParticles;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import lotr.common.LOTRLog;
import lotr.common.data.SaveUtil;
import lotr.common.world.spawning.WanderingTradersSpawner;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.LogicalSide;

public class ExtendedLevelData {
    private static final ExtendedLevelData SERVER_INSTANCE = new ExtendedLevelData(LogicalSide.SERVER);
    private boolean needsSave = false;
    private boolean needsLoad = true;
    private final LogicalSide side;
    private int timeUntilTrader = 0;
    private boolean requireRandom = true;
    private Map<UUID, Integer> playerTraderSpawnCooldowns = new HashMap<UUID, Integer>();
    private Map<UUID, Integer> secondsInBarrows = new HashMap<UUID, Integer>();

    public ExtendedLevelData(LogicalSide side) {
        this.side = side;
    }

    public static ExtendedLevelData serverInstance() {
        return SERVER_INSTANCE;
    }

    public boolean needsLoad() {
        return this.needsLoad;
    }

    public void save(ServerWorld world) {
        try {
            if (this.needsSave) {
                File lotrDataFile = ExtendedLevelData.getLOTRDataFile(world);
                if (!lotrDataFile.exists()) {
                    SaveUtil.saveNBTToFile((File)lotrDataFile, (CompoundNBT)new CompoundNBT());
                }
                CompoundNBT levelData = new CompoundNBT();
                CompoundNBT traderData = new CompoundNBT();
                traderData.func_74768_a("timeUntilTrader", this.timeUntilTrader);
                traderData.func_74757_a("requireRandom", this.requireRandom);
                levelData.func_218657_a("traderData", (INBT)traderData);
                this.savePlayerTraderCooldowns(levelData);
                this.saveSecondsInBarrows(levelData);
                SaveUtil.saveNBTToFile((File)lotrDataFile, (CompoundNBT)levelData);
                this.needsSave = false;
            }
        }
        catch (Exception e) {
            LOTRLog.error((String)"Error saving Extended mod data!");
            e.printStackTrace();
        }
    }

    public void load(ServerWorld world) {
        try {
            CompoundNBT levelData = SaveUtil.loadNBTFromFile((File)ExtendedLevelData.getLOTRDataFile(world));
            CompoundNBT traderData = levelData.func_74775_l("traderData");
            this.timeUntilTrader = traderData.func_74762_e("timeUntilTrader");
            this.requireRandom = traderData.func_74767_n("requireRandom");
            this.loadPlayerTraderCooldownTimes(levelData);
            this.loadSecondsInBarrows(levelData);
            this.needsLoad = false;
            this.needsSave = true;
            this.save(world);
        }
        catch (Exception e) {
            LOTRLog.error((String)"Error loading Extended mod data!");
            e.printStackTrace();
        }
    }

    public int getTimeUntilTrader() {
        return this.timeUntilTrader;
    }

    public int getPlayersTraderCooldown(UUID uuid) {
        if (this.playerTraderSpawnCooldowns.containsKey(uuid)) {
            return this.playerTraderSpawnCooldowns.get(uuid);
        }
        return -1;
    }

    public boolean isPlayerBarrowCursed(PlayerEntity player) {
        return this.secondsInBarrows.containsKey(player.func_110124_au()) && this.secondsInBarrows.get(player.func_110124_au()) == -1;
    }

    public void removeCurse(PlayerEntity player) {
        this.secondsInBarrows.put(player.func_110124_au(), -2);
    }

    public void decrementPlayerTraderCooldowns(World world) {
        for (PlayerEntity player : world.func_217369_A()) {
            UUID playerUUID = player.func_110124_au();
            if (this.playerTraderSpawnCooldowns.containsKey(playerUUID)) {
                int secondsLeft = this.playerTraderSpawnCooldowns.get(playerUUID);
                if (secondsLeft > 0) {
                    --secondsLeft;
                }
                this.playerTraderSpawnCooldowns.put(playerUUID, secondsLeft);
                continue;
            }
            this.playerTraderSpawnCooldowns.put(playerUUID, 180);
        }
    }

    public void incrementPlayerTimeInBarrows(World world) {
        for (PlayerEntity player : world.func_217369_A()) {
            Biome biome = world.func_226691_t_(player.func_233580_cy_());
            UUID playerUUID = player.func_110124_au();
            if (biome.getRegistryName().toString().equals("lotr:barrow_downs")) {
                if (this.secondsInBarrows.containsKey(playerUUID)) {
                    int seconds = this.secondsInBarrows.get(playerUUID);
                    if (seconds == -3) {
                        double rand = world.field_73012_v.nextDouble();
                        if (rand < 0.13) {
                            this.secondsInBarrows.put(playerUUID, 1);
                        } else {
                            this.secondsInBarrows.put(playerUUID, -2);
                        }
                    }
                    if (seconds <= 30 && seconds >= 1) {
                        this.secondsInBarrows.put(playerUUID, seconds + 1);
                    }
                    if (seconds <= 30) continue;
                    ((ServerWorld)world).func_195600_a((ServerPlayerEntity)player, (IParticleData)ExtendedParticles.BARROW_WIGHT_JUMPSCARE.get(), false, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 1, 0.0, 0.0, 0.0, 1.0);
                    this.secondsInBarrows.put(playerUUID, -1);
                    continue;
                }
                this.secondsInBarrows.put(playerUUID, 1);
                continue;
            }
            if (!this.secondsInBarrows.containsKey(playerUUID) || this.secondsInBarrows.get(playerUUID) != -2) continue;
            this.secondsInBarrows.put(playerUUID, -3);
        }
    }

    private void loadPlayerTraderCooldownTimes(CompoundNBT tag) {
        ListNBT listnbt = tag.func_150295_c("playerCooldowns", 10);
        if (listnbt.isEmpty()) {
            this.playerTraderSpawnCooldowns = new HashMap<UUID, Integer>();
        }
        for (int i = 0; i < listnbt.size(); ++i) {
            CompoundNBT compoundnbt = listnbt.func_150305_b(i);
            UUID playerUUID = compoundnbt.func_186857_a("player");
            int cooldown = compoundnbt.func_74762_e("cooldown");
            this.playerTraderSpawnCooldowns.put(playerUUID, cooldown);
        }
    }

    private void loadSecondsInBarrows(CompoundNBT tag) {
        ListNBT listnbt = tag.func_150295_c("secondsInBarrows", 10);
        if (listnbt.isEmpty()) {
            this.secondsInBarrows = new HashMap<UUID, Integer>();
        }
        for (int i = 0; i < listnbt.size(); ++i) {
            CompoundNBT compoundnbt = listnbt.func_150305_b(i);
            UUID playerUUID = compoundnbt.func_186857_a("player");
            int seconds = compoundnbt.func_74762_e("seconds");
            this.secondsInBarrows.put(playerUUID, seconds);
        }
    }

    private void savePlayerTraderCooldowns(CompoundNBT tag) {
        ListNBT list = new ListNBT();
        for (UUID uuid : this.playerTraderSpawnCooldowns.keySet()) {
            CompoundNBT entry = new CompoundNBT();
            entry.func_186854_a("player", uuid);
            entry.func_74768_a("cooldown", this.playerTraderSpawnCooldowns.get(uuid).intValue());
            list.add((Object)entry);
        }
        tag.func_218657_a("playerCooldowns", (INBT)list);
    }

    private void saveSecondsInBarrows(CompoundNBT tag) {
        ListNBT list = new ListNBT();
        for (UUID uuid : this.secondsInBarrows.keySet()) {
            CompoundNBT entry = new CompoundNBT();
            entry.func_186854_a("player", uuid);
            entry.func_74768_a("seconds", this.secondsInBarrows.get(uuid).intValue());
            list.add((Object)entry);
        }
        tag.func_218657_a("secondsInBarrows", (INBT)list);
    }

    public void checkForWanderingTraderSpawns(World world) {
        if (this.timeUntilTrader > 0) {
            --this.timeUntilTrader;
        } else {
            if (world.func_217369_A().isEmpty() || this.requireRandom && world.field_73012_v.nextInt(4) > 0) {
                this.timeUntilTrader = 1200;
                return;
            }
            ArrayList shuffledPlayers = new ArrayList(world.func_217369_A());
            Collections.shuffle(shuffledPlayers);
            boolean attemptedTraderSpawn = false;
            for (PlayerEntity player : shuffledPlayers) {
                int cooldownLeft = this.getPlayersTraderCooldown(player.func_110124_au());
                if (player.func_184812_l_() || player.func_175149_v()) continue;
                if (cooldownLeft == -1) {
                    this.playerTraderSpawnCooldowns.put(player.func_110124_au(), 180);
                    continue;
                }
                if (cooldownLeft != 0) continue;
                WanderingTradersSpawner.spawn(world, player);
                this.timeUntilTrader = 6000;
                attemptedTraderSpawn = true;
                this.playerTraderSpawnCooldowns.put(player.func_110124_au(), 1800);
                this.requireRandom = true;
                break;
            }
            if (!attemptedTraderSpawn) {
                this.timeUntilTrader = 1200;
                this.requireRandom = false;
            }
        }
        if ((long)this.timeUntilTrader % 1000L == 0L && this.timeUntilTrader != 0) {
            this.needsSave = true;
        }
    }

    private static File getLOTRDataFile(ServerWorld world) {
        String filename = "extended".toUpperCase();
        return new File(SaveUtil.getOrCreateLOTRDir((ServerWorld)world), filename + ".dat");
    }

    public boolean doesNeedSaving() {
        return this.needsSave;
    }
}

