/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import lotr.common.entity.npc.BlueDwarfEntity;
import lotr.common.entity.npc.DwarfEntity;
import lotr.common.entity.npc.ExtendedTraderEntity;
import lotr.common.entity.npc.NPCEntity;
import lotr.common.entity.npc.SpawnEquipmentTable;
import lotr.common.entity.npc.ai.AttackGoalsHolder;
import lotr.common.entity.npc.ai.goal.ExtendedInteractableFriendlyNPCConversationGoal;
import lotr.common.entity.npc.ai.goal.ExtendedInteractableTalkToCurrentGoal;
import lotr.common.entity.npc.ai.goal.ExtendedInteractableWaterAvoidingRandomWalkingGoal;
import lotr.common.entity.npc.ai.goal.NPCDrinkGoal;
import lotr.common.entity.npc.ai.goal.NPCEatGoal;
import lotr.common.entity.npc.ai.goal.WatchSunriseSunsetGoal;
import lotr.common.entity.npc.data.NPCGenderProvider;
import lotr.common.init.ExtendedItems;
import lotr.common.init.LOTREntities;
import lotr.common.init.LOTRItems;
import lotr.common.item.VesselDrinkItem;
import lotr.common.util.DrinkUtils;
import lotr.common.util.ExtendedInteractableHelper;
import lotr.common.util.ExtendedTraderHelper;
import lotr.common.util.TradeUtils;
import lotr.common.util.representation.ExtendedMultitradeEntry;
import lotr.common.util.representation.ExtendedTrade;
import lotr.common.util.representation.ExtendedTradeEntries;
import lotr.common.util.representation.ExtendedTradeEntry;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.OpenDoorGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

public class ExtendedBlueMountainsMerchantEntity
extends BlueDwarfEntity
implements ExtendedTraderEntity {
    private static final SpawnEquipmentTable WEAPONS;
    int lastTickCooldownReduced = 0;
    int lastTickVerifiedPlayerTradingWithIsOnline = 0;
    private static final DataParameter<Optional<UUID>> PLAYER_TRADING_WITH;
    private static final DataParameter<Boolean> IS_WANDERING_TRADER;
    private static final DataParameter<Integer> WANDERING_TRADER_TIME_LEFT;
    private List<UUID> escorts = new ArrayList<UUID>();
    private static final ExtendedTradeEntries BLUE_MOUNTAINS_BOUGHT;
    private static final ExtendedTradeEntries BLUE_MOUNTAINS_SOLD;
    private ArrayList<ExtendedTrade> itemsSoldByTrader;
    private ArrayList<ExtendedTrade> itemsBoughtByTrader;

    public static AttributeModifierMap.MutableAttribute regAttrs() {
        return DwarfEntity.regAttrs().func_233815_a_(Attributes.field_233826_i_, 0.0);
    }

    protected void addNPCAI() {
        ((GroundPathNavigator)this.func_70661_as()).func_179688_b(true);
        this.func_70661_as().func_212239_d(true);
        this.func_184644_a(PathNodeType.DANGER_FIRE, 16.0f);
        this.func_184644_a(PathNodeType.DAMAGE_FIRE, -1.0f);
        this.initialiseAttackGoals(this.getAttackGoalsHolder());
        this.addNPCTargetingAI();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.addAttackGoal(3);
        this.field_70714_bg.func_75776_a(9, (Goal)new OpenDoorGoal((MobEntity)this, true));
        this.field_70714_bg.func_75776_a(10, (Goal)new ExtendedInteractableTalkToCurrentGoal((NPCEntity)this, this));
        this.field_70714_bg.func_75776_a(11, (Goal)new ExtendedInteractableFriendlyNPCConversationGoal((NPCEntity)this, this, 0.001f));
        this.field_70714_bg.func_75776_a(12, (Goal)new WatchSunriseSunsetGoal((MobEntity)this, 0.001f));
        this.field_70714_bg.func_75776_a(13, (Goal)new ExtendedInteractableWaterAvoidingRandomWalkingGoal((CreatureEntity)this, this, 1.0));
        this.field_70714_bg.func_75776_a(14, (Goal)new NPCEatGoal((NPCEntity)this, this.getEatPool(), 6000));
        this.field_70714_bg.func_75776_a(14, (Goal)new NPCDrinkGoal((NPCEntity)this, this.getDrinkPool(), 6000));
        this.field_70714_bg.func_75776_a(15, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f, 0.02f));
        this.field_70714_bg.func_75776_a(15, (Goal)new LookAtGoal((MobEntity)this, NPCEntity.class, 5.0f, 0.02f));
        this.field_70714_bg.func_75776_a(16, (Goal)new LookAtGoal((MobEntity)this, LivingEntity.class, 8.0f, 0.02f));
        this.field_70714_bg.func_75776_a(17, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    @Override
    public void updatePlayerInteractingWith(UUID uuid) {
        this.field_70180_af.func_187227_b(PLAYER_TRADING_WITH, Optional.of(uuid));
    }

    @Override
    public Optional<UUID> getPlayerInteractingWith() {
        return (Optional)this.field_70180_af.func_187225_a(PLAYER_TRADING_WITH);
    }

    public ExtendedBlueMountainsMerchantEntity(EntityType<? extends ExtendedBlueMountainsMerchantEntity> type, World w) {
        super(type, w);
        this.func_110163_bv();
        this.itemsBoughtByTrader = BLUE_MOUNTAINS_BOUGHT.generateTrades();
        this.itemsSoldByTrader = BLUE_MOUNTAINS_SOLD.generateTrades();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PLAYER_TRADING_WITH, Optional.empty());
        this.field_70180_af.func_187214_a(IS_WANDERING_TRADER, (Object)false);
        this.field_70180_af.func_187214_a(WANDERING_TRADER_TIME_LEFT, (Object)1000);
    }

    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        this.saveAllTrades(tag);
        ExtendedTraderHelper.saveWanderingTraderData(this, this.escorts, tag);
    }

    protected void addNPCTargetingAI() {
        this.addNonAggressiveTargetingGoals();
    }

    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        this.loadAllTrades(tag);
        int wanderingTraderTimeLeft = tag.func_74762_e("wanderingTraderTimeLeft");
        this.field_70180_af.func_187227_b(WANDERING_TRADER_TIME_LEFT, (Object)wanderingTraderTimeLeft);
        boolean isWanderingTrader = tag.func_74767_n("isWanderingTrader");
        this.field_70180_af.func_187227_b(IS_WANDERING_TRADER, (Object)isWanderingTrader);
        this.escorts = ExtendedTraderHelper.loadEscortUUIDs(tag);
    }

    protected void initialiseAttackGoals(AttackGoalsHolder holder) {
        holder.setMeleeAttackGoal(this.createDwarfAttackGoal());
    }

    @Override
    public void playTradeSound() {
        ExtendedTraderHelper.playTraderSound(this.field_70170_p, this.func_226268_ag_());
    }

    @Override
    public boolean isInteractingWithPlayer() {
        return ExtendedInteractableHelper.isInteractingWithPlayer(this.getPlayerInteractingWith());
    }

    @Override
    public void removePlayerFromInteracting(PlayerEntity player) {
        ExtendedInteractableHelper.removePlayerFromInteracting(player, this.field_70180_af, PLAYER_TRADING_WITH);
    }

    @Override
    public boolean canTradeWith(PlayerEntity player) {
        return this.isFriendlyAndAlignedWithLevel(player, (NPCEntity)this, 0.0f);
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        return ExtendedTraderHelper.mobInteract((NPCEntity)this, this, player, hand);
    }

    @Override
    public void openCoinExchange(PlayerEntity player) {
        ExtendedTraderHelper.openCoinExchange((NPCEntity)this, player, this);
    }

    @Override
    public void openTradeMenu(PlayerEntity player) {
        ExtendedTraderHelper.openTradeMenu((NPCEntity)this, player, this);
    }

    @Override
    public String getTraderName() {
        return ExtendedTraderHelper.getTraderName(this.func_145748_c_());
    }

    @Override
    public Inventory getDisplayInventory() {
        return TradeUtils.generateDisplayInventory(this.itemsSoldByTrader, this.itemsBoughtByTrader);
    }

    @Override
    public List<ExtendedTrade> getBuys() {
        return this.itemsBoughtByTrader;
    }

    @Override
    public int[] getBoughtPrices() {
        return ExtendedTraderHelper.getBoughtPrices(this.itemsBoughtByTrader);
    }

    @Override
    public int[] getBoughtQuantities() {
        return ExtendedTraderHelper.getBoughtQuantity(this.itemsBoughtByTrader);
    }

    @Override
    public int[] getSoldPrices() {
        return ExtendedTraderHelper.getSoldPrices(this.itemsSoldByTrader);
    }

    @Override
    public int[] getSoldQuantities() {
        return ExtendedTraderHelper.getSoldQuantity(this.itemsSoldByTrader);
    }

    @Override
    public int[] getSoldOriginalQuantities() {
        return ExtendedTraderHelper.getSoldOriginalQuantity(this.itemsSoldByTrader);
    }

    @Override
    public int[] getBoughtOriginalQuantities() {
        return ExtendedTraderHelper.getBoughtOriginalQuantity(this.itemsBoughtByTrader);
    }

    @Override
    public boolean isWanderingTrader() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_WANDERING_TRADER);
    }

    @Override
    public void setWanderingTrader(boolean isWanderingTrader) {
        this.field_70180_af.func_187227_b(IS_WANDERING_TRADER, (Object)isWanderingTrader);
    }

    @Override
    public int getWanderingTraderTicksLeft() {
        return (Integer)this.field_70180_af.func_187225_a(WANDERING_TRADER_TIME_LEFT);
    }

    @Override
    public void setWanderingTraderTicksLeft(int ticksLeft) {
        this.field_70180_af.func_187227_b(WANDERING_TRADER_TIME_LEFT, (Object)ticksLeft);
    }

    @Override
    public List<ExtendedTrade> getSells() {
        return this.itemsSoldByTrader;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.lastTickVerifiedPlayerTradingWithIsOnline >= 100) {
            UUID uuid;
            if (((Optional)this.field_70180_af.func_187225_a(PLAYER_TRADING_WITH)).isPresent() && this.field_70170_p.func_217371_b(uuid = (UUID)((Optional)this.field_70180_af.func_187225_a(PLAYER_TRADING_WITH)).get()) == null) {
                this.field_70180_af.func_187227_b(PLAYER_TRADING_WITH, Optional.empty());
            }
            this.lastTickVerifiedPlayerTradingWithIsOnline = 0;
        } else {
            ++this.lastTickVerifiedPlayerTradingWithIsOnline;
        }
        if (this.lastTickCooldownReduced >= 1200) {
            for (ExtendedTrade trade : this.itemsSoldByTrader) {
                if (trade.getQuantityLeft() >= trade.getOriginalQuantity()) continue;
                trade.setQuantityLeft(trade.getQuantityLeft() + 1);
            }
            for (ExtendedTrade trade : this.itemsBoughtByTrader) {
                if (trade.getQuantityLeft() >= trade.getOriginalQuantity()) continue;
                trade.setQuantityLeft(trade.getQuantityLeft() + 1);
            }
            this.lastTickCooldownReduced = 0;
        } else {
            ++this.lastTickCooldownReduced;
        }
        ExtendedTraderHelper.tickTrader((NPCEntity)this, this);
    }

    public ILivingEntityData func_213386_a(IServerWorld sw, DifficultyInstance diff, SpawnReason reason, ILivingEntityData spawnData, CompoundNBT dataTag) {
        spawnData = super.func_213386_a(sw, diff, reason, spawnData, dataTag);
        this.npcItemsInv.setMeleeWeapon(WEAPONS.getRandomItem(this.field_70146_Z));
        this.npcItemsInv.clearIdleItem();
        return spawnData;
    }

    @Override
    public TranslationTextComponent getDepartureLine(PlayerEntity player) {
        return new TranslationTextComponent("speechbank.blue_mountains_merchant.departure." + (this.field_70146_Z.nextInt(10) + 1), new Object[]{this.func_200200_C_(), player.func_200200_C_()});
    }

    protected NPCGenderProvider getGenderProvider() {
        return NPCGenderProvider.MALE;
    }

    @Override
    public List<UUID> getEscortUUIDs() {
        return this.escorts;
    }

    @Override
    public void addEscort(UUID uuid) {
        this.escorts.add(uuid);
    }

    @Override
    public NPCEntity createEscort() {
        return (NPCEntity)((EntityType)LOTREntities.BLUE_MOUNTAINS_DWARF.get()).func_200721_a(this.field_70170_p);
    }

    @Override
    public void setBuys(ArrayList<ExtendedTrade> trades) {
        this.itemsBoughtByTrader = trades;
    }

    @Override
    public void setSells(ArrayList<ExtendedTrade> trades) {
        this.itemsSoldByTrader = trades;
    }

    static {
        PLAYER_TRADING_WITH = EntityDataManager.func_187226_a(ExtendedBlueMountainsMerchantEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
        IS_WANDERING_TRADER = EntityDataManager.func_187226_a(ExtendedBlueMountainsMerchantEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
        WANDERING_TRADER_TIME_LEFT = EntityDataManager.func_187226_a(ExtendedBlueMountainsMerchantEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
        BLUE_MOUNTAINS_BOUGHT = new ExtendedTradeEntries(ExtendedTradeEntries.TradeType.BOUGHT, new ExtendedTradeEntry[]{new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_151025_P), 2, 3, 192), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.BRONZE_INGOT.get()), 2, 4, 192), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_151044_h, 2), 1, 1, 192), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_151077_bg), 2, 4, 192), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_196102_ba), 2, 4, 192), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_196104_bb), 2, 4, 192), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_179557_bn), 2, 4, 192), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_151157_am), 2, 4, 192), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_179559_bp), 2, 4, 192), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.COPPER_INGOT.get()), 2, 4, 192), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.GAMMON.get()), 2, 4), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_151043_k), 11, 19), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_151042_j), 2, 4), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_151083_be), 2, 4), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.TIN_INGOT.get()), 2, 4), new ExtendedTradeEntry(new ItemStack((IItemProvider)ExtendedItems.DIAMOND.get()), 19, 31), new ExtendedTradeEntry(new ItemStack((IItemProvider)ExtendedItems.SAPPHIRE.get()), 9, 15), new ExtendedTradeEntry(new ItemStack((IItemProvider)ExtendedItems.OPAL.get()), 8, 13), new ExtendedTradeEntry(new ItemStack((IItemProvider)ExtendedItems.PEARL.get()), 19, 31)});
        BLUE_MOUNTAINS_SOLD = new ExtendedTradeEntries(ExtendedTradeEntries.TradeType.SOLD, new ExtendedTradeEntry[]{new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.BLUE_DWARVEN_HELMET.get()), 19, 31), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.BLUE_DWARVEN_CHESTPLATE.get()), 27, 45), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.BLUE_DWARVEN_LEGGINGS.get()), 23, 38), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.BLUE_DWARVEN_BOOTS.get()), 17, 38), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.BLUE_DWARVEN_AXE.get()), 11, 19), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.BLUE_DWARVEN_DAGGER.get()), 10, 16), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.BLUE_DWARVEN_PICKAXE.get()), 11, 18), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.BLUE_DWARVEN_SHOVEL.get()), 9, 15), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.BLUE_DWARVEN_SPEAR.get()), 14, 23), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.BLUE_DWARVEN_SWORD.get()), 12, 20), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_151114_aO, 4), 2, 3), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.DWARVEN_FORGE.get()), 30, 50), new ExtendedTradeEntry(new ItemStack((IItemProvider)ExtendedItems.DWARF_MARRIAGE_RING.get()), 12, 20), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.GLOWING_DWARVEN_BRICK.get()), 3, 5), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.GLOWING_DWARVEN_BRICK.get()), 3, 5), new ExtendedTradeEntry(new ItemStack((IItemProvider)ExtendedItems.EMERALD.get()), 19, 31), new ExtendedTradeEntry(new ItemStack((IItemProvider)ExtendedItems.RUBY.get()), 15, 25), new ExtendedTradeEntry(new ItemStack((IItemProvider)ExtendedItems.AMETHYST.get()), 9, 15), new ExtendedTradeEntry(new ItemStack((IItemProvider)ExtendedItems.TOPAZ.get()), 9, 15), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.BLUE_ROCK.get(), 8), 2, 3), new ExtendedMultitradeEntry(new ExtendedTradeEntry[]{new ExtendedTradeEntry(DrinkUtils.drinkOfPotency((Item)LOTRItems.DWARVEN_TONIC.get(), VesselDrinkItem.Potency.LIGHT), 8, 13, 8), new ExtendedTradeEntry(DrinkUtils.drinkOfPotency((Item)LOTRItems.DWARVEN_TONIC.get(), VesselDrinkItem.Potency.MODERATE), 11, 18, 8), new ExtendedTradeEntry(DrinkUtils.drinkOfPotency((Item)LOTRItems.DWARVEN_TONIC.get(), VesselDrinkItem.Potency.STRONG), 13, 22, 8)}), new ExtendedMultitradeEntry(new ExtendedTradeEntry[]{new ExtendedTradeEntry(DrinkUtils.drinkOfPotency((Item)LOTRItems.DWARVEN_ALE.get(), VesselDrinkItem.Potency.LIGHT), 5, 8, 16), new ExtendedTradeEntry(DrinkUtils.drinkOfPotency((Item)LOTRItems.DWARVEN_ALE.get(), VesselDrinkItem.Potency.MODERATE), 7, 11, 16), new ExtendedTradeEntry(DrinkUtils.drinkOfPotency((Item)LOTRItems.DWARVEN_ALE.get(), VesselDrinkItem.Potency.STRONG), 8, 14, 16)})});
        WEAPONS = SpawnEquipmentTable.of((Object[])new Object[]{LOTRItems.BLUE_DWARVEN_DAGGER});
    }
}

