/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import lotr.common.entity.npc.BreeManEntity;
import lotr.common.entity.npc.ExtendedTraderEntity;
import lotr.common.entity.npc.HobbitEntity;
import lotr.common.entity.npc.NPCEntity;
import lotr.common.entity.npc.ai.goal.ExtendedInteractableFriendlyNPCConversationGoal;
import lotr.common.entity.npc.ai.goal.ExtendedInteractableTalkToCurrentGoal;
import lotr.common.entity.npc.ai.goal.ExtendedInteractableWaterAvoidingRandomWalkingGoal;
import lotr.common.entity.npc.ai.goal.WatchSunriseSunsetGoal;
import lotr.common.init.ExtendedItems;
import lotr.common.init.LOTRItems;
import lotr.common.util.ExtendedInteractableHelper;
import lotr.common.util.ExtendedTraderHelper;
import lotr.common.util.TradeUtils;
import lotr.common.util.representation.ExtendedMultitradeEntry;
import lotr.common.util.representation.ExtendedTrade;
import lotr.common.util.representation.ExtendedTradeEntries;
import lotr.common.util.representation.ExtendedTradeEntry;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.OpenDoorGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

public class ExtendedBreelandPotterEntity
extends BreeManEntity
implements ExtendedTraderEntity {
    int lastTickCooldownReduced = 0;
    int lastTickVerifiedPlayerTradingWithIsOnline = 0;
    private static final DataParameter<Optional<UUID>> PLAYER_TRADING_WITH = EntityDataManager.func_187226_a(ExtendedBreelandPotterEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Boolean> IS_WANDERING_TRADER = EntityDataManager.func_187226_a(ExtendedBreelandPotterEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> WANDERING_TRADER_TIME_LEFT = EntityDataManager.func_187226_a(ExtendedBreelandPotterEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private List<UUID> escorts = new ArrayList<UUID>();
    private final ExtendedTradeEntries BREE_POTTER_BOUGHT = new ExtendedTradeEntries(ExtendedTradeEntries.TradeType.BOUGHT, new ExtendedTradeEntry[]{new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_151119_aD, 4), 1, 1), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_221776_cx), 1, 1), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_151133_ar), 2, 4, 16), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_151131_as), 3, 5, 16), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_151038_n), 1, 2, 32), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_151051_r), 1, 2, 32), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.BRONZE_SHOVEL.get()), 2, 6, 16), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_151037_a), 2, 8, 16), new ExtendedMultitradeEntry(new ExtendedTradeEntry[]{new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_222086_lz), 1, 1), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_222083_lx), 1, 1), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_222085_ly), 1, 1), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_196124_bl), 1, 1), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_196120_bj), 1, 1), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_222079_lj), 1, 1), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_196112_bf), 1, 1), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_196122_bk), 1, 1), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_196116_bh), 1, 1), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_196110_be), 1, 1), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_196108_bd), 1, 1), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_196118_bi), 1, 1), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_196126_bm), 1, 1), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_222078_li), 1, 1), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_222069_lA), 1, 1), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_222081_ls), 1, 1)})});
    private final ExtendedTradeEntries BREE_POTTER_SOLD = new ExtendedTradeEntries(ExtendedTradeEntries.TradeType.SOLD, new ExtendedTradeEntry[]{new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_221894_fe, 4), 4, 6), new ExtendedMultitradeEntry(new ExtendedTradeEntry[]{new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_221801_eK, 4), 4, 6), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_221793_eG, 4), 4, 6), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_221795_eH, 4), 4, 6), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_221789_eE, 4), 4, 6), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_221785_eC, 4), 4, 6), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_221797_eI, 4), 4, 6), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_221882_ey, 4), 4, 6), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_221787_eD, 4), 4, 6), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_221781_eA, 4), 4, 6), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_221880_ex, 4), 4, 6), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_221878_ew, 4), 4, 6), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_221783_eB, 4), 4, 6), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_221791_eF, 4), 4, 6), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_221799_eJ, 4), 4, 6), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_221876_ev, 4), 4, 6), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_221884_ez, 4), 4, 6)}), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_222087_nH), 5, 8), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_151118_aC, 2), 2, 4), new ExtendedTradeEntry(new ItemStack((IItemProvider)ExtendedItems.LARGE_POT.get()), 6, 8), new ExtendedTradeEntry(new ItemStack((IItemProvider)ExtendedItems.LARGE_FLOWER_POT.get()), 6, 8), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_221647_bL, 4), 5, 7), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.WATTLE_AND_DAUB.get(), 4), 5, 8), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.WATTLE_AND_DAUB_PILLAR.get(), 3), 3, 6), new ExtendedTradeEntry(new ItemStack((IItemProvider)ExtendedItems.CROSSED_WATTLE_AND_DAUB.get(), 4), 6, 8), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.CLAY_MUG.get()), 2, 4), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.CLAY_PLATE.get(), 2), 1, 2), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.CERAMIC_MUG.get()), 3, 5), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.STONEWARE_PLATE.get(), 2), 2, 4), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.CLAY_TILING.get(), 4), 4, 6), new ExtendedMultitradeEntry(new ExtendedTradeEntry[]{new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.BLACK_CLAY_TILING.get(), 4), 4, 6), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.BLUE_CLAY_TILING.get(), 4), 4, 6), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.BROWN_CLAY_TILING.get(), 4), 4, 6), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.CYAN_CLAY_TILING.get(), 4), 4, 6), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.GRAY_CLAY_TILING.get(), 4), 4, 6), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.GREEN_CLAY_TILING.get(), 4), 4, 6), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.LIGHT_BLUE_CLAY_TILING.get(), 4), 4, 6), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.LIGHT_GRAY_CLAY_TILING.get(), 4), 4, 6), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.LIME_CLAY_TILING.get(), 4), 4, 6), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.MAGENTA_CLAY_TILING.get(), 4), 4, 6), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.ORANGE_CLAY_TILING.get(), 4), 4, 6), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.PINK_CLAY_TILING.get(), 4), 4, 6), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.PURPLE_CLAY_TILING.get(), 4), 4, 6), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.RED_CLAY_TILING.get(), 4), 4, 6), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.WHITE_CLAY_TILING.get(), 4), 4, 6), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.YELLOW_CLAY_TILING.get(), 4), 4, 6)})});
    private ArrayList<ExtendedTrade> itemsSoldByTrader;
    private ArrayList<ExtendedTrade> itemsBoughtByTrader;

    public ExtendedBreelandPotterEntity(EntityType<? extends BreeManEntity> type, World w) {
        super(type, w);
        this.func_110163_bv();
        this.itemsBoughtByTrader = this.BREE_POTTER_BOUGHT.generateTrades();
        this.itemsSoldByTrader = this.BREE_POTTER_SOLD.generateTrades();
        this.func_184611_a(Hand.MAIN_HAND, new ItemStack((IItemProvider)Items.field_151119_aD.getItem(), 1));
        this.func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)ExtendedItems.LEATHER_HAT.get(), 1));
    }

    protected void addNPCAI() {
        ((GroundPathNavigator)this.func_70661_as()).func_179688_b(true);
        this.func_70661_as().func_212239_d(true);
        this.func_184644_a(PathNodeType.DANGER_FIRE, 16.0f);
        this.func_184644_a(PathNodeType.DAMAGE_FIRE, -1.0f);
        this.initialiseAttackGoals(this.getAttackGoalsHolder());
        this.addNPCTargetingAI();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.addAttackGoal(2);
        this.field_70714_bg.func_75776_a(4, (Goal)new OpenDoorGoal((MobEntity)this, true));
        this.field_70714_bg.func_75776_a(5, (Goal)new ExtendedInteractableTalkToCurrentGoal((NPCEntity)this, this));
        this.field_70714_bg.func_75776_a(6, (Goal)new ExtendedInteractableFriendlyNPCConversationGoal((NPCEntity)this, this, 5.0E-4f));
        this.field_70714_bg.func_75776_a(7, (Goal)new WatchSunriseSunsetGoal((MobEntity)this, 0.005f));
        this.field_70714_bg.func_75776_a(8, (Goal)new ExtendedInteractableWaterAvoidingRandomWalkingGoal((CreatureEntity)this, this, 1.0));
        this.addConsumingGoals(9);
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f, 0.02f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, NPCEntity.class, 5.0f, 0.02f));
        this.field_70714_bg.func_75776_a(11, (Goal)new LookAtGoal((MobEntity)this, LivingEntity.class, 8.0f, 0.02f));
        this.field_70714_bg.func_75776_a(12, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PLAYER_TRADING_WITH, Optional.empty());
        this.field_70180_af.func_187214_a(IS_WANDERING_TRADER, (Object)false);
        this.field_70180_af.func_187214_a(WANDERING_TRADER_TIME_LEFT, (Object)1000);
    }

    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        this.saveAllTrades(tag);
        ExtendedTraderHelper.saveWanderingTraderData(this, this.escorts, tag);
    }

    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        this.loadAllTrades(tag);
        int wanderingTraderTimeLeft = tag.func_74762_e("wanderingTraderTimeLeft");
        this.field_70180_af.func_187227_b(WANDERING_TRADER_TIME_LEFT, (Object)wanderingTraderTimeLeft);
        boolean isWanderingTrader = tag.func_74767_n("isWanderingTrader");
        this.field_70180_af.func_187227_b(IS_WANDERING_TRADER, (Object)isWanderingTrader);
        this.escorts = ExtendedTraderHelper.loadEscortUUIDs(tag);
    }

    @Override
    public void updatePlayerInteractingWith(UUID uuid) {
        this.field_70180_af.func_187227_b(PLAYER_TRADING_WITH, Optional.of(uuid));
    }

    @Override
    public Optional<UUID> getPlayerInteractingWith() {
        return (Optional)this.field_70180_af.func_187225_a(PLAYER_TRADING_WITH);
    }

    @Override
    public boolean canTradeWith(PlayerEntity player) {
        return this.isFriendlyAndAlignedWithLevel(player, (NPCEntity)this, 0.0f);
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return HobbitEntity.regAttrs();
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        return ExtendedTraderHelper.mobInteract((NPCEntity)this, this, player, hand);
    }

    @Override
    public void playTradeSound() {
        ExtendedTraderHelper.playTraderSound(this.field_70170_p, this.func_226268_ag_());
    }

    @Override
    public boolean isInteractingWithPlayer() {
        return ExtendedInteractableHelper.isInteractingWithPlayer(this.getPlayerInteractingWith());
    }

    @Override
    public void removePlayerFromInteracting(PlayerEntity player) {
        ExtendedInteractableHelper.removePlayerFromInteracting(player, this.field_70180_af, PLAYER_TRADING_WITH);
    }

    @Override
    public boolean isWanderingTrader() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_WANDERING_TRADER);
    }

    @Override
    public void setWanderingTrader(boolean isWanderingTrader) {
        this.field_70180_af.func_187227_b(IS_WANDERING_TRADER, (Object)isWanderingTrader);
    }

    @Override
    public int getWanderingTraderTicksLeft() {
        return (Integer)this.field_70180_af.func_187225_a(WANDERING_TRADER_TIME_LEFT);
    }

    @Override
    public void setWanderingTraderTicksLeft(int ticksLeft) {
        this.field_70180_af.func_187227_b(WANDERING_TRADER_TIME_LEFT, (Object)ticksLeft);
    }

    @Override
    public TranslationTextComponent getDepartureLine(PlayerEntity player) {
        return null;
    }

    @Override
    public void openCoinExchange(PlayerEntity player) {
        ExtendedTraderHelper.openCoinExchange((NPCEntity)this, player, this);
    }

    @Override
    public void openTradeMenu(PlayerEntity player) {
        ExtendedTraderHelper.openTradeMenu((NPCEntity)this, player, this);
    }

    @Override
    public String getTraderName() {
        return ExtendedTraderHelper.getTraderName(this.func_145748_c_());
    }

    @Override
    public Inventory getDisplayInventory() {
        return TradeUtils.generateDisplayInventory(this.itemsSoldByTrader, this.itemsBoughtByTrader);
    }

    @Override
    public List<ExtendedTrade> getBuys() {
        return this.itemsBoughtByTrader;
    }

    @Override
    public int[] getBoughtPrices() {
        return ExtendedTraderHelper.getBoughtPrices(this.itemsBoughtByTrader);
    }

    @Override
    public int[] getBoughtQuantities() {
        return ExtendedTraderHelper.getBoughtQuantity(this.itemsBoughtByTrader);
    }

    @Override
    public int[] getSoldPrices() {
        return ExtendedTraderHelper.getSoldPrices(this.itemsSoldByTrader);
    }

    @Override
    public int[] getSoldQuantities() {
        return ExtendedTraderHelper.getSoldQuantity(this.itemsSoldByTrader);
    }

    @Override
    public int[] getSoldOriginalQuantities() {
        return ExtendedTraderHelper.getSoldOriginalQuantity(this.itemsSoldByTrader);
    }

    @Override
    public int[] getBoughtOriginalQuantities() {
        return ExtendedTraderHelper.getBoughtOriginalQuantity(this.itemsBoughtByTrader);
    }

    @Override
    public List<ExtendedTrade> getSells() {
        return this.itemsSoldByTrader;
    }

    public ILivingEntityData func_213386_a(IServerWorld sw, DifficultyInstance diff, SpawnReason reason, ILivingEntityData spawnData, CompoundNBT dataTag) {
        spawnData = super.func_213386_a(sw, diff, reason, spawnData, dataTag);
        this.npcItemsInv.setIdleItem(new ItemStack((IItemProvider)Items.field_151119_aD.getItem()));
        this.func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)ExtendedItems.LEATHER_HAT.get()));
        this.func_184611_a(Hand.MAIN_HAND, new ItemStack((IItemProvider)Items.field_151119_aD.getItem(), 1));
        return spawnData;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.lastTickVerifiedPlayerTradingWithIsOnline >= 100) {
            UUID uuid;
            if (((Optional)this.field_70180_af.func_187225_a(PLAYER_TRADING_WITH)).isPresent() && this.field_70170_p.func_217371_b(uuid = (UUID)((Optional)this.field_70180_af.func_187225_a(PLAYER_TRADING_WITH)).get()) == null) {
                this.field_70180_af.func_187227_b(PLAYER_TRADING_WITH, Optional.empty());
            }
            this.lastTickVerifiedPlayerTradingWithIsOnline = 0;
        } else {
            ++this.lastTickVerifiedPlayerTradingWithIsOnline;
        }
        if (this.lastTickCooldownReduced >= 1200) {
            for (ExtendedTrade trade : this.itemsSoldByTrader) {
                if (trade.getQuantityLeft() >= trade.getOriginalQuantity()) continue;
                trade.setQuantityLeft(trade.getQuantityLeft() + 1);
            }
            for (ExtendedTrade trade : this.itemsBoughtByTrader) {
                if (trade.getQuantityLeft() >= trade.getOriginalQuantity()) continue;
                trade.setQuantityLeft(trade.getQuantityLeft() + 1);
            }
            this.lastTickCooldownReduced = 0;
        } else {
            ++this.lastTickCooldownReduced;
        }
        ExtendedTraderHelper.tickTrader((NPCEntity)this, this);
    }

    @Override
    public List<UUID> getEscortUUIDs() {
        return this.escorts;
    }

    @Override
    public void addEscort(UUID uuid) {
        this.escorts.add(uuid);
    }

    @Override
    public NPCEntity createEscort() {
        return null;
    }

    @Override
    public void setBuys(ArrayList<ExtendedTrade> trades) {
        this.itemsBoughtByTrader = trades;
    }

    @Override
    public void setSells(ArrayList<ExtendedTrade> trades) {
        this.itemsSoldByTrader = trades;
    }
}

