/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import lotr.common.entity.npc.BreeManEntity;
import lotr.common.entity.npc.ExtendedCaptainEntity;
import lotr.common.entity.npc.NPCEntity;
import lotr.common.entity.npc.SpawnEquipmentTable;
import lotr.common.entity.npc.ai.goal.ExtendedInteractableFriendlyNPCConversationGoal;
import lotr.common.entity.npc.ai.goal.ExtendedInteractableTalkToCurrentGoal;
import lotr.common.entity.npc.ai.goal.ExtendedInteractableWaterAvoidingRandomWalkingGoal;
import lotr.common.entity.npc.ai.goal.ExtendedShieldSwapMeleeAttackGoal;
import lotr.common.entity.npc.ai.goal.WatchSunriseSunsetGoal;
import lotr.common.entity.npc.data.NPCGenderProvider;
import lotr.common.entity.npc.data.name.NPCNameGenerator;
import lotr.common.entity.npc.data.name.NPCNameGenerators;
import lotr.common.entity.npc.util.LeatherDyeUtil;
import lotr.common.init.ExtendedItems;
import lotr.common.util.ExtendedCaptainHelper;
import lotr.common.util.ExtendedInteractableHelper;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.OpenDoorGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

public class ExtendedBreelandSheriffEntity
extends BreeManEntity
implements ExtendedCaptainEntity {
    private static final SpawnEquipmentTable WEAPONS;
    private static final DataParameter<Optional<UUID>> PLAYER_INTERACTING_WITH;
    private static final int[] SUIT_COLORS;

    public static AttributeModifierMap.MutableAttribute regAttrs() {
        return BreeManEntity.regAttrs().func_233815_a_(Attributes.field_233818_a_, 25.0);
    }

    protected void addNPCAI() {
        ((GroundPathNavigator)this.func_70661_as()).func_179688_b(true);
        this.func_70661_as().func_212239_d(true);
        this.func_184644_a(PathNodeType.DANGER_FIRE, 16.0f);
        this.func_184644_a(PathNodeType.DAMAGE_FIRE, -1.0f);
        this.initialiseAttackGoals(this.getAttackGoalsHolder());
        this.addNPCTargetingAI();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.addAttackGoal(2);
        this.field_70714_bg.func_75776_a(4, (Goal)new OpenDoorGoal((MobEntity)this, true));
        this.field_70714_bg.func_75776_a(5, (Goal)new ExtendedInteractableTalkToCurrentGoal((NPCEntity)this, this));
        this.field_70714_bg.func_75776_a(6, (Goal)new ExtendedInteractableFriendlyNPCConversationGoal((NPCEntity)this, this, 5.0E-4f));
        this.field_70714_bg.func_75776_a(7, (Goal)new WatchSunriseSunsetGoal((MobEntity)this, 0.005f));
        this.field_70714_bg.func_75776_a(8, (Goal)new ExtendedInteractableWaterAvoidingRandomWalkingGoal((CreatureEntity)this, this, 1.0));
        this.addConsumingGoals(9);
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f, 0.02f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, NPCEntity.class, 5.0f, 0.02f));
        this.field_70714_bg.func_75776_a(11, (Goal)new LookAtGoal((MobEntity)this, LivingEntity.class, 8.0f, 0.02f));
        this.field_70714_bg.func_75776_a(12, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    public ExtendedBreelandSheriffEntity(EntityType<? extends ExtendedBreelandSheriffEntity> type, World w) {
        super(type, w);
        this.func_110163_bv();
    }

    @Override
    public boolean isInteractingWithPlayer() {
        return ExtendedInteractableHelper.isInteractingWithPlayer(this.getPlayerInteractingWith());
    }

    @Override
    public Optional<UUID> getPlayerInteractingWith() {
        return (Optional)this.field_70180_af.func_187225_a(PLAYER_INTERACTING_WITH);
    }

    @Override
    public void updatePlayerInteractingWith(UUID uuid) {
        this.field_70180_af.func_187227_b(PLAYER_INTERACTING_WITH, Optional.of(uuid));
    }

    @Override
    public void removePlayerFromInteracting(PlayerEntity player) {
        ExtendedInteractableHelper.removePlayerFromInteracting(player, this.field_70180_af, PLAYER_INTERACTING_WITH);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PLAYER_INTERACTING_WITH, Optional.empty());
    }

    protected void addNPCTargetingAI() {
        this.addNonAggressiveTargetingGoals();
    }

    protected NPCNameGenerator getNameGenerator() {
        return NPCNameGenerators.BREE;
    }

    protected Goal createAttackGoal() {
        return new ExtendedShieldSwapMeleeAttackGoal((NPCEntity)this, 1.45, new ItemStack((IItemProvider)Items.field_185159_cQ), ItemStack.field_190927_a);
    }

    @Override
    public boolean canHire(PlayerEntity player) {
        return this.isFriendlyAndAlignedWithLevel(player, (NPCEntity)this, 100.0f);
    }

    @Override
    public int getCost(String unitName, PlayerEntity player) {
        if (unitName.equals("BREE_GUARD")) {
            return 30;
        }
        return 0;
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        return ExtendedCaptainHelper.mobInteract((NPCEntity)this, this, player, hand);
    }

    public ILivingEntityData func_213386_a(IServerWorld sw, DifficultyInstance diff, SpawnReason reason, ILivingEntityData spawnData, CompoundNBT dataTag) {
        spawnData = super.func_213386_a(sw, diff, reason, spawnData, dataTag);
        this.npcItemsInv.setMeleeWeapon(WEAPONS.getRandomItem(this.field_70146_Z));
        this.npcItemsInv.setIdleItem(new ItemStack((IItemProvider)Items.field_151099_bA));
        this.func_184201_a(EquipmentSlotType.FEET, LeatherDyeUtil.dyeLeather((Item)Items.field_151021_T, (int)3354152));
        this.func_184201_a(EquipmentSlotType.LEGS, LeatherDyeUtil.dyeLeather((Item)Items.field_151026_S, (int[])SUIT_COLORS, (Random)this.field_70146_Z));
        this.func_184201_a(EquipmentSlotType.CHEST, LeatherDyeUtil.dyeLeather((Item)Items.field_151027_R, (int[])SUIT_COLORS, (Random)this.field_70146_Z));
        this.func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)ExtendedItems.LEATHER_HAT.get()));
        this.func_184201_a(EquipmentSlotType.OFFHAND, ItemStack.field_190927_a);
        return spawnData;
    }

    protected NPCGenderProvider getGenderProvider() {
        return NPCGenderProvider.MALE;
    }

    static {
        PLAYER_INTERACTING_WITH = EntityDataManager.func_187226_a(ExtendedBreelandSheriffEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
        WEAPONS = SpawnEquipmentTable.of((Object[])new Object[]{Items.field_151040_l});
        SUIT_COLORS = new int[]{11373426, 7823440, 5983041, 9535090};
    }
}

