/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import lotr.common.entity.npc.ManEntity;
import lotr.common.entity.npc.NPCEntity;
import lotr.common.entity.npc.SpawnEquipmentTable;
import lotr.common.entity.npc.ai.AttackGoalsHolder;
import lotr.common.entity.npc.ai.StandardAttackModeUpdaters;
import lotr.common.entity.npc.ai.goal.ExtendedRangerMeleeAttackGoal;
import lotr.common.entity.npc.ai.goal.ExtendedRangerRangedAttackGoal;
import lotr.common.entity.npc.ai.goal.FriendlyNPCConversationGoal;
import lotr.common.entity.npc.ai.goal.NPCDrinkGoal;
import lotr.common.entity.npc.ai.goal.NPCEatGoal;
import lotr.common.entity.npc.ai.goal.StargazingGoal;
import lotr.common.entity.npc.ai.goal.TalkToCurrentGoal;
import lotr.common.entity.npc.ai.goal.WatchSunriseSunsetGoal;
import lotr.common.entity.npc.data.ExtendedFoodPools;
import lotr.common.entity.npc.data.NPCFoodPool;
import lotr.common.entity.npc.data.name.NPCNameGenerator;
import lotr.common.entity.npc.data.name.NPCNameGenerators;
import lotr.common.init.ExtendedItems;
import lotr.common.init.LOTRAttributes;
import lotr.common.init.LOTRItems;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.OpenDoorGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

public class ExtendedDunedainRangerEntity
extends ManEntity {
    private static final SpawnEquipmentTable WEAPONS = SpawnEquipmentTable.of((Object[])new Object[]{LOTRItems.ARNOR_SWORD, LOTRItems.BRONZE_SWORD, Items.field_151040_l, LOTRItems.ARNOR_DAGGER, LOTRItems.BRONZE_DAGGER, LOTRItems.IRON_DAGGER});
    private static final DataParameter<Integer> CLOAK_COOLDOWN = EntityDataManager.func_187226_a(ExtendedDunedainRangerEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> AUTO_DECLOAK_IN = EntityDataManager.func_187226_a(ExtendedDunedainRangerEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> IS_CLOAKED = EntityDataManager.func_187226_a(ExtendedDunedainRangerEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public double xCloakO;
    public double yCloakO;
    public double zCloakO;
    public double xCloak;
    public double yCloak;
    public double zCloak;
    public float oBob;
    public float bob;

    public ExtendedDunedainRangerEntity(EntityType<? extends ExtendedDunedainRangerEntity> type, World w) {
        super(type, w);
        this.getNPCCombatUpdater().setAttackModeUpdater(StandardAttackModeUpdaters.meleeRangedSwitching());
        this.spawnRequiresSurfaceBlock = true;
        if (this.field_70146_Z.nextInt(100) < 4) {
            this.personalInfo.setMale(false);
        } else {
            this.personalInfo.setMale(true);
        }
    }

    protected void addNPCAI() {
        super.addNPCAI();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.addAttackGoal(2);
        this.field_70714_bg.func_75776_a(4, (Goal)new OpenDoorGoal((MobEntity)this, true));
        this.field_70714_bg.func_75776_a(5, (Goal)new TalkToCurrentGoal((NPCEntity)this));
        this.field_70714_bg.func_75776_a(6, (Goal)new FriendlyNPCConversationGoal((NPCEntity)this, 0.001f));
        this.field_70714_bg.func_75776_a(7, (Goal)new WatchSunriseSunsetGoal((MobEntity)this, 0.01f));
        this.field_70714_bg.func_75776_a(8, (Goal)new StargazingGoal((MobEntity)this, 4.0E-4f));
        this.field_70714_bg.func_75776_a(9, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(10, (Goal)new NPCEatGoal((NPCEntity)this, this.getEatPool(), 12000));
        this.field_70714_bg.func_75776_a(10, (Goal)new NPCDrinkGoal((NPCEntity)this, this.getDrinkPool(), 8000));
        this.field_70714_bg.func_75776_a(11, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f, 0.02f));
        this.field_70714_bg.func_75776_a(11, (Goal)new LookAtGoal((MobEntity)this, NPCEntity.class, 5.0f, 0.02f));
        this.field_70714_bg.func_75776_a(12, (Goal)new LookAtGoal((MobEntity)this, LivingEntity.class, 8.0f, 0.02f));
        this.field_70714_bg.func_75776_a(13, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    public ILivingEntityData func_213386_a(IServerWorld sw, DifficultyInstance diff, SpawnReason reason, ILivingEntityData spawnData, CompoundNBT dataTag) {
        spawnData = super.func_213386_a(sw, diff, reason, spawnData, dataTag);
        this.npcItemsInv.setMeleeWeapon(WEAPONS.getRandomItem(this.field_70146_Z));
        this.npcItemsInv.setRangedWeapon(new ItemStack((IItemProvider)ExtendedItems.DUNEDAIN_BOW.get()));
        this.npcItemsInv.setIdleItemsFromRangedWeapons();
        if (this.field_70146_Z.nextFloat() < 0.5f) {
            this.func_184201_a(EquipmentSlotType.OFFHAND, new ItemStack((IItemProvider)ExtendedItems.DUNEDAIN_SHIELD.get()));
        }
        this.func_184201_a(EquipmentSlotType.FEET, new ItemStack((IItemProvider)LOTRItems.RANGER_NORTH_BOOTS.get()));
        this.func_184201_a(EquipmentSlotType.LEGS, new ItemStack((IItemProvider)LOTRItems.RANGER_NORTH_LEGGINGS.get()));
        this.func_184201_a(EquipmentSlotType.CHEST, new ItemStack((IItemProvider)LOTRItems.RANGER_NORTH_CHESTPLATE.get()));
        this.func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)LOTRItems.RANGER_NORTH_HELMET.get()));
        return spawnData;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.getCooldownLeft() > 0) {
            this.decrementCooldown();
        }
        if (this.getAutoDecloak() > 0 && this.isCloaked()) {
            this.decrementAutoDecloak();
            if (this.getAutoDecloak() == 0) {
                this.unCloak();
            }
        }
        this.moveCloak();
    }

    public void func_184609_a(Hand p_184609_1_) {
        if (this.isCloaked()) {
            this.unCloak();
        }
        super.func_184609_a(p_184609_1_);
    }

    public void func_82196_d(LivingEntity target, float charge) {
        this.rangerArrowAttack(target, charge);
    }

    private void rangerArrowAttack(LivingEntity target, float charge) {
        ItemStack heldItem = this.func_184586_b(ProjectileHelper.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof BowItem));
        ItemStack ammoItem = this.func_213356_f(heldItem);
        AbstractArrowEntity arrow = ProjectileHelper.func_221272_a((LivingEntity)this, (ItemStack)ammoItem, (float)charge);
        if (heldItem.func_77973_b() instanceof BowItem) {
            arrow = ((BowItem)heldItem.func_77973_b()).customArrow(arrow);
        }
        double dx = target.func_226277_ct_() - this.func_226277_ct_();
        double dy = target.func_226283_e_(0.3333333333333333) - arrow.func_226278_cu_();
        double dz = target.func_226281_cx_() - this.func_226281_cx_();
        double dxzSq = MathHelper.func_76133_a((double)(dx * dx + dz * dz));
        float power = 1.6f;
        arrow.func_70186_c(dx, dy + dxzSq * (double)0.2f, dz, power, (float)this.func_233637_b_((Attribute)LOTRAttributes.NPC_RANGED_INACCURACY.get()));
        if (heldItem.func_77973_b().equals(ExtendedItems.DUNEDAIN_BOW.get())) {
            arrow.func_70239_b(arrow.func_70242_d() + 2.5);
        }
        this.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_217376_c((Entity)arrow);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_CLOAKED, (Object)false);
        this.field_70180_af.func_187214_a(CLOAK_COOLDOWN, (Object)0);
        this.field_70180_af.func_187214_a(AUTO_DECLOAK_IN, (Object)40);
    }

    public boolean isCloaked() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_CLOAKED);
    }

    public int getCooldownLeft() {
        return (Integer)this.field_70180_af.func_187225_a(CLOAK_COOLDOWN);
    }

    public void resetCooldown() {
        this.field_70180_af.func_187227_b(CLOAK_COOLDOWN, (Object)100);
    }

    public void decrementCooldown() {
        this.field_70180_af.func_187227_b(CLOAK_COOLDOWN, (Object)((Integer)this.field_70180_af.func_187225_a(CLOAK_COOLDOWN) - 1));
    }

    public void decrementAutoDecloak() {
        this.field_70180_af.func_187227_b(AUTO_DECLOAK_IN, (Object)((Integer)this.field_70180_af.func_187225_a(AUTO_DECLOAK_IN) - 1));
    }

    public int getAutoDecloak() {
        return (Integer)this.field_70180_af.func_187225_a(AUTO_DECLOAK_IN);
    }

    protected NPCFoodPool getEatPool() {
        return ExtendedFoodPools.RANGER;
    }

    protected NPCFoodPool getDrinkPool() {
        return ExtendedFoodPools.RANGER_DRINK;
    }

    protected void initialiseAttackGoals(AttackGoalsHolder holder) {
        holder.setMeleeAttackGoal(this.createRangerMeleeAttackGoal());
        holder.setRangedAttackGoal(this.createRangerRangedAttackGoal());
    }

    private void moveCloak() {
        this.xCloakO = this.xCloak;
        this.yCloakO = this.yCloak;
        this.zCloakO = this.zCloak;
        double d0 = this.func_226277_ct_() - this.xCloak;
        double d1 = this.func_226278_cu_() - this.yCloak;
        double d2 = this.func_226281_cx_() - this.zCloak;
        if (d0 > 10.0) {
            this.xCloakO = this.xCloak = this.func_226277_ct_();
        }
        if (d2 > 10.0) {
            this.zCloakO = this.zCloak = this.func_226281_cx_();
        }
        if (d1 > 10.0) {
            this.yCloakO = this.yCloak = this.func_226278_cu_();
        }
        if (d0 < -10.0) {
            this.xCloakO = this.xCloak = this.func_226277_ct_();
        }
        if (d2 < -10.0) {
            this.zCloakO = this.zCloak = this.func_226281_cx_();
        }
        if (d1 < -10.0) {
            this.yCloakO = this.yCloak = this.func_226278_cu_();
        }
        this.xCloak += d0 * 0.25;
        this.zCloak += d2 * 0.25;
        this.yCloak += d1 * 0.25;
    }

    protected Goal createAttackGoal() {
        return this.createRangerRangedAttackGoal();
    }

    public void cloak() {
        this.field_70180_af.func_187227_b(IS_CLOAKED, (Object)true);
        this.field_70180_af.func_187227_b(AUTO_DECLOAK_IN, (Object)40);
    }

    public void renewCloak() {
        this.field_70180_af.func_187227_b(AUTO_DECLOAK_IN, (Object)40);
    }

    public void unCloak() {
        this.field_70180_af.func_187227_b(IS_CLOAKED, (Object)false);
        this.resetCooldown();
    }

    protected NPCNameGenerator getNameGenerator() {
        return NPCNameGenerators.GONDOR;
    }

    public static AttributeModifierMap.MutableAttribute regAttrs() {
        return NPCEntity.registerBaseNPCAttributes().func_233815_a_(Attributes.field_233818_a_, 25.0).func_233815_a_(Attributes.field_233821_d_, 0.2).func_233815_a_((Attribute)LOTRAttributes.NPC_RANGED_INACCURACY.get(), 0.5).func_233815_a_(Attributes.field_233819_b_, 16.0);
    }

    protected Goal createRangerRangedAttackGoal() {
        return new ExtendedRangerRangedAttackGoal(this, 1.25, 20, 16.0f);
    }

    protected Goal createRangerMeleeAttackGoal() {
        return new ExtendedRangerMeleeAttackGoal(this, 1.4);
    }

    protected void addNPCTargetingAI() {
        this.addAggressiveTargetingGoals();
    }

    public ResourceLocation getCloakTextureLocation() {
        return new ResourceLocation("lotr", "textures/cape/ranger.png");
    }
}

