/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import lotr.common.entity.npc.ExtendedTraderEntity;
import lotr.common.entity.npc.GundabadOrcEntity;
import lotr.common.entity.npc.NPCEntity;
import lotr.common.entity.npc.ai.StandardAttackModeUpdaters;
import lotr.common.entity.npc.ai.goal.ExtendedInteractableFriendlyNPCConversationGoal;
import lotr.common.entity.npc.ai.goal.ExtendedInteractableTalkToCurrentGoal;
import lotr.common.entity.npc.ai.goal.ExtendedInteractableWaterAvoidingRandomWalkingGoal;
import lotr.common.entity.npc.ai.goal.NPCDrinkGoal;
import lotr.common.entity.npc.ai.goal.NPCEatGoal;
import lotr.common.entity.npc.data.NPCFoodPools;
import lotr.common.init.ExtendedItems;
import lotr.common.init.LOTRItems;
import lotr.common.item.VesselDrinkItem;
import lotr.common.util.DrinkUtils;
import lotr.common.util.ExtendedInteractableHelper;
import lotr.common.util.ExtendedTraderHelper;
import lotr.common.util.TradeUtils;
import lotr.common.util.representation.ExtendedMultitradeEntry;
import lotr.common.util.representation.ExtendedTrade;
import lotr.common.util.representation.ExtendedTradeEntries;
import lotr.common.util.representation.ExtendedTradeEntry;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.OpenDoorGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

public class ExtendedGundabadOrcTraderEntity
extends GundabadOrcEntity
implements ExtendedTraderEntity {
    int lastTickCooldownReduced = 0;
    int lastTickVerifiedPlayerTradingWithIsOnline = 0;
    private ArrayList<ExtendedTrade> itemsSoldByTrader;
    private ArrayList<ExtendedTrade> itemsBoughtByTrader;
    private static final DataParameter<Optional<UUID>> PLAYER_TRADING_WITH = EntityDataManager.func_187226_a(ExtendedGundabadOrcTraderEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Boolean> IS_WANDERING_TRADER = EntityDataManager.func_187226_a(ExtendedGundabadOrcTraderEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> WANDERING_TRADER_TIME_LEFT = EntityDataManager.func_187226_a(ExtendedGundabadOrcTraderEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private List<UUID> escorts = new ArrayList<UUID>();
    private final ExtendedTradeEntries GUNDABAD_ORC_SOLD = new ExtendedTradeEntries(ExtendedTradeEntries.TradeType.BOUGHT, new ExtendedTradeEntry[]{new ExtendedTradeEntry(new ItemStack((IItemProvider)ExtendedItems.NORTHERN_ORC_CRAFTING_TABLE.get()), 30, 50, 16), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.BRONZE_HELMET.get()), 15, 25, 8), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.BRONZE_CHESTPLATE.get()), 23, 38, 8), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.BRONZE_LEGGINGS.get()), 20, 33, 8), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.BRONZE_BOOTS.get()), 14, 23, 8), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.BRONZE_SWORD.get()), 11, 18, 8), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.BRONZE_SPEAR.get()), 11, 19, 8), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.BRONZE_DAGGER.get()), 6, 10, 8), new ExtendedMultitradeEntry(new ExtendedTradeEntry[]{new ExtendedTradeEntry(DrinkUtils.drinkOfPotency((Item)LOTRItems.ORC_DRAUGHT.get(), VesselDrinkItem.Potency.LIGHT), 5, 8, 16), new ExtendedTradeEntry(DrinkUtils.drinkOfPotency((Item)LOTRItems.ORC_DRAUGHT.get(), VesselDrinkItem.Potency.MODERATE), 6, 10, 16), new ExtendedTradeEntry(DrinkUtils.drinkOfPotency((Item)LOTRItems.ORC_DRAUGHT.get(), VesselDrinkItem.Potency.STRONG), 8, 13, 16)}), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.FUR.get()), 3, 5), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_151032_g, 4), 2, 4, 64), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.BRONZE_PICKAXE.get()), 11, 18, 8), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.BRONZE_AXE.get()), 11, 18, 8), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_151035_b), 11, 18, 8), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_151036_c), 11, 18, 8), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.MAGGOTY_BREAD.get()), 3, 5), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.FUR_HELMET.get()), 11, 19, 8), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.FUR_CHESTPLATE.get()), 15, 25, 8), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.FUR_LEGGINGS.get()), 12, 20, 8), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.FUR_BOOTS.get()), 9, 15, 8)});
    private final ExtendedTradeEntries GUNDABAD_ORC_BOUGHT = new ExtendedTradeEntries(ExtendedTradeEntries.TradeType.SOLD, new ExtendedTradeEntry[]{new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.ORC_STEEL_INGOT.get()), 2, 4), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.URUK_STEEL_INGOT.get()), 2, 4), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_151042_j), 2, 4), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.BRONZE_INGOT.get()), 2, 4), new ExtendedTradeEntry(new ItemStack((IItemProvider)ExtendedItems.DIAMOND.get()), 19, 31), new ExtendedTradeEntry(new ItemStack((IItemProvider)ExtendedItems.EMERALD.get()), 11, 19), new ExtendedTradeEntry(new ItemStack((IItemProvider)ExtendedItems.SAPPHIRE.get()), 9, 15), new ExtendedTradeEntry(new ItemStack((IItemProvider)ExtendedItems.RUBY.get()), 9, 15), new ExtendedTradeEntry(new ItemStack((IItemProvider)ExtendedItems.OPAL.get()), 8, 13), new ExtendedTradeEntry(new ItemStack((IItemProvider)ExtendedItems.PEARL.get()), 19, 31), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_151007_F, 2), 1, 1), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_151008_G), 2, 3), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.WOODEN_MUG.get()), 1, 1), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.WATERSKIN.get()), 2, 3), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_151015_O, 2), 1, 1), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.ELF_BONE.get()), 1, 1), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.DWARF_BONE.get()), 1, 1), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.HOBBIT_BONE.get()), 1, 1), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_151103_aS), 1, 1), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.MAN_FLESH.get()), 2, 4)});

    public ExtendedGundabadOrcTraderEntity(EntityType<? extends GundabadOrcEntity> type, World w) {
        super(type, w);
        this.func_110163_bv();
        this.getNPCCombatUpdater().setAttackModeUpdater(StandardAttackModeUpdaters.meleeOnly());
        this.itemsBoughtByTrader = this.GUNDABAD_ORC_BOUGHT.generateTrades();
        this.itemsSoldByTrader = this.GUNDABAD_ORC_SOLD.generateTrades();
    }

    public void addNPCAI() {
        ((GroundPathNavigator)this.func_70661_as()).func_179688_b(true);
        this.func_70661_as().func_212239_d(true);
        this.func_184644_a(PathNodeType.DANGER_FIRE, 16.0f);
        this.func_184644_a(PathNodeType.DAMAGE_FIRE, -1.0f);
        this.initialiseAttackGoals(this.getAttackGoalsHolder());
        this.addNPCTargetingAI();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.addAttackGoal(4);
        this.field_70714_bg.func_75776_a(6, (Goal)new OpenDoorGoal((MobEntity)this, true));
        this.field_70714_bg.func_75776_a(7, (Goal)new ExtendedInteractableTalkToCurrentGoal((NPCEntity)this, this));
        this.field_70714_bg.func_75776_a(8, (Goal)new ExtendedInteractableFriendlyNPCConversationGoal((NPCEntity)this, this, 2.0E-4f));
        this.field_70714_bg.func_75776_a(9, (Goal)new ExtendedInteractableWaterAvoidingRandomWalkingGoal((CreatureEntity)this, this, 1.0));
        this.field_70714_bg.func_75776_a(10, (Goal)new NPCEatGoal((NPCEntity)this, NPCFoodPools.ORC, 6000));
        this.field_70714_bg.func_75776_a(10, (Goal)new NPCDrinkGoal((NPCEntity)this, NPCFoodPools.ORC_DRINK, 6000));
        this.field_70714_bg.func_75776_a(11, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f, 0.05f));
        this.field_70714_bg.func_75776_a(11, (Goal)new LookAtGoal((MobEntity)this, NPCEntity.class, 5.0f, 0.05f));
        this.field_70714_bg.func_75776_a(12, (Goal)new LookAtGoal((MobEntity)this, LivingEntity.class, 8.0f, 0.02f));
        this.field_70714_bg.func_75776_a(13, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PLAYER_TRADING_WITH, Optional.empty());
        this.field_70180_af.func_187214_a(IS_WANDERING_TRADER, (Object)false);
        this.field_70180_af.func_187214_a(WANDERING_TRADER_TIME_LEFT, (Object)1000);
    }

    public ILivingEntityData func_213386_a(IServerWorld sw, DifficultyInstance diff, SpawnReason reason, ILivingEntityData spawnData, CompoundNBT dataTag) {
        ItemStack bootsItem;
        ItemStack legaItem;
        ItemStack chestItem;
        ItemStack headItem;
        spawnData = super.func_213386_a(sw, diff, reason, spawnData, dataTag);
        this.npcItemsInv.setMeleeWeapon(new ItemStack((IItemProvider)LOTRItems.MORDOR_DAGGER.get()));
        this.npcItemsInv.clearRangedWeapon();
        this.npcItemsInv.clearIdleItem();
        if (this.field_70146_Z.nextInt(500) == 0) {
            headItem = new ItemStack((IItemProvider)ExtendedItems.WHITE_WARG_HELMET.get());
            chestItem = new ItemStack((IItemProvider)ExtendedItems.WHITE_WARG_CHESTPLATE.get());
            legaItem = new ItemStack((IItemProvider)ExtendedItems.WHITE_WARG_LEGGINGS.get());
            bootsItem = new ItemStack((IItemProvider)ExtendedItems.WHITE_WARG_BOOTS.get());
        } else if (this.field_70146_Z.nextInt(24) == 0) {
            headItem = new ItemStack((IItemProvider)ExtendedItems.BLACK_WARG_HELMET.get());
            chestItem = new ItemStack((IItemProvider)ExtendedItems.BLACK_WARG_CHESTPLATE.get());
            legaItem = new ItemStack((IItemProvider)ExtendedItems.BLACK_WARG_LEGGINGS.get());
            bootsItem = new ItemStack((IItemProvider)ExtendedItems.BLACK_WARG_BOOTS.get());
        } else if (this.field_70146_Z.nextInt(10) == 0) {
            headItem = new ItemStack((IItemProvider)ExtendedItems.SILVER_WARG_HELMET.get());
            chestItem = new ItemStack((IItemProvider)ExtendedItems.SILVER_WARG_CHESTPLATE.get());
            legaItem = new ItemStack((IItemProvider)ExtendedItems.SILVER_WARG_LEGGINGS.get());
            bootsItem = new ItemStack((IItemProvider)ExtendedItems.SILVER_WARG_BOOTS.get());
        } else if (this.field_70146_Z.nextInt(3) == 0) {
            headItem = new ItemStack((IItemProvider)ExtendedItems.BROWN_WARG_HELMET.get());
            chestItem = new ItemStack((IItemProvider)ExtendedItems.BROWN_WARG_CHESTPLATE.get());
            legaItem = new ItemStack((IItemProvider)ExtendedItems.BROWN_WARG_LEGGINGS.get());
            bootsItem = new ItemStack((IItemProvider)ExtendedItems.BROWN_WARG_BOOTS.get());
        } else {
            headItem = new ItemStack((IItemProvider)ExtendedItems.GRAY_WARG_HELMET.get());
            chestItem = new ItemStack((IItemProvider)ExtendedItems.GRAY_WARG_CHESTPLATE.get());
            legaItem = new ItemStack((IItemProvider)ExtendedItems.GRAY_WARG_LEGGINGS.get());
            bootsItem = new ItemStack((IItemProvider)ExtendedItems.GRAY_WARG_BOOTS.get());
        }
        this.func_184201_a(EquipmentSlotType.FEET, bootsItem);
        this.func_184201_a(EquipmentSlotType.LEGS, legaItem);
        this.func_184201_a(EquipmentSlotType.CHEST, chestItem);
        this.func_184201_a(EquipmentSlotType.HEAD, headItem);
        this.func_184201_a(EquipmentSlotType.OFFHAND, ItemStack.field_190927_a);
        return spawnData;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.lastTickVerifiedPlayerTradingWithIsOnline >= 100) {
            UUID uuid;
            if (((Optional)this.field_70180_af.func_187225_a(PLAYER_TRADING_WITH)).isPresent() && this.field_70170_p.func_217371_b(uuid = (UUID)((Optional)this.field_70180_af.func_187225_a(PLAYER_TRADING_WITH)).get()) == null) {
                this.field_70180_af.func_187227_b(PLAYER_TRADING_WITH, Optional.empty());
            }
            this.lastTickVerifiedPlayerTradingWithIsOnline = 0;
        } else {
            ++this.lastTickVerifiedPlayerTradingWithIsOnline;
        }
        if (this.lastTickCooldownReduced >= 1200) {
            for (ExtendedTrade trade : this.itemsSoldByTrader) {
                if (trade.getQuantityLeft() >= trade.getOriginalQuantity()) continue;
                trade.setQuantityLeft(trade.getQuantityLeft() + 1);
            }
            for (ExtendedTrade trade : this.itemsBoughtByTrader) {
                if (trade.getQuantityLeft() >= trade.getOriginalQuantity()) continue;
                trade.setQuantityLeft(trade.getQuantityLeft() + 1);
            }
            this.lastTickCooldownReduced = 0;
        } else {
            ++this.lastTickCooldownReduced;
        }
        ExtendedTraderHelper.tickTrader((NPCEntity)this, this);
    }

    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        this.loadAllTrades(tag);
        int wanderingTraderTimeLeft = tag.func_74762_e("wanderingTraderTimeLeft");
        this.field_70180_af.func_187227_b(WANDERING_TRADER_TIME_LEFT, (Object)wanderingTraderTimeLeft);
        boolean isWanderingTrader = tag.func_74767_n("isWanderingTrader");
        this.field_70180_af.func_187227_b(IS_WANDERING_TRADER, (Object)isWanderingTrader);
        this.escorts = ExtendedTraderHelper.loadEscortUUIDs(tag);
    }

    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        this.saveAllTrades(tag);
        ExtendedTraderHelper.saveWanderingTraderData(this, this.escorts, tag);
    }

    @Override
    public void playTradeSound() {
        ExtendedTraderHelper.playTraderSound(this.field_70170_p, this.func_226268_ag_());
    }

    @Override
    public boolean isInteractingWithPlayer() {
        return ExtendedInteractableHelper.isInteractingWithPlayer(this.getPlayerInteractingWith());
    }

    @Override
    public void removePlayerFromInteracting(PlayerEntity player) {
        ExtendedInteractableHelper.removePlayerFromInteracting(player, this.field_70180_af, PLAYER_TRADING_WITH);
    }

    @Override
    public void updatePlayerInteractingWith(UUID uuid) {
        this.field_70180_af.func_187227_b(PLAYER_TRADING_WITH, Optional.of(uuid));
    }

    @Override
    public Optional<UUID> getPlayerInteractingWith() {
        return (Optional)this.field_70180_af.func_187225_a(PLAYER_TRADING_WITH);
    }

    @Override
    public void openCoinExchange(PlayerEntity player) {
        ExtendedTraderHelper.openCoinExchange((NPCEntity)this, player, this);
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        return ExtendedTraderHelper.mobInteract((NPCEntity)this, this, player, hand);
    }

    @Override
    public void openTradeMenu(PlayerEntity player) {
        ExtendedTraderHelper.openTradeMenu((NPCEntity)this, player, this);
    }

    @Override
    public String getTraderName() {
        return ExtendedTraderHelper.getTraderName(this.func_145748_c_());
    }

    @Override
    public Inventory getDisplayInventory() {
        return TradeUtils.generateDisplayInventory(this.itemsSoldByTrader, this.itemsBoughtByTrader);
    }

    @Override
    public List<ExtendedTrade> getBuys() {
        return this.itemsBoughtByTrader;
    }

    @Override
    public void setBuys(ArrayList<ExtendedTrade> trades) {
        this.itemsBoughtByTrader = trades;
    }

    @Override
    public int[] getBoughtPrices() {
        return ExtendedTraderHelper.getBoughtPrices(this.itemsBoughtByTrader);
    }

    @Override
    public int[] getBoughtQuantities() {
        return ExtendedTraderHelper.getBoughtQuantity(this.itemsBoughtByTrader);
    }

    @Override
    public int[] getSoldPrices() {
        return ExtendedTraderHelper.getSoldPrices(this.itemsSoldByTrader);
    }

    @Override
    public int[] getSoldQuantities() {
        return ExtendedTraderHelper.getSoldQuantity(this.itemsSoldByTrader);
    }

    @Override
    public int[] getSoldOriginalQuantities() {
        return ExtendedTraderHelper.getSoldOriginalQuantity(this.itemsSoldByTrader);
    }

    @Override
    public int[] getBoughtOriginalQuantities() {
        return ExtendedTraderHelper.getBoughtOriginalQuantity(this.itemsBoughtByTrader);
    }

    @Override
    public List<ExtendedTrade> getSells() {
        return this.itemsSoldByTrader;
    }

    @Override
    public void setSells(ArrayList<ExtendedTrade> trades) {
        this.itemsSoldByTrader = trades;
    }

    protected void addNPCTargetingAI() {
        this.addNonAggressiveTargetingGoals();
    }

    @Override
    public boolean canTradeWith(PlayerEntity player) {
        return this.isFriendlyAndAlignedWithLevel(player, (NPCEntity)this, 50.0f);
    }

    @Override
    public boolean isWanderingTrader() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_WANDERING_TRADER);
    }

    @Override
    public void setWanderingTrader(boolean isWanderingTrader) {
        this.field_70180_af.func_187227_b(IS_WANDERING_TRADER, (Object)isWanderingTrader);
    }

    @Override
    public int getWanderingTraderTicksLeft() {
        return (Integer)this.field_70180_af.func_187225_a(WANDERING_TRADER_TIME_LEFT);
    }

    @Override
    public void setWanderingTraderTicksLeft(int ticksLeft) {
        this.field_70180_af.func_187227_b(WANDERING_TRADER_TIME_LEFT, (Object)ticksLeft);
    }

    @Override
    public TranslationTextComponent getDepartureLine(PlayerEntity player) {
        return null;
    }

    @Override
    public List<UUID> getEscortUUIDs() {
        return this.escorts;
    }

    @Override
    public void addEscort(UUID uuid) {
        this.escorts.add(uuid);
    }

    @Override
    public NPCEntity createEscort() {
        return null;
    }
}

