/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import lotr.common.entity.npc.ExtendedTraderEntity;
import lotr.common.entity.npc.HobbitEntity;
import lotr.common.entity.npc.NPCEntity;
import lotr.common.entity.npc.OrcEntity;
import lotr.common.entity.npc.ai.goal.ExtendedInteractableFriendlyNPCConversationGoal;
import lotr.common.entity.npc.ai.goal.ExtendedInteractableTalkToCurrentGoal;
import lotr.common.entity.npc.ai.goal.ExtendedInteractableWaterAvoidingRandomWalkingGoal;
import lotr.common.entity.npc.ai.goal.WatchSunriseSunsetGoal;
import lotr.common.init.ExtendedItems;
import lotr.common.init.LOTRItems;
import lotr.common.item.VesselDrinkItem;
import lotr.common.util.DrinkUtils;
import lotr.common.util.ExtendedInteractableHelper;
import lotr.common.util.ExtendedTraderHelper;
import lotr.common.util.TradeUtils;
import lotr.common.util.representation.ExtendedMultitradeEntry;
import lotr.common.util.representation.ExtendedTrade;
import lotr.common.util.representation.ExtendedTradeEntries;
import lotr.common.util.representation.ExtendedTradeEntry;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.OpenDoorGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class ExtendedHobbitBartenderEntity
extends HobbitEntity
implements ExtendedTraderEntity {
    int lastTickCooldownReduced = 0;
    int lastTickVerifiedPlayerTradingWithIsOnline = 0;
    private static final DataParameter<Optional<UUID>> PLAYER_TRADING_WITH = EntityDataManager.func_187226_a(ExtendedHobbitBartenderEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Boolean> IS_WANDERING_TRADER = EntityDataManager.func_187226_a(ExtendedHobbitBartenderEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> WANDERING_TRADER_TIME_LEFT = EntityDataManager.func_187226_a(ExtendedHobbitBartenderEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private List<UUID> escorts = new ArrayList<UUID>();
    private final ExtendedTradeEntries HOBBIT_BARTENDER_BOUGHT = new ExtendedTradeEntries(ExtendedTradeEntries.TradeType.BOUGHT, new ExtendedTradeEntry[]{new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_151082_bd), 2, 4, 128), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_151147_al), 2, 4, 128), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_179561_bm), 2, 4, 128), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_151076_bf), 2, 4, 128), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_179558_bo), 2, 4, 128), new ExtendedTradeEntry(new ItemStack((IItemProvider)ExtendedItems.RAW_DUCK.get()), 2, 4, 128), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.CLAY_PLATE.get()), 1, 1), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.CLAY_MUG.get()), 1, 1), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.PIPEWEED_LEAF.get()), 1, 1, 160), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_151174_bG, 3), 1, 1, 128), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_196086_aW), 2, 3, 128), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_196087_aX), 2, 3, 128), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_151131_as), 3, 5, 32), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_151044_h, 2), 1, 1, 128), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.SALT.get()), 8, 13, 128), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_151133_ar), 2, 4, 16), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.FOUR_LEAF_CLOVER.get()), 30, 50, 32)});
    private final ExtendedTradeEntries HOBBIT_BARTENDER_SOLD = new ExtendedTradeEntries(ExtendedTradeEntries.TradeType.SOLD, new ExtendedTradeEntry[]{new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_151083_be), 5, 9, 32), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_151157_am), 5, 9, 32), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_179557_bn), 5, 9, 32), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_151077_bg), 5, 8, 32), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_179559_bp), 5, 9, 32), new ExtendedTradeEntry(new ItemStack((IItemProvider)ExtendedItems.COOKED_DUCK.get()), 5, 8, 32), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_151025_P), 4, 6, 40), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.PIPEWEED.get(), 6), 5, 8, 64), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.SMOKING_PIPE.get()), 11, 19, 8), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.WOODEN_MUG.get()), 2, 3, 64), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.CERAMIC_MUG.get()), 2, 3, 64), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_151168_bH, 2), 5, 9, 32), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_196104_bb), 5, 8, 32), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_196102_ba), 5, 8, 32), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.CHOCOLATE_DRINK.get()), 3, 5, 20), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.APPLE_JUICE.get()), 5, 8, 20), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.GAMMON.get()), 5, 9, 32), new ExtendedTradeEntry(new ItemStack((IItemProvider)Items.field_151009_A), 8, 13, 8), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.FINE_PLATE.get()), 2, 3, 32), new ExtendedTradeEntry(new ItemStack((IItemProvider)ExtendedItems.HOBBIT_MARRIAGE_RING.get()), 11, 18, 8), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.HOBBIT_OVEN.get()), 30, 50, 2), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.STONEWARE_PLATE.get()), 2, 3, 32), new ExtendedTradeEntry(new ItemStack((IItemProvider)LOTRItems.HOBBIT_CRAFTING_TABLE.get()), 30, 50, 2), new ExtendedTradeEntry(new ItemStack((IItemProvider)ExtendedItems.HOBBIT_PANCAKE.get()), 5, 8, 16), new ExtendedMultitradeEntry(new ExtendedTradeEntry[]{new ExtendedTradeEntry(DrinkUtils.drinkOfPotency((Item)LOTRItems.ALE.get(), VesselDrinkItem.Potency.LIGHT), 5, 8, 16), new ExtendedTradeEntry(DrinkUtils.drinkOfPotency((Item)LOTRItems.ALE.get(), VesselDrinkItem.Potency.MODERATE), 6, 10, 16), new ExtendedTradeEntry(DrinkUtils.drinkOfPotency((Item)LOTRItems.ALE.get(), VesselDrinkItem.Potency.STRONG), 8, 13, 16)}), new ExtendedMultitradeEntry(new ExtendedTradeEntry[]{new ExtendedTradeEntry(DrinkUtils.drinkOfPotency((Item)LOTRItems.CIDER.get(), VesselDrinkItem.Potency.LIGHT), 5, 8, 16), new ExtendedTradeEntry(DrinkUtils.drinkOfPotency((Item)LOTRItems.CIDER.get(), VesselDrinkItem.Potency.MODERATE), 6, 10, 16), new ExtendedTradeEntry(DrinkUtils.drinkOfPotency((Item)LOTRItems.CIDER.get(), VesselDrinkItem.Potency.STRONG), 8, 13, 16)}), new ExtendedMultitradeEntry(new ExtendedTradeEntry[]{new ExtendedTradeEntry(DrinkUtils.drinkOfPotency((Item)LOTRItems.PERRY.get(), VesselDrinkItem.Potency.LIGHT), 5, 8, 16), new ExtendedTradeEntry(DrinkUtils.drinkOfPotency((Item)LOTRItems.PERRY.get(), VesselDrinkItem.Potency.MODERATE), 6, 10, 16), new ExtendedTradeEntry(DrinkUtils.drinkOfPotency((Item)LOTRItems.PERRY.get(), VesselDrinkItem.Potency.STRONG), 8, 13, 16)})});
    private ArrayList<ExtendedTrade> itemsSoldByTrader;
    private ArrayList<ExtendedTrade> itemsBoughtByTrader;

    @Override
    public void updatePlayerInteractingWith(UUID uuid) {
        this.field_70180_af.func_187227_b(PLAYER_TRADING_WITH, Optional.of(uuid));
    }

    @Override
    public Optional<UUID> getPlayerInteractingWith() {
        return (Optional)this.field_70180_af.func_187225_a(PLAYER_TRADING_WITH);
    }

    public ExtendedHobbitBartenderEntity(EntityType<? extends HobbitEntity> type, World w) {
        super(type, w);
        this.func_110163_bv();
        this.itemsBoughtByTrader = this.HOBBIT_BARTENDER_BOUGHT.generateTrades();
        this.itemsSoldByTrader = this.HOBBIT_BARTENDER_SOLD.generateTrades();
    }

    protected void addNPCAI() {
        ((GroundPathNavigator)this.func_70661_as()).func_179688_b(true);
        this.func_70661_as().func_212239_d(true);
        this.func_184644_a(PathNodeType.DANGER_FIRE, 16.0f);
        this.func_184644_a(PathNodeType.DAMAGE_FIRE, -1.0f);
        this.initialiseAttackGoals(this.getAttackGoalsHolder());
        this.addNPCTargetingAI();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal((CreatureEntity)this, OrcEntity.class, 12.0f, 1.5, 1.8));
        this.field_70714_bg.func_75776_a(2, (Goal)new PanicGoal((CreatureEntity)this, 1.6));
        this.field_70714_bg.func_75776_a(9, (Goal)new OpenDoorGoal((MobEntity)this, true));
        this.field_70714_bg.func_75776_a(10, (Goal)new ExtendedInteractableTalkToCurrentGoal((NPCEntity)this, this));
        this.field_70714_bg.func_75776_a(11, (Goal)new ExtendedInteractableFriendlyNPCConversationGoal((NPCEntity)this, this, 0.001f));
        this.field_70714_bg.func_75776_a(12, (Goal)new WatchSunriseSunsetGoal((MobEntity)this, 0.01f));
        this.field_70714_bg.func_75776_a(13, (Goal)new ExtendedInteractableWaterAvoidingRandomWalkingGoal((CreatureEntity)this, this, 1.1));
        this.field_70714_bg.func_75776_a(15, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f, 0.05f));
        this.field_70714_bg.func_75776_a(15, (Goal)new LookAtGoal((MobEntity)this, NPCEntity.class, 5.0f, 0.05f));
        this.field_70714_bg.func_75776_a(16, (Goal)new LookAtGoal((MobEntity)this, LivingEntity.class, 8.0f, 0.02f));
        this.field_70714_bg.func_75776_a(17, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PLAYER_TRADING_WITH, Optional.empty());
        this.field_70180_af.func_187214_a(IS_WANDERING_TRADER, (Object)false);
        this.field_70180_af.func_187214_a(WANDERING_TRADER_TIME_LEFT, (Object)1000);
    }

    @Override
    public boolean canTradeWith(PlayerEntity player) {
        return this.isFriendlyAndAlignedWithLevel(player, (NPCEntity)this, 0.0f);
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return HobbitEntity.regAttrs();
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        return ExtendedTraderHelper.mobInteract((NPCEntity)this, this, player, hand);
    }

    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        this.saveAllTrades(tag);
        ExtendedTraderHelper.saveWanderingTraderData(this, this.escorts, tag);
    }

    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        this.loadAllTrades(tag);
        int wanderingTraderTimeLeft = tag.func_74762_e("wanderingTraderTimeLeft");
        this.field_70180_af.func_187227_b(WANDERING_TRADER_TIME_LEFT, (Object)wanderingTraderTimeLeft);
        boolean isWanderingTrader = tag.func_74767_n("isWanderingTrader");
        this.field_70180_af.func_187227_b(IS_WANDERING_TRADER, (Object)isWanderingTrader);
        this.escorts = ExtendedTraderHelper.loadEscortUUIDs(tag);
    }

    @Override
    public void playTradeSound() {
        ExtendedTraderHelper.playTraderSound(this.field_70170_p, this.func_226268_ag_());
    }

    @Override
    public boolean isInteractingWithPlayer() {
        return ExtendedInteractableHelper.isInteractingWithPlayer(this.getPlayerInteractingWith());
    }

    @Override
    public void removePlayerFromInteracting(PlayerEntity player) {
        ExtendedInteractableHelper.removePlayerFromInteracting(player, this.field_70180_af, PLAYER_TRADING_WITH);
    }

    @Override
    public void openCoinExchange(PlayerEntity player) {
        ExtendedTraderHelper.openCoinExchange((NPCEntity)this, player, this);
    }

    @Override
    public void openTradeMenu(PlayerEntity player) {
        ExtendedTraderHelper.openTradeMenu((NPCEntity)this, player, this);
    }

    @Override
    public String getTraderName() {
        return ExtendedTraderHelper.getTraderName(this.func_145748_c_());
    }

    @Override
    public Inventory getDisplayInventory() {
        return TradeUtils.generateDisplayInventory(this.itemsSoldByTrader, this.itemsBoughtByTrader);
    }

    @Override
    public List<ExtendedTrade> getBuys() {
        return this.itemsBoughtByTrader;
    }

    @Override
    public int[] getBoughtPrices() {
        return ExtendedTraderHelper.getBoughtPrices(this.itemsBoughtByTrader);
    }

    @Override
    public int[] getBoughtQuantities() {
        return ExtendedTraderHelper.getBoughtQuantity(this.itemsBoughtByTrader);
    }

    @Override
    public int[] getSoldPrices() {
        return ExtendedTraderHelper.getSoldPrices(this.itemsSoldByTrader);
    }

    @Override
    public int[] getSoldQuantities() {
        return ExtendedTraderHelper.getSoldQuantity(this.itemsSoldByTrader);
    }

    @Override
    public int[] getSoldOriginalQuantities() {
        return ExtendedTraderHelper.getSoldOriginalQuantity(this.itemsSoldByTrader);
    }

    @Override
    public int[] getBoughtOriginalQuantities() {
        return ExtendedTraderHelper.getBoughtOriginalQuantity(this.itemsBoughtByTrader);
    }

    @Override
    public boolean isWanderingTrader() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_WANDERING_TRADER);
    }

    @Override
    public void setWanderingTrader(boolean isWanderingTrader) {
        this.field_70180_af.func_187227_b(IS_WANDERING_TRADER, (Object)isWanderingTrader);
    }

    @Override
    public int getWanderingTraderTicksLeft() {
        return (Integer)this.field_70180_af.func_187225_a(WANDERING_TRADER_TIME_LEFT);
    }

    @Override
    public void setWanderingTraderTicksLeft(int ticksLeft) {
        this.field_70180_af.func_187227_b(WANDERING_TRADER_TIME_LEFT, (Object)ticksLeft);
    }

    @Override
    public TranslationTextComponent getDepartureLine(PlayerEntity player) {
        return null;
    }

    @Override
    public List<ExtendedTrade> getSells() {
        return this.itemsSoldByTrader;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.lastTickVerifiedPlayerTradingWithIsOnline >= 100) {
            UUID uuid;
            if (((Optional)this.field_70180_af.func_187225_a(PLAYER_TRADING_WITH)).isPresent() && this.field_70170_p.func_217371_b(uuid = (UUID)((Optional)this.field_70180_af.func_187225_a(PLAYER_TRADING_WITH)).get()) == null) {
                this.field_70180_af.func_187227_b(PLAYER_TRADING_WITH, Optional.empty());
            }
            this.lastTickVerifiedPlayerTradingWithIsOnline = 0;
        } else {
            ++this.lastTickVerifiedPlayerTradingWithIsOnline;
        }
        if (this.lastTickCooldownReduced >= 1200) {
            for (ExtendedTrade trade : this.itemsSoldByTrader) {
                if (trade.getQuantityLeft() >= trade.getOriginalQuantity()) continue;
                trade.setQuantityLeft(trade.getQuantityLeft() + 1);
            }
            for (ExtendedTrade trade : this.itemsBoughtByTrader) {
                if (trade.getQuantityLeft() >= trade.getOriginalQuantity()) continue;
                trade.setQuantityLeft(trade.getQuantityLeft() + 1);
            }
            this.lastTickCooldownReduced = 0;
        } else {
            ++this.lastTickCooldownReduced;
        }
        ExtendedTraderHelper.tickTrader((NPCEntity)this, this);
    }

    @Override
    public List<UUID> getEscortUUIDs() {
        return this.escorts;
    }

    @Override
    public void addEscort(UUID uuid) {
        this.escorts.add(uuid);
    }

    @Override
    public NPCEntity createEscort() {
        return null;
    }

    @Override
    public void setBuys(ArrayList<ExtendedTrade> trades) {
        this.itemsBoughtByTrader = trades;
    }

    @Override
    public void setSells(ArrayList<ExtendedTrade> trades) {
        this.itemsSoldByTrader = trades;
    }
}

