/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import lotr.common.entity.npc.ExtendedInteractableEntity;
import lotr.common.entity.npc.NPCEntity;
import lotr.common.util.TradeUtils;
import lotr.common.util.representation.ExtendedTrade;
import lotr.common.util.representation.ExtendedTradeEntries;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.Inventory;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.TranslationTextComponent;

public interface ExtendedTraderEntity
extends ExtendedInteractableEntity {
    default public void saveAllTrades(CompoundNBT tag) {
        TradeUtils.saveAllTrades(ExtendedTradeEntries.TradeType.BOUGHT, this.getBuys(), tag);
        TradeUtils.saveAllTrades(ExtendedTradeEntries.TradeType.SOLD, this.getSells(), tag);
    }

    default public void loadAllTrades(CompoundNBT tag) {
        ArrayList<ExtendedTrade> buys = TradeUtils.loadAllTrades(ExtendedTradeEntries.TradeType.BOUGHT, tag);
        ArrayList<ExtendedTrade> sells = TradeUtils.loadAllTrades(ExtendedTradeEntries.TradeType.SOLD, tag);
        if (buys != null) {
            this.setBuys(TradeUtils.loadAllTrades(ExtendedTradeEntries.TradeType.BOUGHT, tag));
        } else {
            this.setBuys(new ArrayList<ExtendedTrade>());
        }
        if (sells != null) {
            this.setSells(TradeUtils.loadAllTrades(ExtendedTradeEntries.TradeType.SOLD, tag));
        } else {
            this.setSells(new ArrayList<ExtendedTrade>());
        }
    }

    public void playTradeSound();

    public void openCoinExchange(PlayerEntity var1);

    public void openTradeMenu(PlayerEntity var1);

    public String getTraderName();

    public Inventory getDisplayInventory();

    public List<ExtendedTrade> getBuys();

    public void setBuys(ArrayList<ExtendedTrade> var1);

    public int[] getBoughtPrices();

    public int[] getBoughtQuantities();

    public int[] getSoldPrices();

    public int[] getSoldQuantities();

    public int[] getSoldOriginalQuantities();

    public int[] getBoughtOriginalQuantities();

    public List<ExtendedTrade> getSells();

    public void setSells(ArrayList<ExtendedTrade> var1);

    public boolean canTradeWith(PlayerEntity var1);

    public boolean isWanderingTrader();

    public void setWanderingTrader(boolean var1);

    public int getWanderingTraderTicksLeft();

    public void setWanderingTraderTicksLeft(int var1);

    public TranslationTextComponent getDepartureLine(PlayerEntity var1);

    public List<UUID> getEscortUUIDs();

    public void addEscort(UUID var1);

    public NPCEntity createEscort();
}

