/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc.data;

import com.github.maximuslotro.lotrrextended.common.network.ExtendedPacketHandler;
import com.github.maximuslotro.lotrrextended.common.network.ExtendedSPacketNpcMarriageInfo;
import java.util.UUID;
import lotr.common.entity.npc.ExtendedNPCEntity;
import lotr.common.entity.npc.NPCEntity;
import lotr.common.entity.npc.data.ExtendedNpcDataInterface;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;

public class ExtendedNpcMarriageHolder
implements ExtendedNpcDataInterface {
    private final NPCEntity thisEntity;
    public int numberOfCurrentChildren = 0;
    public int maxNumberOfCurrentChildren = 0;
    public UUID spouseID;
    public UUID maleID;
    public UUID femaleID;
    public UUID playerID;
    private boolean resendData = true;

    public ExtendedNpcMarriageHolder(NPCEntity thisEntity) {
        this.thisEntity = thisEntity;
    }

    @Override
    public void markDirty() {
        if (!this.thisEntity.field_70170_p.field_72995_K) {
            if (this.thisEntity.field_70173_aa > 0) {
                this.resendData = true;
            } else {
                this.sendDataToAllBeings();
            }
        }
    }

    @Override
    public void loadFromNbt(CompoundNBT nbt) {
        if (nbt.func_74764_b("Children")) {
            this.numberOfCurrentChildren = nbt.func_74762_e("Children");
        }
        if (nbt.func_74764_b("ChildrenMax")) {
            this.maxNumberOfCurrentChildren = nbt.func_74762_e("ChildrenMax");
        }
        if (nbt.func_74764_b("SpouseUUIDMost") && nbt.func_74764_b("SpouseUUIDLeast")) {
            this.spouseID = new UUID(nbt.func_74763_f("SpouseUUIDMost"), nbt.func_74763_f("SpouseUUIDLeast"));
        }
        if (nbt.func_74764_b("ParentMaleUUIDMost") && nbt.func_74764_b("ParentMaleUUIDLeast")) {
            this.maleID = new UUID(nbt.func_74763_f("ParentMaleUUIDMost"), nbt.func_74763_f("ParentMaleUUIDLeast"));
        }
        if (nbt.func_74764_b("ParentFemaleUUIDMost") && nbt.func_74764_b("ParentFemaleUUIDLeast")) {
            this.femaleID = new UUID(nbt.func_74763_f("ParentFemaleUUIDMost"), nbt.func_74763_f("ParentFemaleUUIDLeast"));
        }
        if (nbt.func_74764_b("PlayerUUIDMost") && nbt.func_74764_b("PlayerUUIDLeast")) {
            this.playerID = new UUID(nbt.func_74763_f("PlayerUUIDMost"), nbt.func_74763_f("PlayerUUIDLeast"));
        }
    }

    @Override
    public void writeToNbt(CompoundNBT nbt) {
        nbt.func_74768_a("Children", this.numberOfCurrentChildren);
        nbt.func_74768_a("ChildrenMax", this.maxNumberOfCurrentChildren);
        if (this.spouseID != null) {
            nbt.func_74772_a("SpouseUUIDMost", this.spouseID.getMostSignificantBits());
            nbt.func_74772_a("SpouseUUIDLeast", this.spouseID.getLeastSignificantBits());
        }
        if (this.maleID != null) {
            nbt.func_74772_a("ParentMaleUUIDMost", this.maleID.getMostSignificantBits());
            nbt.func_74772_a("ParentMaleUUIDLeast", this.maleID.getLeastSignificantBits());
        }
        if (this.femaleID != null) {
            nbt.func_74772_a("ParentFemaleUUIDMost", this.femaleID.getMostSignificantBits());
            nbt.func_74772_a("ParentFemaleUUIDLeast", this.femaleID.getLeastSignificantBits());
        }
        if (this.playerID != null) {
            nbt.func_74772_a("PlayerUUIDMost", this.playerID.getMostSignificantBits());
            nbt.func_74772_a("PlayerUUIDLeast", this.playerID.getLeastSignificantBits());
        }
    }

    @Override
    public PacketBuffer createDataPacketToClient(PacketBuffer buf) {
        buf.func_150787_b(this.thisEntity.func_145782_y());
        buf.writeBoolean(this.numberOfCurrentChildren != 0);
        if (this.numberOfCurrentChildren != 0) {
            buf.func_150787_b(this.numberOfCurrentChildren);
        }
        buf.writeBoolean(this.maxNumberOfCurrentChildren != 0);
        if (this.maxNumberOfCurrentChildren != 0) {
            buf.func_150787_b(this.maxNumberOfCurrentChildren);
        }
        buf.writeBoolean(this.spouseID != null);
        if (this.spouseID != null) {
            buf.writeLong(this.spouseID.getMostSignificantBits());
            buf.writeLong(this.spouseID.getLeastSignificantBits());
        }
        buf.writeBoolean(this.maleID != null);
        if (this.maleID != null) {
            buf.writeLong(this.maleID.getMostSignificantBits());
            buf.writeLong(this.maleID.getLeastSignificantBits());
        }
        buf.writeBoolean(this.femaleID != null);
        if (this.femaleID != null) {
            buf.writeLong(this.femaleID.getMostSignificantBits());
            buf.writeLong(this.femaleID.getLeastSignificantBits());
        }
        buf.writeBoolean(this.playerID != null);
        if (this.playerID != null) {
            buf.writeLong(this.playerID.getMostSignificantBits());
            buf.writeLong(this.playerID.getLeastSignificantBits());
        }
        return buf;
    }

    public static void readDataPacketFromServer(PacketBuffer buf, World world) {
        NPCEntity npc;
        ExtendedNpcMarriageHolder marriageInfo;
        int entityId = buf.func_150792_a();
        Entity entity = world.func_73045_a(entityId);
        if (entity instanceof NPCEntity && (marriageInfo = ((ExtendedNPCEntity)(npc = (NPCEntity)entity)).getMarriageInfo()) != null) {
            marriageInfo.numberOfCurrentChildren = buf.readBoolean() ? buf.readInt() : 0;
            marriageInfo.maxNumberOfCurrentChildren = buf.readBoolean() ? buf.readInt() : 0;
            marriageInfo.spouseID = buf.readBoolean() ? new UUID(buf.readLong(), buf.readLong()) : null;
            marriageInfo.maleID = buf.readBoolean() ? new UUID(buf.readLong(), buf.readLong()) : null;
            marriageInfo.femaleID = buf.readBoolean() ? new UUID(buf.readLong(), buf.readLong()) : null;
            marriageInfo.playerID = buf.readBoolean() ? new UUID(buf.readLong(), buf.readLong()) : null;
        }
    }

    @Override
    public void sendDataToPlayer(ServerPlayerEntity player) {
        ExtendedSPacketNpcMarriageInfo packet = new ExtendedSPacketNpcMarriageInfo(this);
        ExtendedPacketHandler.sendToClient(packet, player);
    }

    @Override
    public void sendDataToAllBeings() {
        ExtendedSPacketNpcMarriageInfo packet = new ExtendedSPacketNpcMarriageInfo(this);
        ExtendedPacketHandler.sendToAllTrackingEntity(packet, (Entity)this.thisEntity);
    }

    @Override
    public void tick() {
        if (!this.thisEntity.field_70170_p.field_72995_K && this.resendData) {
            this.sendDataToAllBeings();
            this.resendData = false;
        }
    }
}

