/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.fellowship;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import lotr.common.data.ExtendedLOTRPlayerData;
import lotr.common.data.LOTRLevelData;
import lotr.common.fellowship.ExtendedFellowshipHolderServer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class ExtendedFellowship {
    private UUID fellowshipId;
    private String fellowshipName;
    private UUID fellowshipOwner;
    private Set<UUID> fellowshipMembers = new HashSet<UUID>();
    private Set<UUID> fellowshipAdmins = new HashSet<UUID>();
    private boolean preventHiredFF = true;
    private boolean preventPVP = true;
    private boolean showMap = true;
    private boolean needsSaving = false;
    private boolean disbanded;
    private ItemStack icon = ItemStack.field_190927_a;

    public ExtendedFellowship(String publicName, UUID ownerUUID) {
        this.fellowshipId = UUID.randomUUID();
        this.fellowshipName = publicName;
        this.fellowshipOwner = ownerUUID;
    }

    public ExtendedFellowship(UUID ID) {
        this.fellowshipId = ID;
    }

    public void markDirty() {
        this.needsSaving = true;
    }

    public boolean needsSave() {
        return this.needsSaving;
    }

    public void createAndRegister() {
        ExtendedFellowshipHolderServer.addFellowship(this);
        ((ExtendedLOTRPlayerData)LOTRLevelData.serverInstance().getData(null, this.fellowshipOwner)).getFellowshipData().addFellowship(this);
        this.markDirty();
    }

    public void load(CompoundNBT pCompound) {
        this.disbanded = pCompound.func_74767_n("Disbanded");
        if (pCompound.func_74764_b("Owner")) {
            this.fellowshipOwner = UUID.fromString(pCompound.func_74779_i("Owner"));
        }
        this.fellowshipMembers.clear();
        this.fellowshipAdmins.clear();
        ListNBT memberTags = pCompound.func_150295_c("Members", 10);
        for (int i = 0; i < memberTags.size(); ++i) {
            boolean isAdmin;
            CompoundNBT nbt = memberTags.func_150305_b(i);
            UUID member = UUID.fromString(nbt.func_74779_i("Member"));
            if (member == null) continue;
            this.fellowshipMembers.add(member);
            if (!nbt.func_74764_b("Admin") || !(isAdmin = nbt.func_74767_n("Admin"))) continue;
            this.fellowshipAdmins.add(member);
        }
        if (pCompound.func_74764_b("Icon")) {
            CompoundNBT item = pCompound.func_74775_l("Icon");
            this.icon = ItemStack.func_199557_a((CompoundNBT)item);
        }
        if (pCompound.func_74764_b("Name")) {
            this.fellowshipName = pCompound.func_74779_i("Name");
        }
        if (pCompound.func_74764_b("preventPVP")) {
            this.preventPVP = pCompound.func_74767_n("preventPVP");
        }
        if (pCompound.func_74764_b("preventHiredFF")) {
            this.preventHiredFF = pCompound.func_74767_n("preventHiredFF");
        }
        if (pCompound.func_74764_b("showMap")) {
            this.showMap = pCompound.func_74767_n("showMap");
        }
    }

    public void save(CompoundNBT pCompound) {
        pCompound.func_74757_a("Disbanded", this.disbanded);
        if (this.fellowshipOwner != null) {
            pCompound.func_74778_a("Owner", this.fellowshipOwner.toString());
        }
        ListNBT memberTags = new ListNBT();
        for (UUID member : this.fellowshipMembers) {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74778_a("Member", member.toString());
            if (this.fellowshipAdmins.contains(member)) {
                nbt.func_74757_a("Admin", true);
            }
            memberTags.add((Object)nbt);
        }
        pCompound.func_218657_a("Members", (INBT)memberTags);
        if (this.icon != null) {
            CompoundNBT item = new CompoundNBT();
            item = this.icon.serializeNBT();
            pCompound.func_218657_a("Icon", (INBT)item);
        }
        if (this.fellowshipName != null) {
            pCompound.func_74778_a("Name", this.fellowshipName);
        }
        pCompound.func_74757_a("preventPVP", this.preventPVP);
        pCompound.func_74757_a("preventHiredFF", this.preventHiredFF);
        pCompound.func_74757_a("showMap", this.showMap);
        this.needsSaving = false;
    }

    public String getFellowshipName() {
        return this.fellowshipName;
    }

    public void setFellowshipName(String name) {
        this.fellowshipName = name;
        this.markDirty();
    }

    public UUID getFellowshipId() {
        return this.fellowshipId;
    }

    public UUID getOwnerUUID() {
        return this.fellowshipOwner;
    }

    public boolean isFellowshipOwner(UUID player) {
        return this.fellowshipOwner.equals(player);
    }

    public boolean isFellowshipMember(UUID player) {
        return this.fellowshipMembers.contains(player);
    }

    public boolean isFellowshipAdmin(UUID player) {
        return this.isFellowshipMember(player) && this.fellowshipAdmins.contains(player);
    }

    public boolean isInFellowship(UUID player) {
        return this.isFellowshipMember(player) || this.isFellowshipOwner(player);
    }

    public boolean hasEditPowers(UUID player) {
        return this.isFellowshipMember(player) && this.fellowshipAdmins.contains(player) || this.fellowshipOwner.equals(player);
    }

    public void setOwnerUUID(UUID ownerUUID) {
        UUID prevOwner = this.fellowshipOwner;
        if (prevOwner != null && !this.fellowshipMembers.contains(prevOwner)) {
            this.fellowshipMembers.add(prevOwner);
        }
        this.fellowshipOwner = ownerUUID;
        if (this.fellowshipMembers.contains(ownerUUID)) {
            this.fellowshipMembers.remove(ownerUUID);
        }
        if (this.fellowshipAdmins.contains(ownerUUID)) {
            this.fellowshipAdmins.remove(ownerUUID);
        }
        ((ExtendedLOTRPlayerData)LOTRLevelData.serverInstance().getData(null, this.fellowshipOwner)).getFellowshipData().addFellowship(this);
        this.markDirty();
    }

    public void addFellowshipMember(UUID player) {
        if (!this.isFellowshipOwner(player) && !this.fellowshipMembers.contains(player)) {
            this.fellowshipMembers.add(player);
            ((ExtendedLOTRPlayerData)LOTRLevelData.serverInstance().getData(null, this.fellowshipOwner)).getFellowshipData().addFellowship(this);
            this.markDirty();
        }
    }

    public void removeFellowshipMember(UUID player) {
        if (this.fellowshipMembers.contains(player)) {
            this.fellowshipMembers.remove(player);
            if (this.fellowshipAdmins.contains(player)) {
                this.fellowshipAdmins.remove(player);
            }
            ((ExtendedLOTRPlayerData)LOTRLevelData.serverInstance().getData(null, this.fellowshipOwner)).getFellowshipData().removeFellowship(this);
            this.markDirty();
        }
    }

    public Set<UUID> getFellowshipMembers() {
        return this.fellowshipMembers;
    }

    public Set<UUID> getAllFellowshipMembers() {
        HashSet<UUID> list = new HashSet<UUID>();
        list.add(this.fellowshipOwner);
        list.addAll(this.fellowshipMembers);
        return list;
    }

    public Set<UUID> getFellowshipAdmins() {
        return this.fellowshipAdmins;
    }

    public void addFellowshipAdmin(UUID player) {
        if (this.fellowshipMembers.contains(player) && !this.fellowshipAdmins.contains(player)) {
            this.fellowshipAdmins.add(player);
            this.markDirty();
        }
    }

    public void removeFellowshipAdmin(UUID player) {
        if (this.fellowshipMembers.contains(player) && this.fellowshipAdmins.contains(player)) {
            this.fellowshipAdmins.remove(player);
            this.markDirty();
        }
    }

    public boolean isPreventPVP() {
        return this.preventPVP;
    }

    public void setPreventPVP(boolean allowPVP) {
        this.preventPVP = allowPVP;
        this.markDirty();
    }

    public boolean isPreventHiredFF() {
        return this.preventHiredFF;
    }

    public void setPreventHiredFF(boolean allowUnitPVP) {
        this.preventHiredFF = allowUnitPVP;
        this.markDirty();
    }

    public boolean isHideMapLocation() {
        return this.showMap;
    }

    public void setHideMapLocation(boolean hideMapLocation) {
        this.showMap = hideMapLocation;
        this.markDirty();
    }

    public ItemStack getIcon() {
        return this.icon;
    }

    public void setIcon(ItemStack itemstack) {
        this.icon = itemstack;
        this.markDirty();
    }

    public void disband() {
        this.disbanded = true;
        for (UUID player : new ArrayList<UUID>(this.fellowshipMembers)) {
            this.removeFellowshipMember(player);
        }
        this.markDirty();
    }

    public boolean isDisbanded() {
        return this.disbanded;
    }

    public void createNotification(String message, PlayerEntity reciever) {
        TranslationTextComponent comp = new TranslationTextComponent(message);
        comp.func_240699_a_(TextFormatting.YELLOW);
        this.sendMessage(reciever, (ITextComponent)comp);
    }

    public void createNotification(String message, PlayerEntity reciever, Object ... args) {
        TranslationTextComponent comp = new TranslationTextComponent(message, args);
        comp.func_240699_a_(TextFormatting.YELLOW);
        this.sendMessage(reciever, (ITextComponent)comp);
    }

    private void sendMessage(PlayerEntity reciever, ITextComponent pComponent) {
        if (reciever != null) {
            reciever.func_145747_a(pComponent, Util.field_240973_b_);
        }
    }
}

