/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.fellowship;

import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.item.ItemStack;

public class ExtendedFellowshipClient {
    private final UUID FellowshipId;
    private String FellowshipName;
    private UUID FellowshipOwner;
    private Set<UUID> FellowshipMembers = new HashSet<UUID>();
    private Set<UUID> FellowshipAdmins = new HashSet<UUID>();
    private boolean PreventHiredFF;
    private boolean PreventPVP;
    private boolean ShowMap;
    private ItemStack icon;
    private boolean isOwned;
    private boolean isAdminned;
    private Map<UUID, String> usernameMap = new HashMap<UUID, String>();

    public ExtendedFellowshipClient(UUID id, String name, boolean owned, boolean admin, GameProfile owner, List<GameProfile> members) {
        this.FellowshipId = id;
        this.FellowshipName = name;
        this.isOwned = owned;
        this.isAdminned = admin;
        this.FellowshipOwner = owner.getId();
        this.usernameMap.put(this.FellowshipOwner, owner.getName());
        for (GameProfile member : members) {
            this.FellowshipMembers.add(member.getId());
            this.usernameMap.put(member.getId(), member.getName());
        }
    }

    public void setOwner(GameProfile newOwner, boolean owned) {
        UUID prevOwnerUuid = this.FellowshipOwner;
        UUID newOwnerUuid = newOwner.getId();
        if (!prevOwnerUuid.equals(newOwnerUuid)) {
            if (!this.FellowshipMembers.contains(prevOwnerUuid)) {
                this.FellowshipMembers.add(prevOwnerUuid);
            }
            this.FellowshipOwner = newOwnerUuid;
            this.usernameMap.put(this.FellowshipOwner, newOwner.getName());
            if (this.FellowshipMembers.contains(newOwnerUuid)) {
                this.FellowshipMembers.remove(newOwnerUuid);
            }
            if (this.FellowshipAdmins.contains(newOwnerUuid)) {
                this.FellowshipAdmins.remove(newOwnerUuid);
            }
            this.isOwned = owned;
            if (this.isOwned) {
                this.isAdminned = false;
            }
        }
    }

    public void addMember(GameProfile member) {
        UUID memberUuid = member.getId();
        if (!this.FellowshipMembers.contains(memberUuid)) {
            this.FellowshipMembers.add(memberUuid);
            this.usernameMap.put(memberUuid, member.getName());
        }
    }

    public void removeMember(GameProfile member) {
        UUID memberUuid = member.getId();
        if (this.FellowshipMembers.contains(memberUuid)) {
            this.FellowshipMembers.remove(memberUuid);
            this.usernameMap.remove(memberUuid);
            if (this.FellowshipAdmins.contains(memberUuid)) {
                this.FellowshipAdmins.remove(memberUuid);
            }
        }
    }

    public void setAdmins(Set<UUID> admins) {
        this.FellowshipAdmins = admins;
    }

    public void setAdmin(UUID playerUuid, boolean adminned) {
        if (!this.FellowshipAdmins.contains(playerUuid)) {
            this.FellowshipAdmins.add(playerUuid);
            this.isAdminned = adminned;
        }
    }

    public void removeAdmin(UUID playerUuid, boolean adminned) {
        if (this.FellowshipAdmins.contains(playerUuid)) {
            this.FellowshipAdmins.remove(playerUuid);
            this.isAdminned = adminned;
        }
    }

    public String getFellowshipName() {
        return this.FellowshipName;
    }

    public void setFellowshipName(String fellowshipName) {
        this.FellowshipName = fellowshipName;
    }

    public boolean isPreventHiredFF() {
        return this.PreventHiredFF;
    }

    public void setPreventHiredFF(boolean preventHiredFF) {
        this.PreventHiredFF = preventHiredFF;
    }

    public boolean isPreventPVP() {
        return this.PreventPVP;
    }

    public void setPreventPVP(boolean preventPVP) {
        this.PreventPVP = preventPVP;
    }

    public boolean isShowMap() {
        return this.ShowMap;
    }

    public void setShowMap(boolean showMap) {
        this.ShowMap = showMap;
    }

    public ItemStack getIcon() {
        return this.icon;
    }

    public void setIcon(ItemStack icon) {
        this.icon = icon;
    }

    public UUID getFellowshipId() {
        return this.FellowshipId;
    }

    public UUID getFellowshipOwner() {
        return this.FellowshipOwner;
    }

    public Set<UUID> getFellowshipMembers() {
        return this.FellowshipMembers;
    }

    public Set<UUID> getFellowshipAdmins() {
        return this.FellowshipAdmins;
    }

    public boolean isOwned() {
        return this.isOwned;
    }

    public boolean isAdminned() {
        return this.isAdminned;
    }
}

