/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.inventory;

import lotr.common.entity.npc.ExtendedTraderEntity;
import lotr.common.entity.npc.NPCEntity;
import lotr.common.init.ExtendedContainers;
import lotr.common.init.ExtendedItems;
import lotr.common.inventory.ExtendedCoinExchangeInventory;
import lotr.common.inventory.ExtendedCoinResultSlot;
import lotr.common.util.CoinUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class ExtendedCoinExchangeContainer
extends Container
implements IContainerListener {
    public static final ITextComponent CONTAINER_TITLE = new TranslationTextComponent("container.lotr.coin_exchange");
    private World level;
    public NPCEntity traderNPC;
    public boolean exchanged = false;
    public int sideExchanged;
    private PlayerEntity player;
    private IInventory coinInputInv = new ExtendedCoinExchangeInventory(this, 1);
    private IInventory exchangeInv = new ExtendedCoinExchangeInventory(this, 2);
    public Slot inputSlot;
    public Slot leftSlot;
    public Slot rightSlot;
    private ItemStack lastInputSlot = null;
    public final ExtendedTraderEntity trader;

    public ExtendedCoinExchangeContainer(int containerId, PlayerInventory inventory, PacketBuffer extraData) {
        super((ContainerType)ExtendedContainers.COIN_TRADING.get(), containerId);
        int i;
        this.player = inventory.field_70458_d;
        this.level = inventory.field_70458_d.field_70170_p;
        this.traderNPC = (NPCEntity)this.level.func_73045_a(extraData.func_150792_a());
        this.trader = (ExtendedTraderEntity)this.traderNPC;
        this.inputSlot = this.func_75146_a(new Slot(this.coinInputInv, 0, 80, 46){

            public boolean func_75214_a(ItemStack stack) {
                return super.func_75214_a(stack) && CoinUtils.isValidCoin(stack);
            }

            public boolean func_82869_a(PlayerEntity p_82869_1_) {
                return !ExtendedCoinExchangeContainer.this.exchanged;
            }

            public ItemStack func_190901_a(PlayerEntity player, ItemStack stack) {
                ExtendedCoinExchangeContainer.this.recalculateResultSlots(stack);
                return stack;
            }
        });
        this.func_75132_a(this);
        this.leftSlot = this.func_75146_a(new ExtendedCoinResultSlot(this, this.exchangeInv, 0, 26, 46));
        this.rightSlot = this.func_75146_a(new ExtendedCoinResultSlot(this, this.exchangeInv, 1, 134, 46));
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)inventory, j + i * 9 + 9, 8 + j * 18, 106 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)inventory, i, 8 + i * 18, 164));
        }
    }

    public void recalculateResultSlots(ItemStack itemStack) {
        if (this.inputSlot.func_75211_c().func_77973_b() == ExtendedItems.SILVER_COIN_ONE.get()) {
            this.leftSlot.func_75215_d(ItemStack.field_190927_a);
            this.exchangeInv.func_70299_a(0, ItemStack.field_190927_a);
            this.leftSlot.func_75218_e();
            if (this.inputSlot.func_75211_c().func_190916_E() >= 10) {
                int tenCoins = this.inputSlot.func_75211_c().func_190916_E() / 10;
                this.rightSlot.func_75215_d(new ItemStack((IItemProvider)ExtendedItems.SILVER_COIN_TEN.get(), tenCoins));
                this.rightSlot.func_75218_e();
                this.exchangeInv.func_70299_a(1, new ItemStack((IItemProvider)ExtendedItems.SILVER_COIN_TEN.get(), tenCoins));
            }
        } else if (this.inputSlot.func_75211_c().func_77973_b() == ExtendedItems.SILVER_COIN_TEN.get()) {
            int oneCoins = this.inputSlot.func_75211_c().func_190916_E() * 10;
            if (oneCoins > 64) {
                oneCoins = 60;
            }
            this.leftSlot.func_75215_d(new ItemStack((IItemProvider)ExtendedItems.SILVER_COIN_ONE.get(), oneCoins));
            this.leftSlot.func_75218_e();
            this.exchangeInv.func_70299_a(0, new ItemStack((IItemProvider)ExtendedItems.SILVER_COIN_ONE.get(), oneCoins));
            if (this.inputSlot.func_75211_c().func_190916_E() >= 10) {
                int hundredCoins = this.inputSlot.func_75211_c().func_190916_E() / 10;
                this.rightSlot.func_75215_d(new ItemStack((IItemProvider)ExtendedItems.SILVER_COIN_HUNDRED.get(), hundredCoins));
                this.rightSlot.func_75218_e();
                this.exchangeInv.func_70299_a(1, new ItemStack((IItemProvider)ExtendedItems.SILVER_COIN_HUNDRED.get(), hundredCoins));
            } else {
                this.rightSlot.func_75215_d(ItemStack.field_190927_a);
                this.exchangeInv.func_70299_a(1, ItemStack.field_190927_a);
                this.rightSlot.func_75218_e();
            }
        } else if (this.inputSlot.func_75211_c().func_77973_b() == ExtendedItems.SILVER_COIN_HUNDRED.get()) {
            int tenCoins = this.inputSlot.func_75211_c().func_190916_E() * 10;
            if (tenCoins > 64) {
                tenCoins = 60;
            }
            this.leftSlot.func_75215_d(new ItemStack((IItemProvider)ExtendedItems.SILVER_COIN_TEN.get(), tenCoins));
            this.leftSlot.func_75218_e();
            this.exchangeInv.func_70299_a(0, new ItemStack((IItemProvider)ExtendedItems.SILVER_COIN_TEN.get(), tenCoins));
            this.rightSlot.func_75215_d(ItemStack.field_190927_a);
            this.rightSlot.func_75218_e();
            this.exchangeInv.func_70299_a(1, ItemStack.field_190927_a);
        } else if (this.inputSlot.func_75211_c().equals(ItemStack.field_190927_a)) {
            this.exchangeInv.func_70299_a(0, ItemStack.field_190927_a);
            this.exchangeInv.func_70299_a(1, ItemStack.field_190927_a);
            this.leftSlot.func_75215_d(ItemStack.field_190927_a);
            this.leftSlot.func_75218_e();
            this.rightSlot.func_75215_d(ItemStack.field_190927_a);
            this.rightSlot.func_75218_e();
        }
    }

    public void handleExchange(int side) {
        if (!this.exchanged && CoinUtils.isValidCoin(this.inputSlot.func_75211_c())) {
            this.exchanged = true;
            this.sideExchanged = side;
            int difference = CoinUtils.value(this.inputSlot.func_75211_c()) - CoinUtils.value(this.exchangeInv.func_70301_a(side));
            int value = CoinUtils.valueOfItem(this.inputSlot.func_75211_c().func_77973_b());
            if (difference > 0 && value > 0) {
                int amount = difference / value;
                this.inputSlot.func_75215_d(new ItemStack((IItemProvider)this.inputSlot.func_75211_c().func_77973_b(), amount));
                this.inputSlot.func_75218_e();
            } else {
                this.inputSlot.func_75215_d(ItemStack.field_190927_a);
                this.inputSlot.func_75218_e();
            }
            this.trader.playTradeSound();
            if (side == 0) {
                this.rightSlot.func_75215_d(ItemStack.field_190927_a);
                this.exchangeInv.func_70299_a(1, ItemStack.field_190927_a);
                this.rightSlot.func_75218_e();
            } else if (side == 1) {
                this.leftSlot.func_75215_d(ItemStack.field_190927_a);
                this.exchangeInv.func_70299_a(0, ItemStack.field_190927_a);
                this.leftSlot.func_75218_e();
            }
        }
    }

    public ItemStack func_82846_b(PlayerEntity player, int slotId) {
        Slot slot = (Slot)this.field_75151_b.get(slotId);
        ItemStack itemstack = slot.func_75211_c();
        if (slot == this.inputSlot) {
            if (player.field_71071_by.func_70441_a(this.inputSlot.func_75211_c())) {
                this.inputSlot.func_75215_d(ItemStack.field_190927_a);
                this.inputSlot.func_75218_e();
                this.func_75130_a((IInventory)player.field_71071_by);
            }
            return ItemStack.field_190927_a;
        }
        if (slot == this.leftSlot) {
            if (this.exchanged && this.sideExchanged == 0 && player.field_71071_by.func_70441_a(this.leftSlot.func_75211_c())) {
                this.leftSlot.func_75215_d(ItemStack.field_190927_a);
                this.leftSlot.func_75218_e();
                this.func_75130_a((IInventory)player.field_71071_by);
                this.exchanged = false;
                this.sideExchanged = -1;
                this.recalculateResultSlots(this.inputSlot.func_75211_c());
            }
            return ItemStack.field_190927_a;
        }
        if (slot == this.rightSlot) {
            if (this.exchanged && this.sideExchanged == 1 && player.field_71071_by.func_70441_a(this.rightSlot.func_75211_c())) {
                this.rightSlot.func_75215_d(ItemStack.field_190927_a);
                this.rightSlot.func_75218_e();
                this.func_75130_a((IInventory)player.field_71071_by);
                this.exchanged = false;
                this.sideExchanged = -1;
                this.recalculateResultSlots(this.inputSlot.func_75211_c());
            }
            return ItemStack.field_190927_a;
        }
        if (!CoinUtils.isValidCoin(itemstack)) {
            return ItemStack.field_190927_a;
        }
        if (itemstack.func_77973_b().equals(this.inputSlot.func_75211_c().func_77973_b()) && this.inputSlot.func_75211_c().func_190916_E() <= 64) {
            int newAmount = this.inputSlot.func_75211_c().func_190916_E() + itemstack.func_190916_E();
            if (newAmount > 64) {
                itemstack.func_190920_e(newAmount - 64);
                this.inputSlot.func_75215_d(new ItemStack((IItemProvider)this.inputSlot.func_75211_c().func_77973_b(), 64));
                this.coinInputInv.func_70299_a(0, new ItemStack((IItemProvider)this.inputSlot.func_75211_c().func_77973_b(), 64));
                this.inputSlot.func_75218_e();
                slot.func_75215_d(itemstack);
                slot.func_75218_e();
                return ItemStack.field_190927_a;
            }
            this.inputSlot.func_75215_d(new ItemStack((IItemProvider)this.inputSlot.func_75211_c().func_77973_b(), newAmount));
            this.coinInputInv.func_70299_a(0, new ItemStack((IItemProvider)this.inputSlot.func_75211_c().func_77973_b(), newAmount));
            this.inputSlot.func_75218_e();
            slot.func_75215_d(ItemStack.field_190927_a);
            slot.func_75218_e();
            return ItemStack.field_190927_a;
        }
        if (!this.inputSlot.func_75211_c().equals(ItemStack.field_190927_a) && !this.inputSlot.func_75211_c().func_77973_b().equals(itemstack.func_77973_b())) {
            return ItemStack.field_190927_a;
        }
        if (this.inputSlot.func_75211_c().equals(ItemStack.field_190927_a)) {
            this.inputSlot.func_75215_d(itemstack);
            this.coinInputInv.func_70299_a(0, itemstack);
            this.inputSlot.func_75218_e();
            slot.func_75215_d(ItemStack.field_190927_a);
            slot.func_75218_e();
            return ItemStack.field_190927_a;
        }
        return itemstack;
    }

    public ItemStack func_184996_a(int slot1, int slot2, ClickType click, PlayerEntity player) {
        Slot s1 = null;
        if (slot1 >= 0 && slot1 < player.field_71071_by.func_70302_i_()) {
            s1 = (Slot)this.field_75151_b.get(slot1);
        }
        boolean s1Equal = s1 == this.inputSlot;
        ItemStack result = super.func_184996_a(slot1, slot2, click, player);
        if (s1Equal && click.equals((Object)ClickType.PICKUP)) {
            this.inputSlot.func_75218_e();
            this.lastInputSlot = null;
            this.recalculateResultSlots(this.inputSlot.func_75211_c());
        }
        return result;
    }

    public boolean func_75145_c(PlayerEntity p_75145_1_) {
        return true;
    }

    public static void writeContainerInitData(PacketBuffer extraData, int entityId) {
        extraData.func_150787_b(entityId);
    }

    public void func_71111_a(Container p_71111_1_, int p_71111_2_, ItemStack p_71111_3_) {
        if (!this.inputSlot.func_75211_c().equals(this.lastInputSlot) && !this.exchanged) {
            this.recalculateResultSlots(this.inputSlot.func_75211_c());
            this.lastInputSlot = this.inputSlot.func_75211_c();
        }
    }

    public void func_71112_a(Container p_71111_1_, int p_71112_2_, int p_71112_3_) {
    }

    public void func_71110_a(Container p_71110_1_, NonNullList<ItemStack> p_71110_2_) {
    }
}

