/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.inventory;

import com.github.maximuslotro.lotrrextended.common.advancements.ExtendedCriteriaTriggers;
import com.github.maximuslotro.lotrrextended.common.network.ExtendedPacketHandler;
import com.github.maximuslotro.lotrrextended.common.network.ExtendedSPacketUpdateTradeQuantities;
import com.github.maximuslotro.lotrrextended.common.stats.ExtendedStats;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import lotr.common.entity.npc.ExtendedTraderEntity;
import lotr.common.entity.npc.NPCEntity;
import lotr.common.init.ExtendedContainers;
import lotr.common.init.ExtendedItems;
import lotr.common.util.CoinUtils;
import lotr.common.util.TradeUtils;
import lotr.common.util.representation.ExtendedTrade;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class ExtendedTradeContainer
extends Container {
    public static final ITextComponent CONTAINER_TITLE = new TranslationTextComponent("container.lotr.trading");
    private boolean tradedYet = false;
    private World level;
    public NPCEntity traderNPC;
    public final ExtendedTraderEntity trader;
    private IInventory displayInventory = new Inventory(18);
    public Inventory sellInventory = new Inventory(9);
    private int[] soldPrices = new int[9];
    private int[] soldQuantities = new int[9];
    private int[] soldOriginalQuantities = new int[9];
    private int[] boughtPrices = new int[9];
    private int[] boughtQuantities = new int[9];
    private int[] boughtOriginalQuantities = new int[9];
    private ItemStack[] soldItems;
    private PlayerEntity player;

    public ExtendedTradeContainer(int containerId, PlayerInventory inventory, PacketBuffer extraData) {
        super((ContainerType)ExtendedContainers.TRADING.get(), containerId);
        int i;
        CompoundNBT nbt = extraData.func_244273_m();
        this.level = inventory.field_70458_d.field_70170_p;
        this.player = inventory.field_70458_d;
        assert (nbt != null);
        this.traderNPC = (NPCEntity)this.level.func_73045_a(nbt.func_74762_e("entityId"));
        this.trader = (ExtendedTraderEntity)this.traderNPC;
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        ListNBT list = nbt.func_150295_c("soldItems", 10);
        for (i = 0; i < list.size(); ++i) {
            CompoundNBT node = list.func_150305_b(i);
            if (node == null) continue;
            ItemStack item = ItemStack.func_199557_a((CompoundNBT)node.func_74775_l("item"));
            items.add(item);
        }
        this.soldItems = items.toArray(new ItemStack[items.size()]);
        if (!inventory.field_70458_d.field_70170_p.field_72995_K) {
            ArrayList<ItemStack> tmpItems = new ArrayList<ItemStack>();
            for (ExtendedTrade trade : this.trader.getSells()) {
                tmpItems.add(trade.getItem());
            }
            this.soldItems = tmpItems.toArray(new ItemStack[tmpItems.size()]);
            this.boughtPrices = this.trader.getBoughtPrices();
        }
        if (this.trader.getDisplayInventory() != null) {
            this.displayInventory = this.trader.getDisplayInventory();
            this.soldPrices = nbt.func_74759_k("sp");
            this.soldQuantities = nbt.func_74759_k("sq");
            this.boughtPrices = nbt.func_74759_k("bp");
            this.boughtQuantities = nbt.func_74759_k("bq");
            this.boughtOriginalQuantities = nbt.func_74759_k("boq");
            this.soldOriginalQuantities = nbt.func_74759_k("soq");
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot(this.displayInventory, i, 8 + i * 18, 40){

                public boolean func_82869_a(PlayerEntity player) {
                    return true;
                }

                public boolean func_75214_a(ItemStack stack) {
                    return false;
                }
            });
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot(this.displayInventory, i + 9, 8 + i * 18, 92){

                public boolean func_82869_a(PlayerEntity player) {
                    return false;
                }

                public boolean func_75214_a(ItemStack stack) {
                    return false;
                }
            });
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)this.sellInventory, i, 8 + i * 18, 141));
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)inventory, j + i * 9 + 9, 8 + j * 18, 188 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)inventory, i, 8 + i * 18, 246));
        }
    }

    public static void writeContainerInitData(PacketBuffer extraData, int entityId, int[] boughtPrices, int[] boughtQuantities, int[] boughtOriginalQuantities, int[] soldPrices, int[] soldQuantities, int[] soldOriginalQuantities, List<ItemStack> soldItems) {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("entityId", entityId);
        nbt.func_74783_a("bp", boughtPrices);
        nbt.func_74783_a("bq", boughtQuantities);
        nbt.func_74783_a("boq", boughtOriginalQuantities);
        nbt.func_74783_a("sp", soldPrices);
        nbt.func_74783_a("sq", soldQuantities);
        nbt.func_74783_a("soq", soldOriginalQuantities);
        ListNBT listnbt = new ListNBT();
        for (ItemStack stack : soldItems) {
            CompoundNBT compoundnbt = new CompoundNBT();
            CompoundNBT itemTag = new CompoundNBT();
            itemTag = stack.func_77955_b(itemTag);
            compoundnbt.func_218657_a("item", (INBT)itemTag);
            listnbt.add((Object)compoundnbt);
        }
        nbt.func_218657_a("soldItems", (INBT)listnbt);
        extraData.func_150786_a(nbt);
    }

    public int[] getBoughtPrices() {
        return this.boughtPrices;
    }

    public int[] getSoldPrices() {
        return this.soldPrices;
    }

    public int[] getSoldQuantities() {
        return this.soldQuantities;
    }

    public int[] getBoughtQuantities() {
        return this.boughtQuantities;
    }

    public int[] getBoughtOriginalQuantities() {
        return this.boughtOriginalQuantities;
    }

    public int[] getSoldOriginalQuantities() {
        return this.soldOriginalQuantities;
    }

    public int getSellValue() {
        int value = 0;
        HashMap<Item, Integer> counts = new HashMap<Item, Integer>();
        for (int i = 0; i < this.sellInventory.func_70302_i_(); ++i) {
            ItemStack stack = this.sellInventory.func_70301_a(i);
            if (counts.containsKey(stack.func_77973_b().getItem())) {
                int count = (Integer)counts.get(stack.func_77973_b()) + stack.func_190916_E();
                counts.put(stack.func_77973_b(), count);
                continue;
            }
            counts.put(stack.func_77973_b(), stack.func_190916_E());
        }
        for (Item item : counts.keySet()) {
            for (int i = 0; i < 9; ++i) {
                int quantity;
                Item displayedItem = this.displayInventory.func_70301_a(i + 9).func_77973_b();
                if (!displayedItem.equals(item) || (quantity = this.displayInventory.func_70301_a(i + 9).func_190916_E()) <= 0) continue;
                int totalTrades = (Integer)counts.get(item) / quantity;
                value += totalTrades * this.boughtPrices[i];
            }
        }
        return value;
    }

    public ItemStack func_184996_a(int index, int p_184996_2_, ClickType clickType, PlayerEntity p_184996_4_) {
        if (index < 9 && !this.displayInventory.func_70301_a(index).equals(ItemStack.field_190927_a) && (clickType.equals((Object)ClickType.PICKUP) || clickType.equals((Object)ClickType.PICKUP_ALL))) {
            boolean stackHasSpace;
            boolean canPerformTrade;
            boolean bl = canPerformTrade = CoinUtils.totalValueInPlayerInventory(this.player.field_71071_by) >= this.soldPrices[index] && this.soldQuantities[index] > 0;
            if (index < this.soldItems.length) {
                this.displayInventory.func_70299_a(index, this.soldItems[index].func_77946_l());
                this.displayInventory.func_70296_d();
            }
            boolean bl2 = stackHasSpace = this.player.field_71071_by.func_70445_o().func_190926_b() || this.player.field_71071_by.func_70445_o().func_77973_b().equals(this.soldItems[index].func_77973_b()) && this.player.field_71071_by.func_70445_o().func_190916_E() + this.soldItems[index].func_190916_E() <= this.soldItems[index].func_77976_d();
            if (canPerformTrade && stackHasSpace) {
                int price = this.soldPrices[index];
                if (!CoinUtils.removeCoins(this.player, this.player.field_71071_by, this.soldPrices[index])) {
                    return super.func_184996_a(index, p_184996_2_, clickType, p_184996_4_);
                }
                this.trader.playTradeSound();
                ItemStack itemForTrade = this.soldItems[index].func_77946_l();
                if (this.player.field_71071_by.func_70445_o().equals(ItemStack.field_190927_a)) {
                    this.player.field_71071_by.func_70437_b(itemForTrade);
                } else {
                    this.player.field_71071_by.func_70437_b(new ItemStack((IItemProvider)this.soldItems[index].func_77973_b(), this.player.field_71071_by.func_70445_o().func_190916_E() + this.soldItems[index].func_190916_E()));
                }
                this.soldQuantities[index] = this.soldQuantities[index] - 1;
                if (!this.level.field_72995_K) {
                    this.trader.getSells().get(index).setQuantityLeft(this.trader.getSells().get(index).getQuantityLeft() - 1);
                }
                this.player.field_71071_by.func_70296_d();
                if (!this.tradedYet) {
                    this.player.func_195066_a(ExtendedStats.TRADERS_TRADED);
                    this.tradedYet = true;
                }
                if (!this.player.field_70170_p.func_201670_d()) {
                    ExtendedCriteriaTriggers.TRAGER_TRADED_TRIGGER.trigger((ServerPlayerEntity)this.player, this.traderNPC.func_200600_R(), true, itemForTrade, price);
                }
            }
            return this.player.field_71071_by.func_70445_o();
        }
        if (clickType == ClickType.PICKUP_ALL && index >= 0) {
            if (index < 27) {
                return ItemStack.field_190927_a;
            }
            Slot initialSlot = (Slot)this.field_75151_b.get(index);
            ItemStack carriedItem = this.player.field_71071_by.func_70445_o();
            if (!(carriedItem.func_190926_b() || initialSlot != null && initialSlot.func_75216_d() && initialSlot.func_82869_a(this.player))) {
                int startIndex = p_184996_2_ == 0 ? 0 : this.field_75151_b.size() - 1;
                int direction = p_184996_2_ == 0 ? 1 : -1;
                for (int pass = 0; pass < 2; ++pass) {
                    for (int i = startIndex; i >= 0 && i < this.field_75151_b.size() && carriedItem.func_190916_E() < carriedItem.func_77976_d(); i += direction) {
                        Slot currentSlot = (Slot)this.field_75151_b.get(i);
                        if (!currentSlot.field_75224_c.equals(this.player.field_71071_by) || !currentSlot.func_75216_d() || !ExtendedTradeContainer.func_94527_a((Slot)currentSlot, (ItemStack)carriedItem, (boolean)true) || !currentSlot.func_82869_a(this.player) || !this.func_94530_a(carriedItem, currentSlot)) continue;
                        ItemStack slotItem = currentSlot.func_75211_c();
                        if (pass == 0 && slotItem.func_190916_E() == slotItem.func_77976_d()) continue;
                        int transferCount = Math.min(carriedItem.func_77976_d() - carriedItem.func_190916_E(), slotItem.func_190916_E());
                        ItemStack removedStack = currentSlot.func_75209_a(transferCount);
                        carriedItem.func_190917_f(transferCount);
                        if (removedStack.func_190926_b()) {
                            currentSlot.func_75215_d(ItemStack.field_190927_a);
                        }
                        currentSlot.func_190901_a(this.player, removedStack);
                    }
                }
            }
            this.func_75142_b();
            return carriedItem;
        }
        return super.func_184996_a(index, p_184996_2_, clickType, p_184996_4_);
    }

    public boolean func_75145_c(PlayerEntity playerEntity) {
        return true;
    }

    public ItemStack func_82846_b(PlayerEntity player, int slotId) {
        Slot slot = (Slot)this.field_75151_b.get(slotId);
        ItemStack item = slot.func_75211_c();
        if (slot.field_75224_c.equals(this.displayInventory) && slot.field_75222_d < 9) {
            if (this.displayInventory.func_70301_a(slot.field_75222_d).func_190916_E() <= 0) {
                return ItemStack.field_190927_a;
            }
            while (player.field_71071_by.func_70447_i() > -1) {
                boolean lastTradeThatCanBePerformed = false;
                int tradesToPerform = this.displayInventory.func_70301_a(slot.field_75222_d).func_77976_d() / this.displayInventory.func_70301_a(slot.field_75222_d).func_190916_E();
                if (tradesToPerform > this.soldQuantities[slot.field_75222_d]) {
                    tradesToPerform = this.soldQuantities[slot.field_75222_d];
                    lastTradeThatCanBePerformed = true;
                }
                if (tradesToPerform * this.soldPrices[slot.field_75222_d] >= CoinUtils.totalValueInPlayerInventory(player.field_71071_by)) {
                    tradesToPerform = CoinUtils.totalValueInPlayerInventory(player.field_71071_by) / this.soldPrices[slot.field_75222_d];
                    lastTradeThatCanBePerformed = true;
                }
                if (tradesToPerform == 0) {
                    return ItemStack.field_190927_a;
                }
                if (!this.tradedYet) {
                    player.func_195066_a(ExtendedStats.TRADERS_TRADED);
                    this.tradedYet = true;
                }
                ItemStack stack = this.displayInventory.func_70301_a(slot.field_75222_d).func_77946_l();
                stack.func_190920_e(tradesToPerform * this.displayInventory.func_70301_a(slot.field_75222_d).func_190916_E());
                CoinUtils.removeCoins(player, player.field_71071_by, tradesToPerform * this.soldPrices[slot.field_75222_d]);
                player.field_71071_by.func_70447_i();
                if (!player.field_71071_by.func_70441_a(stack)) {
                    this.level.func_217376_c((Entity)new ItemEntity(this.level, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), stack));
                }
                player.field_71071_by.func_70296_d();
                this.soldQuantities[slot.field_75222_d] = this.soldQuantities[slot.field_75222_d] - tradesToPerform;
                if (!this.level.field_72995_K) {
                    this.trader.getSells().get(slot.field_75222_d).setQuantityLeft(this.trader.getSells().get(slot.field_75222_d).getQuantityLeft() - tradesToPerform);
                }
                if (!lastTradeThatCanBePerformed) continue;
                break;
            }
            return ItemStack.field_190927_a;
        }
        if (slot.field_75224_c.equals(this.sellInventory)) {
            if (player.field_71071_by.func_70441_a(item)) {
                slot.func_75215_d(ItemStack.field_190927_a);
                slot.func_75218_e();
            }
            return ItemStack.field_190927_a;
        }
        if (TradeUtils.isValidSellItem(item, this.trader.getBuys()) && this.sellInventory.func_233541_b_(item)) {
            ItemStack remaining = this.sellInventory.func_174894_a(item);
            this.sellInventory.func_70296_d();
            if (remaining.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75215_d(remaining);
            }
            slot.func_75218_e();
            player.field_71071_by.func_70296_d();
        }
        return ItemStack.field_190927_a;
    }

    public void handleSellItems() {
        HashMap<Item, Integer> counts = new HashMap<Item, Integer>();
        for (int i = 0; i < this.sellInventory.func_70302_i_(); ++i) {
            ItemStack stack = this.sellInventory.func_70301_a(i);
            if (counts.containsKey(stack.func_77973_b().getItem())) {
                int count = (Integer)counts.get(stack.func_77973_b()) + stack.func_190916_E();
                counts.put(stack.func_77973_b(), count);
                continue;
            }
            counts.put(stack.func_77973_b(), stack.func_190916_E());
        }
        int coinsGiven = 0;
        ArrayList<ItemStack> soldItems = new ArrayList<ItemStack>();
        for (ExtendedTrade trade : this.trader.getBuys()) {
            if (!counts.containsKey(trade.getItem().func_77973_b())) continue;
            int count = (Integer)counts.get(trade.getItem().func_77973_b());
            int totalTrades = count / trade.getItem().func_190916_E();
            if (totalTrades > trade.getQuantityLeft()) {
                totalTrades = trade.getQuantityLeft();
            }
            soldItems.add(new ItemStack((IItemProvider)trade.getItem().func_77973_b()));
            this.sellInventory.func_223374_a(trade.getItem().func_77973_b(), totalTrades * trade.getItem().func_190916_E());
            coinsGiven += totalTrades * trade.getAmount();
            trade.setQuantityLeft(trade.getQuantityLeft() - totalTrades);
            this.sellInventory.func_70296_d();
        }
        if (coinsGiven > 0 && !this.tradedYet) {
            this.player.func_195067_a(ExtendedStats.TRADERS_TRADED, 1);
            this.tradedYet = true;
        }
        if (!this.player.field_70170_p.func_201670_d()) {
            for (ItemStack itemSold : soldItems) {
                ExtendedCriteriaTriggers.TRAGER_TRADED_TRIGGER.trigger((ServerPlayerEntity)this.player, this.traderNPC.func_200600_R(), false, itemSold, coinsGiven);
            }
        }
        ArrayList<ItemStack> itemsToGive = new ArrayList<ItemStack>();
        if (coinsGiven / 100 > 0) {
            int hundreds = coinsGiven / 100;
            itemsToGive.add(new ItemStack((IItemProvider)ExtendedItems.SILVER_COIN_HUNDRED.get(), hundreds));
            coinsGiven -= hundreds * 100;
        }
        if (coinsGiven / 10 > 0) {
            int tens = coinsGiven / 10;
            itemsToGive.add(new ItemStack((IItemProvider)ExtendedItems.SILVER_COIN_TEN.get(), tens));
            coinsGiven -= tens * 10;
        }
        if (coinsGiven > 0) {
            itemsToGive.add(new ItemStack((IItemProvider)ExtendedItems.SILVER_COIN_ONE.get(), coinsGiven));
        }
        for (ItemStack stack : itemsToGive) {
            if (this.player.field_71071_by.func_70441_a(stack)) continue;
            this.level.func_217376_c((Entity)new ItemEntity(this.level, this.player.func_226277_ct_(), this.player.func_226278_cu_(), this.player.func_226281_cx_(), stack));
        }
        this.player.field_71071_by.func_70296_d();
        if (!this.player.field_70170_p.func_201670_d()) {
            ExtendedPacketHandler.sendToClient(new ExtendedSPacketUpdateTradeQuantities(this.trader.getSoldQuantities(), this.trader.getBoughtQuantities()), (ServerPlayerEntity)this.player);
        }
    }

    public void setSoldQuantities(int[] soldQuantities) {
        this.soldQuantities = soldQuantities;
    }

    public void setBoughtQuantities(int[] boughtQuantities) {
        this.boughtQuantities = boughtQuantities;
    }
}

