/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import lotr.common.init.ExtendedItems;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;

public class CoinUtils {
    private CoinUtils() {
    }

    public static int valueOfItem(Item item) {
        if (item.equals(ExtendedItems.SILVER_COIN_ONE.get())) {
            return 1;
        }
        if (item.equals(ExtendedItems.SILVER_COIN_TEN.get())) {
            return 10;
        }
        if (item.equals(ExtendedItems.SILVER_COIN_HUNDRED.get())) {
            return 100;
        }
        return 0;
    }

    public static int value(ItemStack stack) {
        if (!CoinUtils.isValidCoin(stack)) {
            return 0;
        }
        return CoinUtils.valueOfItem(stack.func_77973_b()) * stack.func_190916_E();
    }

    public static boolean isValidCoin(ItemStack stack) {
        return CoinUtils.isSameItem(stack, (Item)ExtendedItems.SILVER_COIN_ONE.get()) || CoinUtils.isSameItem(stack, (Item)ExtendedItems.SILVER_COIN_TEN.get()) || CoinUtils.isSameItem(stack, (Item)ExtendedItems.SILVER_COIN_HUNDRED.get());
    }

    public static int totalValueInPlayerInventory(PlayerInventory inv) {
        int totalValue = 0;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            totalValue += CoinUtils.value(stack);
        }
        return totalValue;
    }

    public static int totalValueInInventory(IInventory inventory) {
        int totalValue = 0;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            totalValue += CoinUtils.value(stack);
        }
        return totalValue;
    }

    private static HashMap<Integer, Integer> totalOfEachDenomination(PlayerInventory inventory) {
        HashMap<Integer, Integer> denominations = new HashMap<Integer, Integer>();
        denominations.put(1, 0);
        denominations.put(10, 0);
        denominations.put(100, 0);
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (!CoinUtils.isValidCoin(stack)) continue;
            if (CoinUtils.valueOfItem(stack.func_77973_b()) == 1) {
                denominations.merge(1, stack.func_190916_E(), Integer::sum);
            }
            if (CoinUtils.valueOfItem(stack.func_77973_b()) == 10) {
                denominations.merge(10, stack.func_190916_E(), Integer::sum);
            }
            if (CoinUtils.valueOfItem(stack.func_77973_b()) != 100) continue;
            denominations.merge(100, stack.func_190916_E(), Integer::sum);
        }
        return denominations;
    }

    private static Item itemFromDenomination(int denomination) {
        if (denomination == 1) {
            return (Item)ExtendedItems.SILVER_COIN_ONE.get();
        }
        if (denomination == 10) {
            return (Item)ExtendedItems.SILVER_COIN_TEN.get();
        }
        if (denomination == 100) {
            return (Item)ExtendedItems.SILVER_COIN_HUNDRED.get();
        }
        return null;
    }

    private static void givePlayerCoins(PlayerEntity player, int denomination, int amount) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        while (amount > 0) {
            if (amount > 64) {
                stacks.add(new ItemStack((IItemProvider)CoinUtils.itemFromDenomination(denomination), 64));
                amount -= 64;
                continue;
            }
            stacks.add(new ItemStack((IItemProvider)CoinUtils.itemFromDenomination(denomination), amount));
            amount = 0;
        }
        for (ItemStack stack : stacks) {
            if (player.field_71071_by.func_70441_a(stack)) continue;
            ItemEntity itemEntity = new ItemEntity(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), stack);
            player.field_70170_p.func_217376_c((Entity)itemEntity);
        }
    }

    private static boolean removeCoinsByDenomination(PlayerEntity player, int denomination, int amount) {
        while (amount > 0) {
            int stackSize = Math.min(amount, 64);
            ItemStack itemStack = new ItemStack((IItemProvider)CoinUtils.itemFromDenomination(denomination));
            int slot = -1;
            for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
                if (((ItemStack)player.field_71071_by.field_70462_a.get(i)).func_190926_b() || !CoinUtils.isSameItem(itemStack, (ItemStack)player.field_71071_by.field_70462_a.get(i))) continue;
                slot = i;
                break;
            }
            if (slot > -1) {
                player.field_71071_by.func_70298_a(slot, stackSize);
                amount -= stackSize;
                continue;
            }
            return false;
        }
        return true;
    }

    public static boolean removeCoins(PlayerEntity player, PlayerInventory inventory, int amount) {
        int n;
        Integer[] denominationOrder;
        if (CoinUtils.totalValueInPlayerInventory(inventory) < amount) {
            return false;
        }
        HashMap<Integer, Integer> denominations = CoinUtils.totalOfEachDenomination(inventory);
        Integer[] integerArray = denominationOrder = new Integer[]{1, 10, 100};
        int n2 = integerArray.length;
        for (n = 0; n < n2; ++n) {
            int quantity;
            int denomination = integerArray[n];
            if (denomination * (quantity = denominations.get(denomination).intValue()) < amount) continue;
            int coinsToConsume = 0;
            while (coinsToConsume * denomination < amount) {
                ++coinsToConsume;
            }
            int change = coinsToConsume * denomination - amount;
            if (change >= 10) {
                int changeInTens = change / 10;
                int changeInOnes = change % 10;
                CoinUtils.givePlayerCoins(player, denomination / 10, changeInTens);
                if (changeInOnes > 0) {
                    CoinUtils.givePlayerCoins(player, 1, changeInOnes);
                }
            } else {
                CoinUtils.givePlayerCoins(player, 1, change);
            }
            CoinUtils.removeCoinsByDenomination(player, denomination, coinsToConsume);
            return true;
        }
        int amountLeft = amount;
        Integer[] integerArray2 = denominationOrder;
        n = integerArray2.length;
        for (int i = 0; i < n; ++i) {
            int denomination = integerArray2[i];
            if (amountLeft == 0) break;
            int quantity = denominations.get(denomination);
            if (denomination * quantity <= amountLeft) {
                CoinUtils.removeCoinsByDenomination(player, denomination, quantity);
                amountLeft -= denomination * quantity;
                continue;
            }
            int coinsToConsume = 0;
            while (coinsToConsume * denomination < amount) {
                ++coinsToConsume;
            }
            int change = coinsToConsume * denomination - amount;
            if (change >= 10) {
                int changeInTens = change / 10;
                int changeInOnes = change % 10;
                CoinUtils.givePlayerCoins(player, denomination / 10, changeInTens);
                if (changeInOnes > 0) {
                    CoinUtils.givePlayerCoins(player, 1, changeInOnes);
                }
            } else {
                CoinUtils.givePlayerCoins(player, 1, change);
            }
            CoinUtils.removeCoinsByDenomination(player, denomination, coinsToConsume);
        }
        return true;
    }

    private static boolean isSameItem(ItemStack p_184431_1_, ItemStack p_184431_2_) {
        return p_184431_1_.func_77973_b() == p_184431_2_.func_77973_b() && ItemStack.func_77970_a((ItemStack)p_184431_1_, (ItemStack)p_184431_2_);
    }

    private static boolean isSameItem(ItemStack stack, Item item) {
        return stack.func_77973_b() == item && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)new ItemStack((IItemProvider)item));
    }
}

