/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.util;

import lotr.common.entity.npc.ExtendedHirableEntity;
import lotr.common.entity.npc.ExtendedHiredBreeGuard;
import lotr.common.entity.npc.NPCEntity;
import lotr.common.entity.npc.util.LeatherDyeUtil;
import lotr.common.init.LOTRItems;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;

public class ExtendedHiredUnitHelper {
    public static final ItemStack BREE_GUARD_HEAD = new ItemStack((IItemProvider)Items.field_151028_Y).func_200302_a((ITextComponent)new TranslationTextComponent("item.lotrextended.base_gear.helmet").func_240699_a_(TextFormatting.BOLD).func_240699_a_(TextFormatting.GOLD));
    public static final ItemStack BREE_GUARD_CHEST = LeatherDyeUtil.dyeLeather((Item)Items.field_151027_R, (int)7823440).func_200302_a((ITextComponent)new TranslationTextComponent("item.lotrextended.base_gear.chestplate").func_240699_a_(TextFormatting.BOLD).func_240699_a_(TextFormatting.GOLD));
    public static final ItemStack BREE_GUARD_LEGS = new ItemStack((IItemProvider)Items.field_151022_W).func_200302_a((ITextComponent)new TranslationTextComponent("item.lotrextended.base_gear.leggings").func_240699_a_(TextFormatting.BOLD).func_240699_a_(TextFormatting.GOLD));
    public static final ItemStack BREE_GUARD_FEET = new ItemStack((IItemProvider)Items.field_151029_X).func_200302_a((ITextComponent)new TranslationTextComponent("item.lotrextended.base_gear.boots").func_240699_a_(TextFormatting.BOLD).func_240699_a_(TextFormatting.GOLD));
    public static final ItemStack BREE_GUARD_MAINHAND = new ItemStack((IItemProvider)LOTRItems.IRON_SPEAR.get()).func_200302_a((ITextComponent)new TranslationTextComponent("item.lotrextended.base_gear.weapon").func_240699_a_(TextFormatting.BOLD).func_240699_a_(TextFormatting.GOLD));
    public static final ItemStack BREE_GUARD_OFFHAND = new ItemStack((IItemProvider)Items.field_185159_cQ).func_200302_a((ITextComponent)new TranslationTextComponent("item.lotrextended.base_gear.shield").func_240699_a_(TextFormatting.BOLD).func_240699_a_(TextFormatting.GOLD));

    public static void die(World world, DamageSource source, ExtendedHirableEntity unit) {
        if (!world.field_72995_K && world.func_82736_K().func_223586_b(GameRules.field_223609_l) && unit.getOwner() instanceof ServerPlayerEntity) {
            unit.getOwner().func_145747_a((ITextComponent)ExtendedHiredUnitHelper.getCompanionDeathMessage(unit, source), unit.getOwnerUUID());
        }
    }

    private static TranslationTextComponent getCompanionDeathMessage(ExtendedHirableEntity unit, DamageSource source) {
        LivingEntity killer = null;
        if (unit instanceof LivingEntity) {
            killer = ((LivingEntity)unit).func_94060_bK();
        }
        String s = "death.attack." + source.field_76373_n;
        TranslationTextComponent companionName = new TranslationTextComponent("chat.lotrextended.hired_companion_prefix", new Object[]{unit.getHiredUnitNameAndTitle()});
        StringTextComponent killerName = new StringTextComponent("");
        if (killer != null) {
            killerName = killer.func_145748_c_();
            if (killer instanceof ExtendedHiredBreeGuard) {
                killerName = ((ExtendedHiredBreeGuard)killer).getHiredUnitNameAndTitle();
            }
        }
        return killer != null ? new TranslationTextComponent(s, new Object[]{companionName, killerName}) : new TranslationTextComponent(s, new Object[]{companionName});
    }

    public static void giveExperiencePoints(ExtendedHirableEntity unit, float points) {
        float newExperience = unit.getCurrentXp() + points;
        if (newExperience >= unit.getMaxXp()) {
            unit.setExpLvl(unit.getExpLvl() + 1);
            float difference = newExperience - unit.getMaxXp();
            unit.setCurrentXp(difference);
            unit.setMaxXp(unit.getMaxXp() + 2.0f);
            unit.setHiredUnitHealth(unit.getHiredUnitHealth() + 2.0f);
            unit.setBaseHealth(unit.getBaseHealth() + 2);
            if (unit.getOwner() != null) {
                unit.getOwner().func_145747_a((ITextComponent)new TranslationTextComponent("chat.lotrextended.hired_companion_levelup", new Object[]{unit.getHiredUnitNameAndTitle(), unit.getExpLvl()}), unit.getOwnerUUID());
            }
        } else {
            unit.setCurrentXp(newExperience);
        }
    }

    public static boolean isEntityHiredUnit(Entity entity) {
        return entity instanceof ExtendedHiredBreeGuard;
    }

    public static ExtendedHirableEntity getExtendedHirableEntity(Entity entity) {
        if (!ExtendedHiredUnitHelper.isEntityHiredUnit(entity)) {
            return null;
        }
        if (entity instanceof ExtendedHirableEntity) {
            return (ExtendedHirableEntity)entity;
        }
        return null;
    }

    public static boolean updateEquipmentSlot(NPCEntity companion, EquipmentSlotType slot, ItemStack item) {
        boolean result = false;
        if (companion instanceof ExtendedHirableEntity) {
            ExtendedHirableEntity hirable = (ExtendedHirableEntity)companion;
            if (slot == EquipmentSlotType.FEET) {
                hirable.updateFeetSlot(item);
                result = true;
            } else if (slot == EquipmentSlotType.HEAD) {
                hirable.updateHeadSlot(item);
                result = true;
            } else if (slot == EquipmentSlotType.CHEST) {
                hirable.updateChestSlot(item);
                result = true;
            } else if (slot == EquipmentSlotType.LEGS) {
                hirable.updateLegsSlot(item);
                result = true;
            } else if (slot == EquipmentSlotType.MAINHAND) {
                hirable.updateMainhandSlot(item);
                result = true;
            } else if (slot == EquipmentSlotType.OFFHAND) {
                hirable.updateOffhandSlot(item);
                result = true;
            }
        }
        return result;
    }

    public static ItemStack[] getBaseGear(Entity entity) {
        ItemStack[] baseGear = new ItemStack[6];
        if (entity instanceof ExtendedHiredBreeGuard) {
            baseGear[0] = BREE_GUARD_HEAD;
            baseGear[1] = BREE_GUARD_CHEST;
            baseGear[2] = BREE_GUARD_LEGS;
            baseGear[3] = BREE_GUARD_FEET;
            baseGear[4] = BREE_GUARD_MAINHAND;
            baseGear[5] = BREE_GUARD_OFFHAND;
        } else {
            baseGear[0] = ItemStack.field_190927_a;
            baseGear[1] = ItemStack.field_190927_a;
            baseGear[2] = ItemStack.field_190927_a;
            baseGear[3] = ItemStack.field_190927_a;
            baseGear[4] = ItemStack.field_190927_a;
            baseGear[5] = ItemStack.field_190927_a;
        }
        return baseGear;
    }
}

