/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.util;

import com.github.maximuslotro.lotrrextended.ExtendedLog;
import com.github.maximuslotro.lotrrextended.common.init.ExtendedSounds;
import com.github.maximuslotro.lotrrextended.common.network.ExtendedCPacketOpenCoinExchange;
import com.github.maximuslotro.lotrrextended.common.network.ExtendedCPacketOpenTradeMenu;
import com.github.maximuslotro.lotrrextended.common.network.ExtendedPacketHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import lotr.common.entity.npc.ExtendedTraderEntity;
import lotr.common.entity.npc.NPCEntity;
import lotr.common.item.LOTRSpawnEggItem;
import lotr.common.util.client.ExtendedClientsideSeperatedScreenHandler;
import lotr.common.util.representation.ExtendedTrade;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class ExtendedTraderHelper {
    private ExtendedTraderHelper() {
    }

    public static void playTraderSound(World level, BlockPos pos) {
        level.func_184133_a(null, pos, (SoundEvent)ExtendedSounds.TRADE.get(), SoundCategory.PLAYERS, 1.0f, 1.0f);
    }

    public static ActionResultType openCoinExchange(NPCEntity entity, PlayerEntity player, ExtendedTraderEntity trader) {
        ExtendedPacketHandler.sendToServer(new ExtendedCPacketOpenCoinExchange(entity.func_145782_y()));
        trader.updatePlayerInteractingWith(player.func_110124_au());
        return ActionResultType.func_233537_a_((boolean)entity.field_70170_p.func_201670_d());
    }

    public static ActionResultType openTradeMenu(NPCEntity entity, PlayerEntity player, ExtendedTraderEntity trader) {
        ExtendedPacketHandler.sendToServer(new ExtendedCPacketOpenTradeMenu(entity.func_145782_y()));
        trader.updatePlayerInteractingWith(player.func_110124_au());
        return ActionResultType.func_233537_a_((boolean)entity.field_70170_p.func_201670_d());
    }

    public static ActionResultType openTraderGui(NPCEntity entity, PlayerEntity player, ExtendedTraderEntity trader) {
        if (trader.getPlayerInteractingWith().isPresent()) {
            if (!entity.field_70170_p.field_72995_K) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("gui.lotrextended.trading.trader_busy"), Util.field_240973_b_);
            }
            return ActionResultType.func_233537_a_((boolean)entity.field_70170_p.func_201670_d());
        }
        trader.updatePlayerInteractingWith(player.func_110124_au());
        if (entity.field_70170_p.func_201670_d()) {
            ExtendedClientsideSeperatedScreenHandler.openTraderGui(entity, player);
        }
        return ActionResultType.func_233537_a_((boolean)entity.field_70170_p.func_201670_d());
    }

    public static String getTraderName(ITextComponent displayName) {
        String result = displayName.getString();
        if (result.split(",").length > 0) {
            return result.split(",")[0];
        }
        return result;
    }

    public static int[] getBoughtPrices(ArrayList<ExtendedTrade> bought) {
        int[] boughtItems = new int[bought.size()];
        for (int i = 0; i < bought.size(); ++i) {
            boughtItems[i] = bought.get(i).getAmount();
        }
        return boughtItems;
    }

    public static int[] getSoldPrices(ArrayList<ExtendedTrade> sold) {
        int[] soldPrices = new int[sold.size()];
        for (int i = 0; i < sold.size(); ++i) {
            soldPrices[i] = sold.get(i).getAmount();
        }
        return soldPrices;
    }

    public static int[] getSoldQuantity(ArrayList<ExtendedTrade> sold) {
        int[] soldQuantity = new int[sold.size()];
        for (int i = 0; i < sold.size(); ++i) {
            soldQuantity[i] = sold.get(i).getQuantityLeft();
        }
        return soldQuantity;
    }

    public static int[] getBoughtQuantity(ArrayList<ExtendedTrade> bought) {
        int[] boughtQuantity = new int[bought.size()];
        for (int i = 0; i < bought.size(); ++i) {
            boughtQuantity[i] = bought.get(i).getQuantityLeft();
        }
        return boughtQuantity;
    }

    public static int[] getSoldOriginalQuantity(ArrayList<ExtendedTrade> sold) {
        int[] soldOriginalQuantity = new int[sold.size()];
        for (int i = 0; i < sold.size(); ++i) {
            soldOriginalQuantity[i] = sold.get(i).getOriginalQuantity();
        }
        return soldOriginalQuantity;
    }

    public static int[] getBoughtOriginalQuantity(ArrayList<ExtendedTrade> bought) {
        int[] boughtOriginalQuantity = new int[bought.size()];
        for (int i = 0; i < bought.size(); ++i) {
            boughtOriginalQuantity[i] = bought.get(i).getOriginalQuantity();
        }
        return boughtOriginalQuantity;
    }

    public static ActionResultType mobInteract(NPCEntity npc, ExtendedTraderEntity trader, PlayerEntity player, Hand hand) {
        if (player.func_184586_b(hand).func_77973_b() instanceof SpawnEggItem || player.func_184586_b(hand).func_77973_b() instanceof LOTRSpawnEggItem) {
            return ActionResultType.SUCCESS;
        }
        return ExtendedTraderHelper.openTraderGui(npc, player, trader);
    }

    public static void tickTrader(NPCEntity npc, ExtendedTraderEntity trader) {
        block4: {
            block5: {
                if (!trader.isWanderingTrader()) break block4;
                if (trader.getWanderingTraderTicksLeft() >= 1) break block5;
                for (PlayerEntity player : npc.field_70170_p.func_217369_A()) {
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("chat.wandering_trader.left_the_area", new Object[]{npc.func_200200_C_().func_230532_e_().func_240699_a_(TextFormatting.YELLOW)}), Util.field_240973_b_);
                }
                npc.func_70106_y();
                if (trader.getEscortUUIDs() == null || trader.getEscortUUIDs().isEmpty()) break block4;
                AxisAlignedBB initial = new AxisAlignedBB(npc.func_226277_ct_(), npc.func_226278_cu_(), npc.func_226281_cx_(), npc.func_226277_ct_() + 1.0, npc.func_226278_cu_() + 1.0, npc.func_226281_cx_() + 1.0);
                List potentialEscorts = npc.field_70170_p.func_217357_a(NPCEntity.class, initial.func_186662_g(256.0));
                for (NPCEntity entity : potentialEscorts) {
                    if (!trader.getEscortUUIDs().contains(entity.func_110124_au())) continue;
                    entity.func_70106_y();
                }
                break block4;
            }
            trader.setWanderingTraderTicksLeft(trader.getWanderingTraderTicksLeft() - 1);
            if (trader.getWanderingTraderTicksLeft() == 2400) {
                AxisAlignedBB initial = new AxisAlignedBB(npc.func_226277_ct_(), npc.func_226278_cu_(), npc.func_226281_cx_(), npc.func_226277_ct_() + 1.0, npc.func_226278_cu_() + 1.0, npc.func_226281_cx_() + 1.0);
                List playersInRange = npc.field_70170_p.func_217357_a(PlayerEntity.class, initial.func_186662_g(80.0));
                for (PlayerEntity player : playersInRange) {
                    player.func_145747_a((ITextComponent)trader.getDepartureLine(player), Util.field_240973_b_);
                }
            }
        }
    }

    public static void saveWanderingTraderData(ExtendedTraderEntity trader, List<UUID> escorts, CompoundNBT tag) {
        tag.func_74768_a("wanderingTraderTimeLeft", trader.getWanderingTraderTicksLeft());
        tag.func_74757_a("isWanderingTrader", trader.isWanderingTrader());
        ListNBT listnbt = new ListNBT();
        for (UUID escort : escorts) {
            CompoundNBT compoundnbt = new CompoundNBT();
            compoundnbt.func_74778_a("UUID", escort.toString());
            listnbt.add((Object)compoundnbt);
        }
        tag.func_218657_a("escorts", (INBT)listnbt);
    }

    public static List<UUID> loadEscortUUIDs(CompoundNBT tag) {
        ListNBT listnbt = tag.func_150295_c("escorts", 10);
        if (listnbt.isEmpty()) {
            return new ArrayList<UUID>();
        }
        ArrayList<UUID> result = new ArrayList<UUID>();
        for (int i = 0; i < listnbt.size(); ++i) {
            CompoundNBT compoundnbt = listnbt.func_150305_b(i);
            String strUUID = compoundnbt.func_74779_i("UUID");
            UUID uuid = null;
            try {
                uuid = UUID.fromString(strUUID);
            }
            catch (Exception ex) {
                ExtendedLog.error(strUUID + " could not be parsed as a UUID - ignoring");
                continue;
            }
            result.add(uuid);
        }
        return result;
    }
}

