/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.util;

import java.util.ArrayList;
import java.util.List;
import lotr.common.util.representation.ExtendedTrade;
import lotr.common.util.representation.ExtendedTradeEntries;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;

public class TradeUtils {
    private TradeUtils() {
    }

    public static ArrayList<ExtendedTrade> loadAllTrades(ExtendedTradeEntries.TradeType type, CompoundNBT tag) {
        ListNBT listnbt = tag.func_150295_c(type.name(), 10);
        if (listnbt.isEmpty()) {
            return null;
        }
        ArrayList<ExtendedTrade> result = new ArrayList<ExtendedTrade>();
        for (int i = 0; i < listnbt.size(); ++i) {
            CompoundNBT compoundnbt = listnbt.func_150305_b(i);
            ItemStack item = ItemStack.func_199557_a((CompoundNBT)compoundnbt.func_74775_l("item"));
            int quantity = compoundnbt.func_74762_e("quantityLeft");
            int amount = compoundnbt.func_74762_e("amount");
            int originalQuantity = compoundnbt.func_74762_e("startingQuantity");
            if (originalQuantity == 0) {
                originalQuantity = 100;
            }
            ExtendedTrade trade = new ExtendedTrade(item, amount, quantity, originalQuantity);
            result.add(trade);
        }
        return result;
    }

    public static void saveAllTrades(ExtendedTradeEntries.TradeType type, List<ExtendedTrade> trades, CompoundNBT tag) {
        ListNBT listnbt = new ListNBT();
        for (ExtendedTrade trade : trades) {
            CompoundNBT compoundnbt = new CompoundNBT();
            compoundnbt = trade.save(compoundnbt);
            listnbt.add((Object)compoundnbt);
        }
        tag.func_218657_a(type.name(), (INBT)listnbt);
    }

    public static Inventory generateDisplayInventory(List<ExtendedTrade> buys, List<ExtendedTrade> sells) {
        ExtendedTrade trade;
        int i;
        Inventory result = new Inventory(18);
        int max = buys.size();
        if (buys.size() > 9) {
            max = 9;
        }
        for (i = 0; i < max; ++i) {
            trade = buys.get(i);
            result.func_70299_a(i, trade.getItem());
        }
        max = sells.size();
        if (sells.size() > 9) {
            max = 9;
        }
        for (i = 0; i < max; ++i) {
            trade = sells.get(i);
            result.func_70299_a(i + 9, trade.getItem());
        }
        return result;
    }

    public static boolean isValidSellItem(ItemStack stack, List<ExtendedTrade> itemsBought) {
        for (ExtendedTrade trade : itemsBought) {
            ItemStack itemBought = trade.getItem();
            if (!itemBought.func_77973_b().equals(stack.func_77973_b())) continue;
            return true;
        }
        return false;
    }
}

