/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.util.representation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import lotr.common.util.representation.ExtendedMultitradeEntry;
import lotr.common.util.representation.ExtendedTrade;
import lotr.common.util.representation.ExtendedTradeEntry;

public class ExtendedTradeEntries {
    private final TradeType tradeType;
    private final ExtendedTradeEntry[] entries;

    public ExtendedTradeEntries(TradeType tradeType, ExtendedTradeEntry[] entries) {
        this.tradeType = tradeType;
        this.entries = entries;
    }

    public TradeType getTradeType() {
        return this.tradeType;
    }

    public ExtendedTradeEntry[] getEntries() {
        return this.entries;
    }

    public ArrayList<ExtendedTrade> generateTrades() {
        Random random = new Random();
        ArrayList<ExtendedTrade> trades = new ArrayList<ExtendedTrade>();
        int tradeCount = random.nextInt(6) + 4;
        if (tradeCount > this.entries.length) {
            tradeCount = this.entries.length;
        }
        List<ExtendedTradeEntry> randomElements = random.ints(0, this.entries.length).distinct().limit(tradeCount).mapToObj(Arrays.asList(this.entries)::get).collect(Collectors.toList());
        randomElements.forEach(entry -> {
            int difference;
            if (entry instanceof ExtendedMultitradeEntry) {
                entry = ((ExtendedMultitradeEntry)entry).pickRandom();
            }
            int amount = (difference = entry.getMax() - entry.getMin()) <= 0 ? entry.getMin() : new Random().nextInt(entry.getMax() - entry.getMin()) + entry.getMin();
            trades.add(new ExtendedTrade(entry.getItem(), amount, entry.getQuantity(), entry.getQuantity()));
        });
        return trades;
    }

    public static enum TradeType {
        BOUGHT,
        SOLD;

    }
}

