/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.biome;

import com.github.maximuslotro.lotrrextended.common.block.ExtendedBerryBushBlock;
import com.github.maximuslotro.lotrrextended.common.world.gen.blockstateprovider.ExtendedListTypedBlockStateProvider;
import com.github.maximuslotro.lotrrextended.common.world.gen.feature.ExtendedFeature;
import com.github.maximuslotro.lotrrextended.common.world.gen.feature.ExtendedFeatures;
import com.github.maximuslotro.lotrrextended.common.world.gen.feature.ExtendedHoleySphereConfig;
import com.github.maximuslotro.lotrrextended.common.world.gen.feature.ExtendedHolyUnderwaterSphereFeature;
import com.github.maximuslotro.lotrrextended.common.world.gen.tree.BananaFoliagePlacer;
import com.github.maximuslotro.lotrrextended.common.world.gen.tree.ExtendedFoilagePlacers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import lotr.common.init.ExtendedBlocks;
import lotr.common.world.gen.tree.ClusterFoliagePlacer;
import lotr.common.world.gen.tree.PartyTrunkPlacer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.Property;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.blockplacer.BlockPlacer;
import net.minecraft.world.gen.blockplacer.SimpleBlockPlacer;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.WeightedBlockStateProvider;
import net.minecraft.world.gen.feature.AbstractFeatureSizeType;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.FeatureSpread;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.TwoLayerFeature;
import net.minecraft.world.gen.feature.template.RuleTest;
import net.minecraft.world.gen.foliageplacer.BlobFoliagePlacer;
import net.minecraft.world.gen.foliageplacer.FancyFoliagePlacer;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.placement.ConfiguredPlacement;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.treedecorator.BeehiveTreeDecorator;
import net.minecraft.world.gen.treedecorator.LeaveVineTreeDecorator;
import net.minecraft.world.gen.treedecorator.TreeDecorator;
import net.minecraft.world.gen.treedecorator.TrunkVineTreeDecorator;
import net.minecraft.world.gen.trunkplacer.AbstractTrunkPlacer;
import net.minecraft.world.gen.trunkplacer.FancyTrunkPlacer;
import net.minecraft.world.gen.trunkplacer.StraightTrunkPlacer;
import net.minecraftforge.event.RegistryEvent;

public class ExtendedBiomeFeatures {
    private static boolean created = false;
    private static BlockState CHESTNUT_LOG;
    private static BlockState CHESTNUT_WOOD;
    private static BlockState CHESTNUT_BRANCH;
    private static BlockState CHESTNUT_LEAVES;
    private static BlockState CHESTNUT_LEAVES_FRUIT;
    private static BlockState BANANA_LOG;
    private static BlockState BANANA_LEAVES;
    public static BlockState BANANA_FRUIT;
    private static BlockState PLUM_LOG;
    private static BlockState PLUM_WOOD;
    private static BlockState PLUM_BRANCH;
    private static BlockState PLUM_LEAVES;
    private static BlockState PLUM_LEAVES_FRUIT;
    private static BlockState AMETHYST_ORE;
    private static BlockState TOPAZ_ORE;
    private static BlockState AMBER_ORE;
    private static BlockState OPAL_ORE;
    private static BlockState SAPPHIRE_ORE;
    private static BlockState RUBY_ORE;
    private static BlockState EMERALD_ORE;
    private static BlockState DIAMOND_ORE;
    private static BlockState REMAINS_ORC;
    private static BlockState REMAINS_ELF;
    private static BlockState REMAINS_MAN;
    private static BlockState REMAINS_DWARF;
    private static BlockState BLACKBERRYBUSH;
    private static BlockState BLUEBERRYBUSH;
    private static BlockState CRANBERRYBUSH;
    private static BlockState ELDERBERRYBUSH;
    private static BlockState RASPBERRYBUSH;
    private static BlockState WILDBERRYBUSH;
    private static BlockClusterFeatureConfig BUSH_PATCH_CONFIG;
    private static BlockStateProvider CHESTNUT_LEAVES_POOL;
    private static BaseTreeFeatureConfig CHESTNUT_TREE;
    private static BaseTreeFeatureConfig CHESTNUT_TREE_FANCY;
    private static BaseTreeFeatureConfig CHESTNUT_TREE_BEES;
    private static BaseTreeFeatureConfig CHESTNUT_TREE_FANCY_BEES;
    private static BaseTreeFeatureConfig CHESTNUT_PARTY;
    private static BlockStateProvider BANANA_LEAVES_POOL;
    private static BaseTreeFeatureConfig BANANA_TREE;
    private static BlockStateProvider PLUM_LEAVES_POOL;
    private static BaseTreeFeatureConfig PLUM_TREE;
    private static BaseTreeFeatureConfig PLUM_TREE_FANCY;
    private static BaseTreeFeatureConfig PLUM_TREE_BEES;
    private static BaseTreeFeatureConfig PLUM_TREE_FANCY_BEES;
    private static BaseTreeFeatureConfig PLUM_PARTY;

    public static ConfiguredFeature<BaseTreeFeatureConfig, ?> chestnut() {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)CHESTNUT_TREE);
    }

    public static ConfiguredFeature<BaseTreeFeatureConfig, ?> chestnutFancy() {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)CHESTNUT_TREE_FANCY);
    }

    public static ConfiguredFeature<BaseTreeFeatureConfig, ?> chestnutBees() {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)CHESTNUT_TREE_BEES);
    }

    public static ConfiguredFeature<BaseTreeFeatureConfig, ?> chestnutFancyBees() {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)CHESTNUT_TREE_FANCY_BEES);
    }

    public static ConfiguredFeature<BaseTreeFeatureConfig, ?> chestnutParty() {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)CHESTNUT_PARTY);
    }

    public static ConfiguredFeature<BaseTreeFeatureConfig, ?> banana() {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)BANANA_TREE);
    }

    public static ConfiguredFeature<BaseTreeFeatureConfig, ?> plum() {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)PLUM_TREE);
    }

    public static ConfiguredFeature<BaseTreeFeatureConfig, ?> plumFancy() {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)PLUM_TREE_FANCY);
    }

    public static ConfiguredFeature<BaseTreeFeatureConfig, ?> plumBees() {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)PLUM_TREE_BEES);
    }

    public static ConfiguredFeature<BaseTreeFeatureConfig, ?> plumFancyBees() {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)PLUM_TREE_FANCY_BEES);
    }

    public static ConfiguredFeature<BaseTreeFeatureConfig, ?> plumParty() {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)PLUM_PARTY);
    }

    public static void setup(RegistryEvent.Register<Block> event) {
        CHESTNUT_LOG = ((Block)ExtendedBlocks.CHESTNUT_LOG.get()).func_176223_P();
        CHESTNUT_WOOD = ((Block)ExtendedBlocks.CHESTNUT_WOOD.get()).func_176223_P();
        CHESTNUT_BRANCH = ((Block)ExtendedBlocks.CHESTNUT_BRANCH.get()).func_176223_P();
        CHESTNUT_LEAVES = ((Block)ExtendedBlocks.CHESTNUT_LEAVES.get()).func_176223_P();
        CHESTNUT_LEAVES_FRUIT = ((Block)ExtendedBlocks.CHESTNUT_LEAVES_FRUIT.get()).func_176223_P();
        BANANA_LOG = ((Block)ExtendedBlocks.BANANA_LOG.get()).func_176223_P();
        BANANA_LEAVES = ((Block)ExtendedBlocks.BANANA_LEAVES.get()).func_176223_P();
        BANANA_FRUIT = ((Block)ExtendedBlocks.HANGING_BANANA.get()).func_176223_P();
        PLUM_LOG = ((Block)ExtendedBlocks.PLUM_LOG.get()).func_176223_P();
        PLUM_WOOD = ((Block)ExtendedBlocks.PLUM_WOOD.get()).func_176223_P();
        PLUM_BRANCH = ((Block)ExtendedBlocks.PLUM_BRANCH.get()).func_176223_P();
        PLUM_LEAVES = ((Block)ExtendedBlocks.PLUM_LEAVES.get()).func_176223_P();
        PLUM_LEAVES_FRUIT = ((Block)ExtendedBlocks.PLUM_LEAVES_FRUIT.get()).func_176223_P();
        AMETHYST_ORE = ((Block)ExtendedBlocks.AMETHYST_ORE.get()).func_176223_P();
        TOPAZ_ORE = ((Block)ExtendedBlocks.TOPAZ_ORE.get()).func_176223_P();
        AMBER_ORE = ((Block)ExtendedBlocks.AMBER_ORE.get()).func_176223_P();
        OPAL_ORE = ((Block)ExtendedBlocks.OPAL_ORE.get()).func_176223_P();
        SAPPHIRE_ORE = ((Block)ExtendedBlocks.SAPPHIRE_ORE.get()).func_176223_P();
        RUBY_ORE = ((Block)ExtendedBlocks.RUBY_ORE.get()).func_176223_P();
        EMERALD_ORE = ((Block)ExtendedBlocks.EMERALD_ORE.get()).func_176223_P();
        DIAMOND_ORE = ((Block)ExtendedBlocks.DIAMOND_ORE.get()).func_176223_P();
        REMAINS_ORC = ((Block)ExtendedBlocks.REMAINS_ORC.get()).func_176223_P();
        REMAINS_ELF = ((Block)ExtendedBlocks.REMAINS_ELF.get()).func_176223_P();
        REMAINS_MAN = ((Block)ExtendedBlocks.REMAINS_MAN.get()).func_176223_P();
        REMAINS_DWARF = ((Block)ExtendedBlocks.REMAINS_DWARF.get()).func_176223_P();
        if (!created) {
            created = true;
            ExtendedFoilagePlacers.registerLeafBuilders();
        }
        CHESTNUT_LEAVES_POOL = new WeightedBlockStateProvider().func_227407_a_(CHESTNUT_LEAVES, 28).func_227407_a_(CHESTNUT_LEAVES_FRUIT, 3);
        CHESTNUT_TREE = ExtendedBiomeFeatures.buildClassicTree(CHESTNUT_LOG, CHESTNUT_LEAVES_POOL, 4, 3);
        CHESTNUT_TREE_BEES = ExtendedBiomeFeatures.buildClassicTreeWithBees(CHESTNUT_LOG, CHESTNUT_LEAVES_POOL, 4, 3);
        CHESTNUT_TREE_FANCY = ExtendedBiomeFeatures.buildFancyTree(CHESTNUT_LOG, CHESTNUT_LEAVES_POOL);
        CHESTNUT_TREE_FANCY_BEES = ExtendedBiomeFeatures.buildFancyTreeWithBees(CHESTNUT_LOG, CHESTNUT_LEAVES_POOL);
        CHESTNUT_PARTY = ExtendedBiomeFeatures.buildNormalPartyTree(CHESTNUT_LOG, CHESTNUT_WOOD, CHESTNUT_BRANCH, CHESTNUT_LEAVES_POOL);
        BANANA_LEAVES_POOL = new SimpleBlockStateProvider(BANANA_LEAVES);
        BANANA_TREE = ExtendedBiomeFeatures.buildTreeWithSpecifiedFoliageGivenTrunk(BANANA_LOG, BANANA_LEAVES_POOL, 4, 2, new BananaFoliagePlacer(FeatureSpread.func_242252_a((int)3), FeatureSpread.func_242252_a((int)0), FeatureSpread.func_242253_a((int)2, (int)2)), false, false);
        PLUM_LEAVES_POOL = new WeightedBlockStateProvider().func_227407_a_(PLUM_LEAVES, 28).func_227407_a_(PLUM_LEAVES_FRUIT, 4);
        PLUM_TREE = ExtendedBiomeFeatures.buildClassicTree(PLUM_LOG, PLUM_LEAVES_POOL, 4, 3);
        PLUM_TREE_BEES = ExtendedBiomeFeatures.buildClassicTreeWithBees(PLUM_LOG, PLUM_LEAVES_POOL, 4, 3);
        PLUM_TREE_FANCY = ExtendedBiomeFeatures.buildFancyTree(PLUM_LOG, PLUM_LEAVES_POOL);
        PLUM_TREE_FANCY_BEES = ExtendedBiomeFeatures.buildFancyTreeWithBees(PLUM_LOG, PLUM_LEAVES_POOL);
        PLUM_PARTY = ExtendedBiomeFeatures.buildNormalPartyTree(PLUM_LOG, PLUM_WOOD, PLUM_BRANCH, PLUM_LEAVES_POOL);
        BLACKBERRYBUSH = (BlockState)((Block)ExtendedBlocks.BLACKBERRY_BUSH_PLANT.get()).func_176223_P().func_206870_a((Property)ExtendedBerryBushBlock.AGE, (Comparable)Integer.valueOf(3));
        BLUEBERRYBUSH = (BlockState)((Block)ExtendedBlocks.BLUEBERRY_BUSH_PLANT.get()).func_176223_P().func_206870_a((Property)ExtendedBerryBushBlock.AGE, (Comparable)Integer.valueOf(3));
        CRANBERRYBUSH = (BlockState)((Block)ExtendedBlocks.CRANBERRY_BUSH_PLANT.get()).func_176223_P().func_206870_a((Property)ExtendedBerryBushBlock.AGE, (Comparable)Integer.valueOf(3));
        ELDERBERRYBUSH = (BlockState)((Block)ExtendedBlocks.ELDERBERRY_BUSH_PLANT.get()).func_176223_P().func_206870_a((Property)ExtendedBerryBushBlock.AGE, (Comparable)Integer.valueOf(3));
        RASPBERRYBUSH = (BlockState)((Block)ExtendedBlocks.RASPBERRY_BUSH_PLANT.get()).func_176223_P().func_206870_a((Property)ExtendedBerryBushBlock.AGE, (Comparable)Integer.valueOf(3));
        WILDBERRYBUSH = (BlockState)((Block)ExtendedBlocks.WILDBERRY_BUSH_PLANT.get()).func_176223_P().func_206870_a((Property)ExtendedBerryBushBlock.AGE, (Comparable)Integer.valueOf(3));
        BUSH_PATCH_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new ExtendedListTypedBlockStateProvider(BLACKBERRYBUSH).addBlock(BLUEBERRYBUSH).addBlock(CRANBERRYBUSH).addBlock(ELDERBERRYBUSH).addBlock(RASPBERRYBUSH).addBlock(WILDBERRYBUSH), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(15).func_227316_a_((Set)ImmutableSet.of((Object)Blocks.field_196658_i.getBlock())).func_227317_b_().func_227322_d_();
    }

    public static void addBushes(BiomeGenerationSettings.Builder builder, int chance) {
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)BUSH_PATCH_CONFIG).func_227228_a_(ExtendedBiomeFeatures.placeHeightmapDoubleChance(chance)));
    }

    public static void addMoss(BiomeGenerationSettings.Builder builder, int freq) {
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ExtendedFeatures.MOSS_PATCH.func_227228_a_(ExtendedBiomeFeatures.placeHeightmapDoubleFreq(freq)));
    }

    public static void addOres(BiomeGenerationSettings.Builder builder) {
        builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig((RuleTest)OreFeatureConfig.FillerBlockType.field_241882_a, (BlockState)ExtendedBiomeFeatures.AMETHYST_ORE, (int)6)).func_242733_d((int)64)).func_242728_a()).func_227227_a_((float)2.0f).field_214842_a.get());
        builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig((RuleTest)OreFeatureConfig.FillerBlockType.field_241882_a, (BlockState)ExtendedBiomeFeatures.TOPAZ_ORE, (int)6)).func_242733_d((int)64)).func_242728_a()).func_227227_a_((float)2.0f).field_214842_a.get());
        builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig((RuleTest)OreFeatureConfig.FillerBlockType.field_241882_a, (BlockState)ExtendedBiomeFeatures.AMBER_ORE, (int)5)).func_242733_d((int)48)).func_242728_a()).func_227227_a_((float)1.5f).field_214842_a.get());
        builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig((RuleTest)OreFeatureConfig.FillerBlockType.field_241882_a, (BlockState)ExtendedBiomeFeatures.OPAL_ORE, (int)5)).func_242733_d((int)48)).func_242728_a()).func_227227_a_((float)1.5f).field_214842_a.get());
        builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig((RuleTest)OreFeatureConfig.FillerBlockType.field_241882_a, (BlockState)ExtendedBiomeFeatures.SAPPHIRE_ORE, (int)4)).func_242733_d((int)32)).func_242728_a()).func_227227_a_((float)1.0f).field_214842_a.get());
        builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig((RuleTest)OreFeatureConfig.FillerBlockType.field_241882_a, (BlockState)ExtendedBiomeFeatures.RUBY_ORE, (int)4)).func_242733_d((int)32)).func_242728_a()).func_227227_a_((float)1.0f).field_214842_a.get());
        builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig((RuleTest)OreFeatureConfig.FillerBlockType.field_241882_a, (BlockState)ExtendedBiomeFeatures.EMERALD_ORE, (int)4)).func_242733_d((int)24)).func_242728_a()).func_227227_a_((float)0.75f).field_214842_a.get());
        builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig((RuleTest)OreFeatureConfig.FillerBlockType.field_241882_a, (BlockState)ExtendedBiomeFeatures.DIAMOND_ORE, (int)4)).func_242733_d((int)16)).func_242728_a()).func_227227_a_((float)0.5f).field_214842_a.get());
    }

    public static void addRemains(BiomeGenerationSettings.Builder builder) {
        List<BlockState> remainsTypes = Arrays.asList(REMAINS_ORC, REMAINS_ELF, REMAINS_MAN, REMAINS_DWARF);
        builder.func_242513_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, (ConfiguredFeature)((ExtendedHolyUnderwaterSphereFeature)ExtendedFeature.HOLEY_UNDERWATER_SPHERE.get()).func_225566_b_((IFeatureConfig)new ExtendedHoleySphereConfig(remainsTypes, (FeatureSpread)FeatureSpread.func_242253_a((int)2, (int)3), (int)4, (List<BlockState>)ImmutableList.of((Object)Blocks.field_150346_d.func_176223_P()), (int)20)).func_227228_a_((ConfiguredPlacement)Features.Placements.field_244003_n).func_227227_a_((float)5.0f).field_214842_a.get());
    }

    private static BaseTreeFeatureConfig buildClassicTree(BlockState log, BlockStateProvider leavesPool, int baseHeight, int heightRandA) {
        return ExtendedBiomeFeatures.buildClassicTree(log, leavesPool, baseHeight, heightRandA, false, false);
    }

    private static BaseTreeFeatureConfig buildClassicTree(BlockState log, BlockStateProvider leavesPool, int baseHeight, int heightRandA, boolean bees, boolean vines) {
        return ExtendedBiomeFeatures.buildTreeWithSpecifiedFoliageGivenTrunk(log, leavesPool, baseHeight, heightRandA, (FoliagePlacer)new BlobFoliagePlacer(FeatureSpread.func_242252_a((int)2), FeatureSpread.func_242252_a((int)0), 3), bees, vines);
    }

    private static BaseTreeFeatureConfig buildClassicTreeWithBees(BlockState log, BlockStateProvider leavesPool, int baseHeight, int heightRandA) {
        return ExtendedBiomeFeatures.buildClassicTree(log, leavesPool, baseHeight, heightRandA, true, false);
    }

    private static BaseTreeFeatureConfig buildTreeWithSpecifiedFoliageGivenTrunk(BlockState log, BlockStateProvider leavesPool, int baseHeight, int heightRandA, FoliagePlacer foliage, boolean bees, boolean vines) {
        ArrayList<Object> decorators = new ArrayList<Object>();
        if (bees) {
            decorators.add(Features.Placements.field_243992_c);
        }
        if (vines) {
            decorators.add(TrunkVineTreeDecorator.field_236879_b_);
            decorators.add(LeaveVineTreeDecorator.field_236871_b_);
        }
        return new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(log), leavesPool, foliage, (AbstractTrunkPlacer)new StraightTrunkPlacer(baseHeight, heightRandA, 0), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 1)).func_236700_a_().func_236703_a_((List)ImmutableList.copyOf(decorators)).func_225568_b_();
    }

    private static BaseTreeFeatureConfig buildFancyTree(BlockState log, BlockStateProvider leavesPool) {
        return ExtendedBiomeFeatures.buildFancyTree(log, leavesPool, false);
    }

    private static BaseTreeFeatureConfig buildFancyTreeWithBees(BlockState log, BlockStateProvider leavesPool) {
        return ExtendedBiomeFeatures.buildFancyTree(log, leavesPool, true);
    }

    private static BaseTreeFeatureConfig buildFancyTree(BlockState log, BlockStateProvider leavesPool, boolean bees) {
        ArrayList<BeehiveTreeDecorator> decorators = new ArrayList<BeehiveTreeDecorator>();
        if (bees) {
            decorators.add(Features.Placements.field_243992_c);
        }
        return new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(log), leavesPool, (FoliagePlacer)new FancyFoliagePlacer(FeatureSpread.func_242252_a((int)2), FeatureSpread.func_242252_a((int)4), 4), (AbstractTrunkPlacer)new FancyTrunkPlacer(3, 11, 0), (AbstractFeatureSizeType)new TwoLayerFeature(0, 0, 0, OptionalInt.of(4))).func_236700_a_().func_236702_a_(Heightmap.Type.MOTION_BLOCKING).func_236703_a_((List)ImmutableList.copyOf(decorators)).func_225568_b_();
    }

    private static BaseTreeFeatureConfig buildNormalFoliagePartyTree(BlockState log, BlockState wood, BlockState branch, BlockStateProvider leavesPool, int baseHeight, int heightRandA) {
        return ExtendedBiomeFeatures.buildPartyTree(log, wood, branch, leavesPool, baseHeight, heightRandA, (FoliagePlacer)new ClusterFoliagePlacer(FeatureSpread.func_242252_a((int)2), FeatureSpread.func_242252_a((int)0)), (List<TreeDecorator>)ImmutableList.of());
    }

    private static BaseTreeFeatureConfig buildNormalHeightPartyTree(BlockState log, BlockState wood, BlockState branch, BlockStateProvider leavesPool, FoliagePlacer foliage) {
        return ExtendedBiomeFeatures.buildPartyTree(log, wood, branch, leavesPool, 10, 14, foliage, (List<TreeDecorator>)ImmutableList.of());
    }

    private static BaseTreeFeatureConfig buildNormalPartyTree(BlockState log, BlockState wood, BlockState branch, BlockStateProvider leavesPool) {
        return ExtendedBiomeFeatures.buildNormalFoliagePartyTree(log, wood, branch, leavesPool, 10, 14);
    }

    private static BaseTreeFeatureConfig buildPartyTree(BlockState log, BlockState wood, BlockState branch, BlockStateProvider leavesPool, int baseHeight, int heightRandA, FoliagePlacer foliage) {
        return ExtendedBiomeFeatures.buildPartyTree(log, wood, branch, leavesPool, baseHeight, heightRandA, foliage, (List<TreeDecorator>)ImmutableList.of());
    }

    private static BaseTreeFeatureConfig buildPartyTree(BlockState log, BlockState wood, BlockState branch, BlockStateProvider leavesPool, int baseHeight, int heightRandA, FoliagePlacer foliage, List<TreeDecorator> decorators) {
        return new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(log), leavesPool, foliage, (AbstractTrunkPlacer)new PartyTrunkPlacer(baseHeight, heightRandA, 0, wood, branch), (AbstractFeatureSizeType)new TwoLayerFeature(1, 1, 2)).func_236700_a_().func_236703_a_((List)ImmutableList.copyOf(decorators)).func_225568_b_();
    }

    private static ConfiguredPlacement<?> placeHeightmapDoubleChance(int chance) {
        return (ConfiguredPlacement)((ConfiguredPlacement)Placement.field_242905_i.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e).func_242728_a()).func_242729_a(chance);
    }

    private static ConfiguredPlacement<?> placeHeightmapDoubleFreq(int freq) {
        return (ConfiguredPlacement)((ConfiguredPlacement)Placement.field_242905_i.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e).func_242728_a()).func_242731_b(freq);
    }
}

