/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.spawning;

import com.github.maximuslotro.lotrrextended.ExtendedLog;
import lotr.common.entity.npc.ExtendedTraderEntity;
import lotr.common.entity.npc.NPCEntity;
import lotr.common.init.ExtendedEntities;
import lotr.common.world.spawning.WanderingTradersList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;

public class WanderingTradersSpawner {
    public static void spawn(World world, PlayerEntity player) {
        for (int attempts = 0; attempts < 16; ++attempts) {
            float angle = world.field_73012_v.nextFloat() * 360.0f;
            int x = MathHelper.func_76128_c((double)player.func_226277_ct_()) + MathHelper.func_76141_d((float)(MathHelper.func_76126_a((float)angle) * (float)(24 + world.field_73012_v.nextInt(20))));
            int z = MathHelper.func_76128_c((double)player.func_226281_cx_()) + MathHelper.func_76141_d((float)(MathHelper.func_76134_b((float)angle) * (float)(24 + world.field_73012_v.nextInt(20))));
            int y = world.func_201676_a(Heightmap.Type.WORLD_SURFACE, x, z);
            BlockPos pos = new BlockPos(x, y, z);
            String biomeName = world.func_242406_i(pos).toString();
            String entityName = null;
            try {
                entityName = WanderingTradersList.pickTraderFromBiomeName(world, biomeName);
            }
            catch (IllegalArgumentException ex) {
                ExtendedLog.error("Issue while determining LOTR when spawning a wandering trader", ex);
            }
            if (entityName == null) {
                ExtendedLog.info("Got null entity when determining if a wandering trader could spawn at " + pos + ". This biome likely doesn't support wandering traders.");
                attempts += 2;
                continue;
            }
            EntityType<?> type = WanderingTradersSpawner.getTraderFromName(entityName);
            if (type == null) {
                ExtendedLog.error("Got null EntityType when attempting to parse " + entityName);
                break;
            }
            BlockPos plusOneY = new BlockPos(x, y + 1, z);
            if (y <= 62 || world.func_180495_p(pos).func_229980_m_((IBlockReader)world, pos) || world.func_180495_p(plusOneY).func_229980_m_((IBlockReader)world, plusOneY)) continue;
            BlockPos spawnPos = pos.func_177971_a(new Vector3i(0.5, 0.0, 0.5));
            Entity trader = type.func_220331_a((ServerWorld)world, null, null, spawnPos, SpawnReason.SPAWN_EGG, true, true);
            if (trader instanceof ExtendedTraderEntity) {
                float yaw = world.field_73012_v.nextFloat() * 360.0f;
                trader.func_181013_g(yaw);
                trader.func_70034_d(yaw);
                ((ExtendedTraderEntity)trader).setWanderingTraderTicksLeft(24000);
                ((ExtendedTraderEntity)trader).setWanderingTrader(true);
                ((NPCEntity)trader).func_213390_a(pos, 5);
                int escortCount = world.field_73012_v.nextInt(3) + 2;
                for (int i = 0; i < escortCount; ++i) {
                    NPCEntity escort = ((ExtendedTraderEntity)trader).createEscort();
                    if (escort == null) continue;
                    escort.func_110163_bv();
                    BlockPos escortPos = new BlockPos(trader.func_226277_ct_(), trader.func_226278_cu_(), trader.func_226281_cx_());
                    escort.func_213386_a((IServerWorld)world, world.func_175649_E(escortPos), SpawnReason.EVENT, null, null);
                    escort.func_70107_b(trader.func_226277_ct_(), trader.func_226278_cu_(), trader.func_226281_cx_());
                    world.func_217376_c((Entity)escort);
                    escort.func_213390_a(escortPos, 8);
                    ((ExtendedTraderEntity)trader).addEscort(escort.func_110124_au());
                }
                player.func_145747_a((ITextComponent)new TranslationTextComponent("chat.wandering_trader.arrive_near_you", new Object[]{trader.func_200200_C_().func_230532_e_().func_240699_a_(TextFormatting.YELLOW)}), Util.field_240973_b_);
                for (PlayerEntity otherPlayer : world.func_217369_A()) {
                    if (otherPlayer.func_110124_au().equals(player.func_110124_au())) continue;
                    otherPlayer.func_145747_a((ITextComponent)new TranslationTextComponent("chat.wandering_trader.arrive_near_player", new Object[]{trader.func_200200_C_().func_230532_e_().func_240699_a_(TextFormatting.YELLOW), player.func_200200_C_()}), Util.field_240973_b_);
                }
                break;
            }
            ExtendedLog.error("Error attempting to set trader options when spawning wandering trader. Does " + type + " extend ExtendedTraderEntity?");
            break;
        }
    }

    private static EntityType<?> getTraderFromName(String name) {
        if (name.equals("lotr:galadhrim_wanderer")) {
            return (EntityType)ExtendedEntities.GALADHRIM_WANDERER.get();
        }
        if (name.equals("lotr:rivendell_wanderer")) {
            return (EntityType)ExtendedEntities.RIVENDELL_WANDERER.get();
        }
        if (name.equals("lotr:oddment_collector")) {
            return (EntityType)ExtendedEntities.ODDMENT_COLLECTOR.get();
        }
        if (name.equals("lotr:blue_mountains_merchant")) {
            return (EntityType)ExtendedEntities.BLUE_MOUNTAINS_MERCHANT.get();
        }
        if (name.equals("lotr:bree_merchant")) {
            return (EntityType)ExtendedEntities.BREE_MERCHANT.get();
        }
        return null;
    }
}

