/*
 * Decompiled with CFR 0.152.
 */
package lotr.client;

import com.google.common.collect.ImmutableMap;
import com.google.common.math.IntMath;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lotr.client.gui.MiddleEarthMasterMenuScreen;
import lotr.common.data.AlignmentDataModule;
import lotr.common.data.LOTRLevelData;
import lotr.common.fac.Faction;
import lotr.common.fac.FactionRegion;
import lotr.common.fac.FactionSettings;
import lotr.common.fac.FactionSettingsManager;
import lotr.common.init.LOTRDimensions;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.World;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;

public class LOTRKeyHandler {
    private static final String KEY_CATEGORY_MOD = String.format("key.categories.mod.%s", "lotr");
    public static final KeyBinding KEY_BIND_MENU = new KeyBinding(LOTRKeyHandler.keybindName("menu"), 77, KEY_CATEGORY_MOD);
    public static final KeyBinding KEY_BIND_MAP_TELEPORT = new KeyBinding(LOTRKeyHandler.keybindName("map_teleport"), 257, KEY_CATEGORY_MOD);
    public static final KeyBinding KEY_BIND_ALIGNMENT_PREVIOUS = new KeyBinding(LOTRKeyHandler.keybindName("alignment_previous"), 263, KEY_CATEGORY_MOD);
    public static final KeyBinding KEY_BIND_ALIGNMENT_NEXT = new KeyBinding(LOTRKeyHandler.keybindName("alignment_next"), 262, KEY_CATEGORY_MOD);
    public static final KeyBinding KEY_BIND_ALIGNMENT_GROUP_PREVIOUS = new KeyBinding(LOTRKeyHandler.keybindName("alignment_group_previous"), 265, KEY_CATEGORY_MOD);
    public static final KeyBinding KEY_BIND_ALIGNMENT_GROUP_NEXT = new KeyBinding(LOTRKeyHandler.keybindName("alignment_group_next"), 264, KEY_CATEGORY_MOD);
    private static final Map<KeyBinding, AlignmentKeyAction> ALIGNMENT_KEY_ACTIONS = ImmutableMap.of((Object)KEY_BIND_ALIGNMENT_PREVIOUS, (Object)new AlignmentKeyAction(-1, 0), (Object)KEY_BIND_ALIGNMENT_NEXT, (Object)new AlignmentKeyAction(1, 0), (Object)KEY_BIND_ALIGNMENT_GROUP_PREVIOUS, (Object)new AlignmentKeyAction(0, -1), (Object)KEY_BIND_ALIGNMENT_GROUP_NEXT, (Object)new AlignmentKeyAction(0, 1));
    private static int alignmentChangeTick;
    private static final int ALIGNMENT_CHANGE_DELAY = 2;

    private static final String keybindName(String name) {
        return String.format("key.%s.%s", "lotr", name);
    }

    public static KeyBinding getFastTravelKey(Minecraft mc) {
        return mc.field_71474_y.field_186718_X;
    }

    public LOTRKeyHandler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.registerKeys();
    }

    private void registerKeys() {
        ClientRegistry.registerKeyBinding((KeyBinding)KEY_BIND_MENU);
        ClientRegistry.registerKeyBinding((KeyBinding)KEY_BIND_MAP_TELEPORT);
        ClientRegistry.registerKeyBinding((KeyBinding)KEY_BIND_ALIGNMENT_PREVIOUS);
        ClientRegistry.registerKeyBinding((KeyBinding)KEY_BIND_ALIGNMENT_NEXT);
        ClientRegistry.registerKeyBinding((KeyBinding)KEY_BIND_ALIGNMENT_GROUP_PREVIOUS);
        ClientRegistry.registerKeyBinding((KeyBinding)KEY_BIND_ALIGNMENT_GROUP_NEXT);
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        Screen menuScreen;
        int key = event.getKey();
        int scancode = event.getScanCode();
        int action = event.getAction();
        Minecraft mc = Minecraft.func_71410_x();
        if (KEY_BIND_MENU.func_197976_a(key, scancode) && mc.field_71462_r == null && mc.field_71439_g != null && (menuScreen = MiddleEarthMasterMenuScreen.openMenu((PlayerEntity)mc.field_71439_g)) != null) {
            mc.func_147108_a(menuScreen);
        }
        if (mc.field_71462_r == null && mc.field_71439_g != null && (action == 1 || action == 2) && alignmentChangeTick <= 0) {
            Optional<AlignmentKeyAction> optAlignmentAction = ALIGNMENT_KEY_ACTIONS.entrySet().stream().filter(e -> ((KeyBinding)e.getKey()).func_197976_a(key, scancode)).map(e -> (AlignmentKeyAction)e.getValue()).findFirst();
            optAlignmentAction.ifPresent(alignmentAction -> {
                FactionSettings factionSettings = FactionSettingsManager.clientInstance().getCurrentLoadedFactions();
                AlignmentDataModule alignData = LOTRLevelData.clientInstance().getData((PlayerEntity)mc.field_71439_g).getAlignmentData();
                boolean changedAlignmentView = false;
                int factionShift = alignmentAction.factionShift;
                int groupShift = alignmentAction.groupShift;
                RegistryKey<World> currentDimension = LOTRDimensions.getCurrentLOTRDimensionOrFallback((World)mc.field_71441_e);
                Faction currentFaction = alignData.getCurrentViewedFaction();
                if (currentFaction != null) {
                    int i;
                    FactionRegion currentRegion = currentFaction.getRegion();
                    List<FactionRegion> regionList = factionSettings.getRegionsForDimension(currentDimension);
                    List<Faction> factionList = factionSettings.getFactionsForRegion(currentRegion);
                    if (factionShift != 0) {
                        i = factionList.indexOf(currentFaction);
                        i += factionShift;
                        i = IntMath.mod((int)i, (int)factionList.size());
                        alignData.setCurrentViewedFaction(factionList.get(i));
                        changedAlignmentView = true;
                    }
                    if (groupShift != 0 && regionList != null && currentRegion != null) {
                        alignData.setRegionLastViewedFaction(currentRegion, currentFaction);
                        i = regionList.indexOf(currentRegion);
                        i += groupShift;
                        i = IntMath.mod((int)i, (int)regionList.size());
                        alignData.setCurrentViewedFaction(alignData.getRegionLastViewedFaction(regionList.get(i)));
                        changedAlignmentView = true;
                    }
                }
                if (changedAlignmentView) {
                    alignData.sendViewedFactionsToServer();
                    alignmentChangeTick = 2;
                }
            });
        }
    }

    public static void updateAlignmentChange() {
        if (alignmentChangeTick > 0) {
            --alignmentChangeTick;
        }
    }

    private static final class AlignmentKeyAction {
        public final int factionShift;
        public final int groupShift;

        private AlignmentKeyAction(int faction, int group) {
            this.factionShift = faction;
            this.groupShift = group;
        }
    }
}

