/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.align;

import java.util.List;
import java.util.stream.Collectors;
import lotr.client.align.AlignmentFormatter;
import lotr.common.LOTRLog;
import lotr.common.fac.Faction;
import lotr.common.network.SPacketNotifyAlignRequirement;
import lotr.common.util.LOTRUtil;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class NotifyAlignmentRequirement {
    public static void displayMessage(ClientPlayerEntity player, SPacketNotifyAlignRequirement packet) {
        String alignString = AlignmentFormatter.formatAlignForDisplay(packet.getAlignmentRequired());
        StringTextComponent componentAlignReq = new StringTextComponent(alignString);
        componentAlignReq.func_240699_a_(TextFormatting.YELLOW);
        List factionNames = packet.getAnyOfFactions().stream().map(Faction::getColoredDisplayName).collect(Collectors.toList());
        if (!factionNames.isEmpty()) {
            TranslationTextComponent fullMessage = factionNames.size() == 1 ? new TranslationTextComponent("chat.lotr.align.insufficient", new Object[]{componentAlignReq, factionNames.get(0)}) : (factionNames.size() == 2 ? new TranslationTextComponent("chat.lotr.align.insufficient.2", new Object[]{componentAlignReq, factionNames.get(0), factionNames.get(1)}) : (factionNames.size() == 3 ? new TranslationTextComponent("chat.lotr.align.insufficient.3", new Object[]{componentAlignReq, factionNames.get(0), factionNames.get(1), factionNames.get(2)}) : new TranslationTextComponent("chat.lotr.align.insufficient.more", new Object[]{componentAlignReq, factionNames.get(0), factionNames.get(1), factionNames.get(2), factionNames.size() - 3})));
            LOTRUtil.sendMessage((PlayerEntity)player, (ITextComponent)fullMessage);
        } else {
            LOTRLog.error("Received notify alignment requirement packet from server with an empty list of factions - this shouldn't happen!");
        }
    }
}

