/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.event;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lotr.client.gui.LOTRMainMenuScreen;
import lotr.client.gui.inv.KegScreen;
import lotr.client.gui.inv.PouchScreen;
import lotr.client.gui.widget.button.PouchRestockButton;
import lotr.common.config.LOTRConfig;
import lotr.common.inv.ShulkerBoxContainerFix;
import lotr.common.network.CPacketRestockPouches;
import lotr.common.network.LOTRPacketHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.AnvilScreen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.screen.inventory.ShulkerBoxScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.ShulkerBoxContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.commons.lang3.tuple.Pair;

public class LOTRGuiHandler {
    public static final Map<Class<? extends ContainerScreen>, PouchRestockButtonPositioner> pouchRestockPositionerByScreen = new HashMap<Class<? extends ContainerScreen>, PouchRestockButtonPositioner>();
    public static final Set<Class<? extends ContainerScreen>> pouchRestockExclusionScreens = new HashSet<Class<? extends ContainerScreen>>();
    public static final PouchRestockButtonPositioner DEFAULT_ABOVE_TOP_RIGHT_SLOT = (topLeftPlayerSlot, topRightPlayerSlot) -> Pair.of((Object)(topRightPlayerSlot.field_75223_e + 7), (Object)(topRightPlayerSlot.field_75221_f - 14));
    public static final PouchRestockButtonPositioner RIGHT_FROM_TOP_RIGHT_SLOT = (topLeftPlayerSlot, topRightPlayerSlot) -> Pair.of((Object)(topRightPlayerSlot.field_75223_e + 21), (Object)(topRightPlayerSlot.field_75221_f - 1));
    public static final PouchRestockButtonPositioner ABOVE_TOP_LEFT_SLOT = (topLeftPlayerSlot, topRightPlayerSlot) -> Pair.of((Object)(topLeftPlayerSlot.field_75223_e - 1), (Object)(topLeftPlayerSlot.field_75221_f - 14));
    private final Minecraft MC;

    public LOTRGuiHandler(Minecraft mc) {
        this.MC = mc;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onGuiOpen(GuiOpenEvent event) {
        Object gui = event.getGui();
        if (((Boolean)LOTRConfig.CLIENT.modMainMenu.get()).booleanValue() && gui != null && gui.getClass() == MainMenuScreen.class) {
            gui = new LOTRMainMenuScreen();
            event.setGui(gui);
        }
        if (gui instanceof ShulkerBoxScreen) {
            ShulkerBoxContainerFix.fixContainerSlots((ShulkerBoxContainer)((ShulkerBoxScreen)gui).func_212873_a_(), (PlayerEntity)this.MC.field_71439_g);
        }
    }

    @SubscribeEvent
    public void postInitGui(GuiScreenEvent.InitGuiEvent.Post event) {
        Screen gui = event.getGui();
        PouchRestockButton restockButton = this.constructPouchRestockButton(gui);
        if (restockButton != null) {
            event.addWidget((Widget)restockButton);
        }
    }

    private PouchRestockButton constructPouchRestockButton(Screen gui) {
        PouchRestockButtonPositioner positioner;
        ContainerScreen containerScreen;
        Optional<Pair<Integer, Integer>> optButtonCoords;
        if (gui instanceof ContainerScreen && !pouchRestockExclusionScreens.contains(gui.getClass()) && (optButtonCoords = PouchRestockButton.getRestockButtonPosition(this.MC, containerScreen = (ContainerScreen)gui, positioner = pouchRestockPositionerByScreen.getOrDefault(gui.getClass(), DEFAULT_ABOVE_TOP_RIGHT_SLOT))).isPresent()) {
            Pair<Integer, Integer> buttonCoords = optButtonCoords.get();
            int buttonX = (Integer)buttonCoords.getLeft();
            int buttonY = (Integer)buttonCoords.getRight();
            return new PouchRestockButton(containerScreen, buttonX, buttonY, positioner, b -> LOTRPacketHandler.sendToServer(new CPacketRestockPouches()));
        }
        return null;
    }

    static {
        pouchRestockPositionerByScreen.put(AnvilScreen.class, (topLeftPlayerSlot, topRightPlayerSlot) -> Pair.of((Object)(topRightPlayerSlot.field_75223_e + 25), (Object)(topRightPlayerSlot.field_75221_f - 1)));
        pouchRestockPositionerByScreen.put(KegScreen.class, RIGHT_FROM_TOP_RIGHT_SLOT);
        pouchRestockExclusionScreens.add(PouchScreen.class);
    }

    @FunctionalInterface
    public static interface PouchRestockButtonPositioner {
        public Pair<Integer, Integer> getButtonPosition(Slot var1, Slot var2);
    }
}

