/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.gui;

import com.google.common.math.IntMath;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lotr.client.align.AlignmentFormatter;
import lotr.client.gui.MiddleEarthMenuScreen;
import lotr.client.gui.map.MiddleEarthMapScreen;
import lotr.client.gui.util.AlignmentRenderer;
import lotr.client.gui.util.AlignmentTextRenderer;
import lotr.client.gui.widget.ScrollPane;
import lotr.client.gui.widget.button.FactionsMapButton;
import lotr.client.gui.widget.button.FactionsPageButton;
import lotr.client.gui.widget.button.FriendlyFireToggleButton;
import lotr.client.gui.widget.button.PledgeButton;
import lotr.client.gui.widget.button.PreferredRankGenderButton;
import lotr.client.gui.widget.button.RedBookButton;
import lotr.client.util.LOTRClientUtil;
import lotr.common.config.LOTRConfig;
import lotr.common.data.AlignmentDataModule;
import lotr.common.data.FactionStats;
import lotr.common.data.LOTRLevelData;
import lotr.common.data.LOTRPlayerData;
import lotr.common.fac.AreasOfInfluence;
import lotr.common.fac.Faction;
import lotr.common.fac.FactionRank;
import lotr.common.fac.FactionRegion;
import lotr.common.fac.FactionRelation;
import lotr.common.fac.FactionSettings;
import lotr.common.fac.FactionSettingsManager;
import lotr.common.fac.MapSquare;
import lotr.common.fac.RankGender;
import lotr.common.init.LOTRDimensions;
import lotr.common.network.CPacketSetPledge;
import lotr.common.network.LOTRPacketHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class MiddleEarthFactionsScreen
extends MiddleEarthMenuScreen {
    public static final ResourceLocation FACTIONS_TEXTURE = new ResourceLocation("lotr", "textures/gui/factions.png");
    public static final ResourceLocation FACTIONS_TEXTURE_FULL = new ResourceLocation("lotr", "textures/gui/factions_full.png");
    private FactionSettings currentLoadedFactions;
    private static RegistryKey<World> currentDimension;
    private static RegistryKey<World> prevDimension;
    private static FactionRegion currentRegion;
    private static FactionRegion prevRegion;
    private static List<Faction> currentFactionList;
    private int currentFactionIndex = 0;
    private int prevFactionIndex = 0;
    private Faction currentFaction;
    private static final int MAX_ALIGNMENTS_DISPLAYED = 1;
    private static Page currentPage;
    private int pageY = 46;
    private int pageWidth = 256;
    private int pageHeight = 128;
    private int pageBorderLeft = 16;
    private int pageBorderTop = 12;
    private int pageMapX = 159;
    private int pageMapY = 22;
    private int pageMapSize = 80;
    private MiddleEarthMapScreen mapDrawGui;
    private final AlignmentTextRenderer alignmentTextRenderer = AlignmentTextRenderer.newGUIRenderer();
    private final AlignmentRenderer alignmentRenderer = new AlignmentRenderer(this.alignmentTextRenderer);
    private Button buttonRegions;
    private Button buttonPagePrev;
    private Button buttonPageNext;
    private Button buttonFactionMap;
    private Button buttonPreferredRanksMasc;
    private Button buttonPreferredRanksFem;
    private Button buttonToggleFriendlyFire;
    private PledgeButton buttonOpenPledgeScreen;
    private PledgeButton buttonPledgeConfirm;
    private PledgeButton buttonPledgeRevoke;
    private float currentScroll;
    private boolean isScrolling;
    private boolean wasMouseDown;
    private boolean isMouseDown;
    private int scrollBarWidth;
    private int scrollBarHeight;
    private int scrollBarX;
    private int scrollBarY;
    private int scrollBarBorder;
    private int scrollWidgetWidth;
    private int scrollWidgetHeight;
    private ScrollPane scrollPaneAlliesEnemies;
    private int scrollAlliesEnemiesX;
    private static final int MAX_DISPLAYED_ALLIES_ENEMIES = 10;
    private int numDisplayedAlliesEnemies;
    private List currentAlliesEnemies;
    private boolean isOtherPlayer;
    private String otherPlayerName;
    private Map<Faction, Float> otherPlayerAlignmentMap;
    private boolean isPledging;
    private boolean isUnpledging;

    public MiddleEarthFactionsScreen() {
        super((ITextComponent)new StringTextComponent("FACTIONS"));
        this.xSize = this.pageWidth;
        this.currentScroll = 0.0f;
        this.isScrolling = false;
        this.scrollBarWidth = 240;
        this.scrollBarHeight = 14;
        this.scrollBarX = this.xSize / 2 - this.scrollBarWidth / 2;
        this.scrollBarY = 180;
        this.scrollBarBorder = 1;
        this.scrollWidgetWidth = 17;
        this.scrollWidgetHeight = 12;
        this.scrollPaneAlliesEnemies = new ScrollPane(7, 7).setColors(5521198, 8019267);
        this.scrollAlliesEnemiesX = 138;
        this.isOtherPlayer = false;
        this.isPledging = false;
        this.isUnpledging = false;
        this.mapDrawGui = new MiddleEarthMapScreen();
        this.currentLoadedFactions = FactionSettingsManager.clientInstance().getCurrentLoadedFactions();
    }

    public void setOtherPlayer(String name, Map<Faction, Float> alignments) {
        this.isOtherPlayer = true;
        this.otherPlayerName = name;
        this.otherPlayerAlignmentMap = alignments;
    }

    public void func_231158_b_(Minecraft mc, int w, int h) {
        super.func_231158_b_(mc, w, h);
        this.mapDrawGui.func_231158_b_(mc, w, h);
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        if (this.isOtherPlayer) {
            this.removeButton((Widget)this.buttonMenuReturn);
        }
        this.buttonRegions = (Button)this.func_230480_a_((Widget)new RedBookButton(this.guiLeft + this.xSize / 2 - 60, this.guiTop + this.scrollBarY + 20, 120, 20, StringTextComponent.field_240750_d_, button -> {
            List<FactionRegion> regionList = this.currentLoadedFactions.getRegionsForDimension(currentDimension);
            if (!regionList.isEmpty()) {
                int i = regionList.indexOf(currentRegion);
                ++i;
                i = IntMath.mod((int)i, (int)regionList.size());
                currentRegion = regionList.get(i);
                this.updateCurrentDimensionAndFaction();
                this.setCurrentScrollFromFaction();
                this.scrollPaneAlliesEnemies.resetScroll();
                this.isPledging = false;
                this.isUnpledging = false;
            }
        }));
        this.buttonPagePrev = (Button)this.func_230480_a_((Widget)new FactionsPageButton(this.guiLeft + 13, this.guiTop + this.pageY + 104, true, (ITextComponent)new TranslationTextComponent("gui.lotr.factions.page.previous"), button -> {
            Page newPage = currentPage.prev();
            if (newPage != null) {
                currentPage = newPage;
                this.scrollPaneAlliesEnemies.resetScroll();
                this.isPledging = false;
                this.isUnpledging = false;
            }
        }));
        this.buttonPageNext = (Button)this.func_230480_a_((Widget)new FactionsPageButton(this.guiLeft + this.pageWidth - 29, this.guiTop + this.pageY + 104, false, (ITextComponent)new TranslationTextComponent("gui.lotr.factions.page.next"), button -> {
            Page newPage = currentPage.next();
            if (newPage != null) {
                currentPage = newPage;
                this.scrollPaneAlliesEnemies.resetScroll();
                this.isPledging = false;
                this.isUnpledging = false;
            }
        }));
        this.buttonFactionMap = (Button)this.func_230480_a_((Widget)new FactionsMapButton(this.guiLeft + this.pageMapX + this.pageMapSize - 3 - 8, this.guiTop + this.pageY + this.pageMapY + 3, button -> {
            MiddleEarthMapScreen factionGuiMap = new MiddleEarthMapScreen();
            factionGuiMap.setAreasOfInfluence(this.currentFaction);
            this.field_230706_i_.func_147108_a((Screen)factionGuiMap);
        }));
        this.buttonPreferredRanksMasc = (Button)this.func_230480_a_((Widget)new PreferredRankGenderButton(this.guiLeft + this.pageWidth - this.pageBorderLeft - 24, this.guiTop + this.pageY + this.pageBorderTop, RankGender.MASCULINE, PreferredRankGenderButton::sendPreferenceToServer));
        this.buttonPreferredRanksFem = (Button)this.func_230480_a_((Widget)new PreferredRankGenderButton(this.guiLeft + this.pageWidth - this.pageBorderLeft - 12, this.guiTop + this.pageY + this.pageBorderTop, RankGender.FEMININE, PreferredRankGenderButton::sendPreferenceToServer));
        this.buttonToggleFriendlyFire = (Button)this.func_230480_a_((Widget)new FriendlyFireToggleButton(this.guiLeft + this.scrollBarX + this.scrollBarWidth - 16, this.guiTop + this.scrollBarY + 22, FriendlyFireToggleButton::sendToggleToServer));
        this.buttonOpenPledgeScreen = (PledgeButton)this.func_230480_a_((Widget)new PledgeButton(this, this.guiLeft + 14, this.guiTop + this.pageY + this.pageHeight - 42, false, button -> {
            if (this.getClientPlayerData().getAlignmentData().isPledgedTo(this.currentFaction)) {
                this.isUnpledging = true;
            } else {
                this.isPledging = true;
            }
        }));
        this.buttonPledgeConfirm = (PledgeButton)this.func_230480_a_((Widget)new PledgeButton(this, this.guiLeft + this.pageWidth / 2 - 16, this.guiTop + this.pageY + this.pageHeight - 44, false, button -> {
            LOTRPacketHandler.sendToServer(new CPacketSetPledge(this.currentFaction));
            this.isPledging = false;
        }));
        this.buttonPledgeRevoke = (PledgeButton)this.func_230480_a_((Widget)new PledgeButton(this, this.guiLeft + this.pageWidth / 2 - 16, this.guiTop + this.pageY + this.pageHeight - 44, true, button -> {
            LOTRPacketHandler.sendToServer(new CPacketSetPledge(null));
            this.isUnpledging = false;
            this.field_230706_i_.func_147108_a(null);
        }));
        currentDimension = LOTRDimensions.getCurrentLOTRDimensionOrFallback((World)this.field_230706_i_.field_71441_e);
        prevDimension = currentDimension;
        AlignmentDataModule alignData = LOTRLevelData.clientInstance().getData((PlayerEntity)this.field_230706_i_.field_71439_g).getAlignmentData();
        this.currentFaction = alignData.getCurrentViewedFactionOrFallbackToFirstIn(currentDimension);
        if (this.currentFaction != null) {
            prevRegion = currentRegion = this.currentFaction.getRegion();
            currentFactionList = this.currentLoadedFactions.getFactionsForRegion(currentRegion);
            this.prevFactionIndex = this.currentFactionIndex = currentFactionList.indexOf(this.currentFaction);
            this.setCurrentScrollFromFaction();
        }
    }

    private LOTRPlayerData getClientPlayerData() {
        return LOTRLevelData.clientInstance().getData((PlayerEntity)this.field_230706_i_.field_71439_g);
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        this.updateCurrentDimensionAndFaction();
        AlignmentDataModule alignData = this.getClientPlayerData().getAlignmentData();
        if (this.isPledging && !alignData.hasPledgeAlignment(this.currentFaction)) {
            this.isPledging = false;
        }
        if (this.isUnpledging && !alignData.isPledgedTo(this.currentFaction)) {
            this.isUnpledging = false;
        }
    }

    private void updateCurrentDimensionAndFaction() {
        boolean changes;
        AlignmentDataModule alignData = this.getClientPlayerData().getAlignmentData();
        HashMap<FactionRegion, Faction> lastViewedRegions = new HashMap<FactionRegion, Faction>();
        if (currentFactionList != null && this.currentFactionIndex != this.prevFactionIndex) {
            this.currentFaction = currentFactionList.get(this.currentFactionIndex);
        }
        this.prevFactionIndex = this.currentFactionIndex;
        currentDimension = LOTRDimensions.getCurrentLOTRDimensionOrFallback((World)this.field_230706_i_.field_71441_e);
        if (currentDimension != prevDimension) {
            currentRegion = this.currentLoadedFactions.getRegions().get(0);
        }
        if (currentRegion != prevRegion) {
            alignData.setRegionLastViewedFaction(prevRegion, this.currentFaction);
            lastViewedRegions.put(prevRegion, this.currentFaction);
            currentFactionList = this.currentLoadedFactions.getFactionsForRegion(currentRegion);
            this.currentFaction = alignData.getRegionLastViewedFaction(currentRegion);
            this.prevFactionIndex = this.currentFactionIndex = currentFactionList.indexOf(this.currentFaction);
        }
        prevDimension = currentDimension;
        prevRegion = currentRegion;
        Faction prevFaction = alignData.getCurrentViewedFaction();
        boolean bl = changes = this.currentFaction != prevFaction;
        if (changes) {
            alignData.setCurrentViewedFaction(this.currentFaction);
            lastViewedRegions.forEach(alignData::setRegionLastViewedFaction);
            alignData.sendViewedFactionsToServer();
            this.isPledging = false;
            this.isUnpledging = false;
        }
    }

    private boolean useFullPageTexture() {
        return this.isPledging || this.isUnpledging || currentPage == Page.RANKS;
    }

    public void func_230430_a_(MatrixStack matStack, int mouseX, int mouseY, float tick) {
        LOTRPlayerData clientPD = this.getClientPlayerData();
        AlignmentDataModule alignData = this.getClientPlayerData().getAlignmentData();
        boolean mouseOverAlignLock = false;
        boolean mouseOverCivilianKills = false;
        if (!this.isPledging && !this.isUnpledging) {
            boolean isRanksPage;
            this.buttonPagePrev.field_230693_o_ = currentPage.prev() != null;
            this.buttonPageNext.field_230693_o_ = currentPage.next() != null;
            this.buttonFactionMap.field_230693_o_ = currentPage != Page.RANKS && this.currentFaction != null && this.currentFaction.getMapSquare() != null && LOTRDimensions.getCurrentLOTRDimensionOrFallback((World)this.field_230706_i_.field_71441_e).equals(this.currentFaction.getDimension());
            this.buttonFactionMap.field_230694_p_ = this.buttonFactionMap.field_230693_o_;
            if (!AreasOfInfluence.areAreasOfInfluenceEnabled((World)this.field_230706_i_.field_71441_e)) {
                this.buttonFactionMap.field_230693_o_ = false;
                this.buttonFactionMap.field_230694_p_ = false;
            }
            this.buttonPreferredRanksMasc.field_230694_p_ = this.buttonPreferredRanksMasc.field_230693_o_ = (isRanksPage = currentPage == Page.RANKS);
            this.buttonPreferredRanksFem.field_230694_p_ = this.buttonPreferredRanksFem.field_230693_o_ = isRanksPage;
            this.buttonToggleFriendlyFire.field_230693_o_ = true;
            this.buttonToggleFriendlyFire.field_230694_p_ = true;
            if (!this.isOtherPlayer && currentPage == Page.OVERVIEW) {
                if (alignData.isPledgedTo(this.currentFaction)) {
                    this.buttonOpenPledgeScreen.setDisplayAsBroken(this.buttonOpenPledgeScreen.func_230449_g_());
                    this.buttonOpenPledgeScreen.field_230693_o_ = true;
                    this.buttonOpenPledgeScreen.field_230694_p_ = true;
                    this.buttonOpenPledgeScreen.setTooltipLines(new ITextComponent[]{new TranslationTextComponent("gui.lotr.factions.unpledge")});
                } else {
                    this.buttonOpenPledgeScreen.setDisplayAsBroken(false);
                    this.buttonOpenPledgeScreen.field_230694_p_ = alignData.getPledgeFaction() == null && this.currentFaction.isPlayableAlignmentFaction() && alignData.getAlignment(this.currentFaction) >= 0.0f;
                    this.buttonOpenPledgeScreen.field_230693_o_ = this.buttonOpenPledgeScreen.field_230694_p_ && alignData.hasPledgeAlignment(this.currentFaction);
                    TranslationTextComponent desc1 = new TranslationTextComponent("gui.lotr.factions.pledge");
                    TranslationTextComponent desc2 = new TranslationTextComponent("gui.lotr.factions.pledge.req", new Object[]{AlignmentFormatter.formatAlignForDisplay(this.currentFaction.getPledgeAlignment())});
                    this.buttonOpenPledgeScreen.setTooltipLines(new ITextComponent[]{desc1, desc2});
                }
            } else {
                this.buttonOpenPledgeScreen.field_230693_o_ = false;
                this.buttonOpenPledgeScreen.field_230694_p_ = false;
            }
            this.buttonPledgeConfirm.field_230693_o_ = false;
            this.buttonPledgeConfirm.field_230694_p_ = false;
            this.buttonPledgeRevoke.field_230693_o_ = false;
            this.buttonPledgeRevoke.field_230694_p_ = false;
        } else {
            this.buttonPagePrev.field_230693_o_ = false;
            this.buttonPageNext.field_230693_o_ = false;
            this.buttonFactionMap.field_230693_o_ = false;
            this.buttonFactionMap.field_230694_p_ = false;
            this.buttonPreferredRanksMasc.field_230693_o_ = false;
            this.buttonPreferredRanksMasc.field_230694_p_ = false;
            this.buttonPreferredRanksFem.field_230693_o_ = false;
            this.buttonPreferredRanksFem.field_230694_p_ = false;
            this.buttonToggleFriendlyFire.field_230693_o_ = true;
            this.buttonToggleFriendlyFire.field_230694_p_ = true;
            this.buttonOpenPledgeScreen.field_230693_o_ = false;
            this.buttonOpenPledgeScreen.field_230694_p_ = false;
            if (this.isPledging) {
                this.buttonPledgeConfirm.field_230694_p_ = true;
                this.buttonPledgeConfirm.field_230693_o_ = alignData.canMakeNewPledge() && alignData.canPledgeToNow(this.currentFaction);
                this.buttonPledgeConfirm.setTooltipLines(new ITextComponent[]{new TranslationTextComponent("gui.lotr.factions.pledge")});
                this.buttonPledgeRevoke.field_230693_o_ = false;
                this.buttonPledgeRevoke.field_230694_p_ = false;
            } else if (this.isUnpledging) {
                this.buttonPledgeConfirm.field_230693_o_ = false;
                this.buttonPledgeConfirm.field_230694_p_ = false;
                this.buttonPledgeRevoke.field_230693_o_ = true;
                this.buttonPledgeRevoke.field_230694_p_ = true;
                this.buttonPledgeRevoke.setTooltipLines(new ITextComponent[]{new TranslationTextComponent("gui.lotr.factions.unpledge")});
            }
        }
        this.processFactionScrollBar(mouseX, mouseY);
        this.func_230446_a_(matStack);
        if (this.useFullPageTexture()) {
            this.field_230706_i_.func_110434_K().func_110577_a(FACTIONS_TEXTURE_FULL);
        } else {
            this.field_230706_i_.func_110434_K().func_110577_a(FACTIONS_TEXTURE);
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_238474_b_(matStack, this.guiLeft, this.guiTop + this.pageY, 0, 0, this.pageWidth, this.pageHeight);
        TranslationTextComponent title = new TranslationTextComponent("gui.lotr.factions.title", new Object[]{LOTRDimensions.getDisplayName(currentDimension)});
        if (this.isOtherPlayer) {
            title = new TranslationTextComponent("gui.lotr.factions.title", new Object[]{this.otherPlayerName});
        }
        this.field_230712_o_.func_243248_b(matStack, (ITextComponent)title, (float)(this.guiLeft + this.xSize / 2 - this.field_230712_o_.func_238414_a_((ITextProperties)title) / 2), (float)(this.guiTop - 30), 0xFFFFFF);
        if (currentRegion != null && this.currentLoadedFactions.getRegionsForDimension(currentDimension).size() > 1) {
            this.buttonRegions.func_238482_a_(currentRegion.getDisplayName());
            this.buttonRegions.field_230693_o_ = true;
            this.buttonRegions.field_230694_p_ = true;
        } else {
            this.buttonRegions.func_238482_a_(StringTextComponent.field_240750_d_);
            this.buttonRegions.field_230693_o_ = false;
            this.buttonRegions.field_230694_p_ = false;
        }
        if (this.currentFaction != null) {
            float alignment = this.isOtherPlayer && this.otherPlayerAlignmentMap != null ? this.otherPlayerAlignmentMap.get(this.currentFaction).floatValue() : alignData.getAlignment(this.currentFaction);
            int x = this.guiLeft + this.xSize / 2;
            int y = this.guiTop;
            this.alignmentRenderer.renderAlignmentBar(matStack, this.field_230706_i_, alignment, this.isOtherPlayer, this.currentFaction, x, y, true, false, true, true);
            this.field_230712_o_.getClass();
            this.drawCenteredStringNoShadow(matStack, this.field_230712_o_, this.currentFaction.getDisplaySubtitle(), x, y += 9 + 22, 0xFFFFFF);
            this.field_230712_o_.getClass();
            y += 9 * 3;
            if (!this.useFullPageTexture()) {
                MapSquare mapSquare = this.currentFaction.getMapSquare();
                if (mapSquare != null) {
                    int mapX = mapSquare.mapX;
                    int mapZ = mapSquare.mapZ;
                    int mapR = mapSquare.radius;
                    int xMin = this.guiLeft + this.pageMapX;
                    int xMax = xMin + this.pageMapSize;
                    int yMin = this.guiTop + this.pageY + this.pageMapY;
                    int yMax = yMin + this.pageMapSize;
                    int mapBorder = 1;
                    MiddleEarthFactionsScreen.func_238467_a_((MatrixStack)matStack, (int)(xMin - mapBorder), (int)(yMin - mapBorder), (int)(xMax + mapBorder), (int)(yMax + mapBorder), (int)-16777216);
                    float zoom = (float)this.pageMapSize / (float)(mapR * 2);
                    float zoomExp = (float)Math.log(zoom) / (float)Math.log(2.0);
                    this.mapDrawGui.setMapViewportAndPositionAndScale(xMin, xMax, yMin, yMax, mapX, mapZ, zoom, zoomExp, zoom);
                    this.mapDrawGui.enableZoomOutObjectFading = false;
                    boolean sepia = (Boolean)LOTRConfig.CLIENT.sepiaMap.get();
                    this.mapDrawGui.renderMapAndOverlay(matStack, tick, sepia, 1.0f, true);
                }
                int wcX = this.guiLeft + this.pageMapX + 3;
                int wcY = this.guiTop + this.pageY + this.pageMapY + this.pageMapSize + 5;
                int wcWidth = 8;
                this.field_230706_i_.func_110434_K().func_110577_a(FACTIONS_TEXTURE);
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (this.currentFaction.approvesCivilianKills()) {
                    this.func_238474_b_(matStack, wcX, wcY, 33, 142, wcWidth, wcWidth);
                } else {
                    this.func_238474_b_(matStack, wcX, wcY, 41, 142, wcWidth, wcWidth);
                }
                if (mouseX >= wcX && mouseX < wcX + wcWidth && mouseY >= wcY && mouseY < wcY + wcWidth) {
                    mouseOverCivilianKills = true;
                }
            }
            x = this.guiLeft + this.pageBorderLeft;
            y = this.guiTop + this.pageY + this.pageBorderTop;
            if (!this.isPledging && !this.isUnpledging) {
                int index;
                if (currentPage == Page.OVERVIEW) {
                    if (this.isOtherPlayer) {
                        TranslationTextComponent otherPlayer = new TranslationTextComponent("gui.lotr.factions.overview.otherPlayer", new Object[]{this.otherPlayerName});
                        this.field_230712_o_.func_243248_b(matStack, (ITextComponent)otherPlayer, (float)x, (float)y, 8019267);
                        this.field_230712_o_.getClass();
                        y += 9 * 2;
                    }
                    TranslationTextComponent alignmentInfo = new TranslationTextComponent("gui.lotr.factions.alignment");
                    this.field_230712_o_.func_243248_b(matStack, (ITextComponent)alignmentInfo, (float)x, (float)y, 8019267);
                    String alignmentString = AlignmentFormatter.formatAlignForDisplay(alignment);
                    this.alignmentTextRenderer.drawAlignmentText(matStack, this.field_230712_o_, x += this.field_230712_o_.func_238414_a_((ITextProperties)alignmentInfo) + 5, y, (ITextComponent)new StringTextComponent(alignmentString), 1.0f);
                    if (alignData.isPledgeEnemyAlignmentLimited(this.currentFaction)) {
                        this.field_230706_i_.func_110434_K().func_110577_a(FACTIONS_TEXTURE);
                        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        int lockX = x + this.field_230712_o_.func_78256_a(alignmentString) + 5;
                        int lockY = y;
                        int lockWidth = 16;
                        this.func_238474_b_(matStack, lockX, lockY, 0, 200, lockWidth, lockWidth);
                        if (mouseX >= lockX && mouseX < lockX + lockWidth && mouseY >= lockY && mouseY < lockY + lockWidth) {
                            mouseOverAlignLock = true;
                        }
                    }
                    this.field_230712_o_.getClass();
                    x = this.guiLeft + this.pageBorderLeft;
                    FactionRank curRank = this.currentFaction.getRankFor(alignment);
                    TranslationTextComponent rankName = new TranslationTextComponent("gui.lotr.factions.alignment.rank", new Object[]{curRank.getDisplayFullName(clientPD.getMiscData().getPreferredRankGender())});
                    this.field_230712_o_.func_243248_b(matStack, (ITextComponent)rankName, (float)x, (float)(y += 9), 8019267);
                    this.field_230712_o_.getClass();
                    y += 9 * 2;
                    if (!this.isOtherPlayer) {
                        FactionStats factionStats = clientPD.getFactionStatsData().getFactionStats(this.currentFaction);
                        if (alignment >= 0.0f) {
                            float conq;
                            TranslationTextComponent facStat = new TranslationTextComponent("gui.lotr.factions.stats.enemiesKilled", new Object[]{factionStats.getEnemiesKilled()});
                            this.field_230712_o_.func_243248_b(matStack, (ITextComponent)facStat, (float)x, (float)y, 8019267);
                            this.field_230712_o_.getClass();
                            facStat = new TranslationTextComponent("gui.lotr.factions.stats.trades", new Object[]{factionStats.getTradeCount()});
                            this.field_230712_o_.func_243248_b(matStack, (ITextComponent)facStat, (float)x, (float)(y += 9), 8019267);
                            this.field_230712_o_.getClass();
                            facStat = new TranslationTextComponent("gui.lotr.factions.stats.hires", new Object[]{factionStats.getHireCount()});
                            this.field_230712_o_.func_243248_b(matStack, (ITextComponent)facStat, (float)x, (float)(y += 9), 8019267);
                            this.field_230712_o_.getClass();
                            facStat = new TranslationTextComponent("gui.lotr.factions.stats.miniquests", new Object[]{factionStats.getMiniQuestsCompleted()});
                            this.field_230712_o_.func_243248_b(matStack, (ITextComponent)facStat, (float)x, (float)(y += 9), 8019267);
                            this.field_230712_o_.getClass();
                            y += 9;
                            if (alignData.isPledgedTo(this.currentFaction) && (conq = factionStats.getConquestEarned()) != 0.0f) {
                                int conqInt = Math.round(conq);
                                facStat = new TranslationTextComponent("gui.lotr.factions.stats.conquest", new Object[]{conqInt});
                                this.field_230712_o_.func_243248_b(matStack, (ITextComponent)facStat, (float)x, (float)y, 8019267);
                                this.field_230712_o_.getClass();
                                y += 9;
                            }
                        }
                        if (alignment <= 0.0f) {
                            TranslationTextComponent stat = new TranslationTextComponent("gui.lotr.factions.stats.membersKilled", new Object[]{factionStats.getMembersKilled()});
                            this.field_230712_o_.func_243248_b(matStack, (ITextComponent)stat, (float)x, (float)y, 8019267);
                            this.field_230712_o_.getClass();
                            y += 9;
                        }
                        if (this.buttonOpenPledgeScreen.field_230694_p_ && alignData.isPledgedTo(this.currentFaction)) {
                            TranslationTextComponent pledgeText = new TranslationTextComponent("gui.lotr.factions.pledged");
                            int px = this.buttonOpenPledgeScreen.field_230690_l_ + this.buttonOpenPledgeScreen.func_230998_h_() + 8;
                            int n = this.buttonOpenPledgeScreen.field_230691_m_ + this.buttonOpenPledgeScreen.func_238483_d_() / 2;
                            this.field_230712_o_.getClass();
                            int py = n - 9 / 2;
                            this.field_230712_o_.func_243248_b(matStack, (ITextComponent)pledgeText, (float)px, (float)py, 0xFF0000);
                        }
                    }
                } else if (currentPage == Page.RANKS) {
                    FactionRank curRank = this.currentFaction.getRankFor(clientPD);
                    int[] minMax = this.scrollPaneAlliesEnemies.getMinMaxIndices(this.currentAlliesEnemies, this.numDisplayedAlliesEnemies);
                    for (index = minMax[0]; index <= minMax[1]; ++index) {
                        Object listObj = this.currentAlliesEnemies.get(index);
                        if (listObj instanceof String) {
                            String s = (String)listObj;
                            this.field_230712_o_.func_243248_b(matStack, (ITextComponent)new StringTextComponent(s), (float)x, (float)y, 8019267);
                        } else if (listObj instanceof FactionRank) {
                            FactionRank rank = (FactionRank)listObj;
                            StringTextComponent rankName = new StringTextComponent(rank.getDisplayShortName(clientPD.getMiscData().getPreferredRankGender()));
                            String rankAlign = AlignmentFormatter.formatAlignForDisplay(rank.getAlignment());
                            if (rank.isNameEqual("enemy")) {
                                rankAlign = "-";
                            }
                            boolean hiddenRankName = false;
                            if (!alignData.isPledgedTo(this.currentFaction) && rank.getAlignment() > this.currentFaction.getPledgeAlignment() && rank.getAlignment() > this.currentFaction.getRankAbove(curRank).getAlignment()) {
                                hiddenRankName = true;
                            }
                            if (hiddenRankName) {
                                rankName = new TranslationTextComponent("gui.lotr.factions.rank.unknown");
                            }
                            TranslationTextComponent listRank = new TranslationTextComponent("gui.lotr.factions.listRank", new Object[]{rankName, rankAlign});
                            if (rank == curRank) {
                                this.alignmentTextRenderer.drawAlignmentText(matStack, this.field_230712_o_, x, y, (ITextComponent)listRank, 1.0f);
                            } else {
                                this.field_230712_o_.func_243248_b(matStack, (ITextComponent)listRank, (float)x, (float)y, 8019267);
                            }
                        }
                        this.field_230712_o_.getClass();
                        y += 9;
                    }
                } else if (currentPage == Page.GOOD_RELATIONS || currentPage == Page.BAD_RELATIONS) {
                    int avgBgColor = LOTRClientUtil.computeAverageFactionPageColor(this.field_230706_i_, FACTIONS_TEXTURE, 20, 20, 120, 80);
                    int[] minMax = this.scrollPaneAlliesEnemies.getMinMaxIndices(this.currentAlliesEnemies, this.numDisplayedAlliesEnemies);
                    for (index = minMax[0]; index <= minMax[1]; ++index) {
                        Object listObj = this.currentAlliesEnemies.get(index);
                        if (listObj instanceof FactionRelation) {
                            FactionRelation rel = (FactionRelation)((Object)listObj);
                            TranslationTextComponent relText = new TranslationTextComponent("gui.lotr.factions.relationHeader", new Object[]{rel.getDisplayName()});
                            this.field_230712_o_.func_243248_b(matStack, (ITextComponent)relText, (float)x, (float)y, 8019267);
                        } else if (listObj instanceof Faction) {
                            Faction fac = (Faction)listObj;
                            TranslationTextComponent facText = new TranslationTextComponent("gui.lotr.factions.list", new Object[]{fac.getDisplayName()});
                            this.field_230712_o_.func_243248_b(matStack, (ITextComponent)facText, (float)x, (float)y, LOTRClientUtil.findContrastingColor(fac.getColor(), avgBgColor));
                        }
                        this.field_230712_o_.getClass();
                        y += 9;
                    }
                }
                if (this.scrollPaneAlliesEnemies.hasScrollBar) {
                    this.scrollPaneAlliesEnemies.drawScrollBar(matStack);
                }
            } else {
                int stringWidth = this.pageWidth - this.pageBorderLeft * 2;
                ArrayList<IReorderingProcessor> displayLines = new ArrayList<IReorderingProcessor>();
                if (this.isPledging) {
                    List<Faction> facsPreventingPledge = alignData.getFactionsPreventingPledgeTo(this.currentFaction);
                    if (facsPreventingPledge.isEmpty()) {
                        if (alignData.canMakeNewPledge()) {
                            if (alignData.canPledgeToNow(this.currentFaction)) {
                                TranslationTextComponent desc1 = new TranslationTextComponent("gui.lotr.factions.pledge.desc.1", new Object[]{this.currentFaction.getDisplayName()});
                                displayLines.addAll(this.field_230712_o_.func_238425_b_((ITextProperties)desc1, stringWidth));
                                displayLines.add(IReorderingProcessor.field_242232_a);
                                TranslationTextComponent desc2 = new TranslationTextComponent("gui.lotr.factions.pledge.desc.2");
                                displayLines.addAll(this.field_230712_o_.func_238425_b_((ITextProperties)desc2, stringWidth));
                            }
                        } else {
                            ITextComponent brokenPledgeName = Faction.getFactionOrUnknownDisplayName(alignData.getBrokenPledgeFaction());
                            TranslationTextComponent desc = new TranslationTextComponent("gui.lotr.factions.pledge.breakCooldown", new Object[]{this.currentFaction.getDisplayName(), brokenPledgeName});
                            displayLines.addAll(this.field_230712_o_.func_238425_b_((ITextProperties)desc, stringWidth));
                            displayLines.add(IReorderingProcessor.field_242232_a);
                            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                            this.field_230706_i_.func_110434_K().func_110577_a(FACTIONS_TEXTURE);
                            this.func_238474_b_(matStack, this.guiLeft + this.pageWidth / 2 - 97, this.guiTop + this.pageY + 56, 0, 240, 194, 16);
                            this.func_238474_b_(matStack, this.guiLeft + this.pageWidth / 2 - 75, this.guiTop + this.pageY + 60, 22, 232, MathHelper.func_76123_f((float)(alignData.getPledgeBreakCooldownFraction() * 150.0f)), 8);
                        }
                    } else {
                        Collections.sort(facsPreventingPledge, Comparator.comparing(alignData::getAlignment).reversed());
                        StringTextComponent facNames = new StringTextComponent("If you are reading this, something has gone hideously wrong.");
                        if (facsPreventingPledge.size() == 1) {
                            facNames = new TranslationTextComponent("gui.lotr.factions.pledge.enemies.1", new Object[]{facsPreventingPledge.get(0).getDisplayName()});
                        } else if (facsPreventingPledge.size() == 2) {
                            facNames = new TranslationTextComponent("gui.lotr.factions.pledge.enemies.2", new Object[]{facsPreventingPledge.get(0).getDisplayName(), facsPreventingPledge.get(1).getDisplayName()});
                        } else if (facsPreventingPledge.size() == 3) {
                            facNames = new TranslationTextComponent("gui.lotr.factions.pledge.enemies.3", new Object[]{facsPreventingPledge.get(0).getDisplayName(), facsPreventingPledge.get(1).getDisplayName(), facsPreventingPledge.get(2).getDisplayName()});
                        } else if (facsPreventingPledge.size() > 3) {
                            facNames = new TranslationTextComponent("gui.lotr.factions.pledge.enemies.3+", new Object[]{facsPreventingPledge.get(0).getDisplayName(), facsPreventingPledge.get(1).getDisplayName(), facsPreventingPledge.get(2).getDisplayName(), facsPreventingPledge.size() - 3});
                        }
                        TranslationTextComponent desc = new TranslationTextComponent("gui.lotr.factions.pledge.enemies", new Object[]{this.currentFaction.getDisplayName(), facNames});
                        displayLines.addAll(this.field_230712_o_.func_238425_b_((ITextProperties)desc, stringWidth));
                        displayLines.add(IReorderingProcessor.field_242232_a);
                    }
                } else if (this.isUnpledging) {
                    TranslationTextComponent desc1 = new TranslationTextComponent("gui.lotr.factions.unpledge.desc.1", new Object[]{this.currentFaction.getDisplayName()});
                    displayLines.addAll(this.field_230712_o_.func_238425_b_((ITextProperties)desc1, stringWidth));
                    displayLines.add(IReorderingProcessor.field_242232_a);
                    TranslationTextComponent desc2 = new TranslationTextComponent("gui.lotr.factions.unpledge.desc.2");
                    displayLines.addAll(this.field_230712_o_.func_238425_b_((ITextProperties)desc2, stringWidth));
                }
                for (IReorderingProcessor line : displayLines) {
                    this.field_230712_o_.func_238422_b_(matStack, line, (float)x, (float)y, 8019267);
                    this.field_230712_o_.getClass();
                    y += 9;
                }
            }
        }
        if (this.hasScrollBar()) {
            this.field_230706_i_.func_110434_K().func_110577_a(FACTIONS_TEXTURE);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_238474_b_(matStack, this.guiLeft + this.scrollBarX, this.guiTop + this.scrollBarY, 0, 128, this.scrollBarWidth, this.scrollBarHeight);
            int factions = currentFactionList.size();
            for (int index = 0; index < factions; ++index) {
                Faction faction = currentFactionList.get(index);
                float[] factionColors = faction.getColorComponents();
                float shade = 0.6f;
                RenderSystem.color4f((float)(factionColors[0] * shade), (float)(factionColors[1] * shade), (float)(factionColors[2] * shade), (float)1.0f);
                float fracMin = (float)index / (float)factions;
                float fracMax = (float)(index + 1) / (float)factions;
                float uMin = (float)this.scrollBarBorder + fracMin * (float)(this.scrollBarWidth - this.scrollBarBorder * 2);
                float uMax = (float)this.scrollBarBorder + fracMax * (float)(this.scrollBarWidth - this.scrollBarBorder * 2);
                float xMin = (float)(this.guiLeft + this.scrollBarX) + uMin;
                float xMax = (float)(this.guiLeft + this.scrollBarX) + uMax;
                float yMin = this.guiTop + this.scrollBarY + this.scrollBarBorder;
                float yMax = this.guiTop + this.scrollBarY + this.scrollBarHeight - this.scrollBarBorder;
                LOTRClientUtil.blitFloat((AbstractGui)this, matStack, xMin, yMin, 0.0f + uMin, (float)(128 + this.scrollBarBorder), xMax - xMin, yMax - yMin);
            }
            this.field_230706_i_.func_110434_K().func_110577_a(FACTIONS_TEXTURE);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (this.canScroll()) {
                int scroll = (int)(this.currentScroll * (float)(this.scrollBarWidth - this.scrollBarBorder * 2 - this.scrollWidgetWidth));
                this.func_238474_b_(matStack, this.guiLeft + this.scrollBarX + this.scrollBarBorder + scroll, this.guiTop + this.scrollBarY + this.scrollBarBorder, 0, 142, this.scrollWidgetWidth, this.scrollWidgetHeight);
            }
        }
        super.func_230430_a_(matStack, mouseX, mouseY, tick);
        this.renderButtonTooltipIfHovered(matStack, this.buttonFactionMap, (ITextProperties)new TranslationTextComponent("gui.lotr.factions.viewMap"), mouseX, mouseY);
        Page prevPage = currentPage.prev();
        Page nextPage = currentPage.next();
        if (prevPage != null) {
            this.renderButtonTooltipIfHovered(matStack, this.buttonPagePrev, (ITextProperties)prevPage.getDisplayName(), mouseX, mouseY);
        }
        if (nextPage != null) {
            this.renderButtonTooltipIfHovered(matStack, this.buttonPageNext, (ITextProperties)nextPage.getDisplayName(), mouseX, mouseY);
        }
        this.renderButtonTooltipIfHovered(matStack, this.buttonPreferredRanksMasc, (ITextProperties)new TranslationTextComponent("gui.lotr.factions.rankGender.masc"), mouseX, mouseY);
        this.renderButtonTooltipIfHovered(matStack, this.buttonPreferredRanksFem, (ITextProperties)new TranslationTextComponent("gui.lotr.factions.rankGender.fem"), mouseX, mouseY);
        this.renderButtonTooltipIfHovered(matStack, this.buttonToggleFriendlyFire, FriendlyFireToggleButton.getTooltipLines(), mouseX, mouseY);
        if (mouseOverAlignLock) {
            String alignLimit = AlignmentFormatter.formatAlignForDisplay(alignData.getPledgeEnemyAlignmentLimit(this.currentFaction));
            TranslationTextComponent lockDesc = new TranslationTextComponent("gui.lotr.factions.pledgeLocked", new Object[]{alignLimit, alignData.getPledgeFaction().getDisplayName()});
            int stringWidth = 200;
            this.func_238654_b_(matStack, this.field_230712_o_.func_238425_b_((ITextProperties)lockDesc, stringWidth), mouseX, mouseY);
        }
        if (mouseOverCivilianKills) {
            TranslationTextComponent civilianKills = new TranslationTextComponent(this.currentFaction.approvesCivilianKills() ? "gui.lotr.factions.civilianKills.yes" : "gui.lotr.factions.civilianKills.no");
            int stringWidth = 200;
            this.func_238654_b_(matStack, this.field_230712_o_.func_238425_b_((ITextProperties)civilianKills, stringWidth), mouseX, mouseY);
        }
    }

    private boolean hasScrollBar() {
        return currentFactionList.size() > 1;
    }

    private boolean canScroll() {
        return true;
    }

    private void processFactionScrollBar(int mouseX, int mouseY) {
        int i1 = this.guiLeft + this.scrollBarX;
        int j1 = this.guiTop + this.scrollBarY;
        int i2 = i1 + this.scrollBarWidth;
        int j2 = j1 + this.scrollBarHeight;
        if (!this.wasMouseDown && this.isMouseDown && mouseX >= i1 && mouseY >= j1 && mouseX < i2 && mouseY < j2) {
            this.isScrolling = this.canScroll();
        }
        if (!this.isMouseDown) {
            this.isScrolling = false;
        }
        this.wasMouseDown = this.isMouseDown;
        if (this.isScrolling) {
            this.currentScroll = ((float)(mouseX - i1) - (float)this.scrollWidgetWidth / 2.0f) / ((float)(i2 - i1) - (float)this.scrollWidgetWidth);
            this.currentScroll = MathHelper.func_76131_a((float)this.currentScroll, (float)0.0f, (float)1.0f);
            this.currentFactionIndex = Math.round(this.currentScroll * (float)(currentFactionList.size() - 1));
            this.scrollPaneAlliesEnemies.resetScroll();
        }
        if (currentPage == Page.GOOD_RELATIONS || currentPage == Page.BAD_RELATIONS || currentPage == Page.RANKS) {
            if (currentPage == Page.GOOD_RELATIONS) {
                List<Faction> friends;
                this.currentAlliesEnemies = new ArrayList();
                List<Faction> allies = this.currentFaction.getOthersOfRelation(FactionRelation.ALLY);
                if (!allies.isEmpty()) {
                    this.currentAlliesEnemies.add(FactionRelation.ALLY);
                    this.currentAlliesEnemies.addAll(allies);
                }
                if (!(friends = this.currentFaction.getOthersOfRelation(FactionRelation.FRIEND)).isEmpty()) {
                    if (!this.currentAlliesEnemies.isEmpty()) {
                        this.currentAlliesEnemies.add(null);
                    }
                    this.currentAlliesEnemies.add(FactionRelation.FRIEND);
                    this.currentAlliesEnemies.addAll(friends);
                }
            } else if (currentPage == Page.BAD_RELATIONS) {
                List<Faction> enemies;
                this.currentAlliesEnemies = new ArrayList();
                List<Faction> mortals = this.currentFaction.getOthersOfRelation(FactionRelation.MORTAL_ENEMY);
                if (!mortals.isEmpty()) {
                    this.currentAlliesEnemies.add(FactionRelation.MORTAL_ENEMY);
                    this.currentAlliesEnemies.addAll(mortals);
                }
                if (!(enemies = this.currentFaction.getOthersOfRelation(FactionRelation.ENEMY)).isEmpty()) {
                    if (!this.currentAlliesEnemies.isEmpty()) {
                        this.currentAlliesEnemies.add(null);
                    }
                    this.currentAlliesEnemies.add(FactionRelation.ENEMY);
                    this.currentAlliesEnemies.addAll(enemies);
                }
            } else if (currentPage == Page.RANKS) {
                this.currentAlliesEnemies = new ArrayList();
                this.currentAlliesEnemies.add(new TranslationTextComponent("gui.lotr.factions.ranksHeader"));
                if (LOTRLevelData.clientInstance().getData((PlayerEntity)this.field_230706_i_.field_71439_g).getAlignmentData().getAlignment(this.currentFaction) <= 0.0f) {
                    this.currentAlliesEnemies.add(this.currentFaction.getEnemyRank());
                }
                FactionRank rank = this.currentFaction.getNeutralRank();
                while (true) {
                    this.currentAlliesEnemies.add(rank);
                    FactionRank nextRank = this.currentFaction.getRankAbove(rank);
                    if (nextRank == null || nextRank.isDummyRank() || this.currentAlliesEnemies.contains(nextRank)) break;
                    rank = nextRank;
                }
            }
            this.scrollPaneAlliesEnemies.hasScrollBar = false;
            this.numDisplayedAlliesEnemies = this.currentAlliesEnemies.size();
            if (this.numDisplayedAlliesEnemies > 10) {
                this.numDisplayedAlliesEnemies = 10;
                this.scrollPaneAlliesEnemies.hasScrollBar = true;
            }
            this.scrollPaneAlliesEnemies.paneX0 = this.guiLeft;
            this.scrollPaneAlliesEnemies.scrollBarX0 = this.guiLeft + this.scrollAlliesEnemiesX;
            if (currentPage == Page.RANKS) {
                this.scrollPaneAlliesEnemies.scrollBarX0 += 50;
            }
            int n = this.scrollPaneAlliesEnemies.paneY0 = this.guiTop + this.pageY + this.pageBorderTop;
            this.field_230712_o_.getClass();
            this.scrollPaneAlliesEnemies.paneY1 = n + 9 * this.numDisplayedAlliesEnemies;
            this.scrollPaneAlliesEnemies.mouseDragScroll(mouseX, mouseY, this.isMouseDown);
        } else {
            this.scrollPaneAlliesEnemies.hasScrollBar = false;
            this.scrollPaneAlliesEnemies.mouseDragScroll(mouseX, mouseY, this.isMouseDown);
        }
    }

    @Override
    public boolean func_231046_a_(int key, int scan, int param3) {
        if (this.isEscapeOrInventoryKey(key, scan)) {
            if (this.isPledging) {
                this.isPledging = false;
                return true;
            }
            if (this.isUnpledging) {
                this.isUnpledging = false;
                return true;
            }
            if (this.isOtherPlayer) {
                this.field_230706_i_.field_71439_g.func_71053_j();
                return true;
            }
        }
        return super.func_231046_a_(key, scan, param3);
    }

    public boolean func_231044_a_(double x, double y, int code) {
        if (code == 0) {
            this.isMouseDown = true;
        }
        return super.func_231044_a_(x, y, code);
    }

    public boolean func_231048_c_(double x, double y, int code) {
        if (code == 0) {
            this.isMouseDown = false;
        }
        return super.func_231048_c_(x, y, code);
    }

    public boolean func_231043_a_(double x, double y, double scroll) {
        if (super.func_231043_a_(x, y, scroll)) {
            return true;
        }
        if (scroll != 0.0) {
            if (this.scrollPaneAlliesEnemies.hasScrollBar && this.scrollPaneAlliesEnemies.mouseOver) {
                int l = this.currentAlliesEnemies.size() - this.numDisplayedAlliesEnemies;
                this.scrollPaneAlliesEnemies.mouseWheelScroll(scroll, l);
                return true;
            }
            if (scroll < 0.0) {
                this.currentFactionIndex = Math.min(this.currentFactionIndex + 1, Math.max(0, currentFactionList.size() - 1));
            }
            if (scroll > 0.0) {
                this.currentFactionIndex = Math.max(this.currentFactionIndex - 1, 0);
            }
            this.setCurrentScrollFromFaction();
            this.scrollPaneAlliesEnemies.resetScroll();
            this.isPledging = false;
            this.isUnpledging = false;
            return true;
        }
        return false;
    }

    private void setCurrentScrollFromFaction() {
        this.currentScroll = (float)this.currentFactionIndex / (float)(currentFactionList.size() - 1);
    }

    static {
        currentPage = Page.OVERVIEW;
    }

    public static enum Page {
        OVERVIEW("overview"),
        RANKS("ranks"),
        GOOD_RELATIONS("goodRelations"),
        BAD_RELATIONS("badRelations");

        private final String pageName;

        private Page(String name) {
            this.pageName = name;
        }

        public ITextComponent getDisplayName() {
            return new TranslationTextComponent("gui.lotr.factions.page." + this.pageName);
        }

        public Page prev() {
            int i = this.ordinal();
            if (i == 0) {
                return null;
            }
            return Page.values()[--i];
        }

        public Page next() {
            int i = this.ordinal();
            if (i == Page.values().length - 1) {
                return null;
            }
            return Page.values()[++i];
        }
    }
}

