/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import lotr.client.gui.BasicIngameScreen;
import lotr.client.gui.MiddleEarthFactionsScreen;
import lotr.client.gui.MiddleEarthMenuScreen;
import lotr.client.gui.map.MiddleEarthMapScreen;
import lotr.client.gui.widget.button.MiddleEarthMenuButton;
import lotr.common.init.LOTRDimensions;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class MiddleEarthMasterMenuScreen
extends BasicIngameScreen {
    public static final ResourceLocation MENU_ICONS = new ResourceLocation("lotr", "textures/gui/menu_icons.png");
    public static Class<? extends MiddleEarthMenuScreen> lastMenuScreen = null;

    public MiddleEarthMasterMenuScreen() {
        super((ITextComponent)new StringTextComponent("MENU"));
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        MiddleEarthMasterMenuScreen.resetLastMenuScreen();
        int midX = this.field_230708_k_ / 2;
        int midY = this.field_230709_l_ / 2;
        int buttonGap = 10;
        int buttonSize = 32;
        this.func_230480_a_((Widget)new MiddleEarthMenuButton(0, 0, MiddleEarthMapScreen.class, (ITextComponent)new TranslationTextComponent("gui.lotr.menu.map"), 3, 77));
        this.func_230480_a_((Widget)new MiddleEarthMenuButton(0, 0, MiddleEarthFactionsScreen.class, (ITextComponent)new TranslationTextComponent("gui.lotr.menu.factions"), 4, 70));
        this.func_230480_a_((Widget)new MiddleEarthMenuButton(0, 0, null, (ITextComponent)new StringTextComponent("?"), 0, -1));
        ArrayList<MiddleEarthMenuButton> menuButtonsToArrange = new ArrayList<MiddleEarthMenuButton>();
        for (Widget widget : this.field_230710_m_) {
            if (!(widget instanceof MiddleEarthMenuButton)) continue;
            MiddleEarthMenuButton menuButton = (MiddleEarthMenuButton)widget;
            menuButton.field_230693_o_ = menuButton.canDisplayMenu();
            menuButtonsToArrange.add(menuButton);
        }
        int numButtons = menuButtonsToArrange.size();
        int numTopRowButtons = (numButtons - 1) / 2 + 1;
        int numBtmRowButtons = numButtons - numTopRowButtons;
        int topRowLeft = midX - (numTopRowButtons * buttonSize + (numTopRowButtons - 1) * buttonGap) / 2;
        int btmRowLeft = midX - (numBtmRowButtons * buttonSize + (numBtmRowButtons - 1) * buttonGap) / 2;
        for (int l = 0; l < numButtons; ++l) {
            MiddleEarthMenuButton button = (MiddleEarthMenuButton)((Object)menuButtonsToArrange.get(l));
            if (l < numTopRowButtons) {
                button.field_230690_l_ = topRowLeft + l * (buttonSize + buttonGap);
                button.field_230691_m_ = midY - buttonGap / 2 - buttonSize;
                continue;
            }
            button.field_230690_l_ = btmRowLeft + (l - numTopRowButtons) * (buttonSize + buttonGap);
            button.field_230691_m_ = midY + buttonGap / 2;
        }
    }

    public static void resetLastMenuScreen() {
        lastMenuScreen = null;
    }

    public void func_230430_a_(MatrixStack matStack, int mouseX, int mouseY, float tick) {
        this.func_230446_a_(matStack);
        ITextComponent dimensionName = LOTRDimensions.getDisplayName(LOTRDimensions.getCurrentLOTRDimensionOrFallback((World)this.field_230706_i_.field_71441_e));
        TranslationTextComponent title = new TranslationTextComponent("gui.lotr.menu", new Object[]{dimensionName});
        this.field_230712_o_.func_243246_a(matStack, (ITextComponent)title, (float)(this.field_230708_k_ / 2 - this.field_230712_o_.func_238414_a_((ITextProperties)title) / 2), (float)(this.field_230709_l_ / 2 - 80), 0xFFFFFF);
        super.func_230430_a_(matStack, mouseX, mouseY, tick);
        for (Widget widget : this.field_230710_m_) {
            MiddleEarthMenuButton menuButton;
            if (!(widget instanceof MiddleEarthMenuButton) || !(menuButton = (MiddleEarthMenuButton)widget).func_230449_g_() || menuButton.func_230458_i_() == null) continue;
            this.func_238652_a_(matStack, menuButton.func_230458_i_(), mouseX, mouseY);
        }
    }

    @Override
    public boolean func_231046_a_(int key, int scan, int param3) {
        for (Widget widget : this.field_230710_m_) {
            if (!(widget instanceof MiddleEarthMenuButton)) continue;
            MiddleEarthMenuButton menuButton = (MiddleEarthMenuButton)widget;
            if (!menuButton.field_230694_p_ || !menuButton.field_230693_o_ || menuButton.menuKeyCode < 0 || key != menuButton.menuKeyCode) continue;
            menuButton.func_230930_b_();
            return true;
        }
        return super.func_231046_a_(key, scan, param3);
    }

    public static Screen openMenu(PlayerEntity player) {
        if (lastMenuScreen != null) {
            try {
                return lastMenuScreen.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new MiddleEarthMasterMenuScreen();
    }
}

