/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.gui.map;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lotr.client.LOTRKeyHandler;
import lotr.client.MapImageTextures;
import lotr.client.gui.MiddleEarthFactionsScreen;
import lotr.client.gui.MiddleEarthMenuScreen;
import lotr.client.gui.map.MapPlayerLocationHolder;
import lotr.client.gui.map.MapWidget;
import lotr.client.gui.map.MarkerTooltipRenderer;
import lotr.client.gui.map.WaypointTooltipRenderer;
import lotr.client.gui.util.AlignmentTextRenderer;
import lotr.client.util.LOTRClientUtil;
import lotr.common.config.LOTRConfig;
import lotr.common.data.FastTravelDataModule;
import lotr.common.data.FogDataModule;
import lotr.common.data.LOTRLevelData;
import lotr.common.data.LOTRPlayerData;
import lotr.common.fac.AreaBorders;
import lotr.common.fac.AreaOfInfluence;
import lotr.common.fac.AreasOfInfluence;
import lotr.common.fac.Faction;
import lotr.common.init.LOTRBiomes;
import lotr.common.init.LOTRDimensions;
import lotr.common.init.LOTRItems;
import lotr.common.network.CPacketCreateMapMarker;
import lotr.common.network.CPacketDeleteMapMarker;
import lotr.common.network.CPacketFastTravel;
import lotr.common.network.CPacketIsOpRequest;
import lotr.common.network.CPacketMapTp;
import lotr.common.network.LOTRPacketHandler;
import lotr.common.util.LOTRUtil;
import lotr.common.world.map.GeneratedRoadPoint;
import lotr.common.world.map.MapLabel;
import lotr.common.world.map.MapMarker;
import lotr.common.world.map.MapPlayerLocation;
import lotr.common.world.map.MapSettings;
import lotr.common.world.map.MapSettingsManager;
import lotr.common.world.map.MapWaypoint;
import lotr.common.world.map.Road;
import lotr.common.world.map.RoadSection;
import lotr.common.world.map.RouteRoadPoint;
import lotr.common.world.map.SelectableMapObject;
import lotr.common.world.map.Waypoint;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.network.play.NetworkPlayerInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.InputMappings;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.profiler.IProfiler;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import org.lwjgl.opengl.GL11;

public class MiddleEarthMapScreen
extends MiddleEarthMenuScreen {
    private static final ItemStack QUEST_ICON = new ItemStack((IItemProvider)LOTRItems.RED_BOOK.get());
    public static final int BLACK = -16777216;
    public static final int BORDER_COLOR = -6156032;
    private static final int MAP_BORDER = 30;
    private static boolean fullscreen = true;
    private final MapSettings loadedMapSettings;
    private int viewportWidth;
    private int viewportHeight;
    private int viewportXMin;
    private int viewportXMax;
    private int viewportYMin;
    private int viewportYMax;
    private List<MapWidget> mapWidgets = new ArrayList<MapWidget>();
    private MapWidget widgetZoomIn;
    private MapWidget widgetZoomOut;
    private MapWidget widgetRecentre;
    private MapWidget widgetFullScreen;
    private MapWidget widgetSepia;
    private MapWidget widgetLabels;
    private MapWidget widgetToggleMapWPs;
    private MapWidget widgetToggleCustomWPs;
    private MapWidget widgetToggleShowLocation;
    private MapWidget widgetToggleMarkers;
    private MapWidget widgetNewMarker;
    private int tickCounter;
    private int renderedMapObjects;
    private double posX;
    private double posY;
    private double prevPosX;
    private double prevPosY;
    private double posXMove;
    private double posYMove;
    private int isMouseButtonDown;
    private int prevMouseX;
    private int prevMouseY;
    private boolean isMouseWithinMap;
    private int mouseXCoord;
    private int mouseZCoord;
    private double recentreToX;
    private double recentreToY;
    private double recentreFromX;
    private double recentreFromY;
    private int recentreTicks;
    private static final int RECENTRE_TIME = 6;
    private static final int MIN_ZOOM = -3;
    private static final int MAX_ZOOM = 4;
    private static float zoomPower = 0.0f;
    private float prevZoomPower = zoomPower;
    private float zoomScale;
    private float zoomScaleStable;
    private float zoomExp;
    private static final int ZOOM_TIME = 6;
    private int zoomTicks;
    private int prevZoomTicks;
    public boolean enableZoomOutObjectFading = true;
    private static final DecimalFormat ZOOM_DISPLAY_FORMAT = new DecimalFormat("0.##");
    private int zoomingMessageDisplayTicks;
    private static final int ZOOMING_MESSAGE_DISPLAY_TIME = 30;
    private boolean zoomingMessageIsZoomIn;
    private SelectableMapObject mouseOverObject;
    private SelectableMapObject selectedObject;
    private static final int OBJECT_SELECT_RANGE = 5;
    private int objectSelectTick;
    private int prevObjectSelectTick;
    private static final int OBJECT_SELECT_TIME = 6;
    private final WaypointTooltipRenderer waypointTooltip = new WaypointTooltipRenderer();
    private final MarkerTooltipRenderer markerTooltip = new MarkerTooltipRenderer();
    private boolean creatingMarker;
    private static final int MARKER_W = 10;
    private boolean hasOverlay;
    private boolean isPlayerOp = false;
    private boolean sentOpRequestPacket = false;
    private Faction areaOfInfluenceFaction;
    private boolean mouseInAreaOfInfluence;
    private boolean mouseInReducedAreaOfInfluence;
    private final AlignmentTextRenderer alignmentTextRenderer = AlignmentTextRenderer.newGUIRenderer();
    private boolean isFacScrolling = false;

    public MiddleEarthMapScreen() {
        super((ITextComponent)new StringTextComponent("MAP"));
        this.loadedMapSettings = MapSettingsManager.clientInstance().getLoadedMapOrLoadDefault(Minecraft.func_71410_x().func_195551_G());
        this.loadCurrentMapTextures();
    }

    public void loadCurrentMapTextures() {
        MapImageTextures.INSTANCE.loadMapTexturesIfNew(this.loadedMapSettings);
    }

    public void setAreasOfInfluence(Faction faction) {
        this.areaOfInfluenceFaction = faction;
    }

    private boolean hasAreasOfInfluence() {
        return this.areaOfInfluenceFaction != null && AreasOfInfluence.areAreasOfInfluenceEnabled((World)this.field_230706_i_.field_71441_e);
    }

    @Override
    public void func_231160_c_() {
        this.xSize = 256;
        this.ySize = 256;
        super.func_231160_c_();
        if (fullscreen) {
            int midX = this.field_230708_k_ / 2;
            int titleWidth = this.field_230712_o_.func_238414_a_((ITextProperties)this.getMapTitle());
            int idealMargin = 24;
            int minimumGapFromTitle = 4;
            this.buttonMenuReturn.field_230690_l_ = Math.min(0 + idealMargin, midX - titleWidth / 2 - minimumGapFromTitle - this.buttonMenuReturn.func_230998_h_());
            this.buttonMenuReturn.field_230691_m_ = 4;
        }
        if (this.hasAreasOfInfluence()) {
            this.removeButton((Widget)this.buttonMenuReturn);
        }
        this.setupMapDimensions();
        this.setupMapWidgets();
        this.field_230705_e_.add(new MapDragListener());
        if (this.hasAreasOfInfluence()) {
            this.setupMapDimensions();
            AreaBorders zoneBorders = this.areaOfInfluenceFaction.getAreasOfInfluence().calculateAreaOfInfluenceBordersIncludingReduced();
            this.posX = this.loadedMapSettings.worldToMapX_frac(zoneBorders.getXCentre());
            this.posY = this.loadedMapSettings.worldToMapZ_frac(zoneBorders.getZCentre());
            double mapZoneWidth = this.loadedMapSettings.worldToMapDistance(zoneBorders.getWidth());
            double mapZoneHeight = this.loadedMapSettings.worldToMapDistance(zoneBorders.getHeight());
            int zoomPowerWidth = MathHelper.func_76128_c((double)(Math.log((double)this.viewportWidth / mapZoneWidth) / Math.log(2.0)));
            int zoomPowerHeight = MathHelper.func_76128_c((double)(Math.log((double)this.viewportHeight / mapZoneHeight) / Math.log(2.0)));
            this.prevZoomPower = zoomPower = (float)Math.min(zoomPowerWidth, zoomPowerHeight);
        } else if (this.field_230706_i_.field_71439_g != null) {
            this.centreMapOnPlayer();
        }
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.refreshZoomVariables(1.0f);
        this.waypointTooltip.init(this, this.field_230706_i_, this.field_230712_o_);
        this.markerTooltip.init(this, this.field_230706_i_, this.field_230712_o_);
    }

    private void setupMapWidgets() {
        this.mapWidgets.clear();
        this.widgetZoomIn = new MapWidget(this, this.viewportXMin + 6, this.viewportYMin + 6, 10, "zoomIn", 30, 0, () -> {
            if (this.zoomTicks == 0 && zoomPower < 4.0f) {
                this.zoomIn();
                return true;
            }
            return false;
        });
        this.mapWidgets.add(this.widgetZoomIn);
        this.widgetZoomOut = new MapWidget(this, this.viewportXMin + 6, this.viewportYMin + 20, 10, "zoomOut", 40, 0, () -> {
            if (this.zoomTicks == 0 && zoomPower > -3.0f) {
                this.zoomOut();
                return true;
            }
            return false;
        });
        this.mapWidgets.add(this.widgetZoomOut);
        this.widgetRecentre = new MapWidget(this, this.viewportXMin + 20, this.viewportYMin + 6, 10, "recentre", 50, 10, () -> {
            if (!this.isRecentringOnPlayer()) {
                this.recentreMapOnPlayer();
                return true;
            }
            return false;
        });
        this.mapWidgets.add(this.widgetRecentre);
        this.widgetFullScreen = new MapWidget(this, this.viewportXMin + 34, this.viewportYMin + 6, 10, "fullScreen", 50, 0, () -> {
            fullscreen = !fullscreen;
            this.func_231158_b_(this.field_230706_i_, this.field_230706_i_.func_228018_at_().func_198107_o(), this.field_230706_i_.func_228018_at_().func_198087_p());
            return true;
        });
        this.mapWidgets.add(this.widgetFullScreen);
        this.widgetSepia = new MapWidget(this, this.viewportXMin + 48, this.viewportYMin + 6, 10, "sepia", 60, 0, () -> {
            LOTRConfig.CLIENT.toggleSepia();
            return true;
        });
        this.mapWidgets.add(this.widgetSepia);
        this.widgetLabels = new MapWidget(this, this.viewportXMax - 16, this.viewportYMin + 6, 10, "labels", 70, 0, () -> {
            this.toggleMapLabels();
            return true;
        });
        this.mapWidgets.add(this.widgetLabels);
        this.widgetToggleMapWPs = new MapWidget(this, this.viewportXMax - 72, this.viewportYMin + 6, 10, "toggleMapWPs", 80, 0, () -> {
            this.getOptClientPlayerData().ifPresent(pd -> pd.getFastTravelData().toggleShowMapWaypointsAndSendToServer());
            return true;
        });
        this.mapWidgets.add(this.widgetToggleMapWPs);
        this.widgetToggleCustomWPs = new MapWidget(this, this.viewportXMax - 58, this.viewportYMin + 6, 10, "toggleCustomWPs", 90, 0, () -> {
            this.getOptClientPlayerData().ifPresent(pd -> pd.getFastTravelData().toggleShowCustomWaypointsAndSendToServer());
            return true;
        });
        this.mapWidgets.add(this.widgetToggleCustomWPs);
        this.widgetToggleShowLocation = new MapWidget(this, this.viewportXMax - 16, this.viewportYMin + 20, 10, "toggleShowLocation", 60, 10, () -> {
            this.getOptClientPlayerData().ifPresent(pd -> pd.getMiscData().toggleShowMapLocationAndSendToServer());
            return true;
        });
        this.mapWidgets.add(this.widgetToggleShowLocation);
        this.widgetToggleMarkers = new MapWidget(this, this.viewportXMax - 44, this.viewportYMin + 6, 10, "toggleMarkers", 110, 0, () -> {
            this.getOptClientPlayerData().ifPresent(pd -> pd.getMapMarkerData().toggleShowMarkersAndSendToServer());
            return true;
        });
        this.mapWidgets.add(this.widgetToggleMarkers);
        this.widgetNewMarker = new MapWidget(this, this.viewportXMax - 30, this.viewportYMin + 6, 10, "newMarker", 120, 0, () -> {
            if (!this.creatingMarker && this.canCreateNewMarker()) {
                this.creatingMarker = true;
                return true;
            }
            return false;
        });
        this.mapWidgets.add(this.widgetNewMarker);
        this.field_230705_e_.addAll(this.mapWidgets);
    }

    public boolean hasOverlay() {
        return this.hasOverlay;
    }

    private void setupMapDimensions() {
        if (fullscreen) {
            this.viewportXMin = 30;
            this.viewportXMax = this.field_230708_k_ - 30;
            this.viewportYMin = 30;
            this.viewportYMax = this.field_230709_l_ - 30;
        } else {
            int windowWidth = 312;
            this.viewportXMin = this.field_230708_k_ / 2 - windowWidth / 2;
            this.viewportXMax = this.field_230708_k_ / 2 + windowWidth / 2;
            this.viewportYMin = this.guiTop;
            this.viewportYMax = this.guiTop + 200;
        }
        this.viewportWidth = this.viewportXMax - this.viewportXMin;
        this.viewportHeight = this.viewportYMax - this.viewportYMin;
    }

    private void centreMapOnPlayer() {
        this.posX = this.getPlayerMapPosX();
        this.posY = this.getPlayerMapPosY();
    }

    private double getPlayerMapPosX() {
        return this.loadedMapSettings.worldToMapX_frac(this.field_230706_i_.field_71439_g.func_226277_ct_());
    }

    private double getPlayerMapPosY() {
        return this.loadedMapSettings.worldToMapZ_frac(this.field_230706_i_.field_71439_g.func_226281_cx_());
    }

    private double lerpPosX(float tick) {
        return MathHelper.func_151238_b((double)this.prevPosX, (double)this.posX, (double)tick);
    }

    private double lerpPosY(float tick) {
        return MathHelper.func_151238_b((double)this.prevPosY, (double)this.posY, (double)tick);
    }

    public double[] transformWorldCoords(double x, double z, float tick) {
        x = this.loadedMapSettings.worldToMapX_frac(x);
        z = this.loadedMapSettings.worldToMapZ_frac(z);
        return this.transformMapCoords(x, z, tick);
    }

    public double[] transformMapCoords(double x, double z, float tick) {
        x -= this.lerpPosX(tick);
        z -= this.lerpPosY(tick);
        x *= (double)this.zoomScale;
        z *= (double)this.zoomScale;
        return new double[]{x += (double)(this.viewportXMin + this.viewportWidth / 2), z += (double)(this.viewportYMin + this.viewportHeight / 2)};
    }

    private double[] convertMouseCoordsToMapCoords(int mouseX, int mouseY, float tick) {
        double mapPosX = this.lerpPosX(tick) + (double)((float)(mouseX - this.viewportXMin - this.viewportWidth / 2) / this.zoomScale);
        double mapPosZ = this.lerpPosY(tick) + (double)((float)(mouseY - this.viewportYMin - this.viewportHeight / 2) / this.zoomScale);
        return new double[]{mapPosX, mapPosZ};
    }

    private ITextComponent getMapTitle() {
        return new TranslationTextComponent("gui.lotr.map.title", new Object[]{this.loadedMapSettings.getTitle()});
    }

    private Optional<LOTRPlayerData> getOptClientPlayerData() {
        return Optional.ofNullable(this.field_230706_i_.field_71439_g).map(LOTRLevelData.clientInstance()::getData);
    }

    public LOTRPlayerData getClientPlayerData() {
        return this.getOptClientPlayerData().get();
    }

    private boolean showLocationToOthers() {
        return this.getOptClientPlayerData().map(pd -> pd.getMiscData().getShowMapLocation()).orElse(true);
    }

    private boolean showMapWaypoints() {
        return this.getOptClientPlayerData().map(pd -> pd.getFastTravelData().getShowMapWaypoints()).orElse(true);
    }

    private boolean showCustomWaypoints() {
        return this.getOptClientPlayerData().map(pd -> pd.getFastTravelData().getShowCustomWaypoints()).orElse(false);
    }

    private boolean showHiddenSharedCustomWaypoints() {
        return true;
    }

    private boolean showMarkers() {
        return this.getOptClientPlayerData().map(pd -> pd.getMapMarkerData().getShowMarkers()).orElse(false);
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        ++this.tickCounter;
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.handleMapKeyboardMovement();
        this.posX += this.posXMove;
        this.posY += this.posYMove;
        if (this.recentreTicks > 0) {
            --this.recentreTicks;
            float lerp = (float)(6 - this.recentreTicks) / 6.0f;
            this.posX = MathHelper.func_219803_d((double)lerp, (double)this.recentreFromX, (double)this.recentreToX);
            this.posY = MathHelper.func_219803_d((double)lerp, (double)this.recentreFromY, (double)this.recentreToY);
        }
        this.keepMapPositionWithinBounds();
        if (this.zoomTicks <= 0 && this.prevZoomTicks > 0) {
            this.prevZoomPower = zoomPower;
        }
        this.prevZoomTicks = this.zoomTicks;
        if (this.zoomTicks > 0) {
            --this.zoomTicks;
        }
        if (this.zoomingMessageDisplayTicks > 0) {
            --this.zoomingMessageDisplayTicks;
        }
        this.prevObjectSelectTick = this.objectSelectTick;
        if (this.objectSelectTick > 0) {
            --this.objectSelectTick;
        }
        this.waypointTooltip.tick();
        this.markerTooltip.tick();
    }

    private void refreshZoomVariables(float tick) {
        float zoomStableExp;
        if (this.zoomTicks > 0 || this.prevZoomTicks > 0) {
            float zoomTickLerp = (float)this.prevZoomTicks + (float)(this.zoomTicks - this.prevZoomTicks) * tick;
            float progress = (6.0f - zoomTickLerp) / 6.0f;
            this.zoomExp = this.prevZoomPower + (zoomPower - this.prevZoomPower) * progress;
            zoomStableExp = Math.min(zoomPower, this.prevZoomPower);
        } else {
            zoomStableExp = this.zoomExp = zoomPower;
        }
        this.zoomScale = (float)Math.pow(2.0, this.zoomExp);
        this.zoomScaleStable = (float)Math.pow(2.0, zoomStableExp);
        this.keepMapPositionWithinBounds();
    }

    public void func_230430_a_(MatrixStack matStack, int mouseX, int mouseY, float tick) {
        Waypoint selectedWp;
        tick = this.field_230706_i_.func_184121_ak();
        ClientWorld world = this.field_230706_i_.field_71441_e;
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buf = tess.func_178180_c();
        boolean blit0 = false;
        this.func_230926_e_(0);
        this.renderedMapObjects = 0;
        this.refreshZoomVariables(tick);
        this.isMouseWithinMap = mouseX >= this.viewportXMin && mouseX < this.viewportXMax && mouseY >= this.viewportYMin && mouseY < this.viewportYMax;
        boolean isSepia = (Boolean)LOTRConfig.CLIENT.sepiaMap.get();
        if (fullscreen) {
            this.field_230706_i_.func_110434_K().func_110577_a(MapImageTextures.OVERLAY_TEXTURE);
            RenderSystem.color4f((float)0.65f, (float)0.5f, (float)0.35f, (float)1.0f);
            float z = this.func_230927_p_();
            buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            Matrix4f mat = matStack.func_227866_c_().func_227870_a_();
            buf.func_227888_a_(mat, 0.0f, (float)this.field_230709_l_, z).func_225583_a_(0.0f, 1.0f).func_181675_d();
            buf.func_227888_a_(mat, (float)this.field_230708_k_, (float)this.field_230709_l_, z).func_225583_a_(1.0f, 1.0f).func_181675_d();
            buf.func_227888_a_(mat, (float)this.field_230708_k_, 0.0f, z).func_225583_a_(1.0f, 0.0f).func_181675_d();
            buf.func_227888_a_(mat, 0.0f, 0.0f, z).func_225583_a_(0.0f, 0.0f).func_181675_d();
            tess.func_78381_a();
            int redW = 4;
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.renderGraduatedRects(matStack, this.viewportXMin - 1, this.viewportYMin - 1, this.viewportXMax + 1, this.viewportYMax + 1, -6156032, -16777216, redW);
        } else {
            this.func_230446_a_(matStack);
            this.renderGraduatedRects(matStack, this.viewportXMin - 1, this.viewportYMin - 1, this.viewportXMax + 1, this.viewportYMax + 1, -6156032, -16777216, 4);
        }
        this.setupScrollBars(mouseX, mouseY);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int seaColor = MapImageTextures.INSTANCE.getMapBackgroundColor(isSepia);
        MiddleEarthMapScreen.func_238467_a_((MatrixStack)matStack, (int)this.viewportXMin, (int)this.viewportYMin, (int)this.viewportXMax, (int)this.viewportYMax, (int)seaColor);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ITextComponent title = this.getMapTitle();
        if (fullscreen) {
            this.drawCenteredStringNoShadow(matStack, this.field_230712_o_, title, this.field_230708_k_ / 2, 10, 0xFFFFFF);
        } else {
            this.drawCenteredStringNoShadow(matStack, this.field_230712_o_, title, this.field_230708_k_ / 2, this.guiTop - 30, 0xFFFFFF);
        }
        if (this.hasAreasOfInfluence()) {
            this.renderMapAndOverlay(matStack, tick, isSepia, 1.0f, false);
            this.renderAreasOfInfluence(matStack, mouseX, mouseY, tick);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            this.renderMapAndOverlay(matStack, tick, isSepia, 0.5f, true);
            RenderSystem.disableBlend();
        } else {
            this.renderMapAndOverlay(matStack, tick, isSepia, 1.0f, true);
        }
        this.renderRoads(matStack, tick);
        this.renderLabels(matStack, tick);
        this.renderFogOfWar(matStack, tick);
        this.renderPlayers(matStack, mouseX, mouseY, tick);
        this.determineMouseOverObject(mouseX, mouseY, tick);
        this.renderWaypoints(matStack, 0, mouseX, mouseY, tick);
        this.renderMarkers(matStack, 0, mouseX, mouseY, tick);
        RenderSystem.enableAlphaTest();
        MapImageTextures.drawMapCompassBottomLeft(matStack, this.viewportXMin + 12, this.viewportYMax - 12, 100.0f, 1.0f);
        this.renderWaypoints(matStack, 1, mouseX, mouseY, tick);
        this.renderMarkers(matStack, 1, mouseX, mouseY, tick);
        if (this.creatingMarker) {
            this.renderCreatingMarker(matStack, mouseX, mouseY);
        }
        if (this.hasAreasOfInfluence()) {
            TranslationTextComponent tooltip;
            Object object = this.mouseInAreaOfInfluence ? new TranslationTextComponent("gui.lotr.map.areaOfInfluence.full") : (tooltip = this.mouseInReducedAreaOfInfluence ? new TranslationTextComponent("gui.lotr.map.areaOfInfluence.reduced") : null);
            if (tooltip != null) {
                this.renderInFront(() -> this.lambda$render$19((ITextComponent)tooltip, mouseX, mouseY, matStack));
            }
        }
        if (!this.hasOverlay && this.selectedObject != null) {
            if (this.selectedObject instanceof Waypoint) {
                selectedWp = (Waypoint)this.selectedObject;
                if (this.isWaypointVisible(selectedWp)) {
                    this.renderWaypointTooltip(matStack, selectedWp, true, mouseX, mouseY, tick);
                } else {
                    this.selectObject(null);
                }
            } else if (this.selectedObject instanceof MapMarker) {
                MapMarker selectedMarker = (MapMarker)this.selectedObject;
                if (this.showMarkers()) {
                    this.renderMarkerTooltip(matStack, selectedMarker, true, mouseX, mouseY, tick);
                } else {
                    this.selectObject(null);
                }
            }
        }
        this.func_230926_e_(100);
        if (!this.hasOverlay) {
            if (this.isMiddleEarth() && this.selectedObject instanceof Waypoint) {
                selectedWp = (Waypoint)this.selectedObject;
                int blit1 = this.func_230927_p_();
                this.func_230926_e_(500);
                LOTRPlayerData pd = this.getClientPlayerData();
                FastTravelDataModule ftData = pd.getFastTravelData();
                boolean hasUnlocked = selectedWp.hasPlayerUnlocked((PlayerEntity)this.field_230706_i_.field_71439_g);
                int ftSince = ftData.getTimeSinceFT();
                int wpTimeThreshold = ftData.getWaypointFTTime(selectedWp, (PlayerEntity)this.field_230706_i_.field_71439_g);
                int timeRemaining = wpTimeThreshold - ftSince;
                boolean canFastTravel = hasUnlocked && timeRemaining <= 0;
                ITextComponent notUnlockedMessage = selectedWp.getNotUnlockedMessage((PlayerEntity)this.field_230706_i_.field_71439_g);
                TranslationTextComponent ftPrompt = new TranslationTextComponent("gui.lotr.map.fastTravel.prompt", new Object[]{LOTRKeyHandler.getFastTravelKey(this.field_230706_i_).func_238171_j_()});
                TranslationTextComponent ftMoreTime = new TranslationTextComponent("gui.lotr.map.fastTravel.moreTime", new Object[]{LOTRUtil.getHMSTime_Ticks(timeRemaining)});
                TranslationTextComponent ftWaitTime = new TranslationTextComponent("gui.lotr.map.fastTravel.waitTime", new Object[]{LOTRUtil.getHMSTime_Ticks(wpTimeThreshold)});
                if (fullscreen) {
                    if (!hasUnlocked) {
                        this.renderFullscreenSubtitles(matStack, notUnlockedMessage);
                    } else if (canFastTravel) {
                        this.renderFullscreenSubtitles(matStack, new ITextComponent[]{ftPrompt, ftWaitTime});
                    } else {
                        this.renderFullscreenSubtitles(matStack, new ITextComponent[]{ftMoreTime, ftWaitTime});
                    }
                } else {
                    ArrayList<Object> lines = new ArrayList<Object>();
                    if (!hasUnlocked) {
                        lines.add(notUnlockedMessage);
                    } else if (canFastTravel) {
                        lines.add(ftPrompt);
                        lines.add(ftWaitTime);
                    } else {
                        lines.add(ftMoreTime);
                        lines.add(ftWaitTime);
                    }
                    this.field_230712_o_.getClass();
                    int stringHeight = 9;
                    int rectWidth = this.viewportWidth;
                    int border = 3;
                    int rectHeight = border + (stringHeight + border) * lines.size();
                    int x = this.viewportXMin + this.viewportWidth / 2 - rectWidth / 2;
                    int y = this.viewportYMax + 10;
                    int strX = this.viewportXMin + this.viewportWidth / 2;
                    int strY = y + border;
                    this.drawFancyRect(matStack, x, y, x + rectWidth, y + rectHeight);
                    for (ITextComponent iTextComponent : lines) {
                        this.drawCenteredStringNoShadow(matStack, this.field_230712_o_, iTextComponent, strX, strY, 0xFFFFFF);
                        strY += stringHeight + border;
                    }
                }
                this.func_230926_e_(blit1);
            } else if (this.isMouseWithinMap) {
                TranslationTextComponent biomeName;
                int blit1 = this.func_230927_p_();
                this.func_230926_e_(500);
                double[] biomeMapCoords = this.convertMouseCoordsToMapCoords(mouseX, mouseY, tick);
                double biomeMapX = biomeMapCoords[0];
                double biomeMapZ = biomeMapCoords[1];
                this.mouseXCoord = this.loadedMapSettings.mapToWorldX(biomeMapX);
                this.mouseZCoord = this.loadedMapSettings.mapToWorldZ(biomeMapZ);
                if (this.isPositionFogged(biomeMapX, biomeMapZ)) {
                    biomeName = new TranslationTextComponent("gui.lotr.map.unexplored");
                } else {
                    int biomePosX_int = MathHelper.func_76128_c((double)biomeMapX);
                    int biomePosZ_int = MathHelper.func_76128_c((double)biomeMapZ);
                    Biome biome = LOTRBiomes.getBiomeByID(this.loadedMapSettings.getBiomeIdAt(biomePosX_int, biomePosZ_int, (IWorld)world), (IWorld)world);
                    biomeName = LOTRBiomes.getBiomeDisplayName(biome, (IWorld)world);
                }
                TranslationTextComponent coords = new TranslationTextComponent("gui.lotr.map.coords", new Object[]{this.mouseXCoord, this.mouseZCoord});
                TranslationTextComponent teleport = new TranslationTextComponent("gui.lotr.map.tp", new Object[]{LOTRKeyHandler.KEY_BIND_MAP_TELEPORT.func_238171_j_()});
                this.field_230712_o_.getClass();
                int stringHeight = 9;
                if (fullscreen) {
                    this.renderFullscreenSubtitles(matStack, new ITextComponent[]{biomeName, coords});
                    if (this.canTeleport()) {
                        matStack.func_227860_a_();
                        matStack.func_227861_a_((double)(this.field_230708_k_ / 2 - 30 - this.field_230712_o_.func_238414_a_((ITextProperties)teleport) / 2), 0.0, 0.0);
                        this.renderFullscreenSubtitles(matStack, new ITextComponent[]{teleport});
                        matStack.func_227865_b_();
                    }
                } else {
                    int rectWidth = this.viewportWidth;
                    int border = 3;
                    int rectHeight = border * 3 + stringHeight * 2;
                    if (this.canTeleport()) {
                        rectHeight += (stringHeight + border) * 2;
                    }
                    int x = this.viewportXMin + this.viewportWidth / 2 - rectWidth / 2;
                    int y = this.viewportYMax + 10;
                    this.drawFancyRect(matStack, x, y, x + rectWidth, y + rectHeight);
                    int strX = this.viewportXMin + this.viewportWidth / 2;
                    int strY = y + border;
                    this.drawCenteredStringNoShadow(matStack, this.field_230712_o_, (ITextComponent)biomeName, strX, strY, 0xFFFFFF);
                    this.drawCenteredStringNoShadow(matStack, this.field_230712_o_, (ITextComponent)coords, strX, strY += stringHeight + border, 0xFFFFFF);
                    if (this.canTeleport()) {
                        this.drawCenteredStringNoShadow(matStack, this.field_230712_o_, (ITextComponent)teleport, strX, strY + (stringHeight + border) * 2, 0xFFFFFF);
                    }
                }
                this.func_230926_e_(blit1);
            }
        }
        if (!this.hasOverlay && this.hasAreasOfInfluence()) {
            this.renderInFront(() -> this.lambda$render$20(matStack, (World)world));
        }
        if (this.zoomingMessageDisplayTicks > 0) {
            this.renderInFront(() -> {
                ITextComponent s = this.getZoomingDisplayMessage();
                int x = this.viewportXMin + this.viewportWidth / 2;
                int y = this.viewportYMax - 30;
                float alpha = LOTRUtil.trapezoidalIntensitySinglePulse(30 - this.zoomingMessageDisplayTicks, 30.0f, 0.16f, 0.0f, 1.0f);
                this.drawCenteredStringNoShadow(matStack, this.field_230712_o_, s, x, y, LOTRClientUtil.getRGBAForFontRendering(0xFFFFFF, alpha));
            });
        }
        super.func_230430_a_(matStack, mouseX, mouseY, tick);
        this.renderMapWidgets(matStack, mouseX, mouseY);
    }

    private void setupScrollBars(int mouseX, int mouseY) {
    }

    private void keepMapPositionWithinBounds() {
        float mapScaleX = (float)this.viewportWidth / this.zoomScale;
        float mapScaleY = (float)this.viewportHeight / this.zoomScale;
        if (this.loadedMapSettings.isScreenSideLocked(Direction.WEST)) {
            float maxPosX = mapScaleX / 2.0f;
            this.posX = Math.max(this.posX, (double)maxPosX);
            this.prevPosX = Math.max(this.prevPosX, (double)maxPosX);
        }
        if (this.loadedMapSettings.isScreenSideLocked(Direction.EAST)) {
            float minPosX = (float)this.loadedMapSettings.getWidth() - mapScaleX / 2.0f;
            this.posX = Math.min(this.posX, (double)minPosX);
            this.prevPosX = Math.min(this.prevPosX, (double)minPosX);
        }
        if (this.loadedMapSettings.isScreenSideLocked(Direction.NORTH)) {
            float maxPosY = mapScaleY / 2.0f;
            this.posY = Math.max(this.posY, (double)maxPosY);
            this.prevPosY = Math.max(this.prevPosY, (double)maxPosY);
        }
        if (this.loadedMapSettings.isScreenSideLocked(Direction.SOUTH)) {
            float minPosY = (float)this.loadedMapSettings.getHeight() - mapScaleY / 2.0f;
            this.posY = Math.min(this.posY, (double)minPosY);
            this.prevPosY = Math.min(this.prevPosY, (double)minPosY);
        }
    }

    public void renderMapAndOverlay(MatrixStack matStack, float tick, boolean sepia, float alpha, boolean overlay) {
        double lerpPosX = this.lerpPosX(tick);
        double lerpPosY = this.lerpPosY(tick);
        int mapXMin_W = this.viewportXMin;
        int mapXMax_W = this.viewportXMax;
        int mapYMin_W = this.viewportYMin;
        int mapYMax_W = this.viewportYMax;
        float mapScaleX = (float)this.viewportWidth / this.zoomScale;
        float mapScaleY = (float)this.viewportHeight / this.zoomScale;
        float minU = (float)(lerpPosX - (double)(mapScaleX / 2.0f)) / (float)this.loadedMapSettings.getWidth();
        float maxU = (float)(lerpPosX + (double)(mapScaleX / 2.0f)) / (float)this.loadedMapSettings.getWidth();
        float minV = (float)(lerpPosY - (double)(mapScaleY / 2.0f)) / (float)this.loadedMapSettings.getHeight();
        float maxV = (float)(lerpPosY + (double)(mapScaleY / 2.0f)) / (float)this.loadedMapSettings.getHeight();
        if (minU < 0.0f) {
            mapXMin_W = this.viewportXMin + Math.round((0.0f - minU) * (float)this.loadedMapSettings.getWidth() * this.zoomScale);
            minU = 0.0f;
            if (maxU < 0.0f) {
                maxU = 0.0f;
                mapXMax_W = mapXMin_W;
            }
        }
        if (maxU > 1.0f) {
            mapXMax_W = this.viewportXMax - Math.round((maxU - 1.0f) * (float)this.loadedMapSettings.getWidth() * this.zoomScale);
            maxU = 1.0f;
            if (minU > 1.0f) {
                minU = 1.0f;
                mapXMin_W = mapXMax_W;
            }
        }
        if (minV < 0.0f) {
            mapYMin_W = this.viewportYMin + Math.round((0.0f - minV) * (float)this.loadedMapSettings.getHeight() * this.zoomScale);
            minV = 0.0f;
            if (maxV < 0.0f) {
                maxV = 0.0f;
                mapYMax_W = mapYMin_W;
            }
        }
        if (maxV > 1.0f) {
            mapYMax_W = this.viewportYMax - Math.round((maxV - 1.0f) * (float)this.loadedMapSettings.getHeight() * this.zoomScale);
            maxV = 1.0f;
            if (minV > 1.0f) {
                minV = 1.0f;
                mapYMin_W = mapYMax_W;
            }
        }
        MapImageTextures.drawMap(matStack, (PlayerEntity)this.field_230706_i_.field_71439_g, sepia, mapXMin_W, mapXMax_W, mapYMin_W, mapYMax_W, this.func_230927_p_(), minU, maxU, minV, maxV, alpha);
        if (overlay) {
            MapImageTextures.drawMapOverlay(matStack, (PlayerEntity)this.field_230706_i_.field_71439_g, this.viewportXMin, this.viewportXMax, this.viewportYMin, this.viewportYMax, this.func_230927_p_(), minU, maxU, minV, maxV);
        }
    }

    private void renderGraduatedRects(MatrixStack matStack, int x1, int y1, int x2, int y2, int c1, int c2, int w) {
        float[] rgb1 = new Color(c1).getColorComponents(null);
        float[] rgb2 = new Color(c2).getColorComponents(null);
        for (int l = w - 1; l >= 0; --l) {
            float f = (float)l / (float)(w - 1);
            float r = rgb1[0] + (rgb2[0] - rgb1[0]) * f;
            float g = rgb1[1] + (rgb2[1] - rgb1[1]) * f;
            float b = rgb1[2] + (rgb2[2] - rgb1[2]) * f;
            int color = LOTRClientUtil.getRGBA(new Color(r, g, b).getRGB(), 1.0f);
            MiddleEarthMapScreen.func_238467_a_((MatrixStack)matStack, (int)(x1 - l), (int)(y1 - l), (int)(x2 + l), (int)(y2 + l), (int)color);
        }
    }

    private void renderMapWidgets(MatrixStack matStack, int mouseX, int mouseY) {
        boolean fineZoom = this.isFineMapMovement();
        boolean quickZoom = this.isQuickMapMovement();
        this.widgetZoomIn.visible = !this.hasOverlay;
        this.widgetZoomIn.setTexVOffset(zoomPower < 4.0f ? 0 : 1);
        this.widgetZoomIn.setTooltip(quickZoom ? "zoomIn.quick" : (fineZoom ? "zoomIn.fine" : "zoomIn"));
        this.widgetZoomOut.visible = !this.hasOverlay;
        this.widgetZoomOut.setTexVOffset(zoomPower > -3.0f ? 0 : 1);
        this.widgetZoomOut.setTooltip(quickZoom ? "zoomOut.quick" : (fineZoom ? "zoomOut.fine" : "zoomOut"));
        this.widgetFullScreen.visible = !this.hasOverlay;
        this.widgetSepia.visible = !this.hasOverlay;
        this.widgetLabels.visible = !this.hasOverlay;
        this.widgetToggleMapWPs.visible = !this.hasOverlay;
        this.widgetToggleMapWPs.setTexVOffset(this.showMapWaypoints() ? 0 : 1);
        this.widgetToggleCustomWPs.visible = !this.hasOverlay;
        this.widgetToggleCustomWPs.setTexVOffset(this.showCustomWaypoints() ? 0 : 1);
        this.widgetToggleMarkers.visible = !this.hasOverlay;
        this.widgetToggleMarkers.setTexVOffset(this.showMarkers() ? 0 : 1);
        this.widgetNewMarker.visible = !this.hasOverlay;
        this.widgetNewMarker.setTexVOffset(this.canCreateNewMarker() ? 0 : 1);
        int numMarkers = this.getOptClientPlayerData().map(pd -> pd.getMapMarkerData().getMarkers().size()).orElse(0);
        if (numMarkers > 0) {
            this.widgetNewMarker.setTooltip("newMarker.count", numMarkers, 64);
        } else {
            this.widgetNewMarker.setTooltip("newMarker");
        }
        this.widgetToggleShowLocation.visible = !this.hasOverlay;
        this.widgetToggleShowLocation.setTexUOffset(this.showLocationToOthers() ? 0 : 1);
        this.widgetToggleShowLocation.setTooltip(this.showLocationToOthers() ? "toggleShowLocation.shown" : "toggleShowLocation.hidden");
        MapWidget mouseOverWidget = null;
        for (MapWidget widget : this.mapWidgets) {
            if (!widget.visible) continue;
            this.field_230706_i_.func_110434_K().func_110577_a(MapImageTextures.MAP_ICONS);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_238474_b_(matStack, widget.getXPos(), widget.getYPos(), widget.getTexU(), widget.getTexV(), widget.width, widget.width);
            if (!widget.func_231047_b_(mouseX, mouseY)) continue;
            mouseOverWidget = widget;
        }
        if (mouseOverWidget != null) {
            int stringWidth = 200;
            List desc = this.field_230712_o_.func_238425_b_((ITextProperties)mouseOverWidget.getTooltip(), stringWidth);
            this.func_238654_b_(matStack, desc, mouseX, mouseY);
        }
    }

    private void renderFullscreenSubtitles(MatrixStack matStack, ITextComponent ... lines) {
        int strX = this.viewportXMin + this.viewportWidth / 2;
        int strY = this.viewportYMax + 7;
        this.field_230712_o_.getClass();
        int border = 9 + 3;
        if (lines.length == 1) {
            strY += border / 2;
        }
        for (ITextComponent s : lines) {
            this.drawCenteredStringNoShadow(matStack, this.field_230712_o_, s, strX, strY, 0xFFFFFF);
            strY += border;
        }
    }

    private void renderInFront(Runnable renderer) {
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)300.0f);
        renderer.run();
        RenderSystem.popMatrix();
    }

    private void renderPlayers(MatrixStack matStack, int mouseX, int mouseY, float tick) {
        String mouseOverPlayerName = null;
        double mouseOverPlayerX = 0.0;
        double mouseOverPlayerY = 0.0;
        double distanceMouseOverPlayer = Double.MAX_VALUE;
        int iconWidthHalf = 4;
        HashMap<UUID, MapPlayerLocation> playersToRender = new HashMap<UUID, MapPlayerLocation>();
        playersToRender.putAll(MapPlayerLocationHolder.getPlayerLocations());
        if (this.isMiddleEarth()) {
            playersToRender.put(this.field_230706_i_.field_71439_g.func_110124_au(), MapPlayerLocation.ofPlayer((PlayerEntity)this.field_230706_i_.field_71439_g));
        }
        for (Map.Entry entry : playersToRender.entrySet()) {
            MapPlayerLocation info = (MapPlayerLocation)entry.getValue();
            GameProfile profile = info.profile;
            String playerName = profile.getName();
            double playerPosX = info.posX;
            double playerPosZ = info.posZ;
            double[] pos = this.transformWorldCoords(playerPosX, playerPosZ, tick);
            float playerX = (float)pos[0];
            float playerY = (float)pos[1];
            float distToPlayer = this.renderPlayerIconAndReturnDistance(matStack, profile, playerX, playerY, mouseX, mouseY);
            ++this.renderedMapObjects;
            if (!(distToPlayer <= (float)(iconWidthHalf + 3)) || !((double)distToPlayer <= distanceMouseOverPlayer)) continue;
            mouseOverPlayerName = playerName;
            mouseOverPlayerX = playerX;
            mouseOverPlayerY = playerY;
            distanceMouseOverPlayer = distToPlayer;
        }
        if (mouseOverPlayerName != null && !this.hasOverlay) {
            String playerNameFinal = mouseOverPlayerName;
            double playerXFinal = mouseOverPlayerX;
            double playerYFinal = mouseOverPlayerY;
            this.renderInFront(() -> {
                int strWidth = this.field_230712_o_.func_78256_a(playerNameFinal);
                this.field_230712_o_.getClass();
                int strHeight = 9;
                int rectX = (int)Math.round(playerXFinal);
                int rectY = (int)Math.round(playerYFinal);
                rectY += iconWidthHalf + 3;
                int border = 3;
                int rectWidth = strWidth + border * 2;
                rectX -= rectWidth / 2;
                int rectHeight = strHeight + border * 2;
                int mapBorder2 = 2;
                rectX = Math.max(rectX, this.viewportXMin + mapBorder2);
                rectX = Math.min(rectX, this.viewportXMax - mapBorder2 - rectWidth);
                rectY = Math.max(rectY, this.viewportYMin + mapBorder2);
                rectY = Math.min(rectY, this.viewportYMax - mapBorder2 - rectHeight);
                this.drawFancyRect(matStack, rectX, rectY, rectX + rectWidth, rectY + rectHeight);
                this.field_230712_o_.func_243248_b(matStack, (ITextComponent)new StringTextComponent(playerNameFinal), (float)(rectX + border), (float)(rectY + border), 0xFFFFFF);
            });
        }
    }

    private float renderPlayerIconAndReturnDistance(MatrixStack matStack, GameProfile profile, float playerX, float playerY, int mouseX, int mouseY) {
        NetworkPlayerInfo playerInfo = this.field_230706_i_.func_147114_u().func_175102_a(profile.getId());
        if (playerInfo != null && playerInfo.func_178856_e()) {
            ResourceLocation skin = playerInfo.func_178837_g();
            Matrix4f mat = matStack.func_227866_c_().func_227870_a_();
            Tessellator tess = Tessellator.func_178181_a();
            BufferBuilder buf = tess.func_178180_c();
            int iconWidthHalf = 4;
            int iconBorder = iconWidthHalf + 1;
            playerX = Math.max((float)(this.viewportXMin + iconBorder), playerX);
            playerX = Math.min((float)(this.viewportXMax - iconBorder - 1), playerX);
            playerY = Math.max((float)(this.viewportYMin + iconBorder), playerY);
            playerY = Math.min((float)(this.viewportYMax - iconBorder - 1), playerY);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableAlphaTest();
            this.field_230706_i_.func_110434_K().func_110577_a(skin);
            float skinWidth = 64.0f;
            float skinHeight = 64.0f;
            float iconMinU = 8.0f / skinWidth;
            float iconMaxU = 16.0f / skinWidth;
            float iconMinV = 8.0f / skinHeight;
            float iconMaxV = 16.0f / skinHeight;
            float playerX_f = playerX + 0.5f;
            float playerY_f = playerY + 0.5f;
            int z = this.func_230927_p_();
            buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            buf.func_227888_a_(mat, playerX_f - (float)iconWidthHalf, playerY_f + (float)iconWidthHalf, (float)z).func_225583_a_(iconMinU, iconMaxV).func_181675_d();
            buf.func_227888_a_(mat, playerX_f + (float)iconWidthHalf, playerY_f + (float)iconWidthHalf, (float)z).func_225583_a_(iconMaxU, iconMaxV).func_181675_d();
            buf.func_227888_a_(mat, playerX_f + (float)iconWidthHalf, playerY_f - (float)iconWidthHalf, (float)z).func_225583_a_(iconMaxU, iconMinV).func_181675_d();
            buf.func_227888_a_(mat, playerX_f - (float)iconWidthHalf, playerY_f - (float)iconWidthHalf, (float)z).func_225583_a_(iconMinU, iconMinV).func_181675_d();
            tess.func_78381_a();
            iconMinU = 40.0f / skinWidth;
            iconMaxU = 48.0f / skinWidth;
            iconMinV = 8.0f / skinHeight;
            iconMaxV = 16.0f / skinHeight;
            buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            buf.func_227888_a_(mat, playerX_f - (float)iconWidthHalf - 0.5f, playerY_f + (float)iconWidthHalf + 0.5f, (float)z).func_225583_a_(iconMinU, iconMaxV).func_181675_d();
            buf.func_227888_a_(mat, playerX_f + (float)iconWidthHalf + 0.5f, playerY_f + (float)iconWidthHalf + 0.5f, (float)z).func_225583_a_(iconMaxU, iconMaxV).func_181675_d();
            buf.func_227888_a_(mat, playerX_f + (float)iconWidthHalf + 0.5f, playerY_f - (float)iconWidthHalf - 0.5f, (float)z).func_225583_a_(iconMaxU, iconMinV).func_181675_d();
            buf.func_227888_a_(mat, playerX_f - (float)iconWidthHalf - 0.5f, playerY_f - (float)iconWidthHalf - 0.5f, (float)z).func_225583_a_(iconMinU, iconMinV).func_181675_d();
            tess.func_78381_a();
            RenderSystem.disableAlphaTest();
            float dx = playerX - (float)mouseX;
            float dy = playerY - (float)mouseY;
            float distToPlayer = MathHelper.func_76129_c((float)(dx * dx + dy * dy));
            return distToPlayer;
        }
        return Float.MAX_VALUE;
    }

    private void renderAreasOfInfluence(MatrixStack matStack, int mouseX, int mouseY, float tick) {
        List<AreaOfInfluence> areasOfInfluence;
        this.mouseInAreaOfInfluence = false;
        this.mouseInReducedAreaOfInfluence = false;
        Faction faction = this.areaOfInfluenceFaction;
        if (LOTRDimensions.isDimension(faction, LOTRDimensions.MIDDLE_EARTH_WORLD_KEY) && !(areasOfInfluence = faction.getAreasOfInfluence().getAreas()).isEmpty()) {
            Tessellator tess = Tessellator.func_178181_a();
            BufferBuilder buf = tess.func_178180_c();
            this.setupMapClipping();
            RenderSystem.disableTexture();
            for (int pass = 0; pass <= 2; ++pass) {
                int areaRgb = 0xFF0000;
                if (pass == 1) {
                    areaRgb = 0x550000;
                }
                if (pass == 0) {
                    areaRgb = 0xFF5555;
                }
                Color areaColor = new Color(areaRgb);
                for (AreaOfInfluence area : areasOfInfluence) {
                    float rScaled;
                    double dy;
                    double[] coords;
                    double dx;
                    float radius = area.getMapRadius();
                    if (pass == 2) {
                        radius -= 1.0f;
                    }
                    if (pass == 0) {
                        radius = area.getMapRadius() + faction.getAreasOfInfluence().getReducedInfluenceRange();
                    }
                    float radiusWorld = this.loadedMapSettings.mapToWorldDistance(radius);
                    buf.func_181668_a(9, DefaultVertexFormats.field_181706_f);
                    int sides = 100;
                    for (int l = sides - 1; l >= 0; --l) {
                        float angle = (float)l / (float)sides * 2.0f * (float)Math.PI;
                        double x = area.getWorldX();
                        double z = area.getWorldZ();
                        double[] coords2 = this.transformWorldCoords(x += (double)(MathHelper.func_76134_b((float)angle) * radiusWorld), z += (double)(MathHelper.func_76126_a((float)angle) * radiusWorld), tick);
                        buf.func_225582_a_(coords2[0], coords2[1], (double)this.func_230927_p_()).func_225586_a_(areaColor.getRed(), areaColor.getGreen(), areaColor.getBlue(), areaColor.getAlpha()).func_181675_d();
                    }
                    tess.func_78381_a();
                    if (this.mouseInAreaOfInfluence && this.mouseInReducedAreaOfInfluence || !((dx = (double)mouseX - (coords = this.transformWorldCoords(area.getWorldX(), area.getWorldZ(), tick))[0]) * dx + (dy = (double)mouseY - coords[1]) * dy <= (double)((rScaled = radius * this.zoomScale) * rScaled))) continue;
                    if (pass >= 1) {
                        this.mouseInAreaOfInfluence = true;
                        continue;
                    }
                    if (pass != 0) continue;
                    this.mouseInReducedAreaOfInfluence = true;
                }
            }
            RenderSystem.enableTexture();
            this.endMapClipping();
        }
    }

    private void renderRoads(MatrixStack matStack, float tick) {
        if (!this.showMapWaypoints() && !this.showCustomWaypoints()) {
            return;
        }
        this.renderRoads(matStack, tick, this.hasMapLabels());
    }

    public void renderRoads(MatrixStack matStack, float tick, boolean labels) {
        float roadAlpha = this.calcZoomedWaypointAlpha();
        if (roadAlpha > 0.0f) {
            float mapScale = this.loadedMapSettings.getScaleFactor();
            int interval = Math.round(mapScale * 3.125f / this.zoomScaleStable);
            interval = Math.max(interval, 1);
            for (Road road : this.loadedMapSettings.getRoads()) {
                for (RoadSection section : road.getSections()) {
                    GeneratedRoadPoint[] sectionPoints = section.getRoutePoints();
                    for (int pointIndex = 0; pointIndex < sectionPoints.length; pointIndex += interval) {
                        int clip;
                        GeneratedRoadPoint point = sectionPoints[pointIndex];
                        double[] pos = this.transformMapCoords(point.getMapX(), point.getMapZ(), tick);
                        float x = (float)pos[0];
                        float y = (float)pos[1];
                        float roadWidth = 1.0f;
                        float roadWidthLess1 = roadWidth - 1.0f;
                        float x0 = x - roadWidthLess1;
                        float x1 = x + roadWidth;
                        float y0 = y - roadWidthLess1;
                        float y1 = y + roadWidth;
                        if (x0 >= (float)this.viewportXMin && x1 <= (float)this.viewportXMax && y0 >= (float)this.viewportYMin && y1 <= (float)this.viewportYMax) {
                            float roadR = 0.0f;
                            float roadG = 0.0f;
                            float roadB = 0.0f;
                            float z = this.func_230927_p_();
                            RenderSystem.disableTexture();
                            RenderSystem.enableBlend();
                            RenderSystem.defaultBlendFunc();
                            Matrix4f mat = matStack.func_227866_c_().func_227870_a_();
                            Tessellator tess = Tessellator.func_178181_a();
                            BufferBuilder buf = tess.func_178180_c();
                            buf.func_181668_a(7, DefaultVertexFormats.field_181706_f);
                            buf.func_227888_a_(mat, x0, y1, z).func_227885_a_(roadR, roadG, roadB, roadAlpha).func_181675_d();
                            buf.func_227888_a_(mat, x1, y1, z).func_227885_a_(roadR, roadG, roadB, roadAlpha).func_181675_d();
                            buf.func_227888_a_(mat, x1, y0, z).func_227885_a_(roadR, roadG, roadB, roadAlpha).func_181675_d();
                            buf.func_227888_a_(mat, x0, y0, z).func_227885_a_(roadR, roadG, roadB, roadAlpha).func_181675_d();
                            tess.func_78381_a();
                            ++this.renderedMapObjects;
                            RenderSystem.disableBlend();
                            RenderSystem.enableTexture();
                        }
                        if (!labels || !(x >= (float)(this.viewportXMin - (clip = 100))) || !(x <= (float)(this.viewportXMax + clip)) || !(y >= (float)(this.viewportYMin - clip)) || !(y <= (float)(this.viewportYMax + clip))) continue;
                        float zoomlerp = (this.zoomExp - -1.0f) / 4.0f;
                        zoomlerp = Math.min(zoomlerp, 1.0f);
                        float roadNameScale = zoomlerp * 0.75f;
                        ITextComponent name = road.getDisplayName();
                        int roadNameWidth = this.field_230712_o_.func_238414_a_((ITextProperties)name);
                        int nameInterval = (int)((float)(roadNameWidth * 2 + 200) * mapScale * 0.78125f / this.zoomScaleStable);
                        if (pointIndex % nameInterval >= interval) continue;
                        boolean endNear = false;
                        for (RouteRoadPoint end : section.getStartAndEndPoints()) {
                            double endY;
                            double dy;
                            int endpointOverlapDistance = 10;
                            MapWaypoint endWp = end.getCorrespondingWaypoint();
                            if (endWp != null) {
                                ITextComponent endWpName = endWp.getDisplayName();
                                int endWpNameWidth = this.field_230712_o_.func_238414_a_((ITextProperties)endWpName);
                                endpointOverlapDistance = endWpNameWidth / 2 + 10;
                            }
                            double overlapWidth = (double)roadNameWidth / 2.0 * (double)roadNameScale + (double)endpointOverlapDistance;
                            double overlapWidthSq = overlapWidth * overlapWidth;
                            double[] endPos = this.transformMapCoords(end.getMapX(), end.getMapZ(), tick);
                            double endX = endPos[0];
                            double dx = (double)x - endX;
                            double dSq = dx * dx + (dy = (double)y - (endY = endPos[1])) * dy;
                            if (!(dSq < overlapWidthSq)) continue;
                            endNear = true;
                        }
                        if (endNear || !(zoomlerp > 0.0f)) continue;
                        this.setupMapClipping();
                        matStack.func_227860_a_();
                        matStack.func_227861_a_((double)x, (double)y, 0.0);
                        matStack.func_227862_a_(roadNameScale, roadNameScale, roadNameScale);
                        GeneratedRoadPoint nextPoint = sectionPoints[Math.min(pointIndex + 1, sectionPoints.length - 1)];
                        GeneratedRoadPoint prevPoint = sectionPoints[Math.max(pointIndex - 1, 0)];
                        double grad = (nextPoint.getMapZ() - prevPoint.getMapZ()) / (nextPoint.getMapX() - prevPoint.getMapX());
                        float angle = (float)Math.atan(grad);
                        angle = (float)Math.toDegrees(angle);
                        if (Math.abs(angle) > 90.0f) {
                            angle += 180.0f;
                        }
                        matStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(angle));
                        float alpha = zoomlerp;
                        RenderSystem.enableBlend();
                        RenderSystem.defaultBlendFunc();
                        int strX = -roadNameWidth / 2;
                        int strY = -15;
                        this.field_230712_o_.func_243248_b(matStack, name, (float)(strX + 1), (float)(strY + 1), LOTRClientUtil.getRGBAForFontRendering(0, alpha *= 0.8f));
                        this.field_230712_o_.func_243248_b(matStack, name, (float)strX, (float)strY, LOTRClientUtil.getRGBAForFontRendering(0xFFFFFF, alpha));
                        RenderSystem.disableBlend();
                        matStack.func_227865_b_();
                        this.endMapClipping();
                    }
                }
            }
        }
    }

    private boolean hasFogOfWar() {
        return this.field_230706_i_.field_71441_e != null && FogDataModule.isFogOfWarEnabledClientside();
    }

    public void renderFogOfWar(MatrixStack matStack, float tick) {
        if (!this.hasFogOfWar()) {
            return;
        }
        this.getOptClientPlayerData().ifPresent(playerData -> {
            IProfiler profiler = this.field_230706_i_.func_213239_aq();
            profiler.func_76320_a("renderFogOfWar");
            double[] minMapCoords = this.convertMouseCoordsToMapCoords(this.viewportXMin, this.viewportYMin, tick);
            double[] maxMapCoords = this.convertMouseCoordsToMapCoords(this.viewportXMax, this.viewportYMax, tick);
            double fogMapXMin = minMapCoords[0];
            double fogMapXMax = maxMapCoords[0];
            double fogMapZMin = minMapCoords[1];
            double fogMapZMax = maxMapCoords[1];
            this.field_230706_i_.func_110434_K().func_110577_a(MapImageTextures.FOG_OF_WAR_TEXTURE);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            profiler.func_76320_a("iterateTiles");
            playerData.getFogData().streamTilesForRendering(fogMapXMin, fogMapXMax, fogMapZMin, fogMapZMax, profiler).forEach(tile -> {
                int tileV;
                int tileU;
                int randTexture;
                profiler.func_76320_a("transformCoords");
                double[] leftTop = this.transformMapCoords(tile.getMapLeft(), tile.getMapTop(), tick);
                double[] rightBottom = this.transformMapCoords(tile.getMapRight(), tile.getMapBottom(), tick);
                profiler.func_76319_b();
                float initX0 = (float)leftTop[0];
                float initX1 = (float)rightBottom[0];
                float initY0 = (float)leftTop[1];
                float initY1 = (float)rightBottom[1];
                float x0 = Math.max(initX0, (float)this.viewportXMin);
                float x1 = Math.min(initX1, (float)this.viewportXMax);
                float y0 = Math.max(initY0, (float)this.viewportYMin);
                float y1 = Math.min(initY1, (float)this.viewportYMax);
                int texSize = 256;
                int tileSize = tile.getSize();
                if (tile.isThickFog()) {
                    randTexture = tile.getPositionalHash() % 4;
                    tileU = randTexture % 4 * tileSize;
                    tileV = (randTexture / 4 + 2) * tileSize;
                } else {
                    randTexture = tile.getPositionalHash() % 7;
                    tileU = randTexture % 4 * tileSize;
                    tileV = randTexture / 4 * tileSize;
                }
                float initWidth = initX1 - initX0;
                float initHeight = initY1 - initY0;
                float u0 = ((float)tileU + (x0 - initX0) / initWidth * (float)tileSize) / (float)texSize;
                float u1 = ((float)tileU + (x1 - initX0) / initWidth * (float)tileSize) / (float)texSize;
                float v0 = ((float)tileV + (y0 - initY0) / initHeight * (float)tileSize) / (float)texSize;
                float v1 = ((float)tileV + (y1 - initY0) / initHeight * (float)tileSize) / (float)texSize;
                profiler.func_76320_a("drawFogTile");
                this.renderFogOfWarTile(matStack, x0, x1, y0, y1, u0, u1, v0, v1);
                ++this.renderedMapObjects;
                profiler.func_76319_b();
            });
            profiler.func_76319_b();
            RenderSystem.disableBlend();
            profiler.func_76319_b();
        });
    }

    private void renderFogOfWarTile(MatrixStack matStack, float x0, float x1, float y0, float y1, float u0, float u1, float v0, float v1) {
        float z = this.func_230927_p_();
        Matrix4f mat = matStack.func_227866_c_().func_227870_a_();
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buf = tess.func_178180_c();
        buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buf.func_227888_a_(mat, x0, y1, z).func_225583_a_(u0, v1).func_181675_d();
        buf.func_227888_a_(mat, x1, y1, z).func_225583_a_(u1, v1).func_181675_d();
        buf.func_227888_a_(mat, x1, y0, z).func_225583_a_(u1, v0).func_181675_d();
        buf.func_227888_a_(mat, x0, y0, z).func_225583_a_(u0, v0).func_181675_d();
        tess.func_78381_a();
    }

    private boolean isPositionFogged(double mapX, double mapZ) {
        if (!this.hasFogOfWar()) {
            return false;
        }
        return this.getClientPlayerData().getFogData().isFogged(MathHelper.func_76128_c((double)mapX), MathHelper.func_76128_c((double)mapZ));
    }

    private void selectObject(SelectableMapObject object) {
        this.selectedObject = object;
        this.objectSelectTick = this.selectedObject != null ? 6 : 0;
        this.prevObjectSelectTick = this.objectSelectTick;
        this.waypointTooltip.onSelect(this.selectedObject instanceof Waypoint ? (Waypoint)this.selectedObject : null);
        this.markerTooltip.onSelect(this.selectedObject instanceof MapMarker ? (MapMarker)this.selectedObject : null);
        if (this.selectedObject instanceof Waypoint) {
            MiddleEarthMapScreen.playWaypointSelectSound();
        } else if (this.selectedObject instanceof MapMarker) {
            MiddleEarthMapScreen.playMarkerSelectSound();
        }
    }

    private void determineMouseOverObject(int mouseX, int mouseY, float tick) {
        this.mouseOverObject = null;
        double distanceMouseOverObject = Double.MAX_VALUE;
        ArrayList<SelectableMapObject> visibleObjects = new ArrayList<SelectableMapObject>();
        visibleObjects.addAll(this.getVisibleWaypoints());
        visibleObjects.addAll(this.getVisibleMarkers());
        for (SelectableMapObject object : visibleObjects) {
            double dy;
            double dx;
            double distToObject;
            int halfW;
            double[] pos = this.transformWorldCoords(object.getWorldX(), object.getWorldZ(), tick);
            double x = pos[0];
            double y = pos[1];
            if (object == this.selectedObject || !(x >= (double)(this.viewportXMin - (halfW = object.getMapIconWidth() / 2))) || !(x <= (double)(this.viewportXMax + halfW)) || !(y >= (double)(this.viewportYMin - halfW)) || !(y <= (double)(this.viewportYMax + halfW)) || !((distToObject = Math.sqrt((dx = x - (double)mouseX) * dx + (dy = y - (double)mouseY) * dy)) <= 5.0) || !(distToObject <= distanceMouseOverObject)) continue;
            this.mouseOverObject = object;
            distanceMouseOverObject = distToObject;
        }
    }

    private boolean isWaypointVisible(Waypoint wp) {
        if (wp.getDisplayState((PlayerEntity)this.field_230706_i_.field_71439_g) == Waypoint.WaypointDisplayState.HIDDEN) {
            return false;
        }
        if (this.isPositionFogged(wp.getMapX(), wp.getMapZ()) && !wp.hasPlayerUnlocked((PlayerEntity)this.field_230706_i_.field_71439_g)) {
            return false;
        }
        if (wp.isCustom()) {
            if (wp.isSharedCustom() && wp.isSharedHidden() && !this.showHiddenSharedCustomWaypoints()) {
                return false;
            }
            return this.showCustomWaypoints();
        }
        return this.showMapWaypoints();
    }

    private void renderWaypoints(MatrixStack matStack, int pass, int mouseX, int mouseY, float tick) {
        if (!(this.showMapWaypoints() || this.showCustomWaypoints() || this.showHiddenSharedCustomWaypoints())) {
            return;
        }
        this.renderWaypoints(matStack, pass, mouseX, mouseY, tick, this.hasMapLabels());
    }

    private List<Waypoint> getVisibleWaypoints() {
        Stream mapWps = this.loadedMapSettings.getWaypoints().stream();
        Stream customWps = this.getOptClientPlayerData().map(pd -> pd.getFastTravelData().getCustomWaypoints().stream()).orElse(Stream.empty());
        Stream adoptedCustomWps = this.getOptClientPlayerData().map(pd -> pd.getFastTravelData().getAdoptedCustomWaypoints().stream()).orElse(Stream.empty());
        return Streams.concat((Stream[])new Stream[]{mapWps, customWps, adoptedCustomWps}).filter(this::isWaypointVisible).collect(Collectors.toList());
    }

    public void renderWaypoints(MatrixStack matStack, int pass, int mouseX, int mouseY, float tick, boolean mapLabels) {
        this.renderWaypoints(matStack, this.getVisibleWaypoints(), pass, mouseX, mouseY, tick, mapLabels);
    }

    private void renderWaypoints(MatrixStack matStack, List<Waypoint> waypoints, int pass, int mouseX, int mouseY, float tick, boolean mapLabels) {
        this.setupMapClipping();
        float wpAlpha = this.calcZoomedWaypointAlpha();
        if (wpAlpha > 0.0f) {
            for (Waypoint waypoint : waypoints) {
                double[] pos = this.transformWorldCoords(waypoint.getWorldX(), waypoint.getWorldZ(), tick);
                float x = (float)pos[0];
                float y = (float)pos[1];
                int clip = 100;
                if (!(x >= (float)(this.viewportXMin - clip)) || !(x <= (float)(this.viewportXMax + clip)) || !(y >= (float)(this.viewportYMin - clip)) || !(y <= (float)(this.viewportYMax + clip)) || pass != 0) continue;
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                if (MiddleEarthMapScreen.isOSRS()) {
                    float osScale = 0.33f;
                    matStack.func_227860_a_();
                    matStack.func_227862_a_(0.33f, 0.33f, 1.0f);
                    this.field_230706_i_.func_110434_K().func_110577_a(MapImageTextures.OSRS_ICONS);
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    LOTRClientUtil.blitFloat((AbstractGui)this, matStack, x / 0.33f - 8.0f, y / 0.33f - 8.0f, 0.0f, 0.0f, 15.0f, 15.0f);
                    matStack.func_227865_b_();
                } else {
                    Waypoint.WaypointDisplayState state = waypoint.getDisplayState((PlayerEntity)this.field_230706_i_.field_71439_g);
                    this.field_230706_i_.func_110434_K().func_110577_a(MapImageTextures.MAP_ICONS);
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)wpAlpha);
                    boolean highlight = waypoint == this.mouseOverObject || waypoint == this.selectedObject;
                    LOTRClientUtil.blitFloat((AbstractGui)this, matStack, x - 3.0f, y - 3.0f, highlight ? (float)state.highlightIconU : (float)state.iconU, highlight ? (float)state.highlightIconV : (float)state.iconV, 6.0f, 6.0f);
                }
                ++this.renderedMapObjects;
                RenderSystem.disableBlend();
                if (!mapLabels) continue;
                float zoomlerp = (this.zoomExp - -1.0f) / 4.0f;
                if (!((zoomlerp = Math.min(zoomlerp, 1.0f)) > 0.0f)) continue;
                matStack.func_227860_a_();
                matStack.func_227861_a_((double)x, (double)y, 0.0);
                float scale = zoomlerp;
                matStack.func_227862_a_(scale, scale, 1.0f);
                float alpha = zoomlerp;
                alpha *= 0.8f;
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                ITextComponent s = waypoint.getDisplayName();
                int strX = -this.field_230712_o_.func_238414_a_((ITextProperties)s) / 2;
                int strY = -15;
                this.field_230712_o_.func_243248_b(matStack, s, (float)(strX + 1), (float)(strY + 1), LOTRClientUtil.getRGBAForFontRendering(0, alpha));
                this.field_230712_o_.func_243248_b(matStack, s, (float)strX, (float)strY, LOTRClientUtil.getRGBAForFontRendering(0xFFFFFF, alpha));
                RenderSystem.disableBlend();
                matStack.func_227865_b_();
            }
        }
        if (pass == 1 && !this.hasOverlay && this.mouseOverObject instanceof Waypoint) {
            this.renderWaypointTooltip(matStack, (Waypoint)this.mouseOverObject, false, mouseX, mouseY, 1.0f);
        }
        this.endMapClipping();
    }

    private float calcZoomedWaypointAlpha() {
        if (this.enableZoomOutObjectFading) {
            float alpha = (this.zoomExp - -3.3f) / 2.2f;
            return Math.min(alpha, 1.0f);
        }
        return 1.0f;
    }

    private void renderWaypointTooltip(MatrixStack matStack, Waypoint waypoint, boolean selected, int mouseX, int mouseY, float tick) {
        this.waypointTooltip.setMapDimensions(this.viewportXMin, this.viewportXMax, this.viewportYMin, this.viewportYMax);
        this.waypointTooltip.setSelectionProgress(this.prevObjectSelectTick, this.objectSelectTick, 6, tick);
        this.waypointTooltip.render(matStack, waypoint, selected, mouseX, mouseY, tick);
    }

    private void renderMarkerTooltip(MatrixStack matStack, MapMarker marker, boolean selected, int mouseX, int mouseY, float tick) {
        this.markerTooltip.setMapDimensions(this.viewportXMin, this.viewportXMax, this.viewportYMin, this.viewportYMax);
        this.markerTooltip.setSelectionProgress(this.prevObjectSelectTick, this.objectSelectTick, 6, tick);
        this.markerTooltip.render(matStack, marker, selected, mouseX, mouseY, tick);
    }

    private boolean canCreateNewMarker() {
        return this.field_230706_i_.field_71439_g != null && this.getClientPlayerData().getMapMarkerData().canCreateNewMarker();
    }

    private List<MapMarker> getVisibleMarkers() {
        if (!this.showMarkers()) {
            return ImmutableList.of();
        }
        return this.getOptClientPlayerData().map(pd -> pd.getMapMarkerData().getMarkers()).orElse((List)ImmutableList.of());
    }

    private void renderMarkers(MatrixStack matStack, int pass, int mouseX, int mouseY, float tick) {
        if (!this.showMarkers()) {
            return;
        }
        float markerAlpha = this.calcZoomedWaypointAlpha();
        if (markerAlpha > 0.0f) {
            this.setupMapClipping();
            List<MapMarker> markers = this.getVisibleMarkers();
            for (MapMarker marker : markers) {
                double[] pos = this.transformWorldCoords(marker.getWorldX(), marker.getWorldZ(), tick);
                float x = (float)pos[0];
                float y = (float)pos[1];
                int clip = 100;
                if (!(x >= (float)(this.viewportXMin - clip)) || !(x <= (float)(this.viewportXMax + clip)) || !(y >= (float)(this.viewportYMin - clip)) || !(y <= (float)(this.viewportYMax + clip)) || pass != 0) continue;
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                boolean highlight = marker == this.mouseOverObject || marker == this.selectedObject;
                this.renderMarker(matStack, marker, x, y, highlight, markerAlpha);
                ++this.renderedMapObjects;
                RenderSystem.disableBlend();
            }
            this.endMapClipping();
        }
        if (pass == 1 && !this.hasOverlay && this.mouseOverObject instanceof MapMarker) {
            this.renderMarkerTooltip(matStack, (MapMarker)this.mouseOverObject, false, mouseX, mouseY, 1.0f);
        }
    }

    private void renderMarker(MatrixStack matStack, MapMarker marker, float markerX, float markerY, boolean mouseOver, float alpha) {
        int w = 10;
        int halfW = 5;
        int u = marker.getIcon().getU(mouseOver);
        int v = marker.getIcon().getV(mouseOver);
        this.field_230706_i_.func_110434_K().func_110577_a(MapImageTextures.MAP_ICONS);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        LOTRClientUtil.blitFloat((AbstractGui)this, matStack, markerX - 5.0f, markerY - 5.0f, (float)u, (float)v, 10.0f, 10.0f);
    }

    private void renderCreatingMarker(MatrixStack matStack, int mouseX, int mouseY) {
        int markerZ;
        int w = 10;
        int halfW = 5;
        boolean u = false;
        int v = 236;
        int markerX = this.boundCreatingMarkerMouseX(mouseX);
        if (!this.isCreatingMarkerAtValidMousePosition(markerX, markerZ = this.boundCreatingMarkerMouseZ(mouseY))) {
            v -= 10;
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        this.field_230706_i_.func_110434_K().func_110577_a(MapImageTextures.MAP_ICONS);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.6f);
        LOTRClientUtil.blitFloat((AbstractGui)this, matStack, (float)(markerX - 5), (float)(markerZ - 5), (float)u, (float)v, 10.0f, 10.0f);
        RenderSystem.disableBlend();
    }

    private int boundCreatingMarkerMouseX(double mouseX) {
        int halfW = 5;
        int markerX = (int)mouseX;
        markerX = Math.max(this.viewportXMin + 5, markerX);
        markerX = Math.min(this.viewportXMax - 5, markerX);
        return markerX;
    }

    private int boundCreatingMarkerMouseZ(double mouseY) {
        int halfW = 5;
        int markerZ = (int)mouseY;
        markerZ = Math.max(this.viewportYMin + 5, markerZ);
        markerZ = Math.min(this.viewportYMax - 5, markerZ);
        return markerZ;
    }

    private boolean isCreatingMarkerAtValidMousePosition(int mouseX, int mouseZ) {
        int[] worldCoords = this.getCreatingMarkerWorldCoords(mouseX, mouseZ);
        return MapMarker.isValidMapMarkerPosition(this.loadedMapSettings, worldCoords[0], worldCoords[1]);
    }

    private int[] getCreatingMarkerWorldCoords(int mouseX, int mouseZ) {
        double[] markerMapCoords = this.convertMouseCoordsToMapCoords(mouseX, mouseZ, 1.0f);
        int worldX = this.loadedMapSettings.mapToWorldX(markerMapCoords[0]);
        int worldZ = this.loadedMapSettings.mapToWorldZ(markerMapCoords[1]);
        return new int[]{worldX, worldZ};
    }

    private void renderLabels(MatrixStack matStack, float tick) {
        if (!this.hasMapLabels()) {
            return;
        }
        this.setupMapClipping();
        List<MapLabel> labels = this.loadedMapSettings.getLabels();
        for (MapLabel label : labels) {
            double[] pos = this.transformMapCoords(label.getMapX(), label.getMapZ(), tick);
            double x = pos[0];
            double y = pos[1];
            float zoomlerp = (this.zoomExp - label.getMinZoom()) / (label.getMaxZoom() - label.getMinZoom());
            if (!(zoomlerp > 0.0f) || !(zoomlerp < 1.0f)) continue;
            float alpha = (0.5f - Math.abs(zoomlerp - 0.5f)) / 0.5f;
            alpha *= 0.7f;
            if (MiddleEarthMapScreen.isOSRS()) {
                if (alpha < 0.3f) continue;
                alpha = 1.0f;
            }
            matStack.func_227860_a_();
            matStack.func_227861_a_(x, y, 0.0);
            float labelScale = this.zoomScale * label.getScale();
            matStack.func_227862_a_(labelScale, labelScale, labelScale);
            if (!MiddleEarthMapScreen.isOSRS()) {
                matStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(label.getAngle()));
            }
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.alphaFunc((int)516, (float)0.01f);
            ITextComponent labelName = label.getDisplayName((IWorld)this.field_230706_i_.field_71441_e);
            int strX = -this.field_230712_o_.func_238414_a_((ITextProperties)labelName) / 2;
            this.field_230712_o_.getClass();
            int strY = -9 / 2;
            if (MiddleEarthMapScreen.isOSRS()) {
                if (label.getScale() > 2.5f) {
                    this.field_230712_o_.func_243248_b(matStack, labelName, (float)(strX + 1), (float)(strY + 1), LOTRClientUtil.getRGBAForFontRendering(0, alpha));
                    this.field_230712_o_.func_243248_b(matStack, labelName, (float)strX, (float)strY, LOTRClientUtil.getRGBAForFontRendering(0xFFAA00, alpha));
                } else {
                    this.field_230712_o_.func_243248_b(matStack, labelName, (float)(strX + 1), (float)(strY + 1), LOTRClientUtil.getRGBAForFontRendering(0, alpha));
                    this.field_230712_o_.func_243248_b(matStack, labelName, (float)strX, (float)strY, LOTRClientUtil.getRGBAForFontRendering(0xFFFFFF, alpha));
                }
            } else {
                this.field_230712_o_.func_243248_b(matStack, labelName, (float)strX, (float)strY, LOTRClientUtil.getRGBAForFontRendering(0xFFFFFF, alpha));
            }
            ++this.renderedMapObjects;
            RenderSystem.defaultAlphaFunc();
            RenderSystem.disableBlend();
            matStack.func_227865_b_();
        }
        this.endMapClipping();
    }

    private boolean hasMapLabels() {
        return (Boolean)LOTRConfig.CLIENT.mapLabels.get();
    }

    private void toggleMapLabels() {
        LOTRConfig.CLIENT.toggleMapLabels();
    }

    private void setupMapClipping() {
        double scale = this.field_230706_i_.func_228018_at_().func_198100_s();
        GL11.glEnable((int)3089);
        GL11.glScissor((int)((int)((double)this.viewportXMin * scale)), (int)((int)((double)(this.field_230709_l_ - this.viewportYMax) * scale)), (int)((int)((double)this.viewportWidth * scale)), (int)((int)((double)this.viewportHeight * scale)));
    }

    private void endMapClipping() {
        GL11.glDisable((int)3089);
    }

    public void drawFancyRect(MatrixStack matStack, int x1, int y1, int x2, int y2) {
        MiddleEarthMapScreen.func_238467_a_((MatrixStack)matStack, (int)x1, (int)y1, (int)x2, (int)y2, (int)-1073741824);
        this.func_238465_a_(matStack, x1 - 1, x2, y1 - 1, -6156032);
        this.func_238465_a_(matStack, x1 - 1, x2, y2, -6156032);
        this.func_238473_b_(matStack, x1 - 1, y1 - 1, y2, -6156032);
        this.func_238473_b_(matStack, x2, y1 - 1, y2, -6156032);
    }

    @Override
    public boolean func_231046_a_(int key, int scan, int param3) {
        if (!this.hasOverlay) {
            Waypoint selectedWp;
            if (this.selectedObject != null && key == 257) {
                this.selectObject(null);
                return true;
            }
            if (this.selectedObject instanceof Waypoint) {
                if (this.waypointTooltip.keyPressed(key, scan, param3)) {
                    return true;
                }
                if (this.waypointTooltip.isTextFieldFocused()) {
                    return false;
                }
            } else if (this.selectedObject instanceof MapMarker) {
                if (this.markerTooltip.keyPressed(key, scan, param3)) {
                    return true;
                }
                if (this.markerTooltip.isTextFieldFocused()) {
                    return false;
                }
            }
            if (!this.isRecentringOnPlayer() && this.field_230706_i_.field_71474_y.field_74314_A.func_197976_a(key, scan)) {
                this.recentreMapOnPlayer();
                return true;
            }
            Waypoint waypoint = selectedWp = this.selectedObject instanceof Waypoint ? (Waypoint)this.selectedObject : null;
            if (selectedWp != null && LOTRKeyHandler.getFastTravelKey(this.field_230706_i_).func_197976_a(key, scan) && this.isMiddleEarth()) {
                FastTravelDataModule ftData = this.getClientPlayerData().getFastTravelData();
                if (selectedWp.hasPlayerUnlocked((PlayerEntity)this.field_230706_i_.field_71439_g) && ftData.getTimeSinceFT() >= ftData.getWaypointFTTime(selectedWp, (PlayerEntity)this.field_230706_i_.field_71439_g)) {
                    CPacketFastTravel packet = new CPacketFastTravel(selectedWp);
                    LOTRPacketHandler.sendToServer(packet);
                    this.field_230706_i_.field_71439_g.func_71053_j();
                    return true;
                }
            }
            if (selectedWp == null && LOTRKeyHandler.KEY_BIND_MAP_TELEPORT.func_197976_a(key, scan) && this.isMouseWithinMap && this.canTeleport()) {
                CPacketMapTp packet = new CPacketMapTp(this.mouseXCoord, this.mouseZCoord);
                LOTRPacketHandler.sendToServer(packet);
                this.field_230706_i_.field_71439_g.func_71053_j();
                return true;
            }
            if (this.hasAreasOfInfluence() && this.isEscapeOrInventoryKey(key, scan)) {
                this.field_230706_i_.func_147108_a((Screen)new MiddleEarthFactionsScreen());
                return true;
            }
        }
        return super.func_231046_a_(key, scan, param3);
    }

    private void recentreMapOnPlayer() {
        this.recentreToX = this.getPlayerMapPosX();
        this.recentreToY = this.getPlayerMapPosY();
        this.recentreFromX = this.posX;
        this.recentreFromY = this.posY;
        this.recentreTicks = 6;
        this.selectObject(null);
    }

    private boolean isRecentringOnPlayer() {
        return this.recentreTicks > 0;
    }

    public boolean func_231042_a_(char c, int modifiers) {
        if (!this.hasOverlay && (this.selectedObject instanceof Waypoint ? this.waypointTooltip.charTyped(c, modifiers) : this.selectedObject instanceof MapMarker && this.markerTooltip.charTyped(c, modifiers))) {
            return true;
        }
        return super.func_231042_a_(c, modifiers);
    }

    private void handleMapKeyboardMovement() {
        this.posXMove = 0.0;
        this.posYMove = 0.0;
        if (!this.hasOverlay && !this.isRecentringOnPlayer()) {
            if (this.waypointTooltip.isTextFieldFocused() || this.markerTooltip.isTextFieldFocused()) {
                return;
            }
            float move = 12.0f / (float)Math.pow(this.zoomScale, 0.8f);
            if (this.isQuickMapMovement()) {
                move *= 2.0f;
            } else if (this.isFineMapMovement()) {
                move *= 0.5f;
            }
            if (this.isKeyboardKeyDown(this.field_230706_i_.field_71474_y.field_74370_x.getKey().func_197937_c()) || this.isKeyboardKeyDown(263)) {
                this.posXMove -= (double)move;
            }
            if (this.isKeyboardKeyDown(this.field_230706_i_.field_71474_y.field_74366_z.getKey().func_197937_c()) || this.isKeyboardKeyDown(262)) {
                this.posXMove += (double)move;
            }
            if (this.isKeyboardKeyDown(this.field_230706_i_.field_71474_y.field_74351_w.getKey().func_197937_c()) || this.isKeyboardKeyDown(265)) {
                this.posYMove -= (double)move;
            }
            if (this.isKeyboardKeyDown(this.field_230706_i_.field_71474_y.field_74368_y.getKey().func_197937_c()) || this.isKeyboardKeyDown(264)) {
                this.posYMove += (double)move;
            }
            if (this.posXMove != 0.0 || this.posYMove != 0.0) {
                this.selectObject(null);
            }
        }
    }

    private boolean isFineMapMovement() {
        return this.isKeyboardKeyDown(this.field_230706_i_.field_71474_y.field_228046_af_.getKey().func_197937_c());
    }

    private boolean isQuickMapMovement() {
        return this.isKeyboardKeyDown(this.field_230706_i_.field_71474_y.field_151444_V.getKey().func_197937_c());
    }

    private boolean isKeyboardKeyDown(int glfwKey) {
        return InputMappings.func_216506_a((long)this.field_230706_i_.func_228018_at_().func_198092_i(), (int)glfwKey);
    }

    public boolean func_231044_a_(double x, double y, int code) {
        if (this.creatingMarker) {
            if (code == 0) {
                int markerZ;
                int markerX = this.boundCreatingMarkerMouseX(x);
                if (this.isCreatingMarkerAtValidMousePosition(markerX, markerZ = this.boundCreatingMarkerMouseZ(y))) {
                    if (this.canCreateNewMarker()) {
                        int[] worldCoords = this.getCreatingMarkerWorldCoords(markerX, markerZ);
                        String defaultName = I18n.func_135052_a((String)"gui.lotr.map.widget.newMarker", (Object[])new Object[0]);
                        CPacketCreateMapMarker packet = new CPacketCreateMapMarker(worldCoords[0], worldCoords[1], defaultName);
                        LOTRPacketHandler.sendToServer(packet);
                        MiddleEarthMapScreen.playMarkerUpdateSound();
                    }
                    this.creatingMarker = false;
                    return true;
                }
            } else if (code == 1) {
                this.creatingMarker = false;
                return true;
            }
        } else if (this.mouseOverObject instanceof MapMarker) {
            MapMarker mouseOverMarker = (MapMarker)this.mouseOverObject;
            if (code == 1) {
                CPacketDeleteMapMarker packet = new CPacketDeleteMapMarker(mouseOverMarker);
                LOTRPacketHandler.sendToServer(packet);
                this.selectObject(null);
                MiddleEarthMapScreen.playMarkerSelectSound();
                return true;
            }
        }
        if (this.selectedObject instanceof Waypoint ? this.waypointTooltip.mouseClicked(x, y, code) : this.selectedObject instanceof MapMarker && this.markerTooltip.mouseClicked(x, y, code)) {
            return true;
        }
        return super.func_231044_a_(x, y, code);
    }

    public static void playWaypointSelectSound() {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187719_p, (float)1.0f));
    }

    public static void playMarkerUpdateSound() {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_219718_mk, (float)1.0f));
    }

    public static void playMarkerSelectSound() {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187546_ae, (float)1.0f));
    }

    public boolean func_231043_a_(double x, double y, double scroll) {
        if (super.func_231043_a_(x, y, scroll)) {
            return true;
        }
        if (!this.hasOverlay && this.zoomTicks == 0) {
            if (scroll < 0.0 && zoomPower > -3.0f) {
                this.zoomOut();
                return true;
            }
            if (scroll > 0.0 && zoomPower < 4.0f) {
                this.zoomIn();
                return true;
            }
        }
        return false;
    }

    private void zoomOut() {
        this.setZoom(zoomPower - this.getZoomIncrement());
    }

    private void zoomIn() {
        this.setZoom(zoomPower + this.getZoomIncrement());
    }

    private float getZoomIncrement() {
        return this.isQuickMapMovement() ? 1.5f : (this.isFineMapMovement() ? 0.25f : 1.0f);
    }

    private void setZoom(float newZoomPower) {
        this.prevZoomPower = zoomPower;
        zoomPower = MathHelper.func_76131_a((float)newZoomPower, (float)-3.0f, (float)4.0f);
        this.zoomTicks = 6;
        this.prevZoomTicks = 6;
        this.zoomingMessageDisplayTicks = 30;
        this.zoomingMessageIsZoomIn = zoomPower > this.prevZoomPower;
        this.selectObject(null);
    }

    private ITextComponent getZoomingDisplayMessage() {
        int numLevels = 7;
        float currentRelativeLevel = zoomPower - -3.0f;
        return new TranslationTextComponent(this.zoomingMessageIsZoomIn ? "gui.lotr.map.zoomingIn" : "gui.lotr.map.zoomingOut", new Object[]{ZOOM_DISPLAY_FORMAT.format(currentRelativeLevel), numLevels});
    }

    private boolean isMiddleEarth() {
        return this.field_230706_i_.field_71439_g != null && LOTRDimensions.isDimension(this.field_230706_i_.field_71439_g.field_70170_p, LOTRDimensions.MIDDLE_EARTH_WORLD_KEY);
    }

    private boolean canTeleport() {
        if (!this.isMiddleEarth()) {
            return false;
        }
        if (!this.field_230706_i_.field_71441_e.func_72863_F().func_217204_a((Entity)this.field_230706_i_.field_71439_g)) {
            return false;
        }
        this.requestIsOp();
        return this.isPlayerOp;
    }

    private void requestIsOp() {
        if (!this.sentOpRequestPacket) {
            CPacketIsOpRequest packet = new CPacketIsOpRequest();
            LOTRPacketHandler.sendToServer(packet);
            this.sentOpRequestPacket = true;
        }
    }

    public void receiveIsOp(boolean isOp) {
        this.isPlayerOp = isOp;
    }

    public void setMapViewportAndPositionAndScale(int xMin, int xMax, int yMin, int yMax, double x, double y, float scale, float scaleExp, float scaleStable) {
        this.viewportXMin = xMin;
        this.viewportXMax = xMax;
        this.viewportYMin = yMin;
        this.viewportYMax = yMax;
        this.viewportWidth = this.viewportXMax - this.viewportXMin;
        this.viewportHeight = this.viewportYMax - this.viewportYMin;
        this.prevPosX = this.posX = x;
        this.prevPosY = this.posY = y;
        this.zoomScale = scale;
        this.zoomExp = scaleExp;
        this.zoomScaleStable = scaleStable;
        this.keepMapPositionWithinBounds();
    }

    private static boolean isOSRS() {
        return false;
    }

    private /* synthetic */ void lambda$render$20(MatrixStack matStack, World world) {
        TranslationTextComponent s = new TranslationTextComponent("gui.lotr.map.areaOfInfluence.title", new Object[]{this.areaOfInfluenceFaction.getDisplayName()});
        int x = this.viewportXMin + this.viewportWidth / 2;
        int y = this.viewportYMin + 20;
        this.alignmentTextRenderer.drawAlignmentText(matStack, this.field_230712_o_, x - this.field_230712_o_.func_238414_a_((ITextProperties)s) / 2, y, (ITextComponent)s, 1.0f);
        if (!AreasOfInfluence.areAreasOfInfluenceEnabled(world)) {
            s = new TranslationTextComponent("gui.lotr.map.areaOfInfluence.disabled");
            this.alignmentTextRenderer.drawAlignmentText(matStack, this.field_230712_o_, x - this.field_230712_o_.func_238414_a_((ITextProperties)s) / 2, this.viewportYMin + this.viewportHeight / 2, (ITextComponent)s, 1.0f);
        }
    }

    private /* synthetic */ void lambda$render$19(ITextComponent tooltip, int mouseX, int mouseY, MatrixStack matStack) {
        int strWidth = this.field_230706_i_.field_71466_p.func_238414_a_((ITextProperties)tooltip);
        this.field_230706_i_.field_71466_p.getClass();
        int strHeight = 9;
        int rectX = mouseX + 12;
        int rectY = mouseY - 12;
        int border = 3;
        int rectWidth = strWidth + border * 2;
        int rectHeight = strHeight + border * 2;
        int mapBorder2 = 2;
        rectX = Math.max(rectX, this.viewportXMin + mapBorder2);
        rectX = Math.min(rectX, this.viewportXMax - mapBorder2 - rectWidth);
        rectY = Math.max(rectY, this.viewportYMin + mapBorder2);
        rectY = Math.min(rectY, this.viewportYMax - mapBorder2 - rectHeight);
        this.drawFancyRect(matStack, rectX, rectY, rectX + rectWidth, rectY + rectHeight);
        this.field_230712_o_.func_243248_b(matStack, tooltip, (float)(rectX + border), (float)(rectY + border), 0xFFFFFF);
    }

    public class MapDragListener
    implements IGuiEventListener {
        private boolean mouseDown;

        public boolean func_231047_b_(double x, double y) {
            if (MiddleEarthMapScreen.this.isMouseWithinMap) {
                return !MiddleEarthMapScreen.this.hasOverlay && !MiddleEarthMapScreen.this.isFacScrolling && !MiddleEarthMapScreen.this.isRecentringOnPlayer();
            }
            return false;
        }

        public boolean func_231044_a_(double x, double y, int code) {
            if (code == 0 && this.func_231047_b_(x, y)) {
                this.mouseDown = true;
                MiddleEarthMapScreen.this.selectObject(MiddleEarthMapScreen.this.mouseOverObject);
                return true;
            }
            return false;
        }

        public boolean func_231048_c_(double x, double y, int code) {
            if (code == 0) {
                this.mouseDown = false;
                return true;
            }
            return false;
        }

        public boolean func_231045_a_(double x, double y, int code, double dx, double dy) {
            if (this.mouseDown && code == 0) {
                MiddleEarthMapScreen.this.posX = MiddleEarthMapScreen.this.posX - dx / (double)MiddleEarthMapScreen.this.zoomScale;
                MiddleEarthMapScreen.this.posY = MiddleEarthMapScreen.this.posY - dy / (double)MiddleEarthMapScreen.this.zoomScale;
                MiddleEarthMapScreen.this.keepMapPositionWithinBounds();
                if (dx != 0.0 || dy != 0.0) {
                    MiddleEarthMapScreen.this.selectObject(null);
                }
                return true;
            }
            return false;
        }
    }
}

