/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.gui.map;

import java.text.DecimalFormat;
import lotr.client.util.LocalizableDecimalFormat;
import lotr.common.config.LOTRConfig;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class WaypointDistanceDisplay {
    private static final LocalizableDecimalFormat DECIMAL_FORMAT = new LocalizableDecimalFormat(new DecimalFormat(",##0.#"), "gui.lotr.map.distance.decimal_separator_char", "gui.lotr.map.distance.group_separator_char");
    private static final double METRES_PER_YARD = 0.9144;
    private static final double YARDS_PER_MILE = 1760.0;
    private static final double MILES_PER_LEAGUE = 3.0;
    private static final double LEAGUE_DISPLAY_THRESHOLD = 10.0;

    public static ITextComponent getDistanceText(double dist) {
        if (((Boolean)LOTRConfig.CLIENT.imperialWaypointDistances.get()).booleanValue()) {
            return WaypointDistanceDisplay.getImperialDistance(dist);
        }
        return WaypointDistanceDisplay.getMetricDistance(dist);
    }

    private static ITextComponent getMetricDistance(double dist) {
        int m = (int)Math.round(dist);
        if (m > 1000) {
            double km = (double)m / 1000.0;
            return new TranslationTextComponent("gui.lotr.map.distance.km", new Object[]{DECIMAL_FORMAT.format(km)});
        }
        return new TranslationTextComponent("gui.lotr.map.distance.m", new Object[]{DECIMAL_FORMAT.format(m)});
    }

    private static ITextComponent getImperialDistance(double dist) {
        int yards = (int)Math.round(dist / 0.9144);
        if ((double)yards > 1760.0) {
            double miles = (double)yards / 1760.0;
            double leagues = miles / 3.0;
            if (leagues > 10.0) {
                return new TranslationTextComponent("gui.lotr.map.distance.leagues", new Object[]{DECIMAL_FORMAT.format(leagues)});
            }
            return new TranslationTextComponent("gui.lotr.map.distance.miles", new Object[]{DECIMAL_FORMAT.format(miles)});
        }
        return new TranslationTextComponent("gui.lotr.map.distance.yards", new Object[]{DECIMAL_FORMAT.format(yards)});
    }
}

