/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.gui.util;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lotr.client.align.AlignmentFormatter;
import lotr.client.gui.PlayerMessageScreen;
import lotr.client.gui.util.AlignmentTextRenderer;
import lotr.client.gui.util.AlignmentTicker;
import lotr.client.util.LOTRClientUtil;
import lotr.common.config.LOTRConfig;
import lotr.common.data.AlignmentDataModule;
import lotr.common.data.LOTRLevelData;
import lotr.common.data.LOTRPlayerData;
import lotr.common.fac.AreasOfInfluence;
import lotr.common.fac.Faction;
import lotr.common.fac.FactionRank;
import lotr.common.fac.FactionSettings;
import lotr.common.fac.FactionSettingsManager;
import lotr.common.fac.RankGender;
import lotr.common.util.LOTRUtil;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;

public class AlignmentRenderer {
    public static final ResourceLocation ALIGNMENT_TEXTURE = new ResourceLocation("lotr", "textures/gui/alignment.png");
    private final AlignmentTextRenderer textRenderer;
    private int alignmentXBase;
    private int alignmentYBase;
    private int alignmentXCurrent;
    private int alignmentYCurrent;
    private int alignmentXPrev;
    private int alignmentYPrev;
    private static final int ALIGNMENT_Y_WHEN_OFFSCREEN = -20;
    private boolean firstAlignmentRender = true;
    private final Map<ResourceLocation, AlignmentTicker> factionTickers = new HashMap<ResourceLocation, AlignmentTicker>();
    private int alignDrainTick;
    private static final int ALIGN_DRAIN_DISPLAY_TIME = 200;
    private int alignDrainNum;

    public AlignmentRenderer(AlignmentTextRenderer textRenderer) {
        this.textRenderer = textRenderer;
    }

    private AlignmentTicker getOrCreateTickerForFaction(Faction fac) {
        return this.factionTickers.computeIfAbsent(fac.getName(), AlignmentTicker::new);
    }

    private boolean initialiseTickers() {
        FactionSettings currentFactionSettings = FactionSettingsManager.clientInstance().getCurrentLoadedFactions();
        if (currentFactionSettings != null) {
            List<Faction> allFactions = currentFactionSettings.getAllPlayableAlignmentFactions();
            allFactions.forEach(this::getOrCreateTickerForFaction);
            return true;
        }
        return false;
    }

    private void updateAllTickers(PlayerEntity player, boolean forceInstant) {
        this.factionTickers.values().forEach(ticker -> ticker.update(player, forceInstant));
    }

    public void updateHUD(Minecraft mc, PlayerEntity player) {
        this.setBarBasePosition(mc);
        this.updateBarCurrentPosition(mc, player);
        if (this.firstAlignmentRender) {
            if (this.initialiseTickers()) {
                this.updateAllTickers(player, true);
                this.alignmentXPrev = this.alignmentXCurrent = this.alignmentXBase;
                this.alignmentYCurrent = -20;
                this.alignmentYPrev = -20;
                this.firstAlignmentRender = false;
            }
        } else {
            this.updateAllTickers(player, false);
        }
        if (this.alignDrainTick > 0) {
            --this.alignDrainTick;
            if (this.alignDrainTick <= 0) {
                this.alignDrainNum = 0;
            }
        }
    }

    private void setBarBasePosition(Minecraft mc) {
        MainWindow mainWindow = mc.func_228018_at_();
        int width = mainWindow.func_198107_o();
        int height = mainWindow.func_198087_p();
        this.alignmentXBase = width / 2 + (Integer)LOTRConfig.CLIENT.alignmentXOffset.get();
        this.alignmentYBase = 4 + (Integer)LOTRConfig.CLIENT.alignmentYOffset.get();
        if (this.isBossActive()) {
            this.alignmentYBase += 20;
        }
        if (this.isInvasionWatched()) {
            this.alignmentYBase += 20;
        }
    }

    private void updateBarCurrentPosition(Minecraft mc, PlayerEntity player) {
        this.alignmentXPrev = this.alignmentXCurrent;
        this.alignmentYPrev = this.alignmentYCurrent;
        this.alignmentXCurrent = this.alignmentXBase;
        int yMove = (int)((float)(this.alignmentYBase - -20) / 3.0f);
        boolean alignmentOnscreen = (mc.field_71462_r == null || mc.field_71462_r instanceof PlayerMessageScreen) && !mc.field_71474_y.field_74321_H.func_151470_d() && !mc.field_71474_y.field_74330_P;
        this.alignmentYCurrent = alignmentOnscreen ? Math.min(this.alignmentYCurrent + yMove, this.alignmentYBase) : Math.max(this.alignmentYCurrent - yMove, -20);
    }

    public void displayAlignmentDrain(int numFactions) {
        this.alignDrainTick = 200;
        this.alignDrainNum = numFactions;
    }

    public void resetInMenu() {
        this.firstAlignmentRender = true;
        this.factionTickers.clear();
        this.alignDrainTick = 0;
        this.alignDrainNum = 0;
    }

    public void renderAlignmentHUDBar(MatrixStack matStack, Minecraft mc, PlayerEntity player, float partialTick) {
        if (this.firstAlignmentRender) {
            return;
        }
        LOTRPlayerData pd = LOTRLevelData.clientInstance().getData(player);
        AlignmentDataModule alignData = pd.getAlignmentData();
        Faction viewingFac = alignData.getCurrentViewedFaction();
        if (viewingFac != null) {
            float alignmentXF = (float)this.alignmentXPrev + (float)(this.alignmentXCurrent - this.alignmentXPrev) * partialTick;
            float alignmentYF = (float)this.alignmentYPrev + (float)(this.alignmentYCurrent - this.alignmentYPrev) * partialTick;
            boolean text = this.alignmentYCurrent == this.alignmentYBase;
            float alignment = this.getOrCreateTickerForFaction(viewingFac).getInterpolatedAlignment(partialTick);
            this.renderAlignmentBar(matStack, mc, player, alignment, false, viewingFac, alignmentXF, alignmentYF, text, text, text, false);
            if (this.alignDrainTick > 0 && text) {
                float alpha = 1.0f;
                int fadeTick = 20;
                if (this.alignDrainTick < fadeTick) {
                    alpha = (float)this.alignDrainTick / (float)fadeTick;
                }
                this.renderAlignmentDrain(matStack, mc, (int)alignmentXF - 155, (int)alignmentYF + 2, this.alignDrainNum, alpha);
            }
        }
    }

    private boolean isBossActive() {
        return false;
    }

    private boolean isInvasionWatched() {
        return false;
    }

    public void renderAlignmentBar(MatrixStack matStack, Minecraft mc, float alignment, boolean isOtherPlayer, Faction faction, float x, float y, boolean renderFacName, boolean renderValue, boolean renderLimits, boolean renderLimitValues) {
        this.renderAlignmentBar(matStack, mc, (PlayerEntity)mc.field_71439_g, alignment, isOtherPlayer, faction, x, y, renderFacName, renderValue, renderLimits, renderLimitValues);
    }

    private void renderAlignmentBar(MatrixStack matStack, Minecraft mc, PlayerEntity player, float alignment, boolean isOtherPlayer, Faction faction, float x, float y, boolean renderFacName, boolean renderValue, boolean renderLimits, boolean renderLimitValues) {
        LOTRPlayerData clientPD = LOTRLevelData.clientInstance().getData(player);
        AlignmentDataModule alignData = clientPD.getAlignmentData();
        FactionRank rank = faction.getRankFor(alignment);
        RankGender preferredRankGender = clientPD.getMiscData().getPreferredRankGender();
        boolean pledged = alignData.isPledgedTo(faction);
        AlignmentTicker ticker = this.getOrCreateTickerForFaction(faction);
        float alignMin = 0.0f;
        float alignMax = 0.0f;
        FactionRank rankMin = null;
        FactionRank rankMax = null;
        float pastRankMultiplier = 10.0f;
        if (!rank.isDummyRank()) {
            alignMin = rank.getAlignment();
            rankMin = rank;
            FactionRank nextRank = faction.getRankAbove(rank);
            if (nextRank != null && !nextRank.isDummyRank() && nextRank != rank) {
                alignMax = nextRank.getAlignment();
                rankMax = nextRank;
            } else {
                alignMax = rank.getAlignment() * 10.0f;
                rankMax = rank;
                while (alignment >= alignMax) {
                    alignMin = alignMax;
                    alignMax = alignMin * 10.0f;
                }
            }
        } else {
            FactionRank firstRank = faction.getFirstRank();
            float firstRankAlign = firstRank != null && !firstRank.isDummyRank() ? firstRank.getAlignment() : 10.0f;
            if (Math.abs(alignment) < firstRankAlign) {
                alignMin = -firstRankAlign;
                alignMax = firstRankAlign;
                rankMin = faction.getEnemyRank();
                rankMax = firstRank != null && !firstRank.isDummyRank() ? firstRank : faction.getNeutralRank();
            } else if (alignment < 0.0f) {
                alignMax = -firstRankAlign;
                alignMin = alignMax * 10.0f;
                rankMin = rankMax = faction.getEnemyRank();
                while (alignment <= alignMin) {
                    alignMin = (alignMax *= 10.0f) * 10.0f;
                }
            } else {
                alignMin = firstRankAlign;
                alignMax = alignMin * 10.0f;
                rankMin = rankMax = faction.getNeutralRank();
                while (alignment >= alignMax) {
                    alignMin = alignMax;
                    alignMax = alignMin * 10.0f;
                }
            }
        }
        float ringProgress = (alignment - alignMin) / (alignMax - alignMin);
        mc.func_110434_K().func_110577_a(ALIGNMENT_TEXTURE);
        int barWidth = 232;
        int barHeight = 14;
        int activeBarWidth = 220;
        float z = 0.0f;
        float[] factionColors = faction.getColorComponents();
        RenderSystem.color4f((float)factionColors[0], (float)factionColors[1], (float)factionColors[2], (float)1.0f);
        LOTRClientUtil.blitFloat(matStack, x - (float)(barWidth / 2), y, z, 0.0f, 14.0f, (float)barWidth, (float)barHeight);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        LOTRClientUtil.blitFloat(matStack, x - (float)(barWidth / 2), y, z, 0.0f, 0.0f, (float)barWidth, (float)barHeight);
        float ringProgressAdj = (ringProgress - 0.5f) * 2.0f;
        int ringSize = 16;
        float ringX = x - (float)(ringSize / 2) + ringProgressAdj * (float)activeBarWidth / 2.0f;
        float ringY = y + (float)(barHeight / 2) - (float)(ringSize / 2);
        int flashTick = ticker.getFlashTick();
        if (pledged) {
            LOTRClientUtil.blitFloat(matStack, ringX, ringY, z, (float)(16 * Math.round(flashTick / 3)), 212.0f, (float)ringSize, (float)ringSize);
        } else {
            LOTRClientUtil.blitFloat(matStack, ringX, ringY, z, (float)(16 * Math.round(flashTick / 3)), 36.0f, (float)ringSize, (float)ringSize);
        }
        if (faction.isPlayableAlignmentFaction()) {
            float alpha = 0.0f;
            boolean definedZone = false;
            AreasOfInfluence areasOfInfluence = faction.getAreasOfInfluence();
            if (areasOfInfluence.isInArea(player)) {
                alpha = 1.0f;
                definedZone = areasOfInfluence.isInDefinedArea(player);
            } else {
                alpha = areasOfInfluence.getAlignmentMultiplier(player);
                definedZone = true;
            }
            if (alpha > 0.0f) {
                int arrowSize = 14;
                int y0 = definedZone ? 60 : 88;
                int y1 = definedZone ? 74 : 102;
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.color4f((float)factionColors[0], (float)factionColors[1], (float)factionColors[2], (float)alpha);
                LOTRClientUtil.blitFloat(matStack, x - (float)(barWidth / 2) - (float)arrowSize, y, z, 0.0f, (float)y1, (float)arrowSize, (float)arrowSize);
                LOTRClientUtil.blitFloat(matStack, x + (float)(barWidth / 2), y, z, (float)arrowSize, (float)y1, (float)arrowSize, (float)arrowSize);
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                LOTRClientUtil.blitFloat(matStack, x - (float)(barWidth / 2) - (float)arrowSize, y, z, 0.0f, (float)y0, (float)arrowSize, (float)arrowSize);
                LOTRClientUtil.blitFloat(matStack, x + (float)(barWidth / 2), y, z, (float)arrowSize, (float)y0, (float)arrowSize, (float)arrowSize);
                RenderSystem.disableBlend();
            }
        }
        FontRenderer fr = mc.field_71466_p;
        int textX = Math.round(x);
        int textY = Math.round(y + (float)barHeight + 4.0f);
        if (renderLimits) {
            String sMin = rankMin.getDisplayShortName(preferredRankGender);
            String sMax = rankMax.getDisplayShortName(preferredRankGender);
            if (renderLimitValues) {
                sMin = I18n.func_135052_a((String)"gui.lotr.alignment.limits", (Object[])new Object[]{sMin, AlignmentFormatter.formatAlignForDisplay(alignMin)});
                sMax = I18n.func_135052_a((String)"gui.lotr.alignment.limits", (Object[])new Object[]{sMax, AlignmentFormatter.formatAlignForDisplay(alignMax)});
            }
            int limitsX = barWidth / 2 - 6;
            int xMin = Math.round(x - (float)limitsX);
            int xMax = Math.round(x + (float)limitsX);
            matStack.func_227860_a_();
            matStack.func_227862_a_(0.5f, 0.5f, 0.5f);
            this.textRenderer.drawAlignmentText(matStack, fr, xMin * 2 - fr.func_78256_a(sMin) / 2, textY * 2, (ITextComponent)new StringTextComponent(sMin), 1.0f);
            this.textRenderer.drawAlignmentText(matStack, fr, xMax * 2 - fr.func_78256_a(sMax) / 2, textY * 2, (ITextComponent)new StringTextComponent(sMax), 1.0f);
            matStack.func_227865_b_();
        }
        if (renderFacName) {
            IFormattableTextComponent name = faction.getDisplayName();
            this.textRenderer.drawAlignmentText(matStack, fr, textX - fr.func_238414_a_((ITextProperties)name) / 2, textY, (ITextComponent)name, 1.0f);
        }
        if (renderValue) {
            String alignS = AlignmentFormatter.formatAlignForDisplay(alignment);
            float alignAlpha = 1.0f;
            int numericalTick = ticker.getDisplayNumericalTick();
            if (numericalTick > 0) {
                alignS = AlignmentFormatter.formatAlignForDisplay(alignment);
                alignAlpha = LOTRUtil.normalisedTriangleWave(numericalTick, 30.0f, 0.7f, 1.0f);
                int fadeTick = 15;
                if (numericalTick < fadeTick) {
                    alignAlpha *= (float)numericalTick / (float)fadeTick;
                }
            } else {
                alignS = rank.getDisplayShortName(preferredRankGender);
                alignAlpha = 1.0f;
            }
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            int n = textX - fr.func_78256_a(alignS) / 2;
            fr.getClass();
            this.textRenderer.drawAlignmentText(matStack, fr, n, textY + 9 + 3, (ITextComponent)new StringTextComponent(alignS), alignAlpha);
            RenderSystem.disableBlend();
        }
    }

    public void renderAlignmentDrain(MatrixStack matStack, Minecraft mc, int x, int y, int numFactions) {
        this.renderAlignmentDrain(matStack, mc, x, y, numFactions, 1.0f);
    }

    public void renderAlignmentDrain(MatrixStack matStack, Minecraft mc, int x, int y, int numFactions, float alpha) {
        float z = 0.0f;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        mc.func_110434_K().func_110577_a(ALIGNMENT_TEXTURE);
        LOTRClientUtil.blitFloat(matStack, x, (float)y, z, 0.0f, 128.0f, 16.0f, 16.0f);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        StringTextComponent drainText = new StringTextComponent("-" + numFactions);
        FontRenderer fr = mc.field_71466_p;
        int n = x + 8 - fr.func_238414_a_((ITextProperties)drainText) / 2;
        fr.getClass();
        this.textRenderer.drawBorderedText(matStack, fr, n, y + 8 - 9 / 2, (ITextComponent)drainText, 0xFFFFFF, alpha);
        RenderSystem.disableBlend();
    }
}

