/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.render.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import lotr.client.render.GenderedRandomTextureVariants;
import lotr.client.render.entity.LOTRBipedRenderer;
import lotr.client.render.entity.model.HobbitModel;
import lotr.common.entity.npc.HobbitEntity;
import lotr.common.util.CalendarUtil;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.util.ResourceLocation;

public class HobbitRenderer
extends LOTRBipedRenderer<HobbitEntity, HobbitModel<HobbitEntity>> {
    private static final GenderedRandomTextureVariants SKINS = new GenderedRandomTextureVariants("lotr", "textures/entity/hobbit/hobbit");
    private static final GenderedRandomTextureVariants CHILD_SKINS = new GenderedRandomTextureVariants("lotr", "textures/entity/hobbit/child");
    private static final float HOBBIT_SCALE = 0.65f;

    public HobbitRenderer(EntityRendererManager mgr) {
        super(mgr, HobbitModel::new, new HobbitModel(0.5f), new HobbitModel(1.0f), 0.325f);
    }

    public ResourceLocation getEntityTexture(HobbitEntity hobbit) {
        return hobbit.func_70631_g_() ? CHILD_SKINS.getRandomSkin(hobbit) : SKINS.getRandomSkin(hobbit);
    }

    @Override
    protected void preRenderCallback(HobbitEntity hobbit, MatrixStack matStack, float f) {
        super.preRenderCallback(hobbit, matStack, f);
        float hobbitScale = CalendarUtil.isAprilFools() ? 2.0f : 0.65f;
        matStack.func_227862_a_(hobbitScale, hobbitScale, hobbitScale);
    }
}

