/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.render.entity.model;

import com.mojang.blaze3d.matrix.MatrixStack;
import lotr.client.render.entity.model.LOTRBipedModel;
import lotr.common.entity.npc.DwarfEntity;
import net.minecraft.util.HandSide;

public class DwarfModel<E extends DwarfEntity>
extends LOTRBipedModel<E> {
    private final float bodyScaleX = 1.25f;
    private final double armTranslateX = 0.0625;
    private final double legTranslateX = 0.015625;

    public DwarfModel(boolean smallArms) {
        this(0.0f, false, smallArms);
    }

    public DwarfModel(float f) {
        this(f, true, false);
    }

    public DwarfModel(float f, boolean isArmor, boolean smallArms) {
        super(f, 0.0f, isArmor, smallArms);
        if (!isArmor) {
            this.createLongHairModel(2.0f, f);
        }
    }

    @Override
    public void preBodyCallback(MatrixStack matStack) {
        matStack.func_227862_a_(1.25f, 1.0f, 1.0f);
    }

    @Override
    public void preRightArmCallback(MatrixStack matStack) {
        matStack.func_227861_a_(-0.0625, 0.0, 0.0);
    }

    @Override
    public void preLeftArmCallback(MatrixStack matStack) {
        matStack.func_227861_a_(0.0625, 0.0, 0.0);
    }

    @Override
    public void preRightLegCallback(MatrixStack matStack) {
        matStack.func_227861_a_(-0.015625, 0.0, 0.0);
        matStack.func_227862_a_(1.25f, 1.0f, 1.0f);
    }

    @Override
    public void preLeftLegCallback(MatrixStack matStack) {
        matStack.func_227861_a_(0.015625, 0.0, 0.0);
        matStack.func_227862_a_(1.25f, 1.0f, 1.0f);
    }

    @Override
    public void func_225599_a_(HandSide side, MatrixStack matStack) {
        double x = 0.0625 * (double)(side == HandSide.RIGHT ? -1 : 1);
        matStack.func_227861_a_(x, 0.0, 0.0);
        super.func_225599_a_(side, matStack);
    }
}

