/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.render.entity.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.function.Consumer;
import java.util.function.Function;
import lotr.common.entity.npc.NPCEntity;
import lotr.common.entity.npc.ai.NPCTalkAnimations;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class LOTRBipedModel<E extends LivingEntity>
extends BipedModel<E> {
    protected static final int STANDARD_BIPED_SKIN_WIDTH = 128;
    protected static final int STANDARD_BIPED_SKIN_HEIGHT = 64;
    protected static final int STANDARD_BIPED_ARMOR_WIDTH = 64;
    protected static final int STANDARD_BIPED_ARMOR_HEIGHT = 32;
    private final boolean isChildHeadScaled = true;
    private final float childHeadOffsetY = 16.0f;
    private final float childHeadOffsetZ = 0.0f;
    private final float childHeadScale = 2.0f;
    private final float childBodyScale = 2.0f;
    private final float childBodyOffsetY = 24.0f;
    protected ModelRenderer bipedChest;
    protected final boolean isArmor;
    public boolean showChest = false;
    public boolean isEating = false;
    private float talkingHeadYawRadians = 0.0f;
    private float talkingHeadPitchRadians = 0.0f;
    private float talkingGestureMainhand = 0.0f;
    private float talkingGestureOffhand = 0.0f;
    protected final ModelRenderer bipedLeftArmwear;
    protected final ModelRenderer bipedRightArmwear;
    protected final ModelRenderer bipedLeftLegwear;
    protected final ModelRenderer bipedRightLegwear;
    protected final ModelRenderer bipedBodywear;
    protected final boolean smallArms;

    public LOTRBipedModel(float modelSize, float yOff, boolean isArmor, boolean smallArms) {
        this(modelSize, yOff, isArmor ? 64 : 128, isArmor ? 32 : 64, isArmor, smallArms);
    }

    public LOTRBipedModel(float modelSize, float yOff, int texW, int texH, boolean isArmor, boolean smallArms) {
        this(RenderType::func_228640_c_, modelSize, yOff, texW, texH, isArmor, smallArms);
    }

    public LOTRBipedModel(Function<ResourceLocation, RenderType> renderType, float modelSize, float yOff, int texW, int texH, boolean isArmor, boolean smallArms) {
        super(renderType, modelSize, yOff, texW, texH);
        this.isArmor = isArmor;
        this.smallArms = smallArms;
        this.bipedChest = new ModelRenderer((Model)this, 32, 8);
        if (!isArmor) {
            this.bipedChest.func_228301_a_(-3.0f, 2.0f, -4.0f, 6.0f, 3.0f, 2.0f, modelSize);
            this.bipedChest.func_78793_a(0.0f, 0.0f, 0.0f);
            this.field_78115_e.func_78792_a(this.bipedChest);
        }
        if (!isArmor) {
            if (smallArms) {
                this.field_178724_i = new ModelRenderer((Model)this, 32, 48);
                this.field_178724_i.func_228301_a_(-1.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, modelSize);
                this.field_178724_i.func_78793_a(5.0f, 2.5f, 0.0f);
                this.field_178723_h = new ModelRenderer((Model)this, 40, 16);
                this.field_178723_h.func_228301_a_(-2.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, modelSize);
                this.field_178723_h.func_78793_a(-5.0f, 2.5f, 0.0f);
                this.bipedLeftArmwear = new ModelRenderer((Model)this, 48, 48);
                this.bipedLeftArmwear.func_228301_a_(-1.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, modelSize + 0.25f);
                this.bipedLeftArmwear.func_78793_a(5.0f, 2.5f, 0.0f);
                this.bipedRightArmwear = new ModelRenderer((Model)this, 40, 32);
                this.bipedRightArmwear.func_228301_a_(-2.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, modelSize + 0.25f);
                this.bipedRightArmwear.func_78793_a(-5.0f, 2.5f, 10.0f);
            } else {
                this.field_178724_i = new ModelRenderer((Model)this, 32, 48);
                this.field_178724_i.func_228301_a_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, modelSize);
                this.field_178724_i.func_78793_a(5.0f, 2.0f, 0.0f);
                this.bipedLeftArmwear = new ModelRenderer((Model)this, 48, 48);
                this.bipedLeftArmwear.func_228301_a_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, modelSize + 0.25f);
                this.bipedLeftArmwear.func_78793_a(5.0f, 2.0f, 0.0f);
                this.bipedRightArmwear = new ModelRenderer((Model)this, 40, 32);
                this.bipedRightArmwear.func_228301_a_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, modelSize + 0.25f);
                this.bipedRightArmwear.func_78793_a(-5.0f, 2.0f, 10.0f);
            }
            this.field_178722_k = new ModelRenderer((Model)this, 16, 48);
            this.field_178722_k.func_228301_a_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, modelSize);
            this.field_178722_k.func_78793_a(1.9f, 12.0f, 0.0f);
            this.bipedLeftLegwear = new ModelRenderer((Model)this, 0, 48);
            this.bipedLeftLegwear.func_228301_a_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, modelSize + 0.25f);
            this.bipedLeftLegwear.func_78793_a(1.9f, 12.0f, 0.0f);
            this.bipedRightLegwear = new ModelRenderer((Model)this, 0, 32);
            this.bipedRightLegwear.func_228301_a_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, modelSize + 0.25f);
            this.bipedRightLegwear.func_78793_a(-1.9f, 12.0f, 0.0f);
            this.bipedBodywear = new ModelRenderer((Model)this, 16, 32);
            this.bipedBodywear.func_228301_a_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, modelSize + 0.25f);
            this.bipedBodywear.func_78793_a(0.0f, 0.0f, 0.0f);
        } else {
            this.bipedRightLegwear = this.bipedBodywear = new ModelRenderer((Model)this, 0, 0);
            this.bipedLeftLegwear = this.bipedBodywear;
            this.bipedRightArmwear = this.bipedBodywear;
            this.bipedLeftArmwear = this.bipedBodywear;
        }
    }

    protected void createLongHairModel(float headRotationY, float f) {
        this.field_178720_f = new ModelRenderer((Model)this, 56, 0);
        this.field_178720_f.func_228301_a_(-4.0f, -8.0f, -4.0f, 8.0f, 24.0f, 8.0f, 0.5f + f);
        this.field_178720_f.func_78793_a(0.0f, headRotationY, 0.0f);
    }

    protected Iterable<ModelRenderer> func_225600_b_() {
        Iterable superBodyParts = super.func_225600_b_();
        if (this.isArmor) {
            return superBodyParts;
        }
        return Iterables.concat((Iterable)superBodyParts, (Iterable)ImmutableList.of((Object)this.bipedLeftLegwear, (Object)this.bipedRightLegwear, (Object)this.bipedLeftArmwear, (Object)this.bipedRightArmwear, (Object)this.bipedBodywear));
    }

    public void func_225598_a_(MatrixStack matStack, IVertexBuilder buf, int packedLight, int packedOverlay, float r, float g, float b, float a) {
        float scale;
        matStack.func_227860_a_();
        this.preRenderAllCallback(matStack);
        matStack.func_227860_a_();
        this.preHeadCallback(matStack);
        if (this.field_217114_e) {
            scale = 0.75f;
            matStack.func_227862_a_(scale, scale, scale);
            matStack.func_227861_a_(0.0, 1.0, 0.0);
            this.postChildHeadCallback(matStack);
        }
        this.field_78116_c.func_228309_a_(matStack, buf, packedLight, packedOverlay, r, g, b, a);
        this.field_178720_f.func_228309_a_(matStack, buf, packedLight, packedOverlay, r, g, b, a);
        matStack.func_227865_b_();
        matStack.func_227860_a_();
        if (this.field_217114_e) {
            scale = 0.5f;
            matStack.func_227862_a_(scale, scale, scale);
            matStack.func_227861_a_(0.0, 1.5, 0.0);
        }
        matStack.func_227860_a_();
        this.preBodyCallback(matStack);
        this.field_78115_e.func_228309_a_(matStack, buf, packedLight, packedOverlay, r, g, b, a);
        this.bipedBodywear.func_228309_a_(matStack, buf, packedLight, packedOverlay, r, g, b, a);
        matStack.func_227865_b_();
        matStack.func_227860_a_();
        this.preRightArmCallback(matStack);
        this.field_178723_h.func_228309_a_(matStack, buf, packedLight, packedOverlay, r, g, b, a);
        this.bipedRightArmwear.func_228309_a_(matStack, buf, packedLight, packedOverlay, r, g, b, a);
        matStack.func_227865_b_();
        matStack.func_227860_a_();
        this.preLeftArmCallback(matStack);
        this.field_178724_i.func_228309_a_(matStack, buf, packedLight, packedOverlay, r, g, b, a);
        this.bipedLeftArmwear.func_228309_a_(matStack, buf, packedLight, packedOverlay, r, g, b, a);
        matStack.func_227865_b_();
        matStack.func_227860_a_();
        this.preRightLegCallback(matStack);
        this.field_178721_j.func_228309_a_(matStack, buf, packedLight, packedOverlay, r, g, b, a);
        this.bipedRightLegwear.func_228309_a_(matStack, buf, packedLight, packedOverlay, r, g, b, a);
        matStack.func_227865_b_();
        matStack.func_227860_a_();
        this.preLeftLegCallback(matStack);
        this.field_178722_k.func_228309_a_(matStack, buf, packedLight, packedOverlay, r, g, b, a);
        this.bipedLeftLegwear.func_228309_a_(matStack, buf, packedLight, packedOverlay, r, g, b, a);
        matStack.func_227865_b_();
        matStack.func_227865_b_();
        matStack.func_227865_b_();
    }

    public void preRenderAllCallback(MatrixStack matStack) {
    }

    public void preHeadCallback(MatrixStack matStack) {
    }

    public void postChildHeadCallback(MatrixStack matStack) {
    }

    public void preBodyCallback(MatrixStack matStack) {
    }

    public void preRightArmCallback(MatrixStack matStack) {
    }

    public void preLeftArmCallback(MatrixStack matStack) {
    }

    public void preRightLegCallback(MatrixStack matStack) {
    }

    public void preLeftLegCallback(MatrixStack matStack) {
    }

    public void setTalkAnimation(NPCTalkAnimations talkAnims, float f) {
        this.talkingHeadYawRadians = talkAnims.getHeadYawRadians(f);
        this.talkingHeadPitchRadians = talkAnims.getHeadPitchRadians(f);
        this.talkingGestureMainhand = talkAnims.getMainhandGestureAmount(f);
        this.talkingGestureOffhand = talkAnims.getOffhandGestureAmount(f);
    }

    public void func_217111_a(EntityModel<E> other) {
        BipedModel otherBiped;
        super.func_217111_a(other);
        if (other instanceof BipedModel) {
            otherBiped = (BipedModel)other;
            otherBiped.field_187075_l = this.field_187075_l;
            otherBiped.field_187076_m = this.field_187076_m;
            otherBiped.field_228270_o_ = this.field_228270_o_;
        }
        if (other instanceof LOTRBipedModel) {
            otherBiped = (LOTRBipedModel)other;
            otherBiped.showChest = this.showChest;
            otherBiped.isEating = this.isEating;
            otherBiped.talkingHeadYawRadians = this.talkingHeadYawRadians;
            otherBiped.talkingHeadPitchRadians = this.talkingHeadPitchRadians;
            otherBiped.talkingGestureMainhand = this.talkingGestureMainhand;
            otherBiped.talkingGestureOffhand = this.talkingGestureOffhand;
        }
    }

    public void func_225597_a_(E entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.func_225597_a_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.bipedChest.field_78806_j = this.showChest;
        if (this.isEating) {
            this.onArm((LivingEntity)entity, Hand.MAIN_HAND, arm -> {
                arm.field_78795_f = Math.min(arm.field_78795_f, (float)Math.toRadians(-60.0));
            });
        }
        this.field_78116_c.field_78796_g += this.talkingHeadYawRadians;
        this.field_78116_c.field_78795_f += this.talkingHeadPitchRadians;
        this.field_178720_f.field_78796_g += this.talkingHeadYawRadians;
        this.field_178720_f.field_78795_f += this.talkingHeadPitchRadians;
        float rightGestureAmount = entity.func_184591_cq() == HandSide.RIGHT ? this.talkingGestureMainhand : this.talkingGestureOffhand;
        float leftGestureAmount = entity.func_184591_cq() == HandSide.RIGHT ? this.talkingGestureOffhand : this.talkingGestureMainhand;
        this.field_178723_h.field_78795_f = (float)((double)this.field_178723_h.field_78795_f + (double)rightGestureAmount * Math.toRadians(-45.0));
        this.field_178723_h.field_78808_h = (float)((double)this.field_178723_h.field_78808_h + (double)rightGestureAmount * Math.toRadians(20.0));
        this.field_178724_i.field_78795_f = (float)((double)this.field_178724_i.field_78795_f + (double)leftGestureAmount * Math.toRadians(-45.0));
        this.field_178724_i.field_78808_h = (float)((double)this.field_178724_i.field_78808_h + (double)leftGestureAmount * Math.toRadians(-20.0));
        if (entity instanceof NPCEntity && !this.field_217113_d) {
            this.field_178721_j.field_78796_g = (float)Math.toRadians(5.0);
            this.field_178722_k.field_78796_g = (float)Math.toRadians(-5.0);
        }
        if (entity instanceof NPCEntity && ((NPCEntity)entity).isDrunk()) {
            float f6 = ageInTicks / 80.0f;
            float f7 = (ageInTicks + 40.0f) / 80.0f;
            float f8 = MathHelper.func_76126_a((float)(f6 *= (float)Math.PI * 2)) * 0.5f;
            float f9 = MathHelper.func_76126_a((float)(f7 *= (float)Math.PI * 2)) * 0.5f;
            this.field_78116_c.field_78795_f += f8;
            this.field_78116_c.field_78796_g += f9;
            this.field_178720_f.field_78795_f += f8;
            this.field_178720_f.field_78796_g += f9;
            for (Hand hand : Hand.values()) {
                if (entity.func_184586_b(hand).func_190926_b()) continue;
                this.onArm((LivingEntity)entity, hand, arm -> {
                    arm.field_78795_f = (float)Math.toRadians(-60.0);
                });
            }
        }
        this.bipedLeftLegwear.func_217177_a(this.field_178722_k);
        this.bipedRightLegwear.func_217177_a(this.field_178721_j);
        this.bipedLeftArmwear.func_217177_a(this.field_178724_i);
        this.bipedRightArmwear.func_217177_a(this.field_178723_h);
        this.bipedBodywear.func_217177_a(this.field_78115_e);
    }

    private void onArm(LivingEntity entity, Hand handType, Consumer<ModelRenderer> action) {
        HandSide mainHandSide = entity.func_184591_cq();
        if (mainHandSide == HandSide.RIGHT) {
            action.accept(handType == Hand.MAIN_HAND ? this.field_178723_h : this.field_178724_i);
        } else {
            action.accept(handType == Hand.MAIN_HAND ? this.field_178724_i : this.field_178723_h);
        }
    }

    public void func_178719_a(boolean visible) {
        super.func_178719_a(visible);
        this.bipedLeftArmwear.field_78806_j = visible;
        this.bipedRightArmwear.field_78806_j = visible;
        this.bipedLeftLegwear.field_78806_j = visible;
        this.bipedRightLegwear.field_78806_j = visible;
        this.bipedBodywear.field_78806_j = visible;
    }

    public void func_225599_a_(HandSide side, MatrixStack matStack) {
        ModelRenderer arm = this.func_187074_a(side);
        if (this.smallArms) {
            float f = 0.5f * (float)(side == HandSide.RIGHT ? 1 : -1);
            arm.field_78800_c += f;
            arm.func_228307_a_(matStack);
            arm.field_78800_c -= f;
        } else {
            arm.func_228307_a_(matStack);
        }
    }
}

