/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.render.entity.model.armor;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import lotr.client.event.LOTRTickHandlerClient;
import lotr.client.render.entity.model.armor.ItemStackDependentModel;
import lotr.client.render.entity.model.armor.SpecialArmorModel;
import lotr.client.render.entity.model.armor.WearerDependentArmorModel;
import lotr.common.entity.capabilities.PlateFallingData;
import lotr.common.entity.capabilities.PlateFallingDataProvider;
import lotr.common.init.LOTRBlocks;
import lotr.common.item.PlateItem;
import lotr.common.tileentity.PlateTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.common.util.LazyOptional;

public class PlateOnHeadModel
extends SpecialArmorModel<LivingEntity>
implements ItemStackDependentModel,
WearerDependentArmorModel {
    private Block plateBlock;
    private LazyOptional<PlateFallingData> fallingData = LazyOptional.empty();
    private ItemStack currentHeldItem = ItemStack.field_190927_a;
    private final PlateTileEntity fakePlateTE = new PlateTileEntity();

    public PlateOnHeadModel(BipedModel referenceBipedModel) {
        super(referenceBipedModel, 0.0f);
    }

    @Override
    public void setModelItem(ItemStack stack) {
        this.plateBlock = stack.func_77973_b() instanceof PlateItem ? ((PlateItem)stack.func_77973_b()).getBlock() : (Block)LOTRBlocks.FINE_PLATE.get();
    }

    @Override
    public void acceptWearingEntity(LivingEntity entity) {
        this.fallingData = entity.getCapability(PlateFallingDataProvider.CAPABILITY);
        this.currentHeldItem = entity.func_184614_ca();
    }

    @Override
    public void func_225598_a_(MatrixStack matStack, IVertexBuilder buf, int packedLight, int packedOverlay, float r, float g, float b, float a) {
        float partialTick = LOTRTickHandlerClient.renderPartialTick;
        float fallingOffset = this.fallingData.map(d -> Float.valueOf(d.getPlateOffsetY(partialTick))).orElse(Float.valueOf(0.0f)).floatValue();
        IRenderTypeBuffer.Impl renderTypeBuf = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        RenderSystem.disableCull();
        matStack.func_227860_a_();
        this.field_78116_c.func_228307_a_(matStack);
        matStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        matStack.func_227861_a_(-0.5, 0.45 + (double)fallingOffset * 0.5, -0.5);
        this.renderPlateBlockModel(matStack, (IRenderTypeBuffer)renderTypeBuf, packedLight, packedOverlay);
        if (PlateTileEntity.isValidFoodItem(this.currentHeldItem)) {
            ItemStack heldItemMinusOne = this.currentHeldItem.func_77946_l();
            heldItemMinusOne.func_190918_g(1);
            if (!heldItemMinusOne.func_190926_b()) {
                this.fakePlateTE.setFoodItem(heldItemMinusOne);
                this.fakePlateTE.setFallingDataForRender(this.fallingData);
                TileEntityRendererDispatcher.field_147556_a.func_147547_b((TileEntity)this.fakePlateTE).func_225616_a_((TileEntity)this.fakePlateTE, partialTick, matStack, (IRenderTypeBuffer)renderTypeBuf, packedLight, packedOverlay);
                this.fakePlateTE.setFoodItem(null);
            }
        }
        matStack.func_227865_b_();
        RenderSystem.enableCull();
        this.fallingData = LazyOptional.empty();
        this.fakePlateTE.setFallingDataForRender((LazyOptional<PlateFallingData>)this.fallingData);
    }

    private void renderPlateBlockModel(MatrixStack matStack, IRenderTypeBuffer renderTypeBuf, int light, int overlay) {
        BlockState state = this.plateBlock.func_176223_P();
        Minecraft.func_71410_x().func_175602_ab().renderBlock(state, matStack, renderTypeBuf, light, overlay, (IModelData)EmptyModelData.INSTANCE);
    }
}

