/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.render.model;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lotr.common.LOTRLog;
import lotr.common.util.LOTRUtil;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.SimpleReloadableResourceManager;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.ISelectiveResourceReloadListener;
import net.minecraftforge.resource.VanillaResourceType;

public class HandheldItemModels
implements ISelectiveResourceReloadListener {
    public static final HandheldItemModels INSTANCE = new HandheldItemModels();
    private static final String HANDHELD_SUFFIX = "handheld";
    private List<ResourceLocation> specialHandheldItemNames = new ArrayList<ResourceLocation>();

    private HandheldItemModels() {
    }

    public void setupAndDetectModels(Minecraft mc) {
        SimpleReloadableResourceManager resMgr = (SimpleReloadableResourceManager)mc.func_195551_G();
        resMgr.func_219534_a((IFutureReloadListener)this);
        this.detectSpecialHandhelds((IResourceManager)resMgr);
    }

    public void onResourceManagerReload(IResourceManager resMgr, Predicate<IResourceType> predicate) {
        if (predicate.test((IResourceType)VanillaResourceType.MODELS)) {
            this.detectSpecialHandhelds(resMgr);
        }
    }

    private void detectSpecialHandhelds(IResourceManager resMgr) {
        this.specialHandheldItemNames.clear();
        for (ResourceLocation itemName : ForgeRegistries.ITEMS.getKeys()) {
            ResourceLocation fullHandheldModelPath = new ResourceLocation(itemName.func_110624_b(), String.format("models/item/%s_%s.json", itemName.func_110623_a(), HANDHELD_SUFFIX));
            if (!resMgr.func_219533_b(fullHandheldModelPath)) continue;
            this.addSpecialHandheld(itemName);
        }
        LOTRLog.info("Automatically detected and registered %d special handheld items!", this.specialHandheldItemNames.size());
    }

    private void addSpecialHandheld(ResourceLocation itemName) {
        this.specialHandheldItemNames.add(itemName);
        ModelLoader.addSpecialModel((ResourceLocation)this.getHandheldModelLocation(itemName));
    }

    private ModelResourceLocation getHandheldModelLocation(ResourceLocation itemName) {
        return new ModelResourceLocation(String.format("%s_%s", itemName, HANDHELD_SUFFIX), "inventory");
    }

    public void onModelBake(ModelBakeEvent event) {
        Map modelMap = event.getModelRegistry();
        for (ResourceLocation itemName : this.specialHandheldItemNames) {
            ModelResourceLocation modelName = new ModelResourceLocation(itemName, "inventory");
            ModelResourceLocation handheldModelName = this.getHandheldModelLocation(itemName);
            IBakedModel defaultModel = (IBakedModel)modelMap.get(modelName);
            IBakedModel handheldModel = (IBakedModel)modelMap.get(handheldModelName);
            if (defaultModel == null) {
                throw new IllegalStateException("Could not find default inventory model for " + modelName);
            }
            if (handheldModel == null) {
                throw new IllegalStateException("Could not find handheld model for " + handheldModelName);
            }
            HandheldWrapperModel.remapHandheldModelOverrides((ResourceLocation)modelName, defaultModel, handheldModel);
            HandheldWrapperModel wrapperModel = new HandheldWrapperModel(defaultModel, handheldModel);
            modelMap.put(modelName, wrapperModel);
        }
    }

    private static class HandheldWrapperModel
    implements IBakedModel {
        private final IBakedModel defaultModel;
        private final IBakedModel handheldModel;

        public HandheldWrapperModel(IBakedModel defaultModel, IBakedModel handheldModel) {
            this.defaultModel = defaultModel;
            this.handheldModel = handheldModel;
        }

        public static void remapHandheldModelOverrides(ResourceLocation modelName, IBakedModel defaultModel, IBakedModel handheldModel) {
            try {
                ItemOverrideList overrides = handheldModel.func_188617_f();
                Field f_overrideBakedModels = ObfuscationReflectionHelper.findField(ItemOverrideList.class, (String)"field_209582_c");
                LOTRUtil.unlockFinalField(f_overrideBakedModels);
                List overrideModels = (List)f_overrideBakedModels.get(overrides);
                List remappedOverrideModels = overrideModels.stream().map(handheldOverride -> new HandheldWrapperModel(defaultModel, (IBakedModel)handheldOverride)).collect(Collectors.toList());
                f_overrideBakedModels.set(overrides, remappedOverrideModels);
            }
            catch (Exception e) {
                LOTRLog.error("Failed to remap handheld model overrides for model %s", modelName);
                e.printStackTrace();
            }
        }

        public List<BakedQuad> func_200117_a(BlockState state, Direction cullFace, Random rand) {
            return this.getQuads(state, cullFace, rand, (IModelData)EmptyModelData.INSTANCE);
        }

        public List<BakedQuad> getQuads(BlockState state, Direction side, Random rand, IModelData extraData) {
            return this.defaultModel.getQuads(state, side, rand, extraData);
        }

        public boolean func_177555_b() {
            return this.defaultModel.func_177555_b();
        }

        public boolean func_177556_c() {
            return this.defaultModel.func_177556_c();
        }

        public boolean func_230044_c_() {
            return this.defaultModel.func_230044_c_();
        }

        public boolean func_188618_c() {
            return this.defaultModel.func_188618_c();
        }

        public TextureAtlasSprite func_177554_e() {
            return this.getParticleTexture((IModelData)EmptyModelData.INSTANCE);
        }

        public TextureAtlasSprite getParticleTexture(IModelData extraData) {
            return this.defaultModel.getParticleTexture(extraData);
        }

        public ItemOverrideList func_188617_f() {
            return this.handheldModel.func_188617_f();
        }

        public IBakedModel handlePerspective(ItemCameraTransforms.TransformType transformType, MatrixStack mat) {
            IBakedModel modelToUse = this.defaultModel;
            if (transformType == ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND || transformType == ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND || transformType == ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND || transformType == ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND) {
                modelToUse = this.handheldModel;
            }
            return ForgeHooksClient.handlePerspective((IBakedModel)modelToUse, (ItemCameraTransforms.TransformType)transformType, (MatrixStack)mat);
        }
    }
}

