/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.render.model.connectedtex;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lotr.client.render.model.connectedtex.ConnectedTexture2DContext;
import lotr.client.render.model.connectedtex.ConnectedTextureFaceMapper;
import lotr.common.block.GateBlock;
import lotr.common.block.WattleAndDaubBlock;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelProperty;

public class ConnectedTexture3DContext
implements IModelData {
    private static final Map<Integer, ConnectedTexture3DContext> ALL_RELEVANT_3D_CONTEXTS = (Map)Util.func_200696_a(new HashMap(), map -> {
        int maxCombinedBits = (1 << PositionOfInterest.values().length) - 1;
        for (int combinedBitFlag = 0; combinedBitFlag <= maxCombinedBits; ++combinedBitFlag) {
            ConnectedTexture3DContext ctx = new ConnectedTexture3DContext(combinedBitFlag);
            if (ctx.hasIrrelevantPositions()) continue;
            map.put(combinedBitFlag, ctx);
        }
    });
    private static final Map<Integer, Map<Direction, ConnectedTexture2DContext>> CONTEXT_TO_FACE_2D_CONTEXT_MAP = ALL_RELEVANT_3D_CONTEXTS.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
        ConnectedTexture3DContext ctx3d = (ConnectedTexture3DContext)entry.getValue();
        return Stream.of(Direction.values()).collect(Collectors.toMap(UnaryOperator.identity(), dir -> ConnectedTextureFaceMapper.get2dFrom3d(ctx3d, dir)));
    }));
    private final int combinedPositionBitFlags;

    private ConnectedTexture3DContext(Set<PositionOfInterest> positionsOfInterest) {
        int combined = 0;
        for (PositionOfInterest poi : positionsOfInterest) {
            combined |= poi.bitFlag;
        }
        this.combinedPositionBitFlags = combined;
    }

    private ConnectedTexture3DContext(int combinedPositionBitFlags) {
        this.combinedPositionBitFlags = combinedPositionBitFlags;
    }

    public static ConnectedTexture3DContext newEmptyContext() {
        return new ConnectedTexture3DContext((Set<PositionOfInterest>)ImmutableSet.of());
    }

    public static ConnectedTexture3DContext newContextFrom(Collection<PositionOfInterest> pois) {
        return new ConnectedTexture3DContext(EnumSet.copyOf(pois));
    }

    public static ConnectedTexture3DContext gatherFromWorld(IBlockDisplayReader world, BlockPos pos, BlockState state, TransformationMatrix blockstateRotation, BlockConnectionType connectionType) {
        EnumSet<PositionOfInterest> pois = EnumSet.noneOf(PositionOfInterest.class);
        BlockPos.Mutable movingPos = new BlockPos.Mutable();
        for (PositionOfInterest poi : PositionOfInterest.values()) {
            movingPos.func_189533_g((Vector3i)pos);
            List<Direction> poiOffsets = poi.offsets.stream().map(arg_0 -> ((TransformationMatrix)blockstateRotation).rotateTransform(arg_0)).collect(Collectors.toList());
            poiOffsets.forEach(arg_0 -> ((BlockPos.Mutable)movingPos).func_189536_c(arg_0));
            if (!connectionType.connects(state, world.func_180495_p((BlockPos)movingPos), poiOffsets)) continue;
            pois.add(poi);
        }
        ConnectedTexture3DContext.pruneIrrelevantPositions(pois);
        return new ConnectedTexture3DContext(pois);
    }

    private static void pruneIrrelevantPositions(Set<PositionOfInterest> pois) {
        pois.removeIf(poi -> {
            if (!poi.isCompoundOffset()) return false;
            if (!ConnectedTexture3DContext.isIrrelevantCompoundOffsetPosition(poi, pois::contains)) return false;
            return true;
        });
    }

    private static boolean isIrrelevantCompoundOffsetPosition(PositionOfInterest poi, Predicate<PositionOfInterest> isOtherPoiContained) {
        return poi.offsets.stream().map(PositionOfInterest.SIMPLE_OFFSET_POSITIONS::get).noneMatch(isOtherPoiContained);
    }

    public boolean has(PositionOfInterest poi) {
        return (this.combinedPositionBitFlags & poi.bitFlag) != 0;
    }

    public int getCombinedBitFlags() {
        return this.combinedPositionBitFlags;
    }

    private boolean hasIrrelevantPositions() {
        return PositionOfInterest.COMPOUND_OFFSET_POSITIONS.stream().filter(this::has).anyMatch(poi -> ConnectedTexture3DContext.isIrrelevantCompoundOffsetPosition(poi, this::has));
    }

    public ConnectedTexture2DContext getFace2DContext(Direction face) {
        return CONTEXT_TO_FACE_2D_CONTEXT_MAP.get(this.combinedPositionBitFlags).get(face);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other != null && other.getClass() == this.getClass()) {
            ConnectedTexture3DContext otherData = (ConnectedTexture3DContext)other;
            return this.combinedPositionBitFlags == otherData.combinedPositionBitFlags;
        }
        return false;
    }

    public int hashCode() {
        return this.getCombinedBitFlags();
    }

    public String toString() {
        String s = "ConnectedTexture3DContext[";
        int added = 0;
        for (PositionOfInterest poi : PositionOfInterest.values()) {
            if (!this.has(poi)) continue;
            if (added > 0) {
                s = s + ", ";
            }
            s = s + poi.name();
            ++added;
        }
        s = s + "]";
        return s;
    }

    public boolean hasProperty(ModelProperty<?> prop) {
        return false;
    }

    public <T> T getData(ModelProperty<T> prop) {
        return null;
    }

    public <T> T setData(ModelProperty<T> prop, T data) {
        return null;
    }

    public static enum BlockConnectionType {
        SAME_BLOCK("same_block", (state, otherState, offsets) -> state.func_177230_c() == otherState.func_177230_c()),
        NO_CONNECTIONS("no_connections", (state, otherState, offsets) -> false),
        GATE("gate", GateBlock::doBlocksConnectVisually),
        CONNECTED_WATTLE("connected_wattle", WattleAndDaubBlock::doBlocksConnectVisually);

        private final String name;
        private final BlockConnectionTest connectionTest;
        private static final Map<String, BlockConnectionType> TYPES_BY_NAME;

        private BlockConnectionType(String name, BlockConnectionTest connectionTest) {
            this.name = name;
            this.connectionTest = connectionTest;
        }

        public boolean connects(BlockState state, BlockState otherState, List<Direction> offsets) {
            return this.connectionTest.test(state, otherState, offsets);
        }

        public static BlockConnectionType getByName(String name) {
            return TYPES_BY_NAME.get(name);
        }

        static {
            TYPES_BY_NAME = Stream.of(BlockConnectionType.values()).collect(Collectors.toMap(type -> type.name, UnaryOperator.identity()));
        }

        @FunctionalInterface
        public static interface BlockConnectionTest {
            public boolean test(BlockState var1, BlockState var2, List<Direction> var3);
        }
    }

    public static enum PositionOfInterest {
        DOWN("down", Direction.DOWN),
        UP("up", Direction.UP),
        NORTH("north", Direction.NORTH),
        SOUTH("south", Direction.SOUTH),
        WEST("west", Direction.WEST),
        EAST("east", Direction.EAST),
        DOWN_NORTH("down_north", Direction.DOWN, Direction.NORTH),
        DOWN_SOUTH("down_south", Direction.DOWN, Direction.SOUTH),
        DOWN_WEST("down_west", Direction.DOWN, Direction.WEST),
        DOWN_EAST("down_east", Direction.DOWN, Direction.EAST),
        UP_NORTH("up_north", Direction.UP, Direction.NORTH),
        UP_SOUTH("up_south", Direction.UP, Direction.SOUTH),
        UP_WEST("up_west", Direction.UP, Direction.WEST),
        UP_EAST("up_east", Direction.UP, Direction.EAST),
        NORTH_WEST("north_west", Direction.NORTH, Direction.WEST),
        NORTH_EAST("north_east", Direction.NORTH, Direction.EAST),
        SOUTH_WEST("south_west", Direction.SOUTH, Direction.WEST),
        SOUTH_EAST("south_east", Direction.SOUTH, Direction.EAST);

        public final int bitFlag = 1 << this.ordinal();
        public final String nameInJson;
        public final List<Direction> offsets;
        private static final Map<String, PositionOfInterest> POSITIONS_BY_NAME;
        public static final Map<Direction, PositionOfInterest> SIMPLE_OFFSET_POSITIONS;
        public static final List<PositionOfInterest> COMPOUND_OFFSET_POSITIONS;

        private PositionOfInterest(String s, Direction ... offs) {
            this.nameInJson = s;
            this.offsets = Arrays.asList(offs);
            if (this.offsets.isEmpty()) {
                throw new IllegalArgumentException("Connected tex: position of interest '" + this.nameInJson + "' offsets must not be empty");
            }
        }

        public boolean isSimpleOffset() {
            return this.offsets.size() == 1;
        }

        public boolean isCompoundOffset() {
            return this.offsets.size() > 1;
        }

        public static PositionOfInterest getByJsonName(String name) {
            return POSITIONS_BY_NAME.get(name);
        }

        static {
            POSITIONS_BY_NAME = Stream.of(PositionOfInterest.values()).collect(Collectors.toMap(poi -> poi.nameInJson, UnaryOperator.identity()));
            SIMPLE_OFFSET_POSITIONS = Stream.of(PositionOfInterest.values()).filter(PositionOfInterest::isSimpleOffset).collect(Collectors.toMap(poi -> poi.offsets.get(0), UnaryOperator.identity()));
            COMPOUND_OFFSET_POSITIONS = Stream.of(PositionOfInterest.values()).filter(PositionOfInterest::isCompoundOffset).collect(Collectors.toList());
        }
    }
}

