/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.render.model.connectedtex;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import lotr.client.render.model.connectedtex.ConnectedTexture2DContext;
import lotr.client.render.model.connectedtex.ConnectedTexture3DContext;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;

public abstract class ConnectedTextureFaceMapper {
    public static final Map<Direction, ConnectedTextureFaceMapper> FACE_MAPPERS = (Map)Util.func_200696_a(new HashMap(), map -> {
        map.put(Direction.DOWN, new ConnectedTextureFaceMapper(){

            @Override
            public ConnectedTexture3DContext.PositionOfInterest getPositionToCheck(ConnectedTexture2DContext.RelativePosition pos) {
                switch (pos) {
                    case TOP_LEFT: {
                        return ConnectedTexture3DContext.PositionOfInterest.SOUTH_WEST;
                    }
                    case TOP: {
                        return ConnectedTexture3DContext.PositionOfInterest.SOUTH;
                    }
                    case TOP_RIGHT: {
                        return ConnectedTexture3DContext.PositionOfInterest.SOUTH_EAST;
                    }
                    case LEFT: {
                        return ConnectedTexture3DContext.PositionOfInterest.WEST;
                    }
                    case RIGHT: {
                        return ConnectedTexture3DContext.PositionOfInterest.EAST;
                    }
                    case BOTTOM_LEFT: {
                        return ConnectedTexture3DContext.PositionOfInterest.NORTH_WEST;
                    }
                    case BOTTOM: {
                        return ConnectedTexture3DContext.PositionOfInterest.NORTH;
                    }
                    case BOTTOM_RIGHT: {
                        return ConnectedTexture3DContext.PositionOfInterest.NORTH_EAST;
                    }
                }
                throw new IllegalArgumentException(pos.name());
            }
        });
        map.put(Direction.UP, new ConnectedTextureFaceMapper(){

            @Override
            public ConnectedTexture3DContext.PositionOfInterest getPositionToCheck(ConnectedTexture2DContext.RelativePosition pos) {
                switch (pos) {
                    case TOP_LEFT: {
                        return ConnectedTexture3DContext.PositionOfInterest.NORTH_WEST;
                    }
                    case TOP: {
                        return ConnectedTexture3DContext.PositionOfInterest.NORTH;
                    }
                    case TOP_RIGHT: {
                        return ConnectedTexture3DContext.PositionOfInterest.NORTH_EAST;
                    }
                    case LEFT: {
                        return ConnectedTexture3DContext.PositionOfInterest.WEST;
                    }
                    case RIGHT: {
                        return ConnectedTexture3DContext.PositionOfInterest.EAST;
                    }
                    case BOTTOM_LEFT: {
                        return ConnectedTexture3DContext.PositionOfInterest.SOUTH_WEST;
                    }
                    case BOTTOM: {
                        return ConnectedTexture3DContext.PositionOfInterest.SOUTH;
                    }
                    case BOTTOM_RIGHT: {
                        return ConnectedTexture3DContext.PositionOfInterest.SOUTH_EAST;
                    }
                }
                throw new IllegalArgumentException(pos.name());
            }
        });
        map.put(Direction.NORTH, new ConnectedTextureFaceMapper(){

            @Override
            public ConnectedTexture3DContext.PositionOfInterest getPositionToCheck(ConnectedTexture2DContext.RelativePosition pos) {
                switch (pos) {
                    case TOP_LEFT: {
                        return ConnectedTexture3DContext.PositionOfInterest.UP_EAST;
                    }
                    case TOP: {
                        return ConnectedTexture3DContext.PositionOfInterest.UP;
                    }
                    case TOP_RIGHT: {
                        return ConnectedTexture3DContext.PositionOfInterest.UP_WEST;
                    }
                    case LEFT: {
                        return ConnectedTexture3DContext.PositionOfInterest.EAST;
                    }
                    case RIGHT: {
                        return ConnectedTexture3DContext.PositionOfInterest.WEST;
                    }
                    case BOTTOM_LEFT: {
                        return ConnectedTexture3DContext.PositionOfInterest.DOWN_EAST;
                    }
                    case BOTTOM: {
                        return ConnectedTexture3DContext.PositionOfInterest.DOWN;
                    }
                    case BOTTOM_RIGHT: {
                        return ConnectedTexture3DContext.PositionOfInterest.DOWN_WEST;
                    }
                }
                throw new IllegalArgumentException(pos.name());
            }
        });
        map.put(Direction.SOUTH, new ConnectedTextureFaceMapper(){

            @Override
            public ConnectedTexture3DContext.PositionOfInterest getPositionToCheck(ConnectedTexture2DContext.RelativePosition pos) {
                switch (pos) {
                    case TOP_LEFT: {
                        return ConnectedTexture3DContext.PositionOfInterest.UP_WEST;
                    }
                    case TOP: {
                        return ConnectedTexture3DContext.PositionOfInterest.UP;
                    }
                    case TOP_RIGHT: {
                        return ConnectedTexture3DContext.PositionOfInterest.UP_EAST;
                    }
                    case LEFT: {
                        return ConnectedTexture3DContext.PositionOfInterest.WEST;
                    }
                    case RIGHT: {
                        return ConnectedTexture3DContext.PositionOfInterest.EAST;
                    }
                    case BOTTOM_LEFT: {
                        return ConnectedTexture3DContext.PositionOfInterest.DOWN_WEST;
                    }
                    case BOTTOM: {
                        return ConnectedTexture3DContext.PositionOfInterest.DOWN;
                    }
                    case BOTTOM_RIGHT: {
                        return ConnectedTexture3DContext.PositionOfInterest.DOWN_EAST;
                    }
                }
                throw new IllegalArgumentException(pos.name());
            }
        });
        map.put(Direction.WEST, new ConnectedTextureFaceMapper(){

            @Override
            public ConnectedTexture3DContext.PositionOfInterest getPositionToCheck(ConnectedTexture2DContext.RelativePosition pos) {
                switch (pos) {
                    case TOP_LEFT: {
                        return ConnectedTexture3DContext.PositionOfInterest.UP_NORTH;
                    }
                    case TOP: {
                        return ConnectedTexture3DContext.PositionOfInterest.UP;
                    }
                    case TOP_RIGHT: {
                        return ConnectedTexture3DContext.PositionOfInterest.UP_SOUTH;
                    }
                    case LEFT: {
                        return ConnectedTexture3DContext.PositionOfInterest.NORTH;
                    }
                    case RIGHT: {
                        return ConnectedTexture3DContext.PositionOfInterest.SOUTH;
                    }
                    case BOTTOM_LEFT: {
                        return ConnectedTexture3DContext.PositionOfInterest.DOWN_NORTH;
                    }
                    case BOTTOM: {
                        return ConnectedTexture3DContext.PositionOfInterest.DOWN;
                    }
                    case BOTTOM_RIGHT: {
                        return ConnectedTexture3DContext.PositionOfInterest.DOWN_SOUTH;
                    }
                }
                throw new IllegalArgumentException(pos.name());
            }
        });
        map.put(Direction.EAST, new ConnectedTextureFaceMapper(){

            @Override
            public ConnectedTexture3DContext.PositionOfInterest getPositionToCheck(ConnectedTexture2DContext.RelativePosition pos) {
                switch (pos) {
                    case TOP_LEFT: {
                        return ConnectedTexture3DContext.PositionOfInterest.UP_SOUTH;
                    }
                    case TOP: {
                        return ConnectedTexture3DContext.PositionOfInterest.UP;
                    }
                    case TOP_RIGHT: {
                        return ConnectedTexture3DContext.PositionOfInterest.UP_NORTH;
                    }
                    case LEFT: {
                        return ConnectedTexture3DContext.PositionOfInterest.SOUTH;
                    }
                    case RIGHT: {
                        return ConnectedTexture3DContext.PositionOfInterest.NORTH;
                    }
                    case BOTTOM_LEFT: {
                        return ConnectedTexture3DContext.PositionOfInterest.DOWN_SOUTH;
                    }
                    case BOTTOM: {
                        return ConnectedTexture3DContext.PositionOfInterest.DOWN;
                    }
                    case BOTTOM_RIGHT: {
                        return ConnectedTexture3DContext.PositionOfInterest.DOWN_NORTH;
                    }
                }
                throw new IllegalArgumentException(pos.name());
            }
        });
    });

    private ConnectedTextureFaceMapper() {
    }

    abstract ConnectedTexture3DContext.PositionOfInterest getPositionToCheck(ConnectedTexture2DContext.RelativePosition var1);

    public static ConnectedTexture2DContext get2dFrom3d(ConnectedTexture3DContext ctx3d, Direction side) {
        ConnectedTextureFaceMapper faceMapper = FACE_MAPPERS.get(side);
        EnumSet<ConnectedTexture2DContext.RelativePosition> relativePositions = EnumSet.noneOf(ConnectedTexture2DContext.RelativePosition.class);
        for (ConnectedTexture2DContext.RelativePosition rPos : ConnectedTexture2DContext.RelativePosition.values()) {
            if (rPos == ConnectedTexture2DContext.RelativePosition.CENTRE) {
                relativePositions.add(rPos);
                continue;
            }
            if (!ctx3d.has(faceMapper.getPositionToCheck(rPos))) continue;
            relativePositions.add(rPos);
        }
        return new ConnectedTexture2DContext(relativePositions);
    }
}

