/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.render.model.connectedtex;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lotr.client.render.model.BlockModelQuadsHolder;
import lotr.client.render.model.BlockModelUtil;
import lotr.client.render.model.DynamicTextureRepository;
import lotr.client.render.model.connectedtex.ConnectedTexture3DContext;
import lotr.client.render.model.connectedtex.ConnectedTextureBlockModel;
import lotr.client.render.model.connectedtex.ConnectedTextureElement;
import lotr.client.render.model.connectedtex.TextureConnectionProperties;
import lotr.client.render.model.connectedtex.UnresolvedTextureConnectionProperties;
import lotr.common.LOTRLog;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.BlockPart;
import net.minecraft.client.renderer.model.BlockPartFace;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.Direction;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraftforge.client.model.IModelBuilder;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.geometry.ISimpleModelGeometry;

public class ConnectedTextureUnbakedModel
implements ISimpleModelGeometry<ConnectedTextureUnbakedModel> {
    private final List<BlockPart> elements;
    private final Map<String, UnresolvedTextureConnectionProperties> texturesConnectionProperties;
    private final List<ConnectedTexture3DContext.PositionOfInterest> itemConnectedContextPoints;
    private final ConnectedTexture3DContext.BlockConnectionType connectionType;

    public ConnectedTextureUnbakedModel(List<BlockPart> elements, Map<String, UnresolvedTextureConnectionProperties> texturesConnectionProperties, List<ConnectedTexture3DContext.PositionOfInterest> itemContext, ConnectedTexture3DContext.BlockConnectionType cType) {
        this.elements = elements;
        this.texturesConnectionProperties = texturesConnectionProperties;
        this.itemConnectedContextPoints = itemContext;
        this.connectionType = cType;
    }

    private Map<ResourceLocation, TextureConnectionProperties> getResolvedTextureConnectionProperties(IModelConfiguration owner) {
        Function<String, ResourceLocation> textureResolver = s -> owner.resolveTexture(s).func_229313_b_();
        return this.texturesConnectionProperties.entrySet().stream().collect(Collectors.toMap(e -> (ResourceLocation)textureResolver.apply((String)e.getKey()), e -> TextureConnectionProperties.resolveFrom((UnresolvedTextureConnectionProperties)e.getValue(), textureResolver)));
    }

    public void addQuads(IModelConfiguration owner, IModelBuilder<?> modelBuilder, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ResourceLocation modelLocation) {
    }

    public Collection<RenderMaterial> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        HashSet textures = Sets.newHashSet();
        for (BlockPart part : this.elements) {
            for (BlockPartFace face : part.field_178240_c.values()) {
                RenderMaterial texture = owner.resolveTexture(face.field_178242_d);
                if (Objects.equals(texture.func_229313_b_().toString(), MissingTextureSprite.func_195675_b().toString())) {
                    missingTextureErrors.add((Pair<String, String>)Pair.of((Object)face.field_178242_d, (Object)owner.getModelName()));
                }
                textures.add(texture);
            }
        }
        Map<ResourceLocation, TextureConnectionProperties> resolvedConnectionProps = this.getResolvedTextureConnectionProperties(owner);
        HashSet allConnectedTextures = Sets.newHashSet();
        for (RenderMaterial texture : textures) {
            ResourceLocation textureName = texture.func_229313_b_();
            if (Objects.equals(textureName.toString(), MissingTextureSprite.func_195675_b().toString())) continue;
            TextureConnectionProperties connectionProperties = resolvedConnectionProps.getOrDefault(textureName, TextureConnectionProperties.defaultProps(textureName));
            List<ResourceLocation> connected = DynamicTextureRepository.INSTANCE.generateAllConnectedTextures(connectionProperties);
            connected.forEach(connectedRes -> {
                RenderMaterial connectedMaterial = new RenderMaterial(texture.func_229310_a_(), connectedRes);
                allConnectedTextures.add(connectedMaterial);
            });
        }
        textures.addAll(allConnectedTextures);
        return textures;
    }

    public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
        TextureAtlasSprite particle = spriteGetter.apply(owner.resolveTexture("particle"));
        Builder builder = new Builder(owner, overrides).setParticle(particle);
        this.addQuads(owner, builder, bakery, spriteGetter, modelTransform, modelLocation);
        DeferredConnectedTextureModelBakery deferredBakery = new DeferredConnectedTextureModelBakery(owner, spriteGetter, modelTransform, modelLocation, this.elements, this.getResolvedTextureConnectionProperties(owner));
        builder.setDeferredConnectedModelBakery(deferredBakery);
        builder.setBlockstateRotation(modelTransform.func_225615_b_());
        builder.createItemConnectedContext(this.itemConnectedContextPoints);
        builder.setBlockConnectionType(this.connectionType);
        return builder.build();
    }

    public static final class Builder
    implements IModelBuilder {
        private final ItemOverrideList builderItemOverrideList;
        private final boolean builderAmbientOcclusion;
        private TextureAtlasSprite particleTexture;
        private final boolean isSideLight;
        private final boolean builderGui3d;
        private final ItemCameraTransforms builderCameraTransforms;
        private DeferredConnectedTextureModelBakery deferredConnectedModelBakery;
        private TransformationMatrix blockstateRotation;
        private ConnectedTexture3DContext itemContext;
        private ConnectedTexture3DContext.BlockConnectionType connectionType;

        public Builder(IModelConfiguration model, ItemOverrideList overrides) {
            this(model.useSmoothLighting(), model.isSideLit(), model.isShadedInGui(), model.getCameraTransforms(), overrides);
        }

        public Builder(BlockModel model, ItemOverrideList overrides, boolean g3d) {
            this(model.func_178309_b(), model.func_230176_c_().func_230178_a_(), g3d, model.func_181682_g(), overrides);
        }

        private Builder(boolean ambOcc, boolean sideLight, boolean g3d, ItemCameraTransforms transform, ItemOverrideList overrides) {
            this.builderItemOverrideList = overrides;
            this.builderAmbientOcclusion = ambOcc;
            this.isSideLight = sideLight;
            this.builderGui3d = g3d;
            this.builderCameraTransforms = transform;
        }

        public void setDeferredConnectedModelBakery(DeferredConnectedTextureModelBakery bakery) {
            this.deferredConnectedModelBakery = bakery;
        }

        public void setBlockstateRotation(TransformationMatrix rotation) {
            this.blockstateRotation = rotation;
        }

        public Builder addFaceQuad(Direction facing, BakedQuad quad) {
            throw new UnsupportedOperationException("Add them through the BlockModelQuadsHolder map instead");
        }

        public Builder addGeneralQuad(BakedQuad quad) {
            throw new UnsupportedOperationException("Add them through the BlockModelQuadsHolder map instead");
        }

        public Builder setParticle(TextureAtlasSprite texture) {
            this.particleTexture = texture;
            return this;
        }

        public Builder createItemConnectedContext(List<ConnectedTexture3DContext.PositionOfInterest> points) {
            this.itemContext = points == null ? ConnectedTexture3DContext.newEmptyContext() : ConnectedTexture3DContext.newContextFrom(points);
            return this;
        }

        public Builder setBlockConnectionType(ConnectedTexture3DContext.BlockConnectionType type) {
            this.connectionType = type == null ? ConnectedTexture3DContext.BlockConnectionType.SAME_BLOCK : type;
            return this;
        }

        public IBakedModel build() {
            if (this.particleTexture == null) {
                throw new RuntimeException("Missing particle!");
            }
            return new ConnectedTextureBlockModel(this.builderAmbientOcclusion, this.isSideLight, this.builderGui3d, this.particleTexture, this.builderCameraTransforms, this.builderItemOverrideList, this.deferredConnectedModelBakery, this.blockstateRotation, this.itemContext, this.connectionType);
        }
    }

    public static final class Loader
    implements IModelLoader<ConnectedTextureUnbakedModel> {
        public static final Loader INSTANCE = new Loader();

        private Loader() {
        }

        public void func_195410_a(IResourceManager resourceManager) {
        }

        public ConnectedTextureUnbakedModel read(JsonDeserializationContext deserializationContext, JsonObject modelObj) {
            String connectionTypeName;
            ArrayList parts = Lists.newArrayList();
            HashMap<String, UnresolvedTextureConnectionProperties> texturesConnectionProperties = new HashMap<String, UnresolvedTextureConnectionProperties>();
            List itemContextPoints = null;
            ConnectedTexture3DContext.BlockConnectionType connectionType = null;
            if (modelObj.has("elements")) {
                for (Object element : JSONUtils.func_151214_t((JsonObject)modelObj, (String)"elements")) {
                    parts.add(deserializationContext.deserialize((JsonElement)element, BlockPart.class));
                }
            }
            if (modelObj.has("texture_connection_properties")) {
                JsonObject texturePropsMap = JSONUtils.func_152754_s((JsonObject)modelObj, (String)"texture_connection_properties");
                for (Map.Entry entry : texturePropsMap.entrySet()) {
                    String textureString = (String)entry.getKey();
                    if (BlockModelUtil.validateTextureString(textureString)) {
                        UnresolvedTextureConnectionProperties properties = UnresolvedTextureConnectionProperties.read(textureString, ((JsonElement)entry.getValue()).getAsJsonObject());
                        texturesConnectionProperties.put(textureString, properties);
                        continue;
                    }
                    LOTRLog.error("Texture name '%s' in texture_connection_properties is not a valid texture path or #reference", textureString);
                }
            }
            if (modelObj.has("item_connected_context")) {
                itemContextPoints = this.loadItemContextParts(modelObj, "item_connected_context");
            }
            if (modelObj.has("block_connection_type") && (connectionType = ConnectedTexture3DContext.BlockConnectionType.getByName(connectionTypeName = modelObj.get("block_connection_type").getAsString())) == null) {
                connectionType = ConnectedTexture3DContext.BlockConnectionType.SAME_BLOCK;
                LOTRLog.error("Connected texture model has unknown block_connection_type %s - defaulting to %s", new Object[]{connectionTypeName, connectionType});
            }
            if (modelObj.has("parent")) {
                IUnbakedModel parentModel;
                String parent = modelObj.get("parent").getAsString();
                ResourceLocation parentLocation = new ResourceLocation(parent);
                HashSet<ResourceLocation> parentModels = new HashSet<ResourceLocation>();
                parentModels.add(parentLocation);
                while (parentLocation != null && (parentModel = ModelLoader.instance().func_209597_a(parentLocation)) instanceof BlockModel) {
                    BlockModel blockModel = (BlockModel)parentModel;
                    if (blockModel.customData.getCustomGeometry() instanceof ConnectedTextureUnbakedModel) {
                        ConnectedTextureUnbakedModel parentCTM = (ConnectedTextureUnbakedModel)blockModel.customData.getCustomGeometry();
                        parts.addAll(parentCTM.elements);
                        parentCTM.texturesConnectionProperties.forEach(texturesConnectionProperties::putIfAbsent);
                        if (itemContextPoints == null && parentCTM.itemConnectedContextPoints != null) {
                            itemContextPoints = parentCTM.itemConnectedContextPoints;
                        }
                        if (connectionType == null && parentCTM.connectionType != null) {
                            connectionType = parentCTM.connectionType;
                        }
                    } else {
                        parts.addAll(blockModel.func_178298_a());
                    }
                    if (!parentModels.contains(parentLocation = blockModel.getParentLocation())) continue;
                    LOTRLog.error("Circular reference in connected texture model 'parent' tree: %s already present", parentLocation);
                    break;
                }
            }
            return new ConnectedTextureUnbakedModel(parts, texturesConnectionProperties, itemContextPoints, connectionType);
        }

        private List<ConnectedTexture3DContext.PositionOfInterest> loadItemContextParts(JsonObject modelObj, String arrayName) {
            ArrayList parts = Lists.newArrayList();
            for (JsonElement element : JSONUtils.func_151214_t((JsonObject)modelObj, (String)arrayName)) {
                String poiName = element.getAsString();
                ConnectedTexture3DContext.PositionOfInterest poi = ConnectedTexture3DContext.PositionOfInterest.getByJsonName(poiName);
                if (poi == null) {
                    LOTRLog.error("Error in connected texture model item_connected_context: no 'point of interest' named %s", poiName);
                    continue;
                }
                parts.add(poi);
            }
            return parts;
        }
    }

    public static class DeferredConnectedTextureModelBakery {
        public final IModelConfiguration owner;
        public final Function<RenderMaterial, TextureAtlasSprite> spriteGetter;
        public final IModelTransform modelTransform;
        public final ResourceLocation modelLocation;
        private final List<BlockPart> elements;
        private final Map<ResourceLocation, TextureConnectionProperties> texturesConnectionProperties;
        private final Map<Integer, BlockModelQuadsHolder> createdBakedModelsFor3dContext = new HashMap<Integer, BlockModelQuadsHolder>();

        public DeferredConnectedTextureModelBakery(IModelConfiguration owner, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ResourceLocation modelLocation, List<BlockPart> elements, Map<ResourceLocation, TextureConnectionProperties> texturesConnectionProperties) {
            this.owner = owner;
            this.spriteGetter = spriteGetter;
            this.modelTransform = modelTransform;
            this.modelLocation = modelLocation;
            this.elements = elements;
            this.texturesConnectionProperties = texturesConnectionProperties;
        }

        public BlockModelQuadsHolder getOrCreateBakedModelFor3DContext(ConnectedTexture3DContext ctx3d) {
            int key = ctx3d.getCombinedBitFlags();
            return this.createdBakedModelsFor3dContext.computeIfAbsent(key, i -> {
                ArrayList generalQuads = Lists.newArrayList();
                EnumMap builderFaceQuads = Maps.newEnumMap(Direction.class);
                for (Direction dir : Direction.values()) {
                    builderFaceQuads.put(dir, Lists.newArrayList());
                }
                for (BlockPart blockpart : this.elements) {
                    for (Direction direction : blockpart.field_178240_c.keySet()) {
                        BlockPartFace blockpartface = (BlockPartFace)blockpart.field_178240_c.get(direction);
                        RenderMaterial material = this.owner.resolveTexture(blockpartface.field_178242_d);
                        ResourceLocation texture = material.func_229313_b_();
                        TextureConnectionProperties connectionProperties = this.texturesConnectionProperties.getOrDefault(texture, TextureConnectionProperties.defaultProps(texture));
                        Set<ConnectedTextureElement> elementSet = ctx3d.getFace2DContext(direction).getTextureElements(connectionProperties.includeBaseElement());
                        ResourceLocation connectedTexture = DynamicTextureRepository.INSTANCE.getConnectedTexture(connectionProperties, elementSet);
                        TextureAtlasSprite icon = this.spriteGetter.apply(new RenderMaterial(material.func_229310_a_(), connectedTexture));
                        if (blockpartface.field_178244_b == null) {
                            generalQuads.add(BlockModel.makeBakedQuad((BlockPart)blockpart, (BlockPartFace)blockpartface, (TextureAtlasSprite)icon, (Direction)direction, (IModelTransform)this.modelTransform, (ResourceLocation)this.modelLocation));
                            continue;
                        }
                        ((List)builderFaceQuads.get(this.modelTransform.func_225615_b_().rotateTransform(blockpartface.field_178244_b))).add(BlockModel.makeBakedQuad((BlockPart)blockpart, (BlockPartFace)blockpartface, (TextureAtlasSprite)icon, (Direction)direction, (IModelTransform)this.modelTransform, (ResourceLocation)this.modelLocation));
                    }
                }
                BlockModelQuadsHolder holder = new BlockModelQuadsHolder(generalQuads, builderFaceQuads);
                return holder;
            });
        }
    }
}

