/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.render.model.connectedtex;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import lotr.client.render.model.connectedtex.ConnectedTextureElement;
import lotr.client.render.model.connectedtex.UnresolvedTextureConnectionProperties;
import net.minecraft.util.ResourceLocation;

public class TextureConnectionProperties {
    private final ResourceLocation textureName;
    private final Optional<Map<ConnectedTextureElement, ResourceLocation>> elementPathOverrides;
    private final boolean includeBaseElement;
    private final boolean makeFromSingleIcon;

    public TextureConnectionProperties(ResourceLocation textureName, Optional<Map<ConnectedTextureElement, ResourceLocation>> elementPathOverrides, boolean includeBaseElement, boolean makeFromSingleIcon) {
        this.textureName = textureName;
        this.elementPathOverrides = elementPathOverrides;
        this.includeBaseElement = includeBaseElement;
        this.makeFromSingleIcon = makeFromSingleIcon;
    }

    public static TextureConnectionProperties defaultProps(ResourceLocation textureName) {
        return new TextureConnectionProperties(textureName, Optional.empty(), true, false);
    }

    public static TextureConnectionProperties resolveFrom(UnresolvedTextureConnectionProperties unresolved, Function<String, ResourceLocation> textureResolver) {
        return new TextureConnectionProperties(textureResolver.apply(unresolved.textureName), TextureConnectionProperties.resolveUnresolvedElementPathOverrides(unresolved.elementPathOverrides, textureResolver), unresolved.includeBaseElement, unresolved.makeFromSingleIcon);
    }

    private static Optional<Map<ConnectedTextureElement, ResourceLocation>> resolveUnresolvedElementPathOverrides(Optional<Map<ConnectedTextureElement, String>> unresolvedOpt, Function<String, ResourceLocation> textureResolver) {
        if (unresolvedOpt.isPresent()) {
            Map<ConnectedTextureElement, String> unresolvedMap = unresolvedOpt.get();
            Map<ConnectedTextureElement, ResourceLocation> resolvedMap = unresolvedMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (ResourceLocation)textureResolver.apply((String)e.getValue())));
            return Optional.of(resolvedMap);
        }
        return Optional.empty();
    }

    public ResourceLocation getBaseTextureName() {
        return this.textureName;
    }

    public Optional<ResourceLocation> getElementIconPath(ConnectedTextureElement element) {
        if (element == ConnectedTextureElement.BASE) {
            throw new IllegalArgumentException("This method should not be used to determine the base icon - this is a development error");
        }
        if (this.elementPathOverrides.isPresent()) {
            return Optional.ofNullable(this.elementPathOverrides.get().get((Object)element));
        }
        return Optional.of(new ResourceLocation(this.textureName + element.getDefaultIconSuffix()));
    }

    public boolean includeBaseElement() {
        return this.includeBaseElement;
    }

    public boolean makeFromSingleIcon() {
        return this.makeFromSingleIcon;
    }

    public ResourceLocation getCanonicalCacheKey() {
        return new ResourceLocation(this.textureName.func_110624_b(), String.format("%s.connectedproperties__overrides_%s__includebaseelement_%s__makefromsingleicon_%s", this.textureName.func_110623_a(), this.getCanonicalFormForElementPathOverrides(), this.includeBaseElement, this.makeFromSingleIcon));
    }

    private String getCanonicalFormForElementPathOverrides() {
        if (this.elementPathOverrides.isPresent()) {
            Map<ConnectedTextureElement, ResourceLocation> map = this.elementPathOverrides.get();
            ArrayList<ConnectedTextureElement> sortedKeys = new ArrayList<ConnectedTextureElement>(map.keySet());
            Collections.sort(sortedKeys, Comparator.comparingInt(elem -> elem.ordinal()));
            return sortedKeys.stream().map(elem -> {
                String elemName = elem.elementName;
                String pathOverride = ((ResourceLocation)map.get(elem)).toString().replace(':', '.');
                return elemName + "_" + pathOverride;
            }).collect(Collectors.joining("_"));
        }
        return "none";
    }
}

