/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.render.model.connectedtex;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lotr.client.render.model.BlockModelUtil;
import lotr.client.render.model.connectedtex.ConnectedTextureElement;
import lotr.common.LOTRLog;
import net.minecraft.util.JSONUtils;

public class UnresolvedTextureConnectionProperties {
    public final String textureName;
    public final Optional<Map<ConnectedTextureElement, String>> elementPathOverrides;
    public final boolean includeBaseElement;
    public final boolean makeFromSingleIcon;

    public UnresolvedTextureConnectionProperties(String textureName, Optional<Map<ConnectedTextureElement, String>> elementPathOverrides, boolean includeBaseElement, boolean makeFromSingleIcon) {
        this.textureName = textureName;
        this.elementPathOverrides = elementPathOverrides;
        this.includeBaseElement = includeBaseElement;
        this.makeFromSingleIcon = makeFromSingleIcon;
    }

    public static UnresolvedTextureConnectionProperties read(String textureName, JsonObject json) {
        Optional<Map<ConnectedTextureElement, String>> elementPathOverrides;
        if (json.has("connection_elements")) {
            HashMap<ConnectedTextureElement, String> elementsMap = new HashMap<ConnectedTextureElement, String>();
            JsonObject elementsObj = JSONUtils.func_152754_s((JsonObject)json, (String)"connection_elements");
            for (Map.Entry entry : elementsObj.entrySet()) {
                String elementName = (String)entry.getKey();
                ConnectedTextureElement element = ConnectedTextureElement.getNonBaseElementByName(elementName);
                if (element != null) {
                    String overrideString = ((JsonElement)entry.getValue()).getAsString();
                    if (BlockModelUtil.validateTextureString(overrideString)) {
                        elementsMap.put(element, overrideString);
                        continue;
                    }
                    LOTRLog.error("Error loading TextureConnectionProperties for texture '%s' - override texture '%s' is not a valid texture path or #reference", textureName, overrideString);
                    continue;
                }
                LOTRLog.error("Error loading TextureConnectionProperties for connected texture '%s' - no connected texture element by name '%s'", textureName, elementName);
            }
            elementPathOverrides = Optional.of(elementsMap);
        } else {
            elementPathOverrides = Optional.empty();
        }
        boolean includeBaseElement = JSONUtils.func_151209_a((JsonObject)json, (String)"include_base", (boolean)true);
        boolean makeFromSingleIcon = JSONUtils.func_151209_a((JsonObject)json, (String)"make_from_single_icon", (boolean)false);
        return new UnresolvedTextureConnectionProperties(textureName, elementPathOverrides, includeBaseElement, makeFromSingleIcon);
    }
}

