/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.render.model.vessel;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import lotr.client.render.model.DynamicTextureRepository;
import lotr.client.render.model.vessel.VesselDrinkModel;
import lotr.client.render.model.vessel.VesselDrinkOverrideHandler;
import lotr.common.item.VesselType;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.model.SimpleBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.geometry.IModelGeometry;

public class VesselDrinkUnbakedModel
implements IModelGeometry<VesselDrinkUnbakedModel> {
    private RenderMaterial cachedLiquidMaterial;

    public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
        RenderMaterial baseMaterial = this.cachedLiquidMaterial;
        VesselDrinkOverrideHandler vesselOverrides = new VesselDrinkOverrideHandler();
        for (VesselType vessel : VesselType.values()) {
            ResourceLocation filledLocation = DynamicTextureRepository.INSTANCE.getFilledVesselTexture(baseMaterial.func_229313_b_(), vessel);
            RenderMaterial filledMaterial = new RenderMaterial(baseMaterial.func_229310_a_(), filledLocation);
            ImmutableList quads = ItemLayerModel.getQuadsForSprites((List)ImmutableList.of((Object)filledMaterial), (TransformationMatrix)modelTransform.func_225615_b_(), spriteGetter);
            SimpleBakedModel vesselModel = new SimpleBakedModel((List)quads, VesselDrinkUnbakedModel.createEmptyFacingQuadsMap(), false, false, false, null, owner.getCameraTransforms(), overrides);
            vesselOverrides.putOverride(vessel, (IBakedModel)vesselModel);
        }
        VesselDrinkModel model = new VesselDrinkModel((ImmutableList<BakedQuad>)ImmutableList.of(), null, (ImmutableMap<ItemCameraTransforms.TransformType, TransformationMatrix>)PerspectiveMapWrapper.getTransforms((IModelTransform)modelTransform), vesselOverrides, modelTransform.func_225615_b_().isIdentity(), owner.isSideLit());
        model.setLiquidTexture(baseMaterial);
        return model;
    }

    private static Map<Direction, List<BakedQuad>> createEmptyFacingQuadsMap() {
        HashMap<Direction, List<BakedQuad>> map = new HashMap<Direction, List<BakedQuad>>();
        for (Direction dir : Direction.values()) {
            map.put(dir, new ArrayList());
        }
        return map;
    }

    public Collection<RenderMaterial> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        RenderMaterial baseMaterial;
        this.cachedLiquidMaterial = baseMaterial = owner.resolveTexture("liquid");
        HashSet materials = Sets.newHashSet();
        materials.add(baseMaterial);
        Map<VesselType, ResourceLocation> filledTextures = DynamicTextureRepository.INSTANCE.generateVesselDrinkTextures(baseMaterial.func_229313_b_());
        filledTextures.values().forEach(res -> {
            RenderMaterial filledMaterial = new RenderMaterial(baseMaterial.func_229310_a_(), res);
            materials.add(filledMaterial);
        });
        return materials;
    }

    public static final class Loader
    implements IModelLoader<VesselDrinkUnbakedModel> {
        public static final Loader INSTANCE = new Loader();

        private Loader() {
        }

        public void func_195410_a(IResourceManager resourceManager) {
        }

        public VesselDrinkUnbakedModel read(JsonDeserializationContext deserializationContext, JsonObject modelObj) {
            return new VesselDrinkUnbakedModel();
        }
    }
}

