/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.render.world;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import lotr.client.render.ProjectionUtil;
import lotr.common.LOTRLog;
import lotr.common.init.LOTRBiomes;
import lotr.common.init.LOTRWorldTypes;
import lotr.common.time.MiddleEarthCalendar;
import lotr.common.time.ShireReckoning;
import lotr.common.util.CalendarUtil;
import lotr.common.world.biome.LOTRBiomeBase;
import lotr.common.world.map.MapSettings;
import lotr.common.world.map.MapSettingsManager;
import lotr.common.world.map.NorthernLightsSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.profiler.IProfiler;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class NorthernLightsRenderer {
    private int nlTick;
    private int currentNightNum = -1;
    private float brightnessTonight;
    private float maxNorthTonight;
    private float minNorthTonight;
    private int rainingTick;
    private int rainingTickPrev;
    private static final int rainingChangeTime = 80;
    private boolean atUtumno = false;
    private int utumnoChange = 0;
    private static final int utumnoChangeTime = 200;
    private final Random rand = new Random(54382502529626502L);
    private final Random dateRand = new Random(664292528855626902L);
    private float[] colorTopCurrent;
    private float[] colorMidCurrent;
    private float[] colorBottomCurrent;
    private float[] colorTopNext;
    private float[] colorMidNext;
    private float[] colorBottomNext;
    private int colorChangeTime;
    private int colorChangeTick;
    private int timeUntilColorChange;
    private int utumnoCheckTime;
    private final AuroraCycle wave0 = new AuroraCycle(4.0f, 0.01f, 0.9f);
    private List<AuroraCycle> waveOscillations = new ArrayList<AuroraCycle>();
    private List<AuroraCycle> glowOscillations = new ArrayList<AuroraCycle>();
    private final AuroraCycle glow0 = new AuroraCycle(20.0f, 0.02f, 0.6f);

    public void render(Minecraft mc, ClientWorld world, MatrixStack matStack, float tick) {
        float maxDaylight;
        if (mc.field_71474_y.field_151451_c < 4) {
            return;
        }
        IProfiler profiler = world.func_217381_Z();
        float minSun = 0.2f;
        float daylight = (world.func_228326_g_(tick) - minSun) / (1.0f - minSun);
        float nlBrightness = (1.0f - daylight - (1.0f - (maxDaylight = 0.3f))) / maxDaylight;
        if (nlBrightness <= 0.0f) {
            return;
        }
        float tonight = this.brightnessTonight;
        float utumno = (float)this.utumnoChange / 200.0f;
        if ((tonight += (1.0f - tonight) * utumno) <= 0.0f) {
            return;
        }
        nlBrightness *= tonight;
        float northernness = this.getNorthernness(mc, mc.field_175622_Z, world);
        if (northernness <= 0.0f) {
            return;
        }
        nlBrightness *= northernness;
        float raininess = ((float)this.rainingTickPrev + (float)(this.rainingTick - this.rainingTickPrev) * tick) / 80.0f;
        if (raininess >= 1.0f) {
            return;
        }
        nlBrightness *= 1.0f - raininess;
        nlBrightness *= 0.3f + (1.0f - world.func_72867_j(tick)) * 0.7f;
        profiler.func_76320_a("aurora");
        float nlScale = 2000.0f;
        float nlDistance = (1.0f - northernness) * nlScale * 2.0f;
        float nlHeight = nlScale * 0.48f;
        Matrix4f projectMatrix = ProjectionUtil.getProjection(mc, tick, nlScale * 5.0f);
        RenderSystem.matrixMode((int)5889);
        RenderSystem.pushMatrix();
        RenderSystem.loadIdentity();
        RenderSystem.multMatrix((Matrix4f)projectMatrix);
        RenderSystem.matrixMode((int)5888);
        RenderSystem.pushMatrix();
        RenderSystem.loadIdentity();
        matStack.func_227860_a_();
        matStack.func_227861_a_(0.0, (double)nlHeight, (double)(-nlDistance));
        RenderSystem.multMatrix((Matrix4f)matStack.func_227866_c_().func_227870_a_());
        RenderSystem.disableTexture();
        RenderSystem.disableAlphaTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.alphaFunc((int)516, (float)0.01f);
        RenderSystem.shadeModel((int)7425);
        RenderSystem.disableCull();
        profiler.func_76320_a("sheet");
        boolean fancy = Minecraft.func_71375_t();
        this.renderSheet(matStack, fancy, nlScale * -0.5f, nlBrightness * 0.8f, nlScale * 1.0f, nlScale * 0.23f, 0.25502f, tick, profiler);
        this.renderSheet(matStack, fancy, nlScale * 0.0f, nlBrightness * 1.0f, nlScale * 1.5f, nlScale * 0.27f, 0.15696f, tick, profiler);
        this.renderSheet(matStack, fancy, nlScale * 0.5f, nlBrightness * 0.8f, nlScale * 1.0f, nlScale * 0.23f, 0.67596f, tick, profiler);
        profiler.func_76319_b();
        RenderSystem.enableCull();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.defaultAlphaFunc();
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
        RenderSystem.matrixMode((int)5889);
        RenderSystem.popMatrix();
        matStack.func_227865_b_();
        RenderSystem.matrixMode((int)5888);
        RenderSystem.popMatrix();
        profiler.func_76319_b();
    }

    private float getNorthernness(Minecraft mc, Entity entity, ClientWorld world) {
        if (!LOTRWorldTypes.hasMapFeaturesClientside()) {
            return NorthernLightsRenderer.getBiomeDependentBrightness(mc, entity, world);
        }
        float minNorth = this.minNorthTonight;
        float maxNorth = this.maxNorthTonight;
        float northernness = ((float)entity.func_226281_cx_() - minNorth) / (maxNorth - minNorth);
        northernness = MathHelper.func_76131_a((float)northernness, (float)0.0f, (float)1.0f);
        return northernness;
    }

    private static float getBiomeDependentBrightness(Minecraft mc, Entity entity, ClientWorld world) {
        int sampled = 0;
        int total = 0;
        int range = Math.min(mc.field_71474_y.field_151451_c * 2, 36);
        BlockPos entityPos = entity.func_233580_cy_();
        BlockPos.Mutable movingPos = new BlockPos.Mutable();
        for (int x = -range; x <= range; ++x) {
            for (int z = -range; z <= range; ++z) {
                movingPos.func_189533_g((Vector3i)entityPos).func_196234_d(x, 0, z);
                Biome biome = world.func_226691_t_((BlockPos)movingPos);
                if (biome.func_201851_b() == Biome.RainType.SNOW) {
                    ++total;
                }
                ++sampled;
            }
        }
        return (float)total / (float)sampled;
    }

    private static boolean isRainLayerAt(Entity entity) {
        World world = entity.func_130014_f_();
        BlockPos pos = entity.func_233580_cy_();
        if (!world.func_72896_J()) {
            return false;
        }
        Biome biome = world.func_226691_t_(pos);
        if (biome.func_201851_b() == Biome.RainType.SNOW) {
            return false;
        }
        float temp = LOTRBiomes.getWrapperFor(biome, (IWorld)world).getTemperatureForSnowWeatherRendering((IWorld)world, pos);
        return !LOTRBiomeBase.isTemperatureSuitableForSnow(temp) && biome.func_201851_b() == Biome.RainType.RAIN;
    }

    private void renderSheet(MatrixStack matStack, boolean fancy, float nlDistance, float nlBrightness, float halfWidth, float halfHeight, float tickExtra, float tick, IProfiler profiler) {
        float r1 = this.colorTopCurrent[0];
        float g1 = this.colorTopCurrent[1];
        float b1 = this.colorTopCurrent[2];
        float r2 = this.colorMidCurrent[0];
        float g2 = this.colorMidCurrent[1];
        float b2 = this.colorMidCurrent[2];
        float r3 = this.colorBottomCurrent[0];
        float g3 = this.colorBottomCurrent[1];
        float b3 = this.colorBottomCurrent[2];
        if (this.colorChangeTime > 0) {
            float t = (float)this.colorChangeTick / (float)this.colorChangeTime;
            t = 1.0f - t;
            r1 = this.colorTopCurrent[0] + (this.colorTopNext[0] - this.colorTopCurrent[0]) * t;
            g1 = this.colorTopCurrent[1] + (this.colorTopNext[1] - this.colorTopCurrent[1]) * t;
            b1 = this.colorTopCurrent[2] + (this.colorTopNext[2] - this.colorTopCurrent[2]) * t;
            r2 = this.colorMidCurrent[0] + (this.colorMidNext[0] - this.colorMidCurrent[0]) * t;
            g2 = this.colorMidCurrent[1] + (this.colorMidNext[1] - this.colorMidCurrent[1]) * t;
            b2 = this.colorMidCurrent[2] + (this.colorMidNext[2] - this.colorMidCurrent[2]) * t;
            r3 = this.colorBottomCurrent[0] + (this.colorBottomNext[0] - this.colorBottomCurrent[0]) * t;
            g3 = this.colorBottomCurrent[1] + (this.colorBottomNext[1] - this.colorBottomCurrent[1]) * t;
            b3 = this.colorBottomCurrent[2] + (this.colorBottomNext[2] - this.colorBottomCurrent[2]) * t;
        }
        float a1 = 0.0f;
        float a2 = 0.4f;
        float a3 = 0.8f;
        a1 *= nlBrightness;
        a2 *= nlBrightness;
        a3 *= nlBrightness;
        float fullTick = (float)this.nlTick + tick + tickExtra;
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buf = tess.func_178180_c();
        buf.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        profiler.func_76320_a("vertexLoop");
        int strips = 500;
        if (!fancy) {
            strips = 80;
        }
        for (int l = 0; l < strips; ++l) {
            float t = (float)l / (float)strips;
            float t1 = (float)(l + 1) / (float)strips;
            float a1_here = a1;
            float a2_here = a2;
            float a3_here = a3;
            float fadeEdge = 0.3f;
            float fadePos = Math.min(t, 1.0f - t);
            if (fadePos < fadeEdge) {
                float fade = fadePos / fadeEdge;
                a1_here *= fade;
                a2_here *= fade;
                a3_here *= fade;
            }
            float randomFade = 0.5f + this.glowEquation(t, fullTick, tick, fancy) * 0.5f;
            a1_here *= randomFade;
            a2_here *= randomFade;
            a3_here *= randomFade;
            float x0 = -halfWidth + halfWidth * 2.0f * t;
            float x1 = x0 + halfWidth * 2.0f / (float)strips;
            float yMin = -halfHeight;
            float yMid = -halfHeight * 0.3f;
            float yMax = halfHeight;
            float z0 = nlDistance;
            float z1 = nlDistance;
            float maxWaveDisplacement = halfWidth * 0.15f;
            float extra = halfHeight * 0.25f;
            buf.func_225582_a_((double)x0, (double)(yMin - extra), (double)(z0 += this.waveEquation(t, fullTick, tick, fancy) * maxWaveDisplacement)).func_227885_a_(r3, g3, b3, 0.0f).func_181675_d();
            buf.func_225582_a_((double)x1, (double)(yMin - extra), (double)(z1 += this.waveEquation(t1, fullTick, tick, fancy) * maxWaveDisplacement)).func_227885_a_(r3, g3, b3, 0.0f).func_181675_d();
            buf.func_225582_a_((double)x1, (double)yMin, (double)z1).func_227885_a_(r3, g3, b3, a3_here).func_181675_d();
            buf.func_225582_a_((double)x0, (double)yMin, (double)z0).func_227885_a_(r3, g3, b3, a3_here).func_181675_d();
            buf.func_225582_a_((double)x0, (double)yMin, (double)z0).func_227885_a_(r3, g3, b3, a3_here).func_181675_d();
            buf.func_225582_a_((double)x1, (double)yMin, (double)z1).func_227885_a_(r3, g3, b3, a3_here).func_181675_d();
            buf.func_225582_a_((double)x1, (double)yMid, (double)z1).func_227885_a_(r2, g2, b2, a2_here).func_181675_d();
            buf.func_225582_a_((double)x0, (double)yMid, (double)z0).func_227885_a_(r2, g2, b2, a2_here).func_181675_d();
            buf.func_225582_a_((double)x0, (double)yMid, (double)z0).func_227885_a_(r2, g2, b2, a2_here).func_181675_d();
            buf.func_225582_a_((double)x1, (double)yMid, (double)z1).func_227885_a_(r2, g2, b2, a2_here).func_181675_d();
            buf.func_225582_a_((double)x1, (double)yMax, (double)z1).func_227885_a_(r1, g1, b1, a1_here).func_181675_d();
            buf.func_225582_a_((double)x0, (double)yMax, (double)z0).func_227885_a_(r1, g1, b1, a1_here).func_181675_d();
        }
        profiler.func_76319_b();
        profiler.func_76320_a("draw");
        tess.func_78381_a();
        profiler.func_76319_b();
    }

    public void update(Entity viewer) {
        ++this.nlTick;
        World world = viewer.func_130014_f_();
        int effectiveDay = MiddleEarthCalendar.currentDay;
        float daytime = (float)(world.func_72820_D() % 48000L) / 48000.0f;
        if (daytime < 0.25f) {
            --effectiveDay;
        }
        if (effectiveDay != this.currentNightNum) {
            this.currentNightNum = effectiveDay;
            this.dateRand.setSeed((long)this.currentNightNum * 35920558925051L + (long)this.currentNightNum + 83025820626792L);
            ShireReckoning.Month month = ((ShireReckoning.ShireDate)ShireReckoning.INSTANCE.getDate((int)this.currentNightNum)).month;
            boolean isYule = month == ShireReckoning.Month.YULE_1 || month == ShireReckoning.Month.YULE_2;
            MapSettings loadedMapSettings = MapSettingsManager.clientInstance().getLoadedMapOrLoadDefault(Minecraft.func_71410_x().func_195551_G());
            if (loadedMapSettings == null) {
                LOTRLog.error("No MapSettings instance is loaded on the client! This should not happen and is very bad!");
            }
            NorthernLightsSettings northernLightsSettings = loadedMapSettings.getNorthernLights();
            int fullNorth = northernLightsSettings.getFullNorth_world();
            int minSouth = northernLightsSettings.getStartSouth_world();
            int maxSouth = northernLightsSettings.getFurthestPossibleSouth_world();
            this.maxNorthTonight = fullNorth;
            float southRand = this.dateRand.nextFloat();
            float southRandAmount = isYule || southRand < 0.01f ? MathHelper.func_151240_a((Random)this.dateRand, (float)0.75f, (float)1.0f) : (southRand < 0.1f ? MathHelper.func_151240_a((Random)this.dateRand, (float)0.5f, (float)0.75f) : (southRand < 0.5f ? MathHelper.func_151240_a((Random)this.dateRand, (float)0.25f, (float)0.5f) : MathHelper.func_151240_a((Random)this.dateRand, (float)0.0f, (float)0.25f)));
            this.minNorthTonight = MathHelper.func_219799_g((float)southRandAmount, (float)minSouth, (float)maxSouth);
            if (CalendarUtil.isChristmas()) {
                this.minNorthTonight = 1.0E8f;
            }
            float appearChance = 0.5f;
            this.brightnessTonight = isYule || effectiveDay == 0 || this.dateRand.nextFloat() < appearChance ? MathHelper.func_151240_a((Random)this.dateRand, (float)0.4f, (float)1.0f) : 0.0f;
        }
        this.rainingTickPrev = this.rainingTick;
        boolean raining = NorthernLightsRenderer.isRainLayerAt(viewer);
        if (raining) {
            if (this.rainingTick < 80) {
                ++this.rainingTick;
            }
        } else if (this.rainingTick > 0) {
            --this.rainingTick;
        }
        if (this.colorTopCurrent == null) {
            Color[] cs = this.generateColorSet();
            this.colorTopCurrent = cs[0].getColorComponents(null);
            this.colorMidCurrent = cs[1].getColorComponents(null);
            this.colorBottomCurrent = cs[2].getColorComponents(null);
        }
        if (this.timeUntilColorChange > 0) {
            --this.timeUntilColorChange;
        } else if (this.rand.nextInt(1200) == 0) {
            Color[] cs = this.generateColorSet();
            this.colorTopNext = cs[0].getColorComponents(null);
            this.colorMidNext = cs[1].getColorComponents(null);
            this.colorBottomNext = cs[2].getColorComponents(null);
            this.colorChangeTick = this.colorChangeTime = MathHelper.func_76136_a((Random)this.rand, (int)100, (int)200);
            this.utumnoCheckTime = 0;
        }
        if (this.colorChangeTick > 0) {
            --this.colorChangeTick;
            if (this.colorChangeTick <= 0) {
                this.colorChangeTime = 0;
                this.colorTopCurrent = this.colorTopNext;
                this.colorMidCurrent = this.colorMidNext;
                this.colorBottomCurrent = this.colorBottomNext;
                this.colorTopNext = null;
                this.colorMidNext = null;
                this.colorBottomNext = null;
                this.timeUntilColorChange = MathHelper.func_76136_a((Random)this.rand, (int)1200, (int)2400);
            }
        }
        if (this.utumnoCheckTime > 0) {
            --this.utumnoCheckTime;
        } else {
            double range = 256.0;
            this.atUtumno = false;
            this.utumnoCheckTime = 200;
        }
        if (this.atUtumno) {
            if (this.utumnoChange < 200) {
                ++this.utumnoChange;
            }
        } else if (this.utumnoChange > 0) {
            --this.utumnoChange;
        }
        if (this.rand.nextInt(50) == 0) {
            float freq = MathHelper.func_151240_a((Random)this.rand, (float)8.0f, (float)100.0f);
            float speed = freq * 5.0E-4f;
            float amp = MathHelper.func_151240_a((Random)this.rand, (float)0.05f, (float)0.3f);
            AuroraCycle cycle = new AuroraCycle(freq, speed, amp);
            cycle.age = cycle.maxAge = MathHelper.func_76136_a((Random)this.rand, (int)100, (int)400);
            this.waveOscillations.add(cycle);
        }
        if (!this.waveOscillations.isEmpty()) {
            HashSet<AuroraCycle> removes = new HashSet<AuroraCycle>();
            for (AuroraCycle c : this.waveOscillations) {
                c.update();
                if (c.age > 0) continue;
                removes.add(c);
            }
            this.waveOscillations.removeAll(removes);
        }
        if (this.rand.nextInt(120) == 0) {
            float freq = MathHelper.func_151240_a((Random)this.rand, (float)30.0f, (float)150.0f);
            float speed = freq * 0.002f;
            float amp = MathHelper.func_151240_a((Random)this.rand, (float)0.05f, (float)0.5f);
            AuroraCycle cycle = new AuroraCycle(freq, speed, amp);
            cycle.age = cycle.maxAge = MathHelper.func_76136_a((Random)this.rand, (int)100, (int)400);
            this.glowOscillations.add(cycle);
        }
        if (this.rand.nextInt(300) == 0) {
            float freq = MathHelper.func_151240_a((Random)this.rand, (float)400.0f, (float)500.0f);
            float speed = freq * 0.004f;
            float amp = MathHelper.func_151240_a((Random)this.rand, (float)0.1f, (float)0.2f);
            AuroraCycle cycle = new AuroraCycle(freq, speed, amp);
            cycle.age = cycle.maxAge = MathHelper.func_76136_a((Random)this.rand, (int)100, (int)200);
            this.glowOscillations.add(cycle);
        }
        if (!this.glowOscillations.isEmpty()) {
            HashSet<AuroraCycle> removes = new HashSet<AuroraCycle>();
            for (AuroraCycle c : this.glowOscillations) {
                c.update();
                if (c.age > 0) continue;
                removes.add(c);
            }
            this.glowOscillations.removeAll(removes);
        }
    }

    private Color[] generateColorSet() {
        float h1 = MathHelper.func_151240_a((Random)this.rand, (float)0.22f, (float)0.48f);
        float h2 = MathHelper.func_151240_a((Random)this.rand, (float)0.22f, (float)0.48f);
        float h3 = MathHelper.func_151240_a((Random)this.rand, (float)0.22f, (float)0.48f);
        if (this.rand.nextInt(5) == 0) {
            h3 = MathHelper.func_151240_a((Random)this.rand, (float)0.94f, (float)1.01f);
        } else {
            if (this.rand.nextInt(6) == 0) {
                h1 = MathHelper.func_151240_a((Random)this.rand, (float)0.78f, (float)1.08f);
            }
            if (this.rand.nextInt(6) == 0) {
                h1 = MathHelper.func_151240_a((Random)this.rand, (float)0.78f, (float)1.08f);
                h2 = MathHelper.func_151240_a((Random)this.rand, (float)0.85f, (float)1.08f);
            }
        }
        if (this.rand.nextInt(50) == 0) {
            h1 = MathHelper.func_151240_a((Random)this.rand, (float)0.7f, (float)1.08f);
            h2 = MathHelper.func_151240_a((Random)this.rand, (float)0.54f, (float)0.77f);
            h3 = MathHelper.func_151240_a((Random)this.rand, (float)0.48f, (float)0.7f);
        }
        Color topColor = new Color(Color.HSBtoRGB(h1, 1.0f, 1.0f));
        Color midColor = new Color(Color.HSBtoRGB(h2, 1.0f, 1.0f));
        Color bottomColor = new Color(Color.HSBtoRGB(h3, 1.0f, 1.0f));
        return new Color[]{topColor, midColor, bottomColor};
    }

    private float waveEquation(float t, float tick, float renderTick, boolean fancy) {
        float f = 0.0f;
        f += this.wave0.calc(t, tick);
        for (AuroraCycle c : this.waveOscillations) {
            f += c.calc(t, tick);
        }
        return f;
    }

    private float glowEquation(float t, float tick, float renderTick, boolean fancy) {
        float f = 0.0f;
        f += this.glow0.calc(t, tick);
        if (fancy) {
            for (AuroraCycle c : this.glowOscillations) {
                f += c.calc(t, tick);
            }
        }
        return f;
    }

    private static class AuroraCycle {
        public final float freq;
        public final float tickMultiplier;
        public final float amp;
        public int age;
        public int maxAge = -1;
        private float ampModifier = 1.0f;

        public AuroraCycle(float f, float t, float a) {
            this.freq = f;
            this.tickMultiplier = t;
            this.amp = a;
        }

        public float calc(float t, float tick) {
            return MathHelper.func_76134_b((float)(t * this.freq + tick * this.tickMultiplier)) * this.amp * this.ampModifier;
        }

        public void update() {
            if (this.age >= 0) {
                --this.age;
                float a = (float)(this.maxAge - this.age) / (float)this.maxAge;
                this.ampModifier = Math.min(a, 1.0f - a);
            }
        }
    }
}

